/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.NetworkAdapterFactory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNet
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNet");
    private INetworkAdapter networkAdapter;
    protected int netMemSize;

    @Override
    public String getName() {
        return "sceNet";
    }

    public INetworkAdapter getNetworkAdapter() {
        return this.networkAdapter;
    }

    public static String convertMacAddressToString(byte[] macAddress) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < macAddress.length; ++i) {
            if (i > 0) {
                str.append(":");
            }
            str.append(String.format("%02x", macAddress[i]));
        }
        return str.toString();
    }

    public static byte[] convertStringToMacAddress(String str) {
        byte[] macAddress = new byte[6];
        int n = 0;
        for (int i = 0; i < macAddress.length; ++i) {
            int n1 = sceNet.parseHexDigit(str.charAt(n++));
            int n2 = sceNet.parseHexDigit(str.charAt(n++));
            ++n;
            macAddress[i] = (byte)((n1 << 4) + n2);
        }
        return macAddress;
    }

    @HLEFunction(nid=967784870, version=150, checkInsideInterrupt=true)
    public void sceNetInit(Processor processor) {
        CpuState cpu = processor.cpu;
        int poolSize = cpu.gpr[4];
        int calloutThreadPri = cpu.gpr[5];
        int calloutThreadStack = cpu.gpr[6];
        int netinitThreadPri = cpu.gpr[7];
        int netinitThreadStack = cpu.gpr[8];
        log.warn((Object)("IGNORING: sceNetInit (poolsize=0x" + Integer.toHexString(poolSize) + ", calloutThreadPri=0x" + Integer.toHexString(calloutThreadPri) + ", calloutThreadStack=0x" + Integer.toHexString(calloutThreadStack) + ", netinitThreadPri=0x" + Integer.toHexString(netinitThreadPri) + ", netinitThreadStack=0x" + Integer.toHexString(netinitThreadStack) + ")"));
        this.netMemSize = poolSize;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=672737449, version=150, checkInsideInterrupt=true)
    public void sceNetTerm(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"IGNORING: sceNetTerm");
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1348760880, version=150, checkInsideInterrupt=true)
    public void sceNetFreeThreadinfo(Processor processor) {
        CpuState cpu = processor.cpu;
        int thID = cpu.gpr[4];
        log.warn((Object)("IGNORING: sceNetFreeThreadinfo (thID=0x" + Integer.toHexString(thID) + ")"));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1385675578, version=150, checkInsideInterrupt=true)
    public void sceNetThreadAbort(Processor processor) {
        CpuState cpu = processor.cpu;
        int thID = cpu.gpr[4];
        log.warn((Object)("IGNORING: sceNetThreadAbort (thID=0x" + Integer.toHexString(thID) + ")"));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1992947376, version=150, checkInsideInterrupt=true)
    public int sceNetEtherNtostr(TPointer etherAddr, TPointer strAddr) {
        Memory mem = Processor.memory;
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(mem, etherAddr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetEtherNtostr etherAddr=%s(%s), strAddr=%s", etherAddr, macAddress, strAddr));
        }
        Utilities.writeStringZ(mem, strAddr.getAddress(), sceNet.convertMacAddressToString(macAddress.macAddress));
        return 0;
    }

    protected static int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        log.error((Object)String.format("Cannot parse hex digit '%c'", Character.valueOf(c)));
        return 0;
    }

    @HLEFunction(nid=-763797047, version=150, checkInsideInterrupt=true)
    public int sceNetEtherStrton(TPointer strAddr, TPointer etherAddr) {
        String str = Utilities.readStringNZ(strAddr.getAddress(), 17);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetEtherStrton strAddr=%s(%s), etherAddr=%s", strAddr, str, etherAddr));
        }
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(sceNet.convertStringToMacAddress(str));
        macAddress.write(Memory.getInstance(), etherAddr.getAddress());
        return 0;
    }

    protected int networkSwap32(int value) {
        return Integer.reverseBytes(value);
    }

    protected int networkSwap16(int value) {
        return Integer.reverseBytes(value) >>> 16;
    }

    @HLEFunction(nid=-176136450, version=150, checkInsideInterrupt=true)
    public void sceNetHtonl(Processor processor) {
        CpuState cpu = processor.cpu;
        int host32 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetHtonl(%08X)", host32));
        }
        cpu.gpr[2] = this.networkSwap32(host32);
    }

    @HLEFunction(nid=968998658, version=150, checkInsideInterrupt=true)
    public void sceNetHtons(Processor processor) {
        CpuState cpu = processor.cpu;
        int host16 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetHtons(%04X)", host16));
        }
        cpu.gpr[2] = this.networkSwap16(host16);
    }

    @HLEFunction(nid=-1815826562, version=150, checkInsideInterrupt=true)
    public void sceNetNtohl(Processor processor) {
        CpuState cpu = processor.cpu;
        int net32 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetNtohl(%08X)", net32));
        }
        cpu.gpr[2] = this.networkSwap32(net32);
    }

    @HLEFunction(nid=1289761287, version=150, checkInsideInterrupt=true)
    public void sceNetNtohs(Processor processor) {
        CpuState cpu = processor.cpu;
        int net16 = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetNtohs(%04X)", net16));
        }
        cpu.gpr[2] = this.networkSwap16(net16);
    }

    @HLEFunction(nid=200319918, version=150, checkInsideInterrupt=true)
    public void sceNetGetLocalEtherAddr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int etherAddr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceNetGetLocalEtherAddr (etherAddr=0x" + Integer.toHexString(etherAddr) + ")"));
        }
        if (Memory.isAddressGood(etherAddr)) {
            pspNetMacAddress macAddress = new pspNetMacAddress();
            macAddress.setMacAddress(Wlan.getMacAddress());
            macAddress.write(mem, etherAddr);
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -1;
        }
    }

    @HLEFunction(nid=-868663736, version=150, checkInsideInterrupt=true)
    public int sceNetGetMallocStat(TPointer statAddr) {
        Memory mem = Processor.memory;
        log.warn((Object)String.format("PARTIAL: sceNetGetMallocStat statAddr=%s", statAddr));
        int freeSize = this.netMemSize / 2;
        int addr = statAddr.getAddress();
        mem.write32(addr, this.netMemSize);
        mem.write32(addr + 4, this.netMemSize - freeSize);
        mem.write32(addr + 8, freeSize);
        return 0;
    }

    @Override
    public void start() {
        this.networkAdapter = NetworkAdapterFactory.createNetworkAdapter();
        this.networkAdapter.start();
        super.start();
    }

    @Override
    public void stop() {
        this.networkAdapter.stop();
        this.networkAdapter = null;
        super.stop();
    }
}

