/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jpcsp.Allegrex.CpuState;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.sceNet;
import jpcsp.HLE.modules150.sceUtility;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.PdpObject;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetAdhoc
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetAdhoc");
    private int netClientPortShift = 0;
    private int netServerPortShift = 0;
    protected static final int GAME_MODE_UPDATE_MICROS = 12000;
    protected static final int PSP_ADHOC_POLL_READY_TO_SEND = 1;
    protected static final int PSP_ADHOC_POLL_DATA_AVAILABLE = 2;
    protected static final int PSP_ADHOC_POLL_CAN_CONNECT = 4;
    protected static final int PSP_ADHOC_POLL_CAN_ACCEPT = 8;
    protected HashMap<Integer, PdpObject> pdpObjects;
    protected HashMap<Integer, PtpObject> ptpObjects;
    private int currentFreePort;
    public static final byte[] ANY_MAC_ADDRESS = new byte[]{-1, -1, -1, -1, -1, -1};
    private GameModeScheduledAction gameModeScheduledAction;
    protected GameModeArea masterGameModeArea;
    protected LinkedList<GameModeArea> replicaGameModeAreas;
    private static final String replicaIdPurpose = "sceNetAdhoc-Replica";
    private static final int adhocGameModePort = 31000;
    private DatagramSocket gameModeSocket;

    protected static String getPollEventName(int event) {
        return String.format("Unknown 0x%X", event);
    }

    @Override
    public String getName() {
        return "sceNetAdhoc";
    }

    @Override
    public void start() {
        this.pdpObjects = new HashMap();
        this.ptpObjects = new HashMap();
        this.currentFreePort = 16384;
        this.replicaGameModeAreas = new LinkedList();
        super.start();
    }

    public void setNetClientPortShift(int netClientPortShift) {
        this.netClientPortShift = netClientPortShift;
        log.info((Object)String.format("Using netClientPortShift=%d", netClientPortShift));
    }

    public void setNetServerPortShift(int netServerPortShift) {
        this.netServerPortShift = netServerPortShift;
        log.info((Object)String.format("Using netServerPortShift=%d", netServerPortShift));
    }

    public int getClientPortFromRealPort(byte[] clientMacAddress, int realPort) {
        if (sceNetAdhoc.isMyMacAddress(clientMacAddress)) {
            return this.getServerPortFromRealPort(realPort);
        }
        return realPort - this.netClientPortShift;
    }

    public int getRealPortFromClientPort(byte[] clientMacAddress, int clientPort) {
        if (sceNetAdhoc.isMyMacAddress(clientMacAddress)) {
            return this.getRealPortFromServerPort(clientPort);
        }
        return clientPort + this.netClientPortShift;
    }

    public int getServerPortFromRealPort(int realPort) {
        return realPort - this.netServerPortShift;
    }

    public int getRealPortFromServerPort(int serverPort) {
        return serverPort + this.netServerPortShift;
    }

    public boolean hasNetPortShiftActive() {
        return this.netServerPortShift > 0 || this.netClientPortShift > 0;
    }

    public void hleExitGameMode() {
        this.masterGameModeArea = null;
        this.replicaGameModeAreas.clear();
        this.stopGameMode();
    }

    public void hleGameModeUpdate() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleGameModeUpdate", new Object[0]));
        }
        try {
            if (this.gameModeSocket == null) {
                this.gameModeSocket = new DatagramSocket(Modules.sceNetAdhocModule.getRealPortFromServerPort(31000));
                this.gameModeSocket.setBroadcast(true);
                this.gameModeSocket.setSoTimeout(1);
            }
            if (this.masterGameModeArea != null && this.masterGameModeArea.hasNewData()) {
                try {
                    AdhocMessage adhocGameModeMessage = this.getNetworkAdapter().createAdhocGameModeMessage(this.masterGameModeArea);
                    SocketAddress socketAddress = Modules.sceNetAdhocModule.getSocketAddress(ANY_MAC_ADDRESS, Modules.sceNetAdhocModule.getRealPortFromClientPort(ANY_MAC_ADDRESS, 31000));
                    DatagramPacket packet = new DatagramPacket(adhocGameModeMessage.getMessage(), adhocGameModeMessage.getMessageLength(), socketAddress);
                    this.gameModeSocket.send(packet);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("GameMode message sent to all: %s", adhocGameModeMessage));
                    }
                }
                catch (SocketTimeoutException e) {
                    // empty catch block
                }
            }
            try {
                block6: while (true) {
                    GameModeArea gameModeArea;
                    byte[] bytes = new byte[10000];
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                    this.gameModeSocket.receive(packet);
                    AdhocMessage adhocGameModeMessage = this.getNetworkAdapter().createAdhocGameModeMessage(packet.getData(), packet.getLength());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("GameMode received: %s", adhocGameModeMessage));
                    }
                    Iterator i$ = this.replicaGameModeAreas.iterator();
                    do {
                        if (!i$.hasNext()) continue block6;
                        gameModeArea = (GameModeArea)i$.next();
                    } while (!sceNetAdhoc.isSameMacAddress(gameModeArea.macAddress.macAddress, adhocGameModeMessage.getFromMacAddress()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Received new Data for GameMode Area %s", gameModeArea));
                    }
                    gameModeArea.setNewData(adhocGameModeMessage.getData());
                }
            }
            catch (SocketTimeoutException e) {
            }
        }
        catch (IOException e) {
            log.error((Object)"hleGameModeUpdate", (Throwable)e);
        }
    }

    protected void startGameMode() {
        if (this.gameModeScheduledAction == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting GameMode", new Object[0]));
            }
            this.gameModeScheduledAction = new GameModeScheduledAction(12000);
            this.gameModeScheduledAction.start();
        }
    }

    protected void stopGameMode() {
        if (this.gameModeScheduledAction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Stopping GameMode", new Object[0]));
            }
            this.gameModeScheduledAction.stop();
            this.gameModeScheduledAction = null;
        }
        if (this.gameModeSocket != null) {
            this.gameModeSocket.close();
            this.gameModeSocket = null;
        }
    }

    public SocketAddress getSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        return this.getNetworkAdapter().getSocketAddress(macAddress, realPort);
    }

    public static boolean isSameMacAddress(byte[] macAddress1, byte[] macAddress2) {
        if (macAddress1.length != macAddress2.length) {
            return false;
        }
        for (int i = 0; i < macAddress1.length; ++i) {
            if (macAddress1[i] == macAddress2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyMacAddress(byte[] macAddress) {
        return sceNetAdhoc.isSameMacAddress(macAddress, ANY_MAC_ADDRESS);
    }

    public static boolean isMyMacAddress(byte[] macAddress) {
        return sceNetAdhoc.isSameMacAddress(Wlan.getMacAddress(), macAddress);
    }

    private int getFreePort() {
        int freePort = this.currentFreePort++;
        if (this.netClientPortShift > 0 || this.netServerPortShift > 0) {
            this.currentFreePort += 2;
        }
        if (this.currentFreePort > Short.MAX_VALUE) {
            this.currentFreePort -= 16384;
        }
        return freePort;
    }

    public int checkPdpId(int pdpId) {
        if (!this.pdpObjects.containsKey(pdpId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Pdp Id=%d", pdpId));
            }
            throw new SceKernelErrorException(-2143222015);
        }
        return pdpId;
    }

    public int checkPtpId(int ptpId) {
        if (!this.ptpObjects.containsKey(ptpId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Ptp Id=%d", ptpId));
            }
            throw new SceKernelErrorException(-2143222015);
        }
        return ptpId;
    }

    public void hleAddPtpObject(PtpObject ptpObject) {
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
    }

    protected INetworkAdapter getNetworkAdapter() {
        return Modules.sceNetModule.getNetworkAdapter();
    }

    @HLEFunction(nid=-506060329, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocInit() {
        log.warn((Object)"IGNORING: sceNetAdhocInit");
        log.info((Object)String.format("Using MAC address=%s, nick name='%s'", sceNet.convertMacAddressToString(Wlan.getMacAddress()), sceUtility.getSystemParamNickname()));
        return 0;
    }

    @HLEFunction(nid=-1507037353, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocTerm() {
        log.warn((Object)"IGNORING: sceNetAdhocTerm");
        return 0;
    }

    @HLEFunction(nid=2053516651, version=150)
    public int sceNetAdhocPollSocket(TPointer socketsAddr, int count, int timeout, int nonblock) {
        Memory mem = Memory.getInstance();
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPollSocket socketsAddr=%s, count=%d, timeout=%d, nonblock=%d", socketsAddr, count, timeout, nonblock));
        int countEvents = 0;
        for (int i = 0; i < count; ++i) {
            pspAdhocPollId pollId = new pspAdhocPollId();
            pollId.read(mem, socketsAddr.getAddress() + i * pollId.sizeof());
            PdpObject pdpObject = this.pdpObjects.get(pollId.id);
            PtpObject ptpObject = null;
            if (pdpObject == null) {
                ptpObject = this.ptpObjects.get(pollId.id);
                pdpObject = ptpObject;
            }
            if (pdpObject != null) {
                try {
                    pdpObject.update();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            pollId.revents = 0;
            if ((pollId.events & 2) != 0 && pdpObject.getRcvdData() > 0) {
                pollId.revents |= 2;
            }
            if ((pollId.events & 1) != 0) {
                pollId.revents |= 1;
            }
            if ((pollId.events & 4) != 0 && ptpObject != null && ptpObject.canConnect()) {
                pollId.revents |= 4;
            }
            if ((pollId.events & 8) != 0 && ptpObject != null && ptpObject.canAccept()) {
                pollId.revents |= 8;
            }
            if (pollId.revents != 0) {
                ++countEvents;
            }
            pollId.write(mem);
            log.info((Object)String.format("sceNetAdhocPollSocket pollId[%d]=%s", i, pollId));
        }
        return countEvents;
    }

    @HLEFunction(nid=1941951789, version=150)
    public int sceNetAdhocSetSocketAlert(int id, int unknown) {
        log.warn((Object)String.format("UNIMPLEMENTED: sceNetAdhocSetSocketAlert id=%d, unknown=0x%X", id, unknown));
        return 0;
    }

    @HLEFunction(nid=1294786969, version=150)
    public void sceNetAdhocGetSocketAlert(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"UNIMPLEMENTED: sceNetAdhocGetSocketAlert");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1871868955, version=150)
    public int sceNetAdhocPdpCreate(int macAddr, int port, int bufSize, int unk1) {
        PdpObject pdpObject;
        int result;
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr);
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPdpCreate macAddr=0x%08X(%s), port=%d, bufsize=%d, unk1=%d", macAddr, macAddress.toString(), port, bufSize, unk1));
        if (port == 0) {
            port = this.getFreePort();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocPdpCreate: using free port %d", port));
            }
        }
        if ((result = (pdpObject = this.getNetworkAdapter().createPdpObject()).create(macAddress, port, bufSize)) == pdpObject.getId()) {
            this.pdpObjects.put(pdpObject.getId(), pdpObject);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocPdpCreate: returning id=%d", result));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPdpCreate: returning error=0x%08X", result));
        }
        return result;
    }

    @HLEFunction(nid=-1410517104, version=150)
    public int sceNetAdhocPdpSend(@CheckArgument(value="checkPdpId") int id, TPointer destMacAddr, int port, TPointer data, int len, int timeout, int nonblock) {
        pspNetMacAddress destMacAddress = new pspNetMacAddress();
        destMacAddress.read(Memory.getInstance(), destMacAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPdpSend id=%d, destMacAddr=%s(%s), port=%d, data=%s, len=%d, timeout=%d, nonblock=%d", id, destMacAddr, destMacAddress, port, data, len, timeout, nonblock));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), len)));
        }
        return this.pdpObjects.get(id).send(destMacAddress, port, data, len, timeout, nonblock);
    }

    @HLEFunction(nid=-538624509, version=150)
    public int sceNetAdhocPdpRecv(@CheckArgument(value="checkPdpId") int id, TPointer srcMacAddr, TPointer16 portAddr, TPointer data, TPointer32 dataLengthAddr, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPdpRecv id=%d, srcMacAddr=%s, portAddr=%s, data=%s, dataLengthAddr=%s(%d), timeout=%d, nonblock=%d", id, srcMacAddr, portAddr, data, dataLengthAddr, dataLengthAddr.getValue(), timeout, nonblock));
        int result = this.pdpObjects.get(id).recv(srcMacAddr, portAddr, data, dataLengthAddr, timeout, nonblock);
        return result;
    }

    @HLEFunction(nid=2133310302, version=150)
    public int sceNetAdhocPdpDelete(@CheckArgument(value="checkPdpId") int id, int unk1) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPdpDelete id=%d, unk=%d", id, unk1));
        this.pdpObjects.remove(id).delete();
        return 0;
    }

    @HLEFunction(nid=-943588265, version=150)
    public int sceNetAdhocGetPdpStat(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        int objectInfoSize = 20;
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGetPdpStat sizeAddr=%s(%d), buf=%s", sizeAddr.toString(), sizeAddr.getValue(), buf.toString()));
        if (buf.getAddress() == 0) {
            sizeAddr.setValue(20 * this.pdpObjects.size());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocGetPdpStat returning size=%d", sizeAddr.getValue()));
            }
        } else {
            Memory mem = Memory.getInstance();
            int addr = buf.getAddress();
            int endAddr = addr + sizeAddr.getValue();
            sizeAddr.setValue(20 * this.pdpObjects.size());
            for (int pdpId : this.pdpObjects.keySet()) {
                PdpObject pdpObject = this.pdpObjects.get(pdpId);
                if (addr + 20 > endAddr || pdpObject == null) break;
                try {
                    pdpObject.update();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocGetPdpStat returning %s at 0x%08X", pdpObject, addr));
                }
                mem.write32(addr += 4, pdpObject.getId());
                pdpObject.getMacAddress().write(mem, addr += 4);
                mem.write16(addr += pdpObject.getMacAddress().sizeof(), (short)pdpObject.getPort());
                mem.write32(addr += 2, pdpObject.getRcvdData());
                addr += 4;
            }
            for (int nextAddr = buf.getAddress(); nextAddr < addr; nextAddr += 20) {
                if (nextAddr + 20 >= addr) {
                    mem.write32(nextAddr, 0);
                    continue;
                }
                mem.write32(nextAddr, nextAddr + 20);
            }
        }
        return 0;
    }

    @HLEFunction(nid=-2021692058, version=150)
    public int sceNetAdhocPtpOpen(TPointer srcMacAddr, int srcPort, TPointer destMacAddr, int destPort, int bufSize, int retryDelay, int retryCount, int unk1) {
        Memory mem = Memory.getInstance();
        pspNetMacAddress srcMacAddress = new pspNetMacAddress();
        srcMacAddress.read(mem, srcMacAddr.getAddress());
        pspNetMacAddress destMacAddress = new pspNetMacAddress();
        destMacAddress.read(mem, destMacAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpOpen scrMacAddr=%s(%s), srcPort=%d, destMacAddr=%s(%s), destPort=%d, bufSize=0x%X, retryDelay=%d, retryCount=%d, unk1=%d", srcMacAddr, srcMacAddress, srcPort, destMacAddr, destMacAddress, destPort, bufSize, retryDelay, retryCount, unk1));
        PtpObject ptpObject = this.getNetworkAdapter().createPtpObject();
        ptpObject.setMacAddress(srcMacAddress);
        ptpObject.setPort(srcPort);
        ptpObject.setDestMacAddress(destMacAddress);
        ptpObject.setDestPort(destPort);
        ptpObject.setBufSize(bufSize);
        ptpObject.setRetryDelay(retryDelay);
        ptpObject.setRetryCount(retryCount);
        int result = ptpObject.open();
        if (result != 0) {
            ptpObject.delete();
            return result;
        }
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPtpOpen: returning id=%d", ptpObject.getId()));
        }
        return ptpObject.getId();
    }

    @HLEFunction(nid=-59785093, version=150)
    public int sceNetAdhocPtpConnect(@CheckArgument(value="checkPtpId") int id, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpConnect id=%d, timeout=%d, nonblock=%d", id, timeout, nonblock));
        return this.ptpObjects.get(id).connect(timeout, nonblock);
    }

    @HLEFunction(nid=-527705407, version=150)
    public int sceNetAdhocPtpListen(TPointer srcMacAddr, int srcPort, int bufSize, int retryDelay, int retryCount, int queue, int unk1) {
        Memory mem = Memory.getInstance();
        pspNetMacAddress srcMacAddress = new pspNetMacAddress();
        srcMacAddress.read(mem, srcMacAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpListen scrMacAddr=%s(%s), srcPort=%d, bufSize=0x%X, retryDelay=%d, retryCount=%d, queue=%d, unk1=%d", srcMacAddr, srcMacAddress, srcPort, bufSize, retryDelay, retryCount, queue, unk1));
        PtpObject ptpObject = this.getNetworkAdapter().createPtpObject();
        ptpObject.setMacAddress(srcMacAddress);
        ptpObject.setPort(srcPort);
        ptpObject.setBufSize(bufSize);
        ptpObject.setRetryDelay(retryDelay);
        ptpObject.setRetryCount(retryCount);
        ptpObject.setQueue(queue);
        int result = ptpObject.listen();
        if (result != 0) {
            ptpObject.delete();
            return result;
        }
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPtpListen: returning id=%d", ptpObject.getId()));
        }
        return ptpObject.getId();
    }

    @HLEFunction(nid=-1644686952, version=150)
    public int sceNetAdhocPtpAccept(@CheckArgument(value="checkPtpId") int id, @CanBeNull TPointer peerMacAddr, @CanBeNull TPointer16 peerPortAddr, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpAccept id=%d, peerMacAddr=%s, peerPort=%s, timeout=%d, nonblock=%d", id, peerMacAddr, peerPortAddr, timeout, nonblock));
        return this.ptpObjects.get(id).accept(peerMacAddr.getAddress(), peerPortAddr.getAddress(), timeout, nonblock);
    }

    @HLEFunction(nid=1302644616, version=150)
    public int sceNetAdhocPtpSend(@CheckArgument(value="checkPtpId") int id, TPointer data, TPointer32 dataSizeAddr, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpSend id=%d, data=%s, dataSizeAddr=%s(%d), timeout=%d, nonblock=%d", id, data, dataSizeAddr, dataSizeAddr.getValue(), timeout, nonblock));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), dataSizeAddr.getValue())));
        }
        return this.ptpObjects.get(id).send(data.getAddress(), dataSizeAddr, timeout, nonblock);
    }

    @HLEFunction(nid=-1947587778, version=150)
    public int sceNetAdhocPtpRecv(@CheckArgument(value="checkPtpId") int id, TPointer data, TPointer32 dataSizeAddr, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpRecv id=%d, data=%s, dataSizeAddr=%s(%d), timeout=%d, nonblock=%d", id, data, dataSizeAddr, dataSizeAddr.getValue(), timeout, nonblock));
        return this.ptpObjects.get(id).recv(data, dataSizeAddr, timeout, nonblock);
    }

    @HLEFunction(nid=-1698500948, version=150)
    public int sceNetAdhocPtpFlush(@CheckArgument(value="checkPtpId") int id, int timeout, int nonblock) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpFlush id=%d, timeout=%d, nonblock=%d", id, timeout, nonblock));
        return 0;
    }

    @HLEFunction(nid=360604197, version=150)
    public int sceNetAdhocPtpClose(@CheckArgument(value="checkPtpId") int id, int unknown) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocPtpClose id=%d, unknown=%d", id, unknown));
        this.ptpObjects.remove(id).delete();
        return 0;
    }

    @HLEFunction(nid=-1184345832, version=150)
    public int sceNetAdhocGetPtpStat(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        int objectInfoSize = 36;
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGetPtpStat sizeAddr=%s(%d), buf=%s", sizeAddr.toString(), sizeAddr.getValue(), buf.toString()));
        if (buf.getAddress() == 0) {
            sizeAddr.setValue(36 * this.ptpObjects.size());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocGetPtpStat returning size=%d", sizeAddr.getValue()));
            }
        } else {
            Memory mem = Memory.getInstance();
            int addr = buf.getAddress();
            int endAddr = addr + sizeAddr.getValue();
            sizeAddr.setValue(36 * this.ptpObjects.size());
            pspNetMacAddress nonExistingDestMacAddress = new pspNetMacAddress();
            for (int pdpId : this.ptpObjects.keySet()) {
                PtpObject ptpObject = this.ptpObjects.get(pdpId);
                if (addr + 36 > endAddr || ptpObject == null) break;
                try {
                    ptpObject.update();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocGetPtpStat returning %s at 0x%08X", ptpObject, addr));
                }
                mem.write32(addr += 4, ptpObject.getId());
                ptpObject.getMacAddress().write(mem, addr += 4);
                addr += ptpObject.getMacAddress().sizeof();
                if (ptpObject.getDestMacAddress() != null) {
                    ptpObject.getDestMacAddress().write(mem, addr);
                    addr += ptpObject.getDestMacAddress().sizeof();
                } else {
                    nonExistingDestMacAddress.write(mem, addr);
                    addr += nonExistingDestMacAddress.sizeof();
                }
                mem.write16(addr, (short)ptpObject.getPort());
                mem.write16(addr += 2, (short)ptpObject.getDestPort());
                mem.write32(addr += 2, ptpObject.getSentData());
                mem.write32(addr += 4, ptpObject.getRcvdData());
                mem.write32(addr += 4, 4);
                addr += 4;
            }
            for (int nextAddr = buf.getAddress(); nextAddr < addr; nextAddr += 36) {
                if (nextAddr + 36 >= addr) {
                    mem.write32(nextAddr, 0);
                    continue;
                }
                mem.write32(nextAddr, nextAddr + 36);
            }
        }
        return 0;
    }

    @HLEFunction(nid=2138424120, version=150)
    public int sceNetAdhocGameModeCreateMaster(TPointer data, int size) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGameModeCreateMaster data=%s, size=%d", data, size));
        this.masterGameModeArea = new GameModeArea(data.getAddress(), size);
        this.startGameMode();
        return 0;
    }

    @HLEFunction(nid=846768908, version=150)
    public int sceNetAdhocGameModeCreateReplica(TPointer macAddr, TPointer data, int size) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGameModeCreateReplica macAddr=%s(%s), data=%s, size=%d", macAddr, macAddress, data, size));
        boolean found = false;
        int result = 0;
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (!sceNetAdhoc.isSameMacAddress(gameModeArea.macAddress.macAddress, macAddress.macAddress)) continue;
            gameModeArea.addr = data.getAddress();
            gameModeArea.size = size;
            result = gameModeArea.id;
            found = true;
            break;
        }
        if (!found) {
            GameModeArea gameModeArea = new GameModeArea(macAddress, data.getAddress(), size);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Adding GameMode Replica %s", gameModeArea));
            }
            result = gameModeArea.id;
            this.replicaGameModeAreas.add(gameModeArea);
        }
        this.startGameMode();
        return result;
    }

    @HLEFunction(nid=-1732115256, version=150)
    public int sceNetAdhocGameModeUpdateMaster() {
        log.warn((Object)"PARTIAL: sceNetAdhocGameModeUpdateMaster");
        if (this.masterGameModeArea != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Master Game Mode Area: %s", Utilities.getMemoryDump(this.masterGameModeArea.addr, this.masterGameModeArea.size)));
            }
            this.masterGameModeArea.setNewData();
        }
        return 0;
    }

    @HLEFunction(nid=-97367218, version=150)
    public int sceNetAdhocGameModeUpdateReplica(int id, @CanBeNull TPointer infoAddr) {
        Memory mem = Memory.getInstance();
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGameModeUpdateReplica id=%d, infoAddr=%s", id, infoAddr));
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (gameModeArea.id != id) continue;
            GameModeUpdateInfo gameModeUpdateInfo = new GameModeUpdateInfo();
            if (infoAddr.getAddress() != 0) {
                gameModeUpdateInfo.read(mem, infoAddr.getAddress());
            }
            if (gameModeArea.hasNewData()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Updating GameMode Area with new data: %s", gameModeArea));
                }
                gameModeArea.writeNewData();
                gameModeArea.resetNewData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Replica GameMode Area updated: %s", Utilities.getMemoryDump(gameModeArea.addr, gameModeArea.size)));
                }
                gameModeUpdateInfo.updated = 1;
            } else {
                gameModeUpdateInfo.updated = 0;
            }
            if (infoAddr.getAddress() == 0) break;
            gameModeUpdateInfo.timeStamp = gameModeArea.getUpdateTimestamp();
            gameModeUpdateInfo.write(mem);
            break;
        }
        return 0;
    }

    @HLEFunction(nid=-1608346782, version=150)
    public int sceNetAdhocGameModeDeleteMaster() {
        log.warn((Object)"PARTIAL: sceNetAdhocGameModeDeleteMaster");
        this.masterGameModeArea = null;
        if (this.replicaGameModeAreas.size() <= 0) {
            this.stopGameMode();
        }
        return 0;
    }

    @HLEFunction(nid=186788073, version=150)
    public int sceNetAdhocGameModeDeleteReplica(int id) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocGameModeDeleteReplica id=%d", id));
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (gameModeArea.id != id) continue;
            this.replicaGameModeAreas.remove(gameModeArea);
            break;
        }
        if (this.replicaGameModeAreas.size() <= 0 && this.masterGameModeArea == null) {
            this.stopGameMode();
        }
        return 0;
    }

    protected static class GameModeUpdateInfo
    extends pspAbstractMemoryMappedStructureVariableLength {
        public int updated;
        public long timeStamp;

        protected GameModeUpdateInfo() {
        }

        @Override
        protected void read() {
            super.read();
            this.updated = this.read32();
            this.timeStamp = this.read64();
        }

        @Override
        protected void write() {
            super.write();
            this.write32(this.updated);
            this.write64(this.timeStamp);
        }
    }

    protected static class pspAdhocPollId
    extends pspAbstractMemoryMappedStructure {
        public int id;
        public int events;
        public int revents;

        protected pspAdhocPollId() {
        }

        @Override
        protected void read() {
            this.id = this.read32();
            this.events = this.read32();
            this.revents = this.read32();
        }

        @Override
        protected void write() {
            this.write32(this.id);
            this.write32(this.events);
            this.write32(this.revents);
        }

        @Override
        public int sizeof() {
            return 12;
        }

        public String toString() {
            return String.format("PollId[id=%d, events=0x%X(%s), revents=0x%X(%s)]", this.id, this.events, sceNetAdhoc.getPollEventName(this.events), this.revents, sceNetAdhoc.getPollEventName(this.revents));
        }
    }

    public static class GameModeArea {
        public pspNetMacAddress macAddress;
        public int addr;
        public int size;
        public int id;
        private byte[] newData;
        private long updateTimestamp;

        public GameModeArea(int addr, int size) {
            this.addr = addr;
            this.size = size;
            this.id = -1;
        }

        public GameModeArea(pspNetMacAddress macAddress, int addr, int size) {
            this.macAddress = macAddress;
            this.addr = addr;
            this.size = size;
            this.id = SceUidManager.getNewUid(sceNetAdhoc.replicaIdPurpose);
        }

        public void delete() {
            if (this.id >= 0) {
                SceUidManager.releaseUid(this.id, sceNetAdhoc.replicaIdPurpose);
                this.id = -1;
            }
        }

        public void setNewData(byte[] newData) {
            this.updateTimestamp = Emulator.getClock().microTime();
            this.newData = newData;
        }

        public void setNewData() {
            byte[] data = new byte[this.size];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.addr, this.size, 1);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)memoryReader.readNext();
            }
            this.setNewData(data);
        }

        public void resetNewData() {
            this.newData = null;
        }

        public byte[] getNewData() {
            return this.newData;
        }

        public boolean hasNewData() {
            return this.newData != null;
        }

        public void writeNewData() {
            if (this.newData != null) {
                Utilities.writeBytes(this.addr, Math.min(this.size, this.newData.length), this.newData, 0);
            }
        }

        public long getUpdateTimestamp() {
            return this.updateTimestamp;
        }

        public String toString() {
            if (this.macAddress == null) {
                return String.format("Master GameModeArea addr=0x%08X, size=%d", this.addr, this.size);
            }
            return String.format("Replica GameModeArea id=%d, macAddress=%s, addr=0x%08X, size=%d", this.id, this.macAddress, this.addr, this.size);
        }
    }

    protected static class GameModeScheduledAction
    implements IAction {
        private final int scheduleRepeatMicros;
        private long nextSchedule;

        public GameModeScheduledAction(int scheduleRepeatMicros) {
            this.scheduleRepeatMicros = scheduleRepeatMicros;
        }

        public void stop() {
            Scheduler.getInstance().removeAction(this.nextSchedule, this);
        }

        public void start() {
            Scheduler.getInstance().addAction(this);
        }

        @Override
        public void execute() {
            Modules.sceNetAdhocModule.hleGameModeUpdate();
            this.nextSchedule = Scheduler.getNow() + (long)this.scheduleRepeatMicros;
            Scheduler.getInstance().addAction(this.nextSchedule, this);
        }
    }
}

