/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import java.util.List;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetAdhocMatching
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNetAdhocMatching");
    protected HashMap<Integer, MatchingObject> matchingObjects;
    public static final int loopThreadRegisterArgument = 16;
    public static final int PSP_ADHOC_MATCHING_EVENT_HELLO = 1;
    public static final int PSP_ADHOC_MATCHING_EVENT_JOIN = 2;
    public static final int PSP_ADHOC_MATCHING_EVENT_LEFT = 3;
    public static final int PSP_ADHOC_MATCHING_EVENT_REJECT = 4;
    public static final int PSP_ADHOC_MATCHING_EVENT_CANCEL = 5;
    public static final int PSP_ADHOC_MATCHING_EVENT_ACCEPT = 6;
    public static final int PSP_ADHOC_MATCHING_EVENT_COMPLETE = 7;
    public static final int PSP_ADHOC_MATCHING_EVENT_TIMEOUT = 8;
    public static final int PSP_ADHOC_MATCHING_EVENT_ERROR = 9;
    public static final int PSP_ADHOC_MATCHING_EVENT_DISCONNECT = 10;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA = 11;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA_CONFIRM = 12;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA_TIMEOUT = 13;
    public static final int PSP_ADHOC_MATCHING_EVENT_INTERNAL_PING = 100;
    public static final int PSP_ADHOC_MATCHING_MODE_HOST = 1;
    public static final int PSP_ADHOC_MATCHING_MODE_CLIENT = 2;
    public static final int PSP_ADHOC_MATCHING_MODE_PTP = 3;

    @Override
    public String getName() {
        return "sceNetAdhocMatching";
    }

    @Override
    public void start() {
        this.matchingObjects = new HashMap();
        super.start();
    }

    protected INetworkAdapter getNetworkAdapter() {
        return Modules.sceNetModule.getNetworkAdapter();
    }

    public int checkMatchingId(int matchingId) {
        if (!this.matchingObjects.containsKey(matchingId)) {
            throw new SceKernelErrorException(-2143221753);
        }
        return matchingId;
    }

    public void hleNetAdhocMatchingEventThread(Processor processor) {
        MatchingObject matchingObject;
        int matchingId = processor.cpu.gpr[16];
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleNetAdhocMatchingEventThread matchingId=%d", matchingId));
        }
        if ((matchingObject = this.matchingObjects.get(matchingId)) != null && matchingObject.eventLoop()) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        } else {
            processor.cpu.gpr[2] = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
        }
    }

    public void hleNetAdhocMatchingInputThread(Processor processor) {
        MatchingObject matchingObject;
        int matchingId = processor.cpu.gpr[16];
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleNetAdhocMatchingInputThread matchingId=%d", matchingId));
        }
        if ((matchingObject = this.matchingObjects.get(matchingId)) != null && matchingObject.inputLoop()) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        } else {
            processor.cpu.gpr[2] = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
        }
    }

    private static String getModeName(int mode) {
        switch (mode) {
            case 1: {
                return "HOST";
            }
            case 2: {
                return "CLIENT";
            }
            case 3: {
                return "PTP";
            }
        }
        return String.format("Unknown mode %d", mode);
    }

    @HLEFunction(nid=707403271, version=150)
    public int sceNetAdhocMatchingInit(int memsize) {
        log.warn((Object)String.format("IGNORING: sceNetAdhocMatchingInit: memsize=0x%X", memsize));
        return 0;
    }

    @HLEFunction(nid=2034625754, version=150)
    public int sceNetAdhocMatchingTerm() {
        log.warn((Object)"IGNORING: sceNetAdhocMatchingTerm");
        return 0;
    }

    @HLEFunction(nid=-899753361, version=150)
    public int sceNetAdhocMatchingCreate(int mode, int maxPeers, int port, int bufSize, int helloDelay, int pingDelay, int initCount, int msgDelay, @CanBeNull TPointer callback) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingCreate mode=%d(%s), maxPeers=%d, port=%d, bufSize=%d, helloDelay=%d, pingDelay=%d, initCount=%d, msgDelay=%d, callback=%s", mode, sceNetAdhocMatching.getModeName(mode), maxPeers, port, bufSize, helloDelay, pingDelay, initCount, msgDelay, callback));
        MatchingObject matchingObject = this.getNetworkAdapter().createMatchingObject();
        matchingObject.setMode(mode);
        matchingObject.setMaxPeers(maxPeers);
        matchingObject.setPort(port);
        matchingObject.setBufSize(bufSize);
        matchingObject.setHelloDelay(helloDelay);
        matchingObject.setPingDelay(pingDelay);
        matchingObject.setInitCount(initCount);
        matchingObject.setMsgDelay(msgDelay);
        matchingObject.setCallback(callback.getAddress());
        matchingObject.create();
        this.matchingObjects.put(matchingObject.getId(), matchingObject);
        return matchingObject.getId();
    }

    @HLEFunction(nid=-1813039037, version=150)
    public int sceNetAdhocMatchingStart(@CheckArgument(value="checkMatchingId") int matchingId, int evthPri, int evthStack, int inthPri, int inthStack, int optLen, @CanBeNull TPointer optData) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingStart matchingId=%d, evthPri=%d, evthStack=0x%X, inthPri=%d, inthStack=0x%X, optLen=%d, optData=%s", matchingId, evthPri, evthStack, inthPri, inthStack, optLen, optData));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Matching opt data: %s", Utilities.getMemoryDump(optData.getAddress(), optLen)));
        }
        return this.matchingObjects.get(matchingId).start(evthPri, evthStack, inthPri, inthStack, optLen, optData.getAddress());
    }

    @HLEFunction(nid=850482867, version=150)
    public int sceNetAdhocMatchingStop(@CheckArgument(value="checkMatchingId") int matchingId) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingStop matchingId=%d", matchingId));
        return this.matchingObjects.get(matchingId).stop();
    }

    @HLEFunction(nid=-244404401, version=150)
    public int sceNetAdhocMatchingDelete(@CheckArgument(value="checkMatchingId") int matchingId) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingDelete matchingId=%d", matchingId));
        this.matchingObjects.remove(matchingId).delete();
        return 0;
    }

    @HLEFunction(nid=-141266217, version=150)
    public int sceNetAdhocMatchingSendData(@CheckArgument(value="checkMatchingId") int matchingId, TPointer macAddr, int dataLen, TPointer data) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingSendData matchingId=%d, macAddr=%s(%s), dataLen=%d, data=%s", matchingId, macAddr, macAddress, dataLen, data));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), dataLen)));
        }
        return this.matchingObjects.get(matchingId).send(macAddress, dataLen, data.getAddress());
    }

    @HLEFunction(nid=-333892739, version=150)
    public int sceNetAdhocMatchingAbortSendData(@CheckArgument(value="checkMatchingId") int matchingId, TPointer macAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("UNIMPLEMENTED: sceNetAdhocMatchingAbortSendData matchingId=%d, macAddr=%s(%s)", matchingId, macAddr, macAddress));
        return 0;
    }

    @HLEFunction(nid=1581075321, version=150)
    public int sceNetAdhocMatchingSelectTarget(@CheckArgument(value="checkMatchingId") int matchingId, TPointer macAddr, int optLen, @CanBeNull TPointer optData) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingSelectTarget matchingId=%d, macAddr=%s(%s), optLen=%d, optData=%s", matchingId, macAddr, macAddress, optLen, optData));
        return this.matchingObjects.get(matchingId).selectTarget(macAddress, optLen, optData.getAddress());
    }

    @HLEFunction(nid=-365141752, version=150)
    public int sceNetAdhocMatchingCancelTarget(@CheckArgument(value="checkMatchingId") int matchingId, TPointer macAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingCancelTarget matchingId=%d, macAddr=%s(%s)", matchingId, macAddr, macAddress));
        return this.matchingObjects.get(matchingId).cancelTarget(macAddress);
    }

    @HLEFunction(nid=-1890009377, version=150)
    public int sceNetAdhocMatchingCancelTargetWithOpt(@CheckArgument(value="checkMatchingId") int matchingId, TPointer macAddr, int optLen, @CanBeNull TPointer optData) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(Memory.getInstance(), macAddr.getAddress());
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingCancelTargetWithOpt matchingId=%d, macAddr=%s(%s), optLen=%d, optData=%s", matchingId, macAddr, macAddress, optLen, optData));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Opt data: %s", Utilities.getMemoryDump(optData.getAddress(), optLen)));
        }
        return this.matchingObjects.get(matchingId).cancelTarget(macAddress, optLen, optData.getAddress());
    }

    @HLEFunction(nid=-1244042198, version=150)
    public int sceNetAdhocMatchingGetHelloOpt(@CheckArgument(value="checkMatchingId") int matchingId, TPointer32 optLenAddr, @CanBeNull TPointer optData) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingGetHelloOpt matchingId=%d, optlenAddr=%s, optData=%s", matchingId, optLenAddr, optData));
        MatchingObject matchingObject = this.matchingObjects.get(matchingId);
        int helloOptLen = matchingObject.getHelloOptLen();
        int bufSize = optLenAddr.getValue();
        optLenAddr.setValue(helloOptLen);
        if (helloOptLen > 0 && optData.getAddress() != 0 && bufSize > 0) {
            int length = Math.min(bufSize, helloOptLen);
            Utilities.writeBytes(optData.getAddress(), length, matchingObject.getHelloOptData(), 0);
        }
        return 0;
    }

    @HLEFunction(nid=-1248960073, version=150)
    public int sceNetAdhocMatchingSetHelloOpt(@CheckArgument(value="checkMatchingId") int matchingId, int optLen, @CanBeNull TPointer optData) {
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingSetHelloOpt matchingId=%d, optLen=%d, optData=%s", matchingId, optLen, optData));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Hello opt data: %s", Utilities.getMemoryDump(optData.getAddress(), optLen)));
        }
        this.matchingObjects.get(matchingId).setHelloOpt(optLen, optData.getAddress());
        return 0;
    }

    @HLEFunction(nid=-980693602, version=150)
    public int sceNetAdhocMatchingGetMembers(@CheckArgument(value="checkMatchingId") int matchingId, TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        int matchingMemberSize = 12;
        log.warn((Object)String.format("PARTIAL: sceNetAdhocMatchingGetMembers matchingId=%d, sizeAddr=%s(%d), buf=%s", matchingId, sizeAddr.toString(), sizeAddr.getValue(), buf));
        MatchingObject matchingObject = this.matchingObjects.get(matchingId);
        List<pspNetMacAddress> members = matchingObject.getMembers();
        if (buf.getAddress() == 0) {
            sizeAddr.setValue(12 * members.size());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocMatchingGetMembers returning size=%d", sizeAddr.getValue()));
            }
        } else {
            Memory mem = Memory.getInstance();
            int addr = buf.getAddress();
            int endAddr = addr + sizeAddr.getValue();
            sizeAddr.setValue(12 * members.size());
            for (pspNetMacAddress member : members) {
                if (addr + 12 > endAddr || member == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocMatchingGetMembers returning %s at 0x%08X", member, addr));
                }
                member.write(mem, addr += 4);
                mem.memset(addr += member.sizeof(), (byte)0, 2);
                addr += 2;
            }
            for (int nextAddr = buf.getAddress(); nextAddr < addr; nextAddr += 12) {
                if (nextAddr + 12 >= addr) {
                    mem.write32(nextAddr, 0);
                    continue;
                }
                mem.write32(nextAddr, nextAddr + 12);
            }
        }
        return 0;
    }

    @HLEFunction(nid=-1671627907, version=150)
    public void sceNetAdhocMatchingGetPoolStat(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"UNIMPLEMENTED: sceNetAdhocMatchingGetPoolStat");
        cpu.gpr[2] = -559038242;
    }

    @HLEFunction(nid=1090057269, version=150)
    public void sceNetAdhocMatchingGetPoolMaxAlloc(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"UNIMPLEMENTED: sceNetAdhocMatchingGetPoolMaxAlloc");
        cpu.gpr[2] = -559038242;
    }
}

