/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Debugger.ElfHeaderInfo;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.NIDMapper;
import jpcsp.format.DeferredStub;
import jpcsp.format.DeferredVStub32;
import jpcsp.format.DeferredVStubHI16;
import jpcsp.format.DeferredVstubLO16;
import jpcsp.format.Elf32;
import jpcsp.format.Elf32EntHeader;
import jpcsp.format.Elf32ProgramHeader;
import jpcsp.format.Elf32Relocate;
import jpcsp.format.Elf32SectionHeader;
import jpcsp.format.Elf32StubHeader;
import jpcsp.format.PBP;
import jpcsp.format.PSF;
import jpcsp.format.PSP;
import jpcsp.format.PSPModuleInfo;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemorySection;
import jpcsp.memory.MemorySections;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class Loader {
    private static Loader instance;
    private boolean loadedFirstModule;
    private static Logger log;
    public static final int SCE_MAGIC = 1162040190;
    public static final int PSP_MAGIC = 0x50535000;
    public static final int EDAT_MAGIC = 0x54414445;
    private static final int FIRMWAREVERSION_HOMEBREW = 999;
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_ELF = 1;
    public static final int FORMAT_PRX = 2;
    public static final int FORMAT_PBP = 4;
    public static final int FORMAT_SCE = 8;
    public static final int FORMAT_PSP = 16;

    public static Loader getInstance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    private Loader() {
    }

    public void reset() {
        this.loadedFirstModule = false;
    }

    public SceModule LoadModule(String pspfilename, ByteBuffer f, int baseAddress, boolean analyzeOnly) throws IOException {
        SceModule module;
        block13: {
            int currentOffset;
            block12: {
                block11: {
                    module = new SceModule(false);
                    currentOffset = f.position();
                    module.fileFormat = 0;
                    module.pspfilename = pspfilename;
                    if (!module.pspfilename.contains(":")) {
                        module.pspfilename = "ms0:" + module.pspfilename;
                    }
                    if (f.capacity() - f.position() == 0) {
                        log.error((Object)"LoadModule: no data.");
                        return module;
                    }
                    f.position(currentOffset);
                    if (!this.LoadPBP(f, module, baseAddress, analyzeOnly)) break block11;
                    currentOffset = f.position();
                    if (currentOffset != f.limit()) break block12;
                    break block13;
                }
                if (!this.loadedFirstModule) {
                    this.loadPSF(module, analyzeOnly);
                }
            }
            if (module.psf != null) {
                log.info((Object)("PBP meta data :\n" + module.psf));
                if (!this.loadedFirstModule) {
                    if (module.psf.isLikelyHomebrew()) {
                        Emulator.getInstance().setFirmwareVersion(999);
                    } else {
                        Emulator.getInstance().setFirmwareVersion(module.psf.getString("PSP_SYSTEM_VER"));
                    }
                    Modules.SysMemUserForUserModule.setMemory64MB(module.psf.getNumeric("MEMSIZE") == 1);
                }
            }
            f.position(currentOffset);
            if (!this.LoadSPRX(f, module, baseAddress, analyzeOnly)) {
                f.position(currentOffset);
                if (!this.LoadSCE(f, module, baseAddress, analyzeOnly)) {
                    f.position(currentOffset);
                    if (!this.LoadPSP(f, module, baseAddress, analyzeOnly)) {
                        f.position(currentOffset);
                        if (!this.LoadELF(f, module, baseAddress, analyzeOnly)) {
                            f.position(currentOffset);
                            this.LoadUNK(f, module, baseAddress, analyzeOnly);
                        }
                    }
                }
            }
        }
        return module;
    }

    private void loadPSF(SceModule module, boolean analyzeOnly) {
        File[] eboot;
        if (module.psf != null) {
            return;
        }
        String filetoload = module.pspfilename;
        if (filetoload.startsWith("ms0:")) {
            filetoload = filetoload.replace("ms0:", "ms0");
        }
        File metapbp = null;
        File pbpfile = new File(filetoload);
        if (pbpfile.getParentFile() == null || pbpfile.getParentFile().getParentFile() == null) {
            return;
        }
        File metadir = new File(pbpfile.getParentFile().getParentFile().getPath() + File.separatorChar + "%" + pbpfile.getParentFile().getName());
        if (metadir.exists() && (eboot = metadir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().equalsIgnoreCase("eboot.pbp");
            }
        })).length > 0) {
            metapbp = eboot[0];
        }
        if ((metadir = new File(pbpfile.getParentFile().getParentFile().getPath() + File.separatorChar + pbpfile.getParentFile().getName() + "%")).exists() && (eboot = metadir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File arg0) {
                return arg0.getName().equalsIgnoreCase("eboot.pbp");
            }
        })).length > 0) {
            metapbp = eboot[0];
        }
        if (metapbp != null) {
            try {
                FileChannel roChannel = new RandomAccessFile(metapbp, "r").getChannel();
                MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                PBP meta = new PBP(readbuffer);
                module.psf = meta.readPSF(readbuffer);
                roChannel.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            File[] psffile = pbpfile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File arg0) {
                    return arg0.getName().equalsIgnoreCase("param.sfo");
                }
            });
            if (psffile != null && psffile.length > 0) {
                try {
                    FileChannel roChannel = new RandomAccessFile(psffile[0], "r").getChannel();
                    MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
                    module.psf = new PSF();
                    module.psf.read(readbuffer);
                    roChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean LoadPBP(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        PBP pbp = new PBP(f);
        if (pbp.isValid()) {
            module.fileFormat |= 4;
            if (pbp.getOffsetParam() > 0L) {
                module.psf = pbp.readPSF(f);
            }
            if (Settings.getInstance().readBool("emu.pbpunpack")) {
                PBP.unpackPBP(f);
            }
            ElfHeaderInfo.PbpInfo = pbp.toString();
            f.position((int)pbp.getOffsetPspData());
            return true;
        }
        return false;
    }

    private boolean LoadSPRX(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        int magicPSP = Utilities.readWord(f);
        int magicEDAT = Utilities.readWord(f);
        if (magicPSP == 0x50535000 && magicEDAT == 0x54414445) {
            log.warn((Object)"Encrypted file detected! (.PSPEDAT)");
            f.position(144);
            this.LoadPSP(f.slice(), module, baseAddress, analyzeOnly);
            return true;
        }
        return false;
    }

    private boolean LoadSCE(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        int magic = Utilities.readWord(f);
        if (magic == 1162040190) {
            module.fileFormat |= 8;
            log.warn((Object)"Encrypted file not supported! (~SCE)");
            return true;
        }
        return false;
    }

    private boolean LoadPSP(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        PSP psp = new PSP(f);
        if (psp.isValid()) {
            module.fileFormat |= 0x10;
            log.warn((Object)"Encrypted file detected! (~PSP)");
            if (!this.loadedFirstModule) {
                log.info((Object)"Calling crypto engine for PRX.");
                this.LoadELF(psp.decrypt(f), module, baseAddress, analyzeOnly);
            }
            return true;
        }
        return false;
    }

    private boolean LoadELF(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        int elfOffset = f.position();
        Elf32 elf = new Elf32(f);
        if (elf.getHeader().isValid()) {
            module.fileFormat |= 1;
            if (!elf.getHeader().isMIPSExecutable()) {
                log.error((Object)"Loader NOT a MIPS executable");
                return false;
            }
            if (elf.getHeader().isPRXDetected()) {
                log.debug((Object)"Loader: Relocation required (PRX)");
                module.fileFormat |= 2;
            } else if (elf.getHeader().requiresRelocation()) {
                log.info((Object)"Loader: Relocation required (ELF)");
            } else {
                if (baseAddress > 0x8900000) {
                    log.warn((Object)"Loader: Probably trying to load PBP ELF while another PBP ELF is already loaded");
                }
                baseAddress = 0;
            }
            module.baseAddress = baseAddress;
            module.entry_addr = elf.getHeader().getE_entry() == 0xFFFFFFFFL ? -1 : baseAddress + (int)elf.getHeader().getE_entry();
            module.loadAddressLow = baseAddress != 0 ? baseAddress : MemoryMap.END_USERSPACE;
            module.loadAddressHigh = baseAddress;
            this.LoadELFProgram(f, module, baseAddress, elf, elfOffset, analyzeOnly);
            this.LoadELFSections(f, module, baseAddress, elf, elfOffset, analyzeOnly);
            if (module.loadAddressLow > module.loadAddressHigh) {
                log.error((Object)String.format("Incorrect ELF module address: loadAddressLow=0x%08X, loadAddressHigh=0x%08X", module.loadAddressLow, module.loadAddressHigh));
                module.loadAddressHigh = module.loadAddressLow;
            }
            if (!analyzeOnly) {
                if (elf.getHeader().requiresRelocation()) {
                    this.relocateFromHeaders(f, module, baseAddress, elf, elfOffset);
                }
                this.LoadELFModuleInfo(f, module, baseAddress, elf, elfOffset);
                this.LoadELFReserveMemory(module);
                this.LoadELFImports(module);
                this.LoadELFExports(module);
                Managers.modules.addModule(module);
                this.ProcessUnresolvedImports();
                this.LoadELFDebuggerInfo(f, module, baseAddress, elf, elfOffset);
                module.write(Memory.getInstance(), module.address);
                this.loadedFirstModule = true;
            }
            return true;
        }
        log.debug((Object)"Loader: Not a ELF");
        return false;
    }

    private boolean LoadUNK(ByteBuffer f, SceModule module, int baseAddress, boolean analyzeOnly) throws IOException {
        byte m0 = f.get();
        byte m1 = f.get();
        byte m2 = f.get();
        byte m3 = f.get();
        if (m0 == 67 && m1 == 73 && m2 == 83 && m3 == 79) {
            log.info((Object)"This is not an executable file!");
            log.info((Object)"Try using the Load UMD menu item");
        } else if (m0 == 0 && m1 == 80 && m2 == 83 && m3 == 70) {
            log.info((Object)"This is not an executable file!");
        } else {
            boolean handled = false;
            if (f.limit() >= 32774) {
                f.position(32768);
                byte[] id = new byte[6];
                f.get(id);
                if ((char)id[1] == 'C' && (char)id[2] == 'D' && (char)id[3] == '0' && (char)id[4] == '0' && (char)id[5] == '1') {
                    log.info((Object)"This is not an executable file!");
                    log.info((Object)"Try using the Load UMD menu item");
                    handled = true;
                }
            }
            if (!handled) {
                log.info((Object)"Unrecognized file format");
                log.info((Object)String.format("File magic %02X %02X %02X %02X", m0, m1, m2, m3));
                if (log.isDebugEnabled()) {
                    byte[] buffer = new byte[256];
                    buffer[0] = m0;
                    buffer[1] = m1;
                    buffer[2] = m2;
                    buffer[3] = m3;
                    f.get(buffer, 4, buffer.length - 4);
                    log.debug((Object)String.format("File header: %s", Utilities.getMemoryDump(buffer, 0, buffer.length, 16)));
                }
            }
        }
        return false;
    }

    private void LoadELFProgram(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int elfOffset, boolean analyzeOnly) throws IOException {
        List<Elf32ProgramHeader> programHeaderList = elf.getProgramHeaderList();
        Memory mem = Memory.getInstance();
        int i = 0;
        module.bss_size = 0;
        for (Elf32ProgramHeader phdr : programHeaderList) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("ELF Program Header: %s", phdr.toString()));
            }
            if (phdr.getP_type() == 1L) {
                int fileOffset = (int)phdr.getP_offset();
                int memOffset = baseAddress + (int)phdr.getP_vaddr();
                if (!Memory.isAddressGood(memOffset) && !Memory.isAddressGood(memOffset = (int)phdr.getP_vaddr())) {
                    log.warn((Object)String.format("Program header has invalid memory offset 0x%08X!", memOffset));
                }
                int fileLen = (int)phdr.getP_filesz();
                int memLen = (int)phdr.getP_memsz();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("PH#%d: loading program %08X - file %08X - mem %08X", i, memOffset, memOffset + fileLen, memOffset + memLen));
                    log.debug((Object)String.format("PH#%d:\n%s", i, phdr));
                }
                f.position(elfOffset + fileOffset);
                if (f.position() + fileLen > f.limit()) {
                    int newLen = f.limit() - f.position();
                    log.warn((Object)String.format("PH#%d: program overflow clamping len %08X to %08X", i, fileLen, newLen));
                    fileLen = newLen;
                }
                if (!analyzeOnly) {
                    if (memLen > fileLen) {
                        mem.memset(memOffset + fileLen, (byte)0, memLen - fileLen);
                    }
                    mem.copyToMemory(memOffset, f, fileLen);
                }
                if (memOffset < module.loadAddressLow) {
                    module.loadAddressLow = memOffset;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("PH#%d: new loadAddressLow %08X", i, module.loadAddressLow));
                    }
                }
                if (memOffset + memLen > module.loadAddressHigh) {
                    module.loadAddressHigh = memOffset + memLen;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("PH#%d: new loadAddressHigh %08X", i, module.loadAddressHigh));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("PH#%d: contributes %08X to bss size", i, (int)(phdr.getP_memsz() - phdr.getP_filesz())));
                }
                module.bss_size += (int)(phdr.getP_memsz() - phdr.getP_filesz());
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("PH alloc consumption %08X (mem %08X)", module.loadAddressHigh - module.loadAddressLow, module.bss_size));
        }
    }

    private void LoadELFSections(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int elfOffset, boolean analyzeOnly) throws IOException {
        List<Elf32SectionHeader> sectionHeaderList = elf.getSectionHeaderList();
        Memory mem = Memory.getInstance();
        for (Elf32SectionHeader shdr : sectionHeaderList) {
            int memOffset;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("ELF Section Header: %s", shdr.toString()));
            }
            if (!Memory.isAddressGood(memOffset = baseAddress + (int)shdr.getSh_addr())) {
                memOffset = (int)shdr.getSh_addr();
            }
            int len = (int)shdr.getSh_size();
            int flags = shdr.getSh_flags();
            if (flags != 0 && Memory.isAddressGood(memOffset)) {
                boolean read = (flags & 2) != 0;
                boolean write = (flags & 1) != 0;
                boolean execute = (flags & 4) != 0;
                MemorySection memorySection = new MemorySection(memOffset, len, read, write, execute);
                MemorySections.getInstance().addMemorySection(memorySection);
            }
            if ((flags & 2) == 0) continue;
            switch (shdr.getSh_type()) {
                case 1: {
                    if (len == 0) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("%s: ignoring zero-length type 1 section %08X", shdr.getSh_namez(), memOffset));
                        break;
                    }
                    if (!Memory.isAddressGood(memOffset)) {
                        log.error((Object)String.format("Section header (type 1) has invalid memory offset 0x%08X!", memOffset));
                        break;
                    }
                    if (memOffset < module.loadAddressLow) {
                        log.warn((Object)String.format("%s: section allocates more than program %08X - %08X", shdr.getSh_namez(), memOffset, memOffset + len));
                        module.loadAddressLow = memOffset;
                    }
                    if (memOffset + len <= module.loadAddressHigh) break;
                    log.warn((Object)String.format("%s: section allocates more than program %08X - %08X", shdr.getSh_namez(), memOffset, memOffset + len));
                    module.loadAddressHigh = memOffset + len;
                    break;
                }
                case 8: {
                    if (len == 0) {
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("%s: ignoring zero-length type 8 section %08X", shdr.getSh_namez(), memOffset));
                        break;
                    }
                    if (!Memory.isAddressGood(memOffset)) {
                        log.error((Object)String.format("Section header (type 8) has invalid memory offset 0x%08X!", memOffset));
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("%s: clearing section %08X - %08X (len %08X)", shdr.getSh_namez(), memOffset, memOffset + len, len));
                    }
                    if (!analyzeOnly) {
                        mem.memset(memOffset, (byte)0, len);
                    }
                    if (memOffset < module.loadAddressLow) {
                        module.loadAddressLow = memOffset;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("%s: new loadAddressLow %08X (+%08X)", shdr.getSh_namez(), module.loadAddressLow, len));
                        }
                    }
                    if (memOffset + len <= module.loadAddressHigh) break;
                    module.loadAddressHigh = memOffset + len;
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("%s: new loadAddressHigh %08X (+%08X)", shdr.getSh_namez(), module.loadAddressHigh, len));
                }
            }
        }
        Elf32SectionHeader shdr = elf.getSectionHeader(".text");
        if (shdr != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SH: Storing text size %08X %d", shdr.getSh_size(), shdr.getSh_size()));
            }
            module.text_addr = (int)((long)baseAddress + shdr.getSh_addr());
            module.text_size = (int)shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".data")) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SH: Storing data size %08X %d", shdr.getSh_size(), shdr.getSh_size()));
            }
            module.data_size = (int)shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".bss")) != null && shdr.getSh_size() != 0L) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SH: Storing bss size %08X %d", shdr.getSh_size(), shdr.getSh_size()));
            }
            if (module.bss_size == (int)shdr.getSh_size()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"SH: Same bss size already set");
                }
            } else if (module.bss_size > (int)shdr.getSh_size()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("SH: Larger bss size already set (%08X > %08X)", module.bss_size, shdr.getSh_size()));
                }
            } else if (module.bss_size != 0) {
                log.warn((Object)String.format("SH: Overwriting bss size %08X with %08X", module.bss_size, shdr.getSh_size()));
                module.bss_size = (int)shdr.getSh_size();
            } else {
                log.info((Object)"SH: bss size not already set");
                module.bss_size = (int)shdr.getSh_size();
            }
        }
        ++module.nsegment;
        module.segmentaddr[0] = module.loadAddressLow;
        module.segmentsize[0] = module.loadAddressHigh - module.loadAddressLow;
    }

    private void LoadELFReserveMemory(SceModule module) {
        int address;
        int size;
        SysMemUserForUser.SysMemInfo info;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reserving 0x%X bytes at 0x%08X for module '%s'", module.loadAddressHigh - module.loadAddressLow, module.loadAddressLow, module.pspfilename));
        }
        if ((info = Modules.SysMemUserForUserModule.malloc(2, module.modname, 2, size = module.loadAddressHigh - (address = module.loadAddressLow & 0xFFFFFF00), address)) == null || info.addr != address) {
            log.warn((Object)String.format("Failed to properly reserve memory consumed by module %s at address 0x%08X, size 0x%X: allocated %s", module.modname, address, size, info));
        }
        module.addAllocatedMemory(info);
    }

    private void LoadELFModuleInfo(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int elfOffset) throws IOException {
        Elf32ProgramHeader phdr = elf.getProgramHeader(0);
        Elf32SectionHeader shdr = elf.getSectionHeader(".rodata.sceModuleInfo");
        if (!elf.getHeader().isPRXDetected() && shdr == null) {
            log.warn((Object)"ELF is not PRX, but has no section headers!");
            int memOffset = (int)(phdr.getP_vaddr() + (phdr.getP_paddr() & Integer.MAX_VALUE) - phdr.getP_offset());
            log.warn((Object)("Manually locating ModuleInfo at address: 0x" + Integer.toHexString(memOffset)));
            PSPModuleInfo moduleInfo = new PSPModuleInfo();
            moduleInfo.read(Memory.getInstance(), memOffset);
            module.copy(moduleInfo);
        } else if (elf.getHeader().isPRXDetected()) {
            int memOffset = (int)((long)baseAddress + (phdr.getP_paddr() & Integer.MAX_VALUE) - phdr.getP_offset());
            PSPModuleInfo moduleInfo = new PSPModuleInfo();
            moduleInfo.read(Memory.getInstance(), memOffset);
            module.copy(moduleInfo);
        } else if (shdr != null) {
            int memOffset = (int)((long)baseAddress + shdr.getSh_addr());
            PSPModuleInfo moduleInfo = new PSPModuleInfo();
            moduleInfo.read(Memory.getInstance(), memOffset);
            module.copy(moduleInfo);
        } else {
            log.error((Object)"ModuleInfo not found!");
            return;
        }
        log.info((Object)("Found ModuleInfo name:'" + module.modname + "' version:" + String.format("%02x%02x", module.version[1], module.version[0]) + " attr:" + String.format("%08x", module.attribute) + " gp:" + String.format("%08x", module.gp_value)));
        if ((module.attribute & 0x1000) != 0) {
            log.warn((Object)"Kernel mode module detected");
        }
        if ((module.attribute & 0x800) != 0) {
            log.warn((Object)"VSH mode module detected");
        }
    }

    private void relocateFromBuffer(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int RelCount) throws IOException {
        Elf32Relocate rel = new Elf32Relocate();
        int AHL = 0;
        LinkedList<Integer> deferredHi16 = new LinkedList<Integer>();
        Memory mem = Memory.getInstance();
        for (int i = 0; i < RelCount; ++i) {
            rel.read(f);
            int R_TYPE = (int)(rel.getR_info() & 0xFFL);
            int OFS_BASE = (int)(rel.getR_info() >> 8 & 0xFFL);
            int ADDR_BASE = (int)(rel.getR_info() >> 16 & 0xFFL);
            long R_OFFSET = rel.getR_offset();
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Relocation #%d type=%d, Offset PH#%d, Base Offset PH#%d, Offset 0x%08X", i, R_TYPE, OFS_BASE, ADDR_BASE, R_OFFSET));
            }
            int phOffset = (int)elf.getProgramHeader(OFS_BASE).getP_vaddr();
            int phBaseOffset = (int)elf.getProgramHeader(ADDR_BASE).getP_vaddr();
            int data_addr = (int)((long)baseAddress + R_OFFSET + (long)phOffset);
            int data = Utilities.readUnaligned32(mem, data_addr);
            long result = 0L;
            int word32 = data & 0xFFFFFFFF;
            int targ26 = data & 0x3FFFFFF;
            int hi16 = data & 0xFFFF;
            int lo16 = data & 0xFFFF;
            int rel16 = data & 0xFFFF;
            int A = 0;
            int S = baseAddress + phBaseOffset;
            int GP_ADDR = baseAddress + (int)R_OFFSET;
            int GP_OFFSET = GP_ADDR - (baseAddress & 0xFFFF0000);
            switch (R_TYPE) {
                case 0: {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_NONE addr=%08X", data_addr));
                    break;
                }
                case 1: {
                    data = data & 0xFFFF0000 | data + S & 0xFFFF;
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_16 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    break;
                }
                case 2: {
                    data += S;
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_32 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    break;
                }
                case 4: {
                    A = targ26;
                    result = (A << 2) + S >> 2;
                    data &= 0xFC000000;
                    data |= (int)(result & 0x3FFFFFFL);
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_26 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    break;
                }
                case 5: {
                    A = hi16;
                    AHL = A << 16;
                    deferredHi16.add(data_addr);
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_HI16 addr=%08X", data_addr));
                    break;
                }
                case 6: {
                    A = lo16;
                    AHL &= 0xFFFF0000;
                    result = (AHL |= A & 0xFFFF) + S;
                    data &= 0xFFFF0000;
                    data = (int)((long)data | result & 0xFFFFL);
                    Iterator it = deferredHi16.iterator();
                    while (it.hasNext()) {
                        int data_addr2 = (Integer)it.next();
                        int data2 = Utilities.readUnaligned32(mem, data_addr2);
                        result = ((data2 & 0xFFFF) << 16) + A + S;
                        if ((A & 0x8000) != 0) {
                            result -= 65536L;
                        }
                        if ((result & 0x8000L) != 0L) {
                            result += 65536L;
                        }
                        data2 &= 0xFFFF0000;
                        data2 = (int)((long)data2 | result >> 16 & 0xFFFFL);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("R_MIPS_HILO16 addr=%08X before=%08X after=%08X", data_addr2, Utilities.readUnaligned32(mem, data_addr2), data2));
                        }
                        Utilities.writeUnaligned32(mem, data_addr2, data2);
                        it.remove();
                    }
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("R_MIPS_LO16 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    break;
                }
                case 7: {
                    A = rel16;
                    result = A == 0 ? (long)(S - GP_ADDR) : (long)(S + GP_OFFSET + ((A & 0x8000) != 0 ? (A & 0x3FFF) + 16384 | 0xFFFF0000 : A) - GP_ADDR);
                    if (result > 32768L || result < -32768L) {
                        log.warn((Object)"Relocation overflow (R_MIPS_GPREL16)");
                    }
                    data &= 0xFFFF0000;
                    data |= (int)(result & 0xFFFFL);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("R_MIPS_GPREL16 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    }
                    log.warn((Object)String.format("Probably incorrect relocation R_MIPS_GPREL16 addr=%08X before=%08X after=%08X", data_addr, word32, data));
                    break;
                }
                default: {
                    log.warn((Object)String.format("Unhandled relocation type %d at %08X", R_TYPE, data_addr));
                }
            }
            Utilities.writeUnaligned32(mem, data_addr, data);
        }
    }

    private void relocateFromHeaders(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int elfOffset) throws IOException {
        int i = 0;
        for (Elf32ProgramHeader phdr : elf.getProgramHeaderList()) {
            if (phdr.getP_type() == 0x700000A0L) {
                int RelCount = (int)phdr.getP_filesz() / Elf32Relocate.sizeof();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PH#" + i + ": relocating " + RelCount + " entries"));
                }
                f.position((int)((long)elfOffset + phdr.getP_offset()));
                this.relocateFromBuffer(f, module, baseAddress, elf, RelCount);
                return;
            }
            if (phdr.getP_type() == 1879048353L) {
                log.warn((Object)("Unimplemented:PH#" + i + ": relocate type 0x700000A1"));
            }
            ++i;
        }
        for (Elf32SectionHeader shdr : elf.getSectionHeaderList()) {
            if (shdr.getSh_type() == 9) {
                log.warn((Object)(shdr.getSh_namez() + ": not relocating section"));
            }
            if (shdr.getSh_type() != 0x700000A0) continue;
            int RelCount = (int)shdr.getSh_size() / Elf32Relocate.sizeof();
            if (log.isDebugEnabled()) {
                log.debug((Object)(shdr.getSh_namez() + ": relocating " + RelCount + " entries"));
            }
            f.position((int)((long)elfOffset + shdr.getSh_offset()));
            this.relocateFromBuffer(f, module, baseAddress, elf, RelCount);
        }
    }

    private void ProcessUnresolvedImports() {
        Memory mem = Memory.getInstance();
        NIDMapper nidMapper = NIDMapper.getInstance();
        int numberoffailedNIDS = 0;
        int numberofmappedNIDS = 0;
        for (SceModule module : Managers.modules.values()) {
            ++module.importFixupAttempts;
            Iterator<DeferredStub> it = module.unresolvedImports.iterator();
            while (it.hasNext()) {
                DeferredStub deferredStub = it.next();
                String moduleName = deferredStub.getModuleName();
                int nid = deferredStub.getNid();
                int importAddress = deferredStub.getImportAddress();
                int exportAddress = nidMapper.moduleNidToAddress(moduleName, nid);
                if (exportAddress != -1) {
                    deferredStub.resolve(mem, exportAddress);
                    it.remove();
                    ++numberofmappedNIDS;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Mapped import at 0x%08X to export at 0x%08X [0x%08X] (attempt %d)", importAddress, exportAddress, nid, module.importFixupAttempts));
                    continue;
                }
                if (nid == 0) {
                    log.warn((Object)String.format("Ignoring import at 0x%08X [0x%08X] (attempt %d)", importAddress, nid, module.importFixupAttempts));
                    it.remove();
                    mem.write32(importAddress + 4, 4129);
                    continue;
                }
                int code = nidMapper.nidToSyscall(nid);
                if (code != -1) {
                    int returnInstruction = 65011720;
                    int syscallInstruction = 0xC | (code & 0xFFFFF) << 6;
                    if (mem.read32(importAddress) == 0) {
                        mem.write32(importAddress, returnInstruction);
                    }
                    mem.write32(importAddress + 4, syscallInstruction);
                    it.remove();
                    ++numberofmappedNIDS;
                    if (!this.loadedFirstModule || !log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Mapped import at 0x%08X to syscall 0x%05X [0x%08X] (attempt %d)", importAddress, code, nid, module.importFixupAttempts));
                    continue;
                }
                log.warn((Object)String.format("Failed to map import at 0x%08X [0x%08X] Module '%s'(attempt %d)", importAddress, nid, moduleName, module.importFixupAttempts));
                ++numberoffailedNIDS;
            }
        }
        log.info((Object)(numberofmappedNIDS + " NIDS mapped"));
        if (numberoffailedNIDS > 0) {
            log.info((Object)(numberoffailedNIDS + " remaining unmapped NIDS"));
        }
    }

    private void LoadELFImports(SceModule module) throws IOException {
        Memory mem = Memory.getInstance();
        int stubHeadersAddress = module.stub_top;
        int stubHeadersEndAddress = module.stub_top + module.stub_size;
        int i = 0;
        while (stubHeadersAddress < stubHeadersEndAddress) {
            Elf32StubHeader stubHeader = new Elf32StubHeader(mem, stubHeadersAddress);
            if (stubHeader.getSize() <= 0) {
                log.warn((Object)("Skipping dummy entry with size " + stubHeader.getSize()));
                stubHeadersAddress += Elf32StubHeader.sizeof() / 2;
            } else {
                String moduleName = Memory.isAddressGood((int)stubHeader.getOffsetModuleName()) ? Utilities.readStringNZ((int)stubHeader.getOffsetModuleName(), 64) : module.modname;
                stubHeader.setModuleNamez(moduleName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processing Import #%d: %s", i, stubHeader.toString()));
                }
                if (stubHeader.hasVStub()) {
                    int vStub;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("'%s' has size %d: %s", stubHeader.getModuleNamez(), stubHeader.getSize(), Utilities.getMemoryDump(stubHeadersAddress, stubHeader.getSize() * 4, 4, 16)));
                    }
                    if ((vStub = (int)stubHeader.getVStub()) != 0) {
                        int vStubSize = stubHeader.getVStubSize();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Vstub has size %d: %s", vStubSize, Utilities.getMemoryDump(vStub, vStubSize * 8, 4, 16)));
                        }
                        IMemoryReader vstubReader = MemoryReader.getMemoryReader(vStub, vStubSize * 8, 4);
                        for (int j = 0; j < vStubSize; ++j) {
                            int reloc;
                            int relocAddr = vstubReader.readNext();
                            int nid = vstubReader.readNext();
                            IMemoryReader relocReader = MemoryReader.getMemoryReader(relocAddr, 4);
                            while ((reloc = relocReader.readNext()) != 0) {
                                int opcode = reloc >>> 26;
                                int address = (reloc & 0x3FFFFFF) << 2;
                                DeferredStub deferredStub = null;
                                switch (opcode) {
                                    case 5: {
                                        deferredStub = new DeferredVStubHI16(stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    case 6: {
                                        deferredStub = new DeferredVstubLO16(stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    case 2: {
                                        deferredStub = new DeferredVStub32(stubHeader.getModuleNamez(), address, nid);
                                        break;
                                    }
                                    default: {
                                        log.warn((Object)String.format("Unknown Vstub relocation nid 0x%08X, reloc=0x%08X", nid, reloc));
                                    }
                                }
                                if (deferredStub == null) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Vstub reloc %s", deferredStub));
                                }
                                module.unresolvedImports.add(deferredStub);
                            }
                        }
                    }
                }
                stubHeadersAddress += stubHeader.getSize() * 4;
                if (!Memory.isAddressGood((int)stubHeader.getOffsetNid()) || !Memory.isAddressGood((int)stubHeader.getOffsetText())) {
                    log.warn((Object)String.format("Incorrect s_nid or s_text address in StubHeader #%d: %s", i, stubHeader.toString()));
                } else {
                    IMemoryReader nidReader = MemoryReader.getMemoryReader((int)stubHeader.getOffsetNid(), stubHeader.getImports() * 4, 4);
                    for (int j = 0; j < stubHeader.getImports(); ++j) {
                        int nid = nidReader.readNext();
                        int importAddress = (int)(stubHeader.getOffsetText() + (long)(j * 8));
                        DeferredStub deferredStub = new DeferredStub(stubHeader.getModuleNamez(), importAddress, nid);
                        module.unresolvedImports.add(deferredStub);
                        int instruction = 0x3FFFFCC;
                        mem.write32(importAddress + 4, instruction);
                    }
                }
            }
            ++i;
        }
        if (module.unresolvedImports.size() > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Found %d unresolved imports", module.unresolvedImports.size()));
        }
    }

    private void LoadELFExports(SceModule module) throws IOException {
        NIDMapper nidMapper = NIDMapper.getInstance();
        Memory mem = Memory.getInstance();
        int entHeadersAddress = module.ent_top;
        int entHeadersEndAddress = module.ent_top + module.ent_size;
        int entCount = 0;
        int i = 0;
        while (entHeadersAddress < entHeadersEndAddress) {
            Elf32EntHeader entHeader = new Elf32EntHeader(mem, entHeadersAddress);
            if (entHeader.getSize() <= 0) {
                log.warn((Object)("Skipping dummy entry with size " + entHeader.getSize()));
                entHeadersAddress += Elf32EntHeader.sizeof() / 2;
            } else {
                int exportAddress;
                int j;
                String moduleName = Memory.isAddressGood((int)entHeader.getOffsetModuleName()) ? Utilities.readStringNZ((int)entHeader.getOffsetModuleName(), 64) : module.modname;
                entHeader.setModuleNamez(moduleName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Processing header #%d at 0x%08X: %s", i, entHeadersAddress, entHeader.toString()));
                }
                if (entHeader.getSize() > 4) {
                    entHeadersAddress += entHeader.getSize() * 4;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("'%s' has size %d", entHeader.getModuleNamez(), entHeader.getSize()));
                    }
                } else {
                    entHeadersAddress += Elf32EntHeader.sizeof();
                }
                int functionCount = entHeader.getFunctionCount();
                int variableCount = entHeader.getVariableCount();
                int nidAddr = (int)entHeader.getOffsetResident();
                IMemoryReader nidReader = MemoryReader.getMemoryReader(nidAddr, 4);
                int exportAddr = nidAddr + (functionCount + variableCount) * 4;
                IMemoryReader exportReader = MemoryReader.getMemoryReader(exportAddr, 4);
                if ((entHeader.getAttr() & 0x8000) == 0) {
                    for (j = 0; j < functionCount; ++j) {
                        int nid = nidReader.readNext();
                        exportAddress = exportReader.readNext();
                        if (!Memory.isAddressGood(exportAddress) || (entHeader.getAttr() & 0x4000) == 16384) continue;
                        nidMapper.addModuleNid(moduleName, nid, exportAddress);
                        ++entCount;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", exportAddress, nid));
                    }
                } else {
                    block16: for (j = 0; j < functionCount; ++j) {
                        int nid = nidReader.readNext();
                        exportAddress = exportReader.readNext();
                        switch (nid) {
                            case -701322021: {
                                module.module_start_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_start found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -823633604: {
                                module.module_stop_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_stop found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case 788942758: {
                                module.module_reboot_before_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_reboot_before found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -1376704699: {
                                module.module_reboot_phase_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_reboot_phase found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            case -747353120: {
                                module.module_bootstart_func = exportAddress;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("module_bootstart found: nid=0x%08X, function=0x%08X", nid, exportAddress));
                                continue block16;
                            }
                            default: {
                                if (!Memory.isAddressGood(exportAddress) || (entHeader.getAttr() & 0x4000) == 16384) continue block16;
                                nidMapper.addModuleNid(moduleName, nid, exportAddress);
                                ++entCount;
                                if (!log.isDebugEnabled()) continue block16;
                                log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", exportAddress, nid));
                            }
                        }
                    }
                }
                int variableTableAddr = exportAddr + functionCount * 4;
                IMemoryReader variableReader = MemoryReader.getMemoryReader(variableTableAddr, 4);
                block17: for (int j2 = 0; j2 < variableCount; ++j2) {
                    int nid = nidReader.readNext();
                    int variableAddr = variableReader.readNext();
                    switch (nid) {
                        case -266505305: {
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_info found: nid=0x%08X, addr=0x%08X", nid, variableAddr));
                            continue block17;
                        }
                        case 259794796: {
                            module.module_start_thread_priority = mem.read32(variableAddr + 4);
                            module.module_start_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_start_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_start_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_start_thread_priority, module.module_start_thread_stacksize, module.module_start_thread_attr));
                            continue block17;
                        }
                        case -821246313: {
                            module.module_stop_thread_priority = mem.read32(variableAddr + 4);
                            module.module_stop_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_stop_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_stop_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_stop_thread_priority, module.module_stop_thread_stacksize, module.module_stop_thread_attr));
                            continue block17;
                        }
                        case -185325155: {
                            module.module_reboot_before_thread_priority = mem.read32(variableAddr + 4);
                            module.module_reboot_before_thread_stacksize = mem.read32(variableAddr + 8);
                            module.module_reboot_before_thread_attr = mem.read32(variableAddr + 12);
                            if (!log.isDebugEnabled()) continue block17;
                            log.debug((Object)String.format("module_reboot_before_thread_parameter found: nid=0x%08X, priority=%d, stacksize=%d, attr=0x%08X", nid, module.module_reboot_before_thread_priority, module.module_reboot_before_thread_stacksize, module.module_reboot_before_thread_attr));
                            continue block17;
                        }
                        case 297366790: {
                            int sdk_version = mem.read32(variableAddr);
                            if (!log.isDebugEnabled()) continue block17;
                            log.warn((Object)String.format("module_sdk_version found: nid=0x%08X, sdk_version=0x%08X", nid, sdk_version));
                            continue block17;
                        }
                        default: {
                            if (Memory.isAddressGood(variableAddr) && (entHeader.getAttr() & 0x4000) != 16384) {
                                nidMapper.addModuleNid(moduleName, nid, variableAddr);
                                ++entCount;
                                if (!log.isDebugEnabled()) continue block17;
                                log.debug((Object)String.format("Export found at 0x%08X [0x%08X]", variableAddr, nid));
                                continue block17;
                            }
                            log.warn((Object)String.format("Unknown variable entry found: nid=0x%08X, addr=0x%08X", nid, variableAddr));
                        }
                    }
                }
            }
            ++i;
        }
        if (entCount > 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("Found %d exports", entCount));
        }
    }

    private void LoadELFDebuggerInfo(ByteBuffer f, SceModule module, int baseAddress, Elf32 elf, int elfOffset) throws IOException {
        Elf32SectionHeader shdr = elf.getSectionHeader(".init");
        if (shdr != null) {
            module.initsection[0] = (int)((long)baseAddress + shdr.getSh_addr());
            module.initsection[1] = (int)shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".fini")) != null) {
            module.finisection[0] = (int)((long)baseAddress + shdr.getSh_addr());
            module.finisection[1] = (int)shdr.getSh_size();
        }
        if ((shdr = elf.getSectionHeader(".sceStub.text")) != null) {
            module.stubtextsection[0] = (int)((long)baseAddress + shdr.getSh_addr());
            module.stubtextsection[1] = (int)shdr.getSh_size();
        }
        if (!this.loadedFirstModule) {
            ElfHeaderInfo.ElfInfo = elf.getElfInfo();
            ElfHeaderInfo.ProgInfo = elf.getProgInfo();
            ElfHeaderInfo.SectInfo = elf.getSectInfo();
        }
    }

    static {
        log = Logger.getLogger((String)"loader");
    }
}

