/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jpcsp.graphics.VideoEngine;

public class DirectBufferUtilities {
    protected static int directBufferSize = 100;
    protected static ByteBuffer directBuffer = ByteBuffer.allocateDirect(directBufferSize).order(ByteOrder.nativeOrder());
    protected static FloatBuffer directFloatBuffer = ByteBuffer.allocateDirect(128 * VideoEngine.SIZEOF_FLOAT).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final int[] round4 = new int[]{0, 3, 2, 1};

    public static FloatBuffer getDirectBuffer(float[] values) {
        return DirectBufferUtilities.getDirectBuffer(values, values.length);
    }

    public static FloatBuffer getDirectBuffer(float[] values, int length) {
        directFloatBuffer.clear();
        directFloatBuffer.limit(length);
        directFloatBuffer.put(values, 0, length);
        directFloatBuffer.rewind();
        return directFloatBuffer;
    }

    protected static int round4(int n) {
        return n + round4[n & 3];
    }

    protected static int round2(int n) {
        return n + (n & 1);
    }

    public static IntBuffer getDirectBuffer(int size, IntBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = DirectBufferUtilities.round4(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 2) + buffer.position());
            return buffer;
        }
        IntBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size).asIntBuffer();
        directBuffer.put((IntBuffer)buffer.slice().limit(size >> 2));
        directBuffer.rewind();
        return directBuffer;
    }

    public static FloatBuffer getDirectBuffer(int size, FloatBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = DirectBufferUtilities.round4(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 2) + buffer.position());
            return buffer;
        }
        FloatBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size).asFloatBuffer();
        directBuffer.put((FloatBuffer)buffer.slice().limit(size >> 2));
        directBuffer.rewind();
        return directBuffer;
    }

    public static ShortBuffer getDirectBuffer(int size, ShortBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        size = DirectBufferUtilities.round2(size);
        if (buffer.isDirect()) {
            buffer.limit((size >> 1) + buffer.position());
            return buffer;
        }
        ShortBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size).asShortBuffer();
        directBuffer.put((ShortBuffer)buffer.slice().limit(size >> 1));
        directBuffer.rewind();
        return directBuffer;
    }

    public static ByteBuffer getDirectBuffer(int size, ByteBuffer buffer) {
        if (buffer == null) {
            return buffer;
        }
        if (buffer.isDirect()) {
            buffer.limit(size + buffer.position());
            return buffer;
        }
        ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size);
        directBuffer.put((ByteBuffer)buffer.slice().limit(size));
        directBuffer.rewind();
        return directBuffer;
    }

    private static ByteBuffer getByteBuffer(int size, Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            buffer.limit(size);
            return (ByteBuffer)buffer;
        }
        if (buffer instanceof IntBuffer) {
            size = DirectBufferUtilities.round4(size);
            ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size);
            directBuffer.asIntBuffer().put((IntBuffer)((IntBuffer)buffer).slice().limit(size >> 2));
            directBuffer.rewind();
            return directBuffer;
        }
        if (buffer instanceof ShortBuffer) {
            size = DirectBufferUtilities.round2(size);
            ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size);
            directBuffer.asShortBuffer().put((ShortBuffer)((ShortBuffer)buffer).slice().limit(size >> 1));
            directBuffer.rewind();
            return directBuffer;
        }
        if (buffer instanceof FloatBuffer) {
            size = DirectBufferUtilities.round4(size);
            ByteBuffer directBuffer = DirectBufferUtilities.allocateDirectBuffer(size);
            directBuffer.asFloatBuffer().put((FloatBuffer)((FloatBuffer)buffer).slice().limit(size >> 2));
            directBuffer.rewind();
            return directBuffer;
        }
        throw new IllegalArgumentException();
    }

    public static ByteBuffer getDirectByteBuffer(int size, Buffer buffer) {
        return DirectBufferUtilities.getDirectBuffer(size, DirectBufferUtilities.getByteBuffer(size, buffer));
    }

    public static FloatBuffer getDirectFloatBuffer(int size, Buffer buffer) {
        return DirectBufferUtilities.getDirectBuffer(size, DirectBufferUtilities.getByteBuffer(size, buffer).asFloatBuffer());
    }

    public static IntBuffer getDirectIntBuffer(int size, Buffer buffer) {
        return DirectBufferUtilities.getDirectBuffer(size, DirectBufferUtilities.getByteBuffer(size, buffer).asIntBuffer());
    }

    public static ShortBuffer getDirectShortBuffer(int size, Buffer buffer) {
        return DirectBufferUtilities.getDirectBuffer(size, DirectBufferUtilities.getByteBuffer(size, buffer).asShortBuffer());
    }

    public static ByteBuffer allocateDirectBuffer(int size) {
        if (size > directBufferSize) {
            directBufferSize = size;
            directBuffer = ByteBuffer.allocateDirect(directBufferSize).order(ByteOrder.nativeOrder());
        }
        directBuffer.clear();
        directBuffer.limit(size);
        return directBuffer;
    }

    public static ByteBuffer allocateDirectBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return DirectBufferUtilities.allocateDirectBuffer(buffer.remaining());
    }

    public static IntBuffer allocateDirectBuffer(IntBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return DirectBufferUtilities.allocateDirectBuffer(buffer.remaining() << 2).asIntBuffer();
    }

    public static ShortBuffer allocateDirectBuffer(ShortBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return DirectBufferUtilities.allocateDirectBuffer(buffer.remaining() << 1).asShortBuffer();
    }

    public static FloatBuffer allocateDirectBuffer(FloatBuffer buffer) {
        if (buffer.isDirect()) {
            return buffer;
        }
        return DirectBufferUtilities.allocateDirectBuffer(buffer.remaining() << 2).asFloatBuffer();
    }

    public static void copyBuffer(ByteBuffer dstBuffer, ByteBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public static void copyBuffer(IntBuffer dstBuffer, IntBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public static void copyBuffer(ShortBuffer dstBuffer, ShortBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }

    public static void copyBuffer(FloatBuffer dstBuffer, FloatBuffer srcBuffer) {
        if (dstBuffer != srcBuffer) {
            srcBuffer.rewind();
            dstBuffer.put(srcBuffer);
        }
    }
}

