/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import javax.imageio.ImageIO;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.graphics.AsyncVertexCache;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.GeCommands;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.VertexArray;
import jpcsp.graphics.VertexArrayManager;
import jpcsp.graphics.VertexBuffer;
import jpcsp.graphics.VertexBufferManager;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VertexInfoReader;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.graphics.capture.CaptureManager;
import jpcsp.graphics.export.IGraphicsExporter;
import jpcsp.graphics.export.WavefrontExporter;
import jpcsp.graphics.textures.GETexture;
import jpcsp.graphics.textures.GETextureManager;
import jpcsp.graphics.textures.Texture;
import jpcsp.graphics.textures.TextureCache;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.CpuDurationStatistics;
import jpcsp.util.DurationStatistics;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VideoEngine {
    public static final int NUM_LIGHTS = 4;
    public static final int SIZEOF_FLOAT = IRenderingEngine.sizeOfType[6];
    public static final String[] psm_names = new String[]{"PSM_5650", "PSM_5551", "PSM_4444", "PSM_8888", "PSM_4BIT_INDEXED", "PSM_8BIT_INDEXED", "PSM_16BIT_INDEXED", "PSM_32BIT_INDEXED", "PSM_DXT1", "PSM_DXT3", "PSM_DXT5"};
    public static final String[] logical_ops_names = new String[]{"LOP_CLEAR", "LOP_AND", "LOP_REVERSE_AND", "LOP_COPY", "LOP_INVERTED_AND", "LOP_NO_OPERATION", "LOP_EXLUSIVE_OR", "LOP_OR", "LOP_NEGATED_OR", "LOP_EQUIVALENCE", "LOP_INVERTED", "LOP_REVERSE_OR", "LOP_INVERTED_COPY", "LOP_INVERTED_OR", "LOP_NEGATED_AND", "LOP_SET"};
    private static final int[] textureByteAlignmentMapping = new int[]{2, 2, 2, 4};
    private static final int[] minimumNumberOfVertex = new int[]{1, 2, 2, 3, 3, 3, 2};
    private static VideoEngine instance;
    private sceDisplay display;
    private IRenderingEngine re;
    private GeContext context;
    private IREBufferManager bufferManager;
    public static Logger log;
    public static final boolean useTextureCache = true;
    private boolean useVertexCache = false;
    private boolean useAsyncVertexCache = true;
    public boolean useOptimisticVertexCache = false;
    private boolean useTextureAnisotropicFilter = false;
    private boolean disableOptimizedVertexInfoReading = false;
    private boolean enableTextureModding = true;
    private static GeCommands helper;
    private int command;
    private int normalArgument;
    private int waitForSyncCount;
    private VertexInfoReader vertexInfoReader = new VertexInfoReader();
    private static final char SPACE = ' ';
    private DurationStatistics statistics = new CpuDurationStatistics("VideoEngine Statistics");
    private DurationStatistics vertexStatistics = new CpuDurationStatistics("Vertex");
    private DurationStatistics vertexReadingStatistics = new CpuDurationStatistics("Vertex Reading");
    private DurationStatistics drawArraysStatistics = new CpuDurationStatistics("glDrawArrays");
    private DurationStatistics waitSignalStatistics = new DurationStatistics("Wait for GE Signal completion");
    private DurationStatistics waitStallStatistics = new DurationStatistics("Wait on stall");
    private DurationStatistics textureCacheLookupStatistics = new CpuDurationStatistics("Lookup in TextureCache");
    private DurationStatistics vertexCacheLookupStatistics = new CpuDurationStatistics("Lookup in VertexCache");
    private DurationStatistics[] commandStatistics;
    private int errorCount;
    private static final int maxErrorCount = 5;
    private boolean isLogTraceEnabled;
    private boolean isLogDebugEnabled;
    private boolean isLogInfoEnabled;
    private boolean isLogWarnEnabled;
    private boolean isGeProfilerEnabled;
    private int primCount;
    private boolean viewportChanged;
    public MatrixUpload projectionMatrixUpload;
    public MatrixUpload modelMatrixUpload;
    public MatrixUpload viewMatrixUpload;
    public MatrixUpload textureMatrixUpload;
    private int boneMatrixIndex;
    private int boneMatrixLinearUpdatedMatrix;
    private static final float[] blackColor;
    private boolean lightingChanged;
    private boolean materialChanged;
    private boolean textureChanged;
    private int[] patch_prim_types = new int[]{4, 2, 0};
    private boolean clutIsDirty;
    private boolean usingTRXKICK;
    private int maxSpriteHeight;
    private int maxSpriteWidth;
    private boolean depthChanged;
    private boolean scissorChanged;
    private int textureId = -1;
    private boolean textureFlipped;
    private float textureFlipTranslateY;
    private int[] tmp_texture_buffer32 = new int[0x100000];
    private short[] tmp_texture_buffer16 = new short[0x100000];
    private int[] clut_buffer32 = new int[4096];
    private short[] clut_buffer16 = new short[4096];
    private boolean listHasEnded;
    private PspGeList currentList;
    private static final int drawBufferSize;
    private int bufferId;
    private int nativeBufferId;
    float[][] bboxVertices;
    private ConcurrentLinkedQueue<PspGeList> drawListQueue;
    private boolean somethingDisplayed;
    private boolean forceLoadGEToScreen;
    private boolean geBufChanged;
    private boolean fbBufChanged;
    private IAction hleAction;
    private int[] currentCMDValues;
    private int[] currentListCMDValues;
    private boolean bboxWarningDisplayed = false;
    private LinkedList<AddressRange> videoTextures;
    private IntBuffer multiDrawFirst;
    private IntBuffer multiDrawCount;
    private static final int maxMultiDrawElements = 1000;
    private static final String name = "VideoEngine";
    private int maxWaitForSyncCount;
    private VertexState v = new VertexState();
    private VertexState v1 = new VertexState();
    private VertexState v2 = new VertexState();
    private boolean isBoundingBox;
    private boolean skipThisFrame;
    private boolean skipListWhenSkippingFrame = false;
    private boolean export3D;
    private boolean export3DOnlyVisible = true;
    private String export3DDirectory;
    private IGraphicsExporter exporter;
    private boolean hasModdedTextureDirectory;

    private static void log(String msg) {
        log.debug((Object)msg);
    }

    public static VideoEngine getInstance() {
        if (instance == null) {
            helper = new GeCommands();
            instance = new VideoEngine();
        }
        return instance;
    }

    private VideoEngine() {
        int i;
        this.context = new GeContext();
        this.modelMatrixUpload = new MatrixUpload(this.context.model_uploaded_matrix, 3, 4);
        this.viewMatrixUpload = new MatrixUpload(this.context.view_uploaded_matrix, 3, 4);
        this.textureMatrixUpload = new MatrixUpload(this.context.texture_uploaded_matrix, 3, 4);
        this.projectionMatrixUpload = new MatrixUpload(this.context.proj_uploaded_matrix, 4, 4);
        this.boneMatrixLinearUpdatedMatrix = 8;
        this.commandStatistics = new DurationStatistics[256];
        for (i = 0; i < this.commandStatistics.length; ++i) {
            this.commandStatistics[i] = new DurationStatistics(String.format("%-11s", helper.getCommandString(i)));
        }
        this.drawListQueue = new ConcurrentLinkedQueue();
        this.bboxVertices = new float[8][3];
        for (i = 0; i < 8; ++i) {
            this.bboxVertices[i] = new float[3];
        }
        this.currentCMDValues = new int[256];
        this.currentListCMDValues = new int[256];
        this.videoTextures = new LinkedList();
        this.multiDrawFirst = ByteBuffer.allocateDirect(4000).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.multiDrawCount = ByteBuffer.allocateDirect(4000).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDrawList(PspGeList list) {
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            this.drawListQueue.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDrawListHead(PspGeList list) {
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            int arraySize = this.drawListQueue.size();
            if (arraySize > 0) {
                PspGeList[] array = this.drawListQueue.toArray(new PspGeList[arraySize]);
                ConcurrentLinkedQueue<PspGeList> newQueue = new ConcurrentLinkedQueue<PspGeList>();
                PspGeList[] newArray = new PspGeList[arraySize + 1];
                newArray[0] = list;
                for (int i = 0; i < arraySize; ++i) {
                    newArray[i + 1] = array[i];
                    newQueue.add(newArray[i]);
                }
                this.drawListQueue = newQueue;
            } else {
                this.drawListQueue.add(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberDrawLists() {
        int size;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            size = this.drawListQueue.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDrawLists() {
        boolean isEmpty;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            isEmpty = this.drawListQueue.isEmpty();
        }
        return !isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDrawList(int listAddr) {
        boolean waitAndRetry;
        boolean result;
        block12: {
            result = false;
            waitAndRetry = false;
            ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
            synchronized (concurrentLinkedQueue) {
                block11: {
                    if (this.currentList == null || this.currentList.list_addr != listAddr) break block11;
                    result = true;
                    if (!this.currentList.isFinished()) break block12;
                    waitAndRetry = true;
                    break block12;
                }
                for (PspGeList list : this.drawListQueue) {
                    if (list == null || list.list_addr != listAddr) continue;
                    result = true;
                    break;
                }
            }
        }
        if (waitAndRetry) {
            for (int i = 0; i < 100; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hasDrawList(0x%08X) waiting on finished list %s", listAddr, this.currentList));
                }
                Utilities.sleep(1, 0);
                ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
                synchronized (concurrentLinkedQueue) {
                    if (this.currentList == null || this.currentList.list_addr != listAddr) {
                        result = false;
                        break;
                    }
                    continue;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PspGeList getFirstDrawList() {
        PspGeList firstList;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            firstList = this.currentList;
            if (firstList == null) {
                firstList = this.drawListQueue.peek();
            }
        }
        return firstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PspGeList getLastDrawList() {
        PspGeList lastList = null;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            for (PspGeList list : this.drawListQueue) {
                if (list == null) continue;
                lastList = list;
            }
            if (lastList == null) {
                lastList = this.currentList;
            }
        }
        return lastList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.currentList != null) {
            ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
            synchronized (concurrentLinkedQueue) {
                this.drawListQueue.clear();
            }
            this.listHasEnded = true;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Settings.getInstance().removeSettingsListener(name);
    }

    public void start() {
        Settings.getInstance().registerSettingsListener(name, "emu.useVertexCache", new UseVertexCacheSettingsListerner());
        Settings.getInstance().registerSettingsListener(name, "emu.graphics.filters.anisotropic", new UseTextureAnisotropicFilterSettingsListerner());
        Settings.getInstance().registerSettingsListener(name, "emu.disableoptimizedvertexinforeading", new DisableOptimizedVertexInfoReadingListener());
        this.display = Modules.sceDisplayModule;
        this.re = this.display.getRenderingEngine();
        this.re.setGeContext(this.context);
        this.context.setRenderingEngine(this.re);
        this.bufferManager = this.re.getBufferManager();
        if (!this.re.getBufferManager().useVBO()) {
            this.useVertexCache = false;
        }
        this.bufferId = this.bufferManager.genBuffer(6, drawBufferSize / SIZEOF_FLOAT, 0);
        this.nativeBufferId = this.bufferManager.genBuffer(0, drawBufferSize, 0);
        if (this.useAsyncVertexCache) {
            AsyncVertexCache.getInstance().setUseVertexArray(this.re.isVertexArrayAvailable());
        }
        this.context.setDirty();
        this.projectionMatrixUpload.setChanged(true);
        this.modelMatrixUpload.setChanged(true);
        this.viewMatrixUpload.setChanged(true);
        this.textureMatrixUpload.setChanged(true);
        this.lightingChanged = true;
        this.textureChanged = true;
        this.geBufChanged = true;
        this.viewportChanged = true;
        this.depthChanged = true;
        this.materialChanged = true;
    }

    public IRenderingEngine getRenderingEngine() {
        return this.re;
    }

    public GeContext getContext() {
        return this.context;
    }

    public static void exit() {
        if (instance != null && VideoEngine.instance.re != null) {
            VideoEngine.instance.re.exit();
        }
    }

    public static DurationStatistics getStatistics() {
        if (instance == null) {
            return null;
        }
        return VideoEngine.instance.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        int listCount;
        ConcurrentLinkedQueue<PspGeList> concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            listCount = this.drawListQueue.size();
            this.currentList = this.drawListQueue.poll();
        }
        if (this.currentList == null) {
            return false;
        }
        this.startUpdate();
        if (State.captureGeNextFrame) {
            CaptureManager.startCapture("capture.bin", this.currentList);
        }
        if (State.replayGeNextFrame) {
            CaptureManager.startReplay("capture.bin");
            PspGeList replayList = this.drawListQueue.poll();
            replayList.id = this.currentList.id;
            replayList.blockedThreadIds.clear();
            replayList.blockedThreadIds.addAll(this.currentList.blockedThreadIds);
            this.currentList = replayList;
        }
        do {
            this.executeList();
            if (--listCount <= 0) break;
            concurrentLinkedQueue = this.drawListQueue;
            synchronized (concurrentLinkedQueue) {
                this.currentList = this.drawListQueue.poll();
            }
        } while (this.currentList != null);
        if (State.captureGeNextFrame) {
            CaptureManager.markListExecuted();
        }
        if (State.replayGeNextFrame) {
            CaptureManager.endReplay();
            State.replayGeNextFrame = false;
        }
        this.endUpdate();
        concurrentLinkedQueue = this.drawListQueue;
        synchronized (concurrentLinkedQueue) {
            this.currentList = null;
        }
        return this.somethingDisplayed;
    }

    private void logLevelUpdated() {
        this.isLogTraceEnabled = log.isTraceEnabled();
        this.isLogDebugEnabled = log.isDebugEnabled();
        this.isLogInfoEnabled = log.isInfoEnabled();
        this.isLogWarnEnabled = log.isEnabledFor((Priority)Level.WARN);
    }

    public void setLogLevel(Level level) {
        log.setLevel(level);
        this.logLevelUpdated();
    }

    private void memoryForGEUpdated() {
        TextureCache.getInstance().resetTextureAlreadyHashed();
        if (this.useVertexCache) {
            VertexCache.getInstance().resetVertexAlreadyChecked();
        }
        VertexBufferManager.getInstance().resetAddressAlreadyChecked();
    }

    public void hleSetFrameBuf(int topAddr, int bufferWidth, int pixelFormat) {
        if (this.context.fbp != topAddr || this.context.fbw != bufferWidth || this.context.psm != pixelFormat) {
            this.fbBufChanged = true;
        }
    }

    private void startUpdate() {
        this.maxWaitForSyncCount = RuntimeContext.isCompilerEnabled() ? 100 : 10000;
        this.statistics.start();
        this.logLevelUpdated();
        this.isGeProfilerEnabled = GEProfiler.isProfilerEnabled();
        this.memoryForGEUpdated();
        this.somethingDisplayed = false;
        this.geBufChanged = true;
        this.forceLoadGEToScreen = true;
        this.textureChanged = true;
        this.projectionMatrixUpload.setChanged(true);
        this.modelMatrixUpload.setChanged(true);
        this.viewMatrixUpload.setChanged(true);
        this.textureMatrixUpload.setChanged(true);
        this.clutIsDirty = true;
        this.lightingChanged = true;
        this.viewportChanged = true;
        this.depthChanged = true;
        this.materialChanged = true;
        this.scissorChanged = true;
        this.errorCount = 0;
        this.usingTRXKICK = false;
        this.maxSpriteHeight = 0;
        this.maxSpriteWidth = 0;
        this.primCount = 0;
        for (int i = 0; i < this.currentListCMDValues.length; ++i) {
            this.currentListCMDValues[i] = -1;
        }
        if (this.fbBufChanged) {
            this.context.fbp = this.display.getTopAddrFb();
            this.context.fbw = this.display.getBufferWidthFb();
            this.context.psm = this.display.getPixelFormatFb();
            this.geBufChanged = true;
            this.fbBufChanged = false;
        }
        this.context.update();
        this.hasModdedTextureDirectory = new File(this.getModdedTextureDirectory()).isDirectory();
        if (State.exportGeNextFrame) {
            this.startExport3D();
        }
    }

    private static String getExportDirectory() {
        int i = 1;
        String directory;
        while (new File(directory = String.format("%sExport-%d%c", "export/", i, Character.valueOf(File.separatorChar))).exists()) {
            ++i;
        }
        return directory;
    }

    private void startExport3D() {
        this.export3D = true;
        this.export3DOnlyVisible = State.exportGeOnlyVisibleElements;
        State.exportGeNextFrame = false;
        this.export3DDirectory = VideoEngine.getExportDirectory();
        if (new File(this.export3DDirectory).mkdirs()) {
            this.exporter = new WavefrontExporter();
            this.exporter.startExport(this.context, this.export3DDirectory);
        } else {
            log.error((Object)String.format("Cannot create export directory '%s'", this.export3DDirectory));
        }
    }

    private void endExport3D() {
        this.exporter.endExport();
        this.exporter = null;
        this.export3D = false;
    }

    private void endUpdate() {
        if (this.export3D) {
            this.endExport3D();
        }
        if (this.re.isVertexArrayAvailable()) {
            this.re.bindVertexArray(0);
        }
        this.re.waitForRenderingCompletion();
        this.context.reTextureGenS.setEnabled(false);
        this.context.reTextureGenT.setEnabled(false);
        if (this.useVertexCache && this.primCount > 30000) {
            log.warn((Object)String.format("VertexCache size (%d) too small to execute %d PRIM commands", 30000, this.primCount));
        }
        this.statistics.end();
    }

    public void error(String message) {
        ++this.errorCount;
        log.error((Object)message);
        if (this.errorCount >= 5 && this.tryToFallback()) {
            log.error((Object)"Aborting current list processing due to too many errors");
        }
    }

    private boolean tryToFallback() {
        boolean abort = false;
        if (!this.currentList.isStackEmpty()) {
            int oldPc = this.currentList.getPc();
            this.currentList.ret();
            int newPc = this.currentList.getPc();
            if (this.isLogDebugEnabled) {
                VideoEngine.log(String.format("tryToFallback old PC: 0x%08X, new PC: 0x%08X", oldPc, newPc));
            }
        } else {
            this.currentList.finishList();
            this.currentList.pushFinishCallback(this.currentList.id, 0);
            this.listHasEnded = true;
            abort = true;
        }
        return abort;
    }

    private void checkCurrentListPc() {
        Memory mem = Memory.getInstance();
        while (!Memory.isAddressGood(this.currentList.getPc())) {
            if (!mem.isIgnoreInvalidMemoryAccess()) {
                this.error("Reading GE list from invalid address 0x" + Integer.toHexString(this.currentList.getPc()));
                break;
            }
            log.warn((Object)("Reading GE list from invalid address 0x" + Integer.toHexString(this.currentList.getPc())));
            if (!this.tryToFallback()) continue;
            break;
        }
    }

    private void executeHleAction() {
        if (this.hleAction != null) {
            this.hleAction.execute();
            this.hleAction = null;
        }
    }

    private void executeListStalled() {
        this.waitStallStatistics.start();
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("Stall address 0x%08X reached, waiting for Sync", this.currentList.getPc()));
        }
        this.currentList.status = 3;
        long startWaitClockMillis = Emulator.getClock().milliTime();
        if (!this.currentList.waitForSync(10)) {
            long endWaitClockMillis = Emulator.getClock().milliTime();
            if (this.isLogDebugEnabled) {
                log.debug((Object)"Wait for sync while stall reached");
            }
            if (startWaitClockMillis != endWaitClockMillis) {
                ++this.waitForSyncCount;
            }
            int maxStallCount = this.maxWaitForSyncCount;
            if (this.currentList.getPc() == this.currentList.list_addr) {
                maxStallCount *= 4;
            }
            if (this.isLogDebugEnabled) {
                maxStallCount = Integer.MAX_VALUE;
            }
            if (this.waitForSyncCount > maxStallCount) {
                this.error(String.format("Waiting too long on stall address 0x%08X, aborting the list %s", this.currentList.getPc(), this.currentList));
            }
        } else {
            this.waitForSyncCount = 0;
        }
        this.executeHleAction();
        if (!this.currentList.isStallReached()) {
            this.currentList.status = 2;
        }
        this.waitStallStatistics.end();
    }

    private boolean executeListPaused() {
        this.waitSignalStatistics.start();
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("FINISH / SIGNAL / END reached, waiting for Sync (%s)", this.currentList.toString()));
        }
        this.currentList.status = 4;
        long startWaitClockMillis = Emulator.getClock().milliTime();
        if (!this.currentList.waitForSync(10)) {
            long endWaitClockMillis = Emulator.getClock().milliTime();
            if (this.isLogDebugEnabled) {
                log.debug((Object)"Wait for sync while END reached");
            }
            if (startWaitClockMillis != endWaitClockMillis) {
                ++this.waitForSyncCount;
            }
            if (this.waitForSyncCount > this.maxWaitForSyncCount) {
                this.error(String.format("Waiting too long on an END command, aborting the list %s", this.currentList));
            }
        } else {
            this.waitForSyncCount = 0;
        }
        this.executeHleAction();
        if (this.currentList.isRestarted()) {
            this.currentList.clearRestart();
            this.currentList.clearPaused();
        }
        if (!this.currentList.isPaused()) {
            if (this.currentList.isFinished()) {
                this.listHasEnded = true;
                return true;
            }
            this.currentList.status = 2;
        }
        this.waitSignalStatistics.end();
        return false;
    }

    private void executeList() {
        if (this.skipThisFrame && this.skipListWhenSkippingFrame) {
            this.listHasEnded = true;
            this.currentList.status = 0;
            Modules.sceGe_userModule.hleGeListSyncDone(this.currentList);
            this.executeHleAction();
            return;
        }
        this.listHasEnded = false;
        this.currentList.status = 2;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("executeList " + this.currentList);
        }
        this.executeHleAction();
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeList();
        }
        this.waitForSyncCount = 0;
        while (!(this.listHasEnded || Emulator.pause && !State.captureGeNextFrame)) {
            if (this.currentList.isPaused() || this.currentList.isEnded()) {
                if (!this.executeListPaused()) continue;
                break;
            }
            if (this.currentList.isStallReached()) {
                this.executeListStalled();
                continue;
            }
            int ins = this.currentList.readNextInstruction();
            this.executeCommand(ins);
        }
        if (Emulator.pause && !this.listHasEnded) {
            if (this.isLogInfoEnabled) {
                log.info((Object)("Emulator paused - cancelling current list id=" + this.currentList.id));
            }
            this.currentList.status = 5;
        }
        if (this.listHasEnded) {
            this.currentList.status = 4;
            if (this.currentList.isEnded()) {
                this.currentList.status = 0;
            }
        }
        if (this.currentList.isDone()) {
            Modules.sceGe_userModule.hleGeListSyncDone(this.currentList);
        }
        this.executeHleAction();
    }

    public PspGeList getCurrentList() {
        return this.currentList;
    }

    public float[] getMatrix(int mtxtype) {
        float[] resmtx;
        switch (mtxtype) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                resmtx = this.context.bone_uploaded_matrix[mtxtype - 0];
                break;
            }
            case 8: {
                resmtx = this.context.model_uploaded_matrix;
                break;
            }
            case 9: {
                resmtx = this.context.view_uploaded_matrix;
                break;
            }
            case 10: {
                resmtx = this.context.proj_uploaded_matrix;
                break;
            }
            case 11: {
                resmtx = this.context.texture_uploaded_matrix;
                break;
            }
            default: {
                resmtx = null;
            }
        }
        return resmtx;
    }

    public int getCommandValue(int cmd) {
        if (cmd < 0 || cmd >= this.currentCMDValues.length) {
            return 0;
        }
        return this.currentCMDValues[cmd];
    }

    public String commandToString(int cmd) {
        return GeCommands.getInstance().getCommandString(cmd);
    }

    public static int command(int instruction) {
        return instruction >>> 24;
    }

    private static int intArgument(int instruction) {
        return instruction & 0xFFFFFF;
    }

    private static float floatArgument(int normalArgument) {
        return Float.intBitsToFloat(normalArgument << 8);
    }

    private int getClutAddr(int level, int clutNumEntries, int clutEntrySize) {
        return this.context.tex_clut_addr + (this.context.tex_clut_start << 4) * clutEntrySize;
    }

    private void readClut() {
        if (!this.clutIsDirty || this.context.tex_clut_addr == 0) {
            return;
        }
        if (!Memory.isAddressGood(this.context.tex_clut_addr)) {
            if (this.isLogWarnEnabled) {
                log.warn((Object)String.format("Invalid clut address 0x%08X", this.context.tex_clut_addr));
            }
            return;
        }
        if (this.context.tex_clut_mode == 3) {
            this.readClut32(0);
        } else {
            this.readClut16(0);
        }
    }

    public short[] readClut16(int level) {
        if (this.clutIsDirty) {
            int clutNumEntries = this.context.tex_clut_num_blocks << 4;
            int clutOffset = this.context.tex_clut_start << 4;
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.getClutAddr(level, clutNumEntries, 2), clutNumEntries - clutOffset << 1, 2);
            for (int i = clutOffset; i < clutNumEntries; ++i) {
                this.clut_buffer16[i] = (short)memoryReader.readNext();
            }
            this.clutIsDirty = false;
        }
        if (State.captureGeNextFrame) {
            log.info((Object)"Capture readClut16");
            CaptureManager.captureRAM(this.context.tex_clut_addr, this.context.tex_clut_num_blocks * 32);
        }
        return this.clut_buffer16;
    }

    public int[] readClut32(int level) {
        if (this.clutIsDirty) {
            int clutNumEntries = this.context.tex_clut_num_blocks << 3;
            int clutOffset = this.context.tex_clut_start << 4;
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.getClutAddr(level, clutNumEntries, 4), clutNumEntries - clutOffset << 2, 4);
            for (int i = clutOffset; i < clutNumEntries; ++i) {
                this.clut_buffer32[i] = memoryReader.readNext();
            }
            this.clutIsDirty = false;
        }
        if (State.captureGeNextFrame) {
            log.info((Object)"Capture readClut32");
            CaptureManager.captureRAM(this.context.tex_clut_addr, this.context.tex_clut_num_blocks * 32);
        }
        return this.clut_buffer32;
    }

    private int getClutIndex(int index) {
        return index >> this.context.tex_clut_shift & this.context.tex_clut_mask | this.context.tex_clut_start << 4;
    }

    private Buffer unswizzleTextureFromMemory(int texaddr, int bytesPerPixel, int level, int textureBufferWidthInPixels) {
        int rowWidth = bytesPerPixel > 0 ? textureBufferWidthInPixels * bytesPerPixel : textureBufferWidthInPixels / 2;
        int pitch = rowWidth / 4;
        int bxc = rowWidth / 16;
        int byc = Math.max((this.context.texture_height[level] + 7) / 8, 1);
        int ydest = 0;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, 4);
        for (int by = 0; by < byc; ++by) {
            int n2;
            int n1;
            int n;
            if (rowWidth >= 16) {
                int xdest = ydest;
                for (int bx = 0; bx < bxc; ++bx) {
                    int dest = xdest;
                    for (int n3 = 0; n3 < 8; ++n3) {
                        this.tmp_texture_buffer32[dest] = memoryReader.readNext();
                        this.tmp_texture_buffer32[dest + 1] = memoryReader.readNext();
                        this.tmp_texture_buffer32[dest + 2] = memoryReader.readNext();
                        this.tmp_texture_buffer32[dest + 3] = memoryReader.readNext();
                        dest += pitch;
                    }
                    xdest += 4;
                }
                ydest += rowWidth * 8 / 4;
                continue;
            }
            if (rowWidth == 8) {
                n = 0;
                while (n < 8) {
                    this.tmp_texture_buffer32[ydest] = memoryReader.readNext();
                    this.tmp_texture_buffer32[ydest + 1] = memoryReader.readNext();
                    memoryReader.skip(2);
                    ++n;
                    ydest += 2;
                }
                continue;
            }
            if (rowWidth == 4) {
                n = 0;
                while (n < 8) {
                    this.tmp_texture_buffer32[ydest] = memoryReader.readNext();
                    memoryReader.skip(3);
                    ++n;
                    ++ydest;
                }
                continue;
            }
            if (rowWidth == 2) {
                n = 0;
                while (n < 4) {
                    n1 = memoryReader.readNext() & 0xFFFF;
                    memoryReader.skip(3);
                    n2 = memoryReader.readNext() & 0xFFFF;
                    memoryReader.skip(3);
                    this.tmp_texture_buffer32[ydest] = n1 | n2 << 16;
                    ++n;
                    ++ydest;
                }
                continue;
            }
            if (rowWidth != 1) continue;
            n = 0;
            while (n < 2) {
                n1 = memoryReader.readNext() & 0xFF;
                memoryReader.skip(3);
                n2 = memoryReader.readNext() & 0xFF;
                memoryReader.skip(3);
                int n3 = memoryReader.readNext() & 0xFF;
                memoryReader.skip(3);
                int n4 = memoryReader.readNext() & 0xFF;
                memoryReader.skip(3);
                this.tmp_texture_buffer32[ydest] = n1 | n2 << 8 | n3 << 16 | n4 << 24;
                ++n;
                ++ydest;
            }
        }
        if (State.captureGeNextFrame) {
            log.info((Object)"Capture unswizzleTextureFromMemory");
            CaptureManager.captureRAM(texaddr, rowWidth * this.context.texture_height[level]);
        }
        return IntBuffer.wrap(this.tmp_texture_buffer32);
    }

    private String getArgumentLog(int normalArgument) {
        if (normalArgument == 0) {
            return "(0)";
        }
        return String.format("(hex=%08X,int=%d,float=%f)", normalArgument, normalArgument, Float.valueOf(VideoEngine.floatArgument(normalArgument)));
    }

    public void executeCommand(int instruction) {
        this.command = VideoEngine.command(instruction);
        if (GeCommands.pureStateCommands[this.command]) {
            if (this.currentListCMDValues[this.command] == instruction) {
                if (this.isLogDebugEnabled) {
                    log.debug((Object)String.format("%s 0x%06X redundant pure state cmd ignored", helper.getCommandString(this.command), VideoEngine.intArgument(instruction)));
                }
                return;
            }
            this.currentListCMDValues[this.command] = instruction;
        }
        this.currentCMDValues[this.command] = this.normalArgument = VideoEngine.intArgument(instruction);
        switch (this.command) {
            case 0: {
                this.executeCommandNOP();
                break;
            }
            case 1: {
                this.executeCommandVADDR();
                break;
            }
            case 2: {
                this.executeCommandIADDR();
                break;
            }
            case 4: {
                this.executeCommandPRIM();
                break;
            }
            case 5: {
                this.executeCommandBEZIER();
                break;
            }
            case 6: {
                this.executeCommandSPLINE();
                break;
            }
            case 7: {
                this.executeCommandBBOX();
                break;
            }
            case 8: {
                this.executeCommandJUMP();
                break;
            }
            case 9: {
                this.executeCommandBJUMP();
                break;
            }
            case 10: {
                this.executeCommandCALL();
                break;
            }
            case 11: {
                this.executeCommandRET();
                break;
            }
            case 12: {
                this.executeCommandEND();
                break;
            }
            case 14: {
                this.executeCommandSIGNAL();
                break;
            }
            case 15: {
                this.executeCommandFINISH();
                break;
            }
            case 16: {
                this.executeCommandBASE();
                break;
            }
            case 18: {
                this.executeCommandVTYPE();
                break;
            }
            case 19: {
                this.executeCommandOFFSET_ADDR();
                break;
            }
            case 20: {
                this.executeCommandORIGIN_ADDR();
                break;
            }
            case 21: {
                this.executeCommandREGION1();
                break;
            }
            case 22: {
                this.executeCommandREGION2();
                break;
            }
            case 23: {
                this.executeCommandLTE();
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.executeCommandLTEn();
                break;
            }
            case 28: {
                this.executeCommandCPE();
                break;
            }
            case 29: {
                this.executeCommandBCE();
                break;
            }
            case 30: {
                this.executeCommandTME();
                break;
            }
            case 31: {
                this.executeCommandFGE();
                break;
            }
            case 32: {
                this.executeCommandDTE();
                break;
            }
            case 33: {
                this.executeCommandABE();
                break;
            }
            case 34: {
                this.executeCommandATE();
                break;
            }
            case 35: {
                this.executeCommandZTE();
                break;
            }
            case 36: {
                this.executeCommandSTE();
                break;
            }
            case 37: {
                this.executeCommandAAE();
                break;
            }
            case 38: {
                this.executeCommandPCE();
                break;
            }
            case 39: {
                this.executeCommandCTE();
                break;
            }
            case 40: {
                this.executeCommandLOE();
                break;
            }
            case 42: {
                this.executeCommandBOFS();
                break;
            }
            case 43: {
                this.executeCommandBONE();
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                this.executeCommandMWn();
                break;
            }
            case 54: {
                this.executeCommandPSUB();
                break;
            }
            case 55: {
                this.executeCommandPPRIM();
                break;
            }
            case 56: {
                this.executeCommandPFACE();
                break;
            }
            case 58: {
                this.executeCommandMMS();
                break;
            }
            case 59: {
                this.executeCommandMODEL();
                break;
            }
            case 60: {
                this.executeCommandVMS();
                break;
            }
            case 61: {
                this.executeCommandVIEW();
                break;
            }
            case 62: {
                this.executeCommandPMS();
                break;
            }
            case 63: {
                this.executeCommandPROJ();
                break;
            }
            case 64: {
                this.executeCommandTMS();
                break;
            }
            case 65: {
                this.executeCommandTMATRIX();
                break;
            }
            case 66: {
                this.executeCommandXSCALE();
                break;
            }
            case 67: {
                this.executeCommandYSCALE();
                break;
            }
            case 68: {
                this.executeCommandZSCALE();
                break;
            }
            case 69: {
                this.executeCommandXPOS();
                break;
            }
            case 70: {
                this.executeCommandYPOS();
                break;
            }
            case 71: {
                this.executeCommandZPOS();
                break;
            }
            case 72: {
                this.executeCommandUSCALE();
                break;
            }
            case 73: {
                this.executeCommandVSCALE();
                break;
            }
            case 74: {
                this.executeCommandUOFFSET();
                break;
            }
            case 75: {
                this.executeCommandVOFFSET();
                break;
            }
            case 76: {
                this.executeCommandOFFSETX();
                break;
            }
            case 77: {
                this.executeCommandOFFSETY();
                break;
            }
            case 80: {
                this.executeCommandSHADE();
                break;
            }
            case 81: {
                this.executeCommandRNORM();
                break;
            }
            case 83: {
                this.executeCommandCMAT();
                break;
            }
            case 84: {
                this.executeCommandEMC();
                break;
            }
            case 85: {
                this.executeCommandAMC();
                break;
            }
            case 86: {
                this.executeCommandDMC();
                break;
            }
            case 87: {
                this.executeCommandSMC();
                break;
            }
            case 88: {
                this.executeCommandAMA();
                break;
            }
            case 91: {
                this.executeCommandSPOW();
                break;
            }
            case 92: {
                this.executeCommandALC();
                break;
            }
            case 93: {
                this.executeCommandALA();
                break;
            }
            case 94: {
                this.executeCommandLMODE();
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                this.executeCommandLTn();
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                this.executeCommandLXPn();
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                this.executeCommandLXDn();
                break;
            }
            case 123: 
            case 126: 
            case 129: 
            case 132: {
                this.executeCommandLCAn();
                break;
            }
            case 124: 
            case 127: 
            case 130: 
            case 133: {
                this.executeCommandLLAn();
                break;
            }
            case 125: 
            case 128: 
            case 131: 
            case 134: {
                this.executeCommandLQAn();
                break;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                this.executeCommandSLEn();
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                this.executeCommandSLFn();
                break;
            }
            case 143: 
            case 146: 
            case 149: 
            case 152: {
                this.executeCommandALCn();
                break;
            }
            case 144: 
            case 147: 
            case 150: 
            case 153: {
                this.executeCommandDLCn();
                break;
            }
            case 145: 
            case 148: 
            case 151: 
            case 154: {
                this.executeCommandSLCn();
                break;
            }
            case 155: {
                this.executeCommandFFACE();
                break;
            }
            case 156: {
                this.executeCommandFBP();
                break;
            }
            case 157: {
                this.executeCommandFBW();
                break;
            }
            case 158: {
                this.executeCommandZBP();
                break;
            }
            case 159: {
                this.executeCommandZBW();
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                this.executeCommandTBPn();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.executeCommandTBWn();
                break;
            }
            case 176: {
                this.executeCommandCBP();
                break;
            }
            case 177: {
                this.executeCommandCBPH();
                break;
            }
            case 178: {
                this.executeCommandTRXSBP();
                break;
            }
            case 179: {
                this.executeCommandTRXSBW();
                break;
            }
            case 180: {
                this.executeCommandTRXDBP();
                break;
            }
            case 181: {
                this.executeCommandTRXDBW();
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                this.executeCommandTSIZEn();
                break;
            }
            case 192: {
                this.executeCommandTMAP();
                break;
            }
            case 193: {
                this.executeCommandTEXTURE_ENV_MAP_MATRIX();
                break;
            }
            case 194: {
                this.executeCommandTMODE();
                break;
            }
            case 195: {
                this.executeCommandTPSM();
                break;
            }
            case 196: {
                this.executeCommandCLOAD();
                break;
            }
            case 197: {
                this.executeCommandCMODE();
                break;
            }
            case 198: {
                this.executeCommandTFLT();
                break;
            }
            case 199: {
                this.executeCommandTWRAP();
                break;
            }
            case 200: {
                this.executeCommandTBIAS();
                break;
            }
            case 201: {
                this.executeCommandTFUNC();
                break;
            }
            case 202: {
                this.executeCommandTEC();
                break;
            }
            case 203: {
                this.executeCommandTFLUSH();
                break;
            }
            case 204: {
                this.executeCommandTSYNC();
                break;
            }
            case 205: {
                this.executeCommandFFAR();
                break;
            }
            case 206: {
                this.executeCommandFDIST();
                break;
            }
            case 207: {
                this.executeCommandFCOL();
                break;
            }
            case 208: {
                this.executeCommandTSLOPE();
                break;
            }
            case 210: {
                this.executeCommandPSM();
                break;
            }
            case 211: {
                this.executeCommandCLEAR();
                break;
            }
            case 212: {
                this.executeCommandSCISSOR1();
                break;
            }
            case 213: {
                this.executeCommandSCISSOR2();
                break;
            }
            case 214: {
                this.executeCommandNEARZ();
                break;
            }
            case 215: {
                this.executeCommandFARZ();
                break;
            }
            case 216: {
                this.executeCommandCTST();
                break;
            }
            case 217: {
                this.executeCommandCREF();
                break;
            }
            case 218: {
                this.executeCommandCMSK();
                break;
            }
            case 219: {
                this.executeCommandATST();
                break;
            }
            case 220: {
                this.executeCommandSTST();
                break;
            }
            case 221: {
                this.executeCommandSOP();
                break;
            }
            case 222: {
                this.executeCommandZTST();
                break;
            }
            case 223: {
                this.executeCommandALPHA();
                break;
            }
            case 224: {
                this.executeCommandSFIX();
                break;
            }
            case 225: {
                this.executeCommandDFIX();
                break;
            }
            case 226: {
                this.executeCommandDTH0();
                break;
            }
            case 227: {
                this.executeCommandDTH1();
                break;
            }
            case 228: {
                this.executeCommandDTH2();
                break;
            }
            case 229: {
                this.executeCommandDTH3();
                break;
            }
            case 230: {
                this.executeCommandLOP();
                break;
            }
            case 231: {
                this.executeCommandZMSK();
                break;
            }
            case 232: {
                this.executeCommandPMSKC();
                break;
            }
            case 233: {
                this.executeCommandPMSKA();
                break;
            }
            case 234: {
                this.executeCommandTRXKICK();
                break;
            }
            case 235: {
                this.executeCommandTRXPOS();
                break;
            }
            case 236: {
                this.executeCommandTRXDPOS();
                break;
            }
            case 238: {
                this.executeCommandTRXSIZE();
                break;
            }
            case 240: {
                this.executeCommandVSCX();
                break;
            }
            case 241: {
                this.executeCommandVSCY();
                break;
            }
            case 242: {
                this.executeCommandVSCZ();
                break;
            }
            case 243: {
                this.executeCommandVTCS();
                break;
            }
            case 244: {
                this.executeCommandVTCT();
                break;
            }
            case 245: {
                this.executeCommandVTCQ();
                break;
            }
            case 246: {
                this.executeCommandVCV();
                break;
            }
            case 247: {
                this.executeCommandVAP();
                break;
            }
            case 248: {
                this.executeCommandVFC();
                break;
            }
            case 249: {
                this.executeCommandVSCV();
                break;
            }
            case 255: {
                this.executeCommandDUMMY();
                break;
            }
            default: {
                this.executeCommandUNKNOWN();
            }
        }
    }

    private void executeCommandUNKNOWN() {
        if (this.isLogWarnEnabled) {
            log.warn((Object)String.format("Unknown/unimplemented video command [%s]%s at 0x%08X", helper.getCommandString(this.command), this.getArgumentLog(this.normalArgument), this.currentList.getPc() - 4));
        }
    }

    private void executeCommandCLEAR() {
        if ((this.normalArgument & 1) == 0) {
            if (!this.context.clearMode) {
                return;
            }
            this.context.clearMode = false;
            this.re.endClearMode();
            if (this.isLogDebugEnabled) {
                VideoEngine.log("clear mode end");
            }
        } else {
            boolean color = (this.normalArgument & 0x100) != 0;
            boolean stencil = (this.normalArgument & 0x200) != 0;
            boolean depth = (this.normalArgument & 0x400) != 0;
            this.updateGeBuf();
            this.re.startClearMode(color, stencil, depth);
            this.context.clearMode = true;
            this.context.clearModeColor = color;
            this.context.clearModeStencil = stencil;
            this.context.clearModeDepth = depth;
            if (this.isLogDebugEnabled) {
                VideoEngine.log(String.format("clear mode: %d (%s%s%s)", this.normalArgument >> 8, color ? "COLOR" : "", stencil ? " STENCIL" : "", depth ? " DEPTH" : ""));
            }
        }
        this.lightingChanged = true;
        this.projectionMatrixUpload.setChanged(true);
        this.modelMatrixUpload.setChanged(true);
        this.viewMatrixUpload.setChanged(true);
        this.textureMatrixUpload.setChanged(true);
        this.viewportChanged = true;
        this.depthChanged = true;
        this.materialChanged = true;
    }

    private void executeCommandTFUNC() {
        this.context.textureFunc = this.normalArgument & 7;
        if (this.context.textureFunc >= 5) {
            log.warn((Object)("Unimplemented tfunc mode " + this.context.textureFunc));
            this.context.textureFunc = 0;
        }
        this.context.textureAlphaUsed = (this.normalArgument >> 8 & 1) != 0;
        this.context.textureColorDoubled = (this.normalArgument >> 16 & 1) != 0;
        this.re.setTextureFunc(this.context.textureFunc, this.context.textureAlphaUsed, this.context.textureColorDoubled);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuTexFunc mode %06X", this.normalArgument) + ((this.normalArgument & 0x10000) != 0 ? " SCALE" : "") + ((this.normalArgument & 0x100) != 0 ? " ALPHA" : ""));
        }
    }

    private int fixNativeBufferOffset(Buffer vertexData, int size) {
        int nativeBufferOffset = 0;
        if (vertexData instanceof IntBuffer || vertexData instanceof FloatBuffer) {
            nativeBufferOffset = this.context.vinfo.ptr_vertex & 3;
        } else if (vertexData instanceof ShortBuffer) {
            nativeBufferOffset = this.context.vinfo.ptr_vertex & 1;
        }
        this.vertexInfoReader.addNativeOffset(nativeBufferOffset);
        return size += nativeBufferOffset;
    }

    private int checkMultiDraw(int currentFirst, int currentType, int currentNumberOfVertex, IntBuffer bufferFirst, IntBuffer bufferCount) {
        int pc;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("checkMultiDraw at 0x%08X", this.currentList.getPc()));
        }
        Memory mem = Memory.getInstance();
        int afterMultiPc = pc = this.currentList.getPc();
        boolean hasMultiDraw = false;
        int initialFirst = currentFirst;
        int currentSkip = 0;
        bufferFirst.clear();
        bufferCount.clear();
        int currentPtrVertex = this.context.vinfo.ptr_vertex + this.context.vinfo.vertexSize * currentNumberOfVertex;
        boolean frontFaceCw = this.context.frontFaceCw;
        while (bufferFirst.remaining() > 1) {
            int instruction = mem.read32(pc);
            pc += 4;
            int cmd = VideoEngine.command(instruction);
            if (cmd == 4) {
                if (this.context.frontFaceCw != frontFaceCw) {
                    if (!this.isLogDebugEnabled) break;
                    log.debug((Object)String.format("%s 0x%06X non matching FFACE has stopped integration in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                    break;
                }
                int type = instruction >> 16 & 7;
                if (type != currentType) {
                    if (!this.isLogDebugEnabled) break;
                    log.debug((Object)String.format("%s 0x%06X non matching vertex type has stopped integration in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                    break;
                }
                int numberOfVertex = instruction & 0xFFFF;
                bufferFirst.put(currentFirst);
                bufferCount.put(currentNumberOfVertex);
                currentFirst += currentNumberOfVertex + currentSkip;
                currentNumberOfVertex = numberOfVertex;
                currentPtrVertex += this.context.vinfo.vertexSize * (numberOfVertex + currentSkip);
                currentSkip = 0;
                hasMultiDraw = true;
                afterMultiPc = pc;
                if (!this.isLogDebugEnabled) continue;
                log.debug((Object)String.format("%s type=%d, numberOfVertex=%d integrated in MultiDrawArrays", helper.getCommandString(cmd), type, numberOfVertex));
                continue;
            }
            if (cmd == 1) {
                int arg = VideoEngine.intArgument(instruction);
                int ptr_vertex = this.currentList.getAddressRelOffset(arg);
                if (ptr_vertex == currentPtrVertex) {
                    if (!this.isLogDebugEnabled) continue;
                    log.debug((Object)String.format("%s 0x%08X integrated in MultiDrawArrays", helper.getCommandString(cmd), ptr_vertex));
                    continue;
                }
                if (ptr_vertex > currentPtrVertex && (ptr_vertex - currentPtrVertex) % this.context.vinfo.vertexSize == 0) {
                    currentSkip = (ptr_vertex - currentPtrVertex) / this.context.vinfo.vertexSize;
                    if (!this.isLogDebugEnabled) continue;
                    log.debug((Object)String.format("%s 0x%08X (skip=%d) integrated in MultiDrawArrays", helper.getCommandString(cmd), ptr_vertex, currentSkip));
                    continue;
                }
                if (!this.isLogDebugEnabled) break;
                log.debug((Object)String.format("%s 0x%08X not integrated in MultiDrawArrays (needed 0x%08X)", helper.getCommandString(cmd), ptr_vertex, currentPtrVertex));
                break;
            }
            if (cmd == 200) {
                int tex_mipmap_mode = instruction & 3;
                if (this.context.tex_mipmap_mode == tex_mipmap_mode && tex_mipmap_mode == 0) {
                    if (!this.isLogDebugEnabled) continue;
                    log.debug((Object)String.format("%s 0x%06X integrated in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                    continue;
                }
                if (!this.isLogDebugEnabled) break;
                log.debug((Object)String.format("%s 0x%06X has stopped integration in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                break;
            }
            if (GeCommands.pureStateCommands[cmd]) {
                if (cmd == 155) {
                    boolean bl = frontFaceCw = VideoEngine.intArgument(instruction) != 0;
                    if (!this.isLogDebugEnabled) continue;
                    log.debug((Object)String.format("%s 0x%06X trying to integrate in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                    continue;
                }
                if (this.currentListCMDValues[cmd] == instruction) {
                    if (!this.isLogDebugEnabled) continue;
                    log.debug((Object)String.format("%s 0x%06X pure state cmd integrated in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                    continue;
                }
                if (!this.isLogDebugEnabled) break;
                log.debug((Object)String.format("%s 0x%06X pure state cmd has stopped integration in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
                break;
            }
            if (!this.isLogDebugEnabled) break;
            log.debug((Object)String.format("%s 0x%06X has stopped integration in MultiDrawArrays", helper.getCommandString(cmd), VideoEngine.intArgument(instruction)));
            break;
        }
        if (!hasMultiDraw) {
            return -1;
        }
        bufferFirst.put(currentFirst);
        bufferCount.put(currentNumberOfVertex);
        bufferFirst.limit(bufferFirst.position());
        bufferFirst.rewind();
        bufferCount.limit(bufferCount.position());
        bufferCount.rewind();
        this.currentList.setPc(afterMultiPc);
        return currentFirst + currentNumberOfVertex - initialFirst;
    }

    private void executeCommandPRIM() {
        boolean mustComputeWeights;
        int numberOfWeightsForBuffer;
        int numberOfVertex = this.normalArgument & 0xFFFF;
        int type = this.normalArgument >> 16 & 7;
        if (numberOfVertex == 0) {
            return;
        }
        Memory mem = Memory.getInstance();
        if (!Memory.isAddressGood(this.context.vinfo.ptr_vertex)) {
            this.error(helper.getCommandString(4) + " Invalid vertex address 0x" + Integer.toHexString(this.context.vinfo.ptr_vertex));
            return;
        }
        if (type > 6) {
            this.error(String.format("%s: Type %d unhandled at 0x%08X", helper.getCommandString(4), type, this.currentList.getPc() - 4));
            return;
        }
        if (numberOfVertex < minimumNumberOfVertex[type]) {
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("%s type %d unsufficient number of vertex %d", helper.getCommandString(4), type, numberOfVertex));
            }
            return;
        }
        if (this.skipThisFrame) {
            this.endRendering(numberOfVertex);
            return;
        }
        this.updateGeBuf();
        this.somethingDisplayed = true;
        ++this.primCount;
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeCmd(4);
        }
        this.loadTexture();
        if (this.isLogDebugEnabled) {
            switch (type) {
                case 0: {
                    VideoEngine.log("prim point " + numberOfVertex + "x");
                    break;
                }
                case 1: {
                    VideoEngine.log("prim line " + numberOfVertex / 2 + "x");
                    break;
                }
                case 2: {
                    VideoEngine.log("prim lines_strips " + (numberOfVertex - 1) + "x");
                    break;
                }
                case 3: {
                    VideoEngine.log("prim triangle " + numberOfVertex / 3 + "x");
                    break;
                }
                case 4: {
                    VideoEngine.log("prim triangle_strips " + (numberOfVertex - 2) + "x");
                    break;
                }
                case 5: {
                    VideoEngine.log("prim triangle_fans " + (numberOfVertex - 2) + "x");
                    break;
                }
                case 6: {
                    VideoEngine.log("prim sprites " + numberOfVertex / 2 + "x");
                    break;
                }
                default: {
                    log.warn((Object)("prim unhandled " + type));
                }
            }
        }
        this.initRendering();
        int nTexCoord = 2;
        int nColor = 4;
        int nVertex = 3;
        boolean useTexture = false;
        boolean useTextureFromNormal = false;
        boolean useTextureFromNormalizedNormal = false;
        boolean useTextureFromPosition = false;
        if (this.context.textureFlag.isEnabled() || this.re.isVertexArrayAvailable()) {
            if (this.context.vinfo.transform2D) {
                if (this.context.vinfo.texture != 0) {
                    useTexture = true;
                }
            } else {
                switch (this.context.tex_map_mode) {
                    case 0: {
                        if (this.context.vinfo.texture == 0) break;
                        useTexture = true;
                        break;
                    }
                    case 1: {
                        switch (this.context.tex_proj_map_mode) {
                            case 0: {
                                if (this.context.vinfo.position == 0) break;
                                useTexture = true;
                                useTextureFromPosition = true;
                                nTexCoord = nVertex;
                                break;
                            }
                            case 1: {
                                if (this.context.vinfo.texture == 0) break;
                                useTexture = true;
                                break;
                            }
                            case 3: {
                                if (this.context.vinfo.normal == 0) break;
                                useTexture = true;
                                useTextureFromNormal = true;
                                nTexCoord = 3;
                                break;
                            }
                            case 2: {
                                if (this.context.vinfo.normal == 0) break;
                                useTexture = true;
                                useTextureFromNormalizedNormal = true;
                                nTexCoord = 3;
                            }
                        }
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        log.warn((Object)String.format("Unhandled texture matrix mode %d", this.context.tex_map_mode));
                    }
                }
            }
        }
        this.vertexStatistics.start();
        this.context.vinfo.setMorphWeights(this.context.morph_weight);
        this.context.vinfo.setDirty();
        if (this.context.vinfo.weight != 0) {
            numberOfWeightsForBuffer = this.re.setBones(this.context.vinfo.skinningWeightCount, this.context.boneMatrixLinear);
            mustComputeWeights = numberOfWeightsForBuffer == 0;
        } else {
            numberOfWeightsForBuffer = this.re.setBones(0, null);
            mustComputeWeights = false;
        }
        if (this.maxSpriteWidth == 0 || this.context.scissor_x2 < this.maxSpriteWidth) {
            this.maxSpriteWidth = this.context.scissor_x2;
        }
        if (this.maxSpriteHeight == 0 || this.context.scissor_y2 < this.maxSpriteHeight) {
            this.maxSpriteHeight = this.context.scissor_y2;
        }
        boolean needSetDataPointers = true;
        if (this.re.canReadAllVertexInfo()) {
            this.re.setVertexInfo(this.context.vinfo, true, this.context.useVertexColor, useTexture, type);
            this.re.drawArrays(type, 0, numberOfVertex);
        } else if (!(this.useVertexCache && !this.re.canAllNativeVertexInfo() || this.context.vinfo.index != 0 || this.context.vinfo.morphingVertexCount != 1 || type == 6 && !this.re.canNativeSpritesPrimitive() || useTextureFromNormalizedNormal || mustComputeWeights || !Memory.isAddressGood(this.context.vinfo.ptr_vertex) || this.disableOptimizedVertexInfoReading())) {
            boolean useBufferManager;
            int stride;
            this.vertexReadingStatistics.start();
            Buffer buffer = this.vertexInfoReader.read(this.context.vinfo, this.context.vinfo.ptr_vertex, numberOfVertex, this.re.canAllNativeVertexInfo());
            this.vertexReadingStatistics.end();
            int size = this.context.vinfo.vertexSize * numberOfVertex;
            int firstVertex = 0;
            boolean multiDrawArrays = false;
            if (this.useVertexCache && buffer == null) {
                stride = this.context.vinfo.vertexSize;
                useBufferManager = false;
                int vertexAddress = this.context.vinfo.ptr_vertex;
                VertexBuffer vertexBuffer = VertexBufferManager.getInstance().getVertexBuffer(this.re, vertexAddress, size, stride, this.re.isVertexArrayAvailable());
                Buffer vertexData = mem.getBuffer(vertexAddress, size);
                vertexBuffer.load(this.re, vertexData, vertexAddress, size);
                if (this.re.isVertexArrayAvailable()) {
                    VertexArray vertexArray = VertexArrayManager.getInstance().getVertexArray(this.re, this.context.vinfo.vtype, vertexBuffer, vertexAddress, stride);
                    needSetDataPointers = vertexArray.bind(this.re);
                    firstVertex = vertexArray.getVertexOffset(vertexAddress);
                } else {
                    this.vertexInfoReader.addNativeOffset(vertexBuffer.getBufferOffset(vertexAddress));
                }
                int multiDrawNumberOfVertex = this.checkMultiDraw(firstVertex, type, numberOfVertex, this.multiDrawFirst, this.multiDrawCount);
                if (multiDrawNumberOfVertex > 0) {
                    multiDrawArrays = true;
                    numberOfVertex = multiDrawNumberOfVertex;
                    size = this.context.vinfo.vertexSize * multiDrawNumberOfVertex;
                    vertexData = mem.getBuffer(vertexAddress, size);
                    vertexBuffer.load(this.re, vertexData, vertexAddress, size);
                }
                if (needSetDataPointers) {
                    vertexBuffer.bind(this.re);
                }
            } else {
                if (this.re.isVertexArrayAvailable()) {
                    this.re.bindVertexArray(0);
                }
                stride = this.vertexInfoReader.getStride();
                useBufferManager = true;
                if (buffer != null) {
                    this.bufferManager.setBufferData(this.bufferId, stride * numberOfVertex, buffer, 0);
                }
                if (this.vertexInfoReader.hasNative()) {
                    Buffer vertexData = mem.getBuffer(this.context.vinfo.ptr_vertex, size);
                    size = this.fixNativeBufferOffset(vertexData, size);
                    this.bufferManager.setBufferData(this.nativeBufferId, size, vertexData, 0);
                }
            }
            this.re.setVertexInfo(this.context.vinfo, this.re.canAllNativeVertexInfo(), this.context.useVertexColor, useTexture, type);
            if (needSetDataPointers) {
                if (useTexture) {
                    int textureType;
                    int textureOffset;
                    boolean textureNative;
                    if (useTextureFromNormal) {
                        textureNative = this.vertexInfoReader.isNormalNative();
                        textureOffset = this.vertexInfoReader.getNormalOffset();
                        textureType = this.vertexInfoReader.getNormalType();
                        nTexCoord = this.vertexInfoReader.getNormalNumberValues();
                    } else if (useTextureFromPosition) {
                        textureNative = this.vertexInfoReader.isPositionNative();
                        textureOffset = this.vertexInfoReader.getPositionOffset();
                        textureType = this.vertexInfoReader.getPositionType();
                        nTexCoord = this.vertexInfoReader.getPositionNumberValues();
                    } else {
                        textureNative = this.vertexInfoReader.isTextureNative();
                        textureOffset = this.vertexInfoReader.getTextureOffset();
                        textureType = this.vertexInfoReader.getTextureType();
                        nTexCoord = this.vertexInfoReader.getTextureNumberValues();
                    }
                    this.setTexCoordPointer(useTexture, nTexCoord, textureType, stride, textureOffset, textureNative, useBufferManager);
                }
                nVertex = this.vertexInfoReader.getPositionNumberValues();
                nColor = this.vertexInfoReader.getColorNumberValues();
                int nWeight = this.vertexInfoReader.getWeightNumberValues();
                this.enableClientState(this.context.useVertexColor, useTexture);
                this.setColorPointer(this.context.useVertexColor, nColor, this.vertexInfoReader.getColorType(), stride, this.vertexInfoReader.getColorOffset(), this.vertexInfoReader.isColorNative(), useBufferManager);
                this.setNormalPointer(this.vertexInfoReader.getNormalType(), stride, this.vertexInfoReader.getNormalOffset(), this.vertexInfoReader.isNormalNative(), useBufferManager);
                this.setWeightPointer(nWeight, this.vertexInfoReader.getWeightType(), stride, this.vertexInfoReader.getWeightOffset(), this.vertexInfoReader.isWeightNative(), useBufferManager);
                this.setVertexPointer(nVertex, this.vertexInfoReader.getPositionType(), stride, this.vertexInfoReader.getPositionOffset(), this.vertexInfoReader.isPositionNative(), useBufferManager);
            }
            this.drawArraysStatistics.start();
            if (multiDrawArrays) {
                this.re.multiDrawArrays(type, this.multiDrawFirst, this.multiDrawCount);
            } else {
                this.re.drawArrays(type, firstVertex, numberOfVertex);
            }
            this.drawArraysStatistics.end();
        } else {
            boolean readTexture;
            VertexInfo cachedVertexInfo = null;
            if (this.useVertexCache) {
                this.vertexCacheLookupStatistics.start();
                cachedVertexInfo = VertexCache.getInstance().getVertex(this.context.vinfo, numberOfVertex, this.context.bone_uploaded_matrix, numberOfWeightsForBuffer);
                this.vertexCacheLookupStatistics.end();
            }
            ByteBuffer byteBuffer = this.bufferManager.getBuffer(this.bufferId);
            byteBuffer.clear();
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.clear();
            if (!this.useVertexCache && this.re.isVertexArrayAvailable()) {
                this.re.bindVertexArray(0);
            }
            boolean bl = readTexture = this.context.textureFlag.isEnabled() && !this.context.clearMode;
            if (this.useVertexCache) {
                readTexture = true;
            }
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.re.setVertexInfo(this.context.vinfo, false, this.context.useVertexColor, useTexture, type);
                    float[] normalizedNormal = new float[3];
                    if (cachedVertexInfo == null) {
                        this.vertexReadingStatistics.start();
                        for (int i = 0; i < numberOfVertex; ++i) {
                            int addr = this.context.vinfo.getAddress(mem, i);
                            this.context.vinfo.readVertex(mem, addr, this.v, readTexture);
                            if (mustComputeWeights && this.context.vinfo.position != 0) {
                                VideoEngine.doSkinning(this.context.bone_uploaded_matrix, this.context.vinfo, this.v);
                            }
                            if (useTextureFromNormal) {
                                floatBuffer.put(this.v.n, 0, 3);
                            } else if (useTextureFromNormalizedNormal) {
                                float normalLength = (float)Math.sqrt(this.v.n[0] * this.v.n[0] + this.v.n[1] * this.v.n[1] + this.v.n[2] * this.v.n[2]);
                                normalizedNormal[0] = this.v.n[0] / normalLength;
                                normalizedNormal[1] = this.v.n[1] / normalLength;
                                normalizedNormal[2] = this.v.n[2] / normalLength;
                                floatBuffer.put(normalizedNormal, 0, 3);
                            } else if (useTextureFromPosition) {
                                floatBuffer.put(this.v.p, 0, 3);
                            } else if (useTexture || this.context.vinfo.texture != 0) {
                                floatBuffer.put(this.v.t);
                            }
                            if (this.context.useVertexColor) {
                                floatBuffer.put(this.v.c);
                            }
                            if (this.context.vinfo.normal != 0) {
                                floatBuffer.put(this.v.n);
                            }
                            if (this.context.vinfo.position != 0) {
                                floatBuffer.put(this.v.p);
                            }
                            if (numberOfWeightsForBuffer > 0) {
                                floatBuffer.put(this.v.boneWeights, 0, numberOfWeightsForBuffer);
                            }
                            if (!this.isLogTraceEnabled || this.context.vinfo.texture == 0 || this.context.vinfo.position == 0) continue;
                            log.trace((Object)("  vertex#" + i + " (" + (int)this.v.t[0] + "," + (int)this.v.t[1] + ") at (" + (int)this.v.p[0] + "," + (int)this.v.p[1] + "," + (int)this.v.p[2] + ")"));
                        }
                        this.vertexReadingStatistics.end();
                        if (this.useVertexCache) {
                            cachedVertexInfo = new VertexInfo(this.context.vinfo);
                            VertexCache.getInstance().addVertex(this.re, cachedVertexInfo, numberOfVertex, this.context.bone_uploaded_matrix, numberOfWeightsForBuffer);
                            int size = floatBuffer.position();
                            floatBuffer.rewind();
                            needSetDataPointers = cachedVertexInfo.loadVertex(this.re, floatBuffer, size);
                        } else {
                            this.bufferManager.setBufferData(this.bufferId, floatBuffer.position() * SIZEOF_FLOAT, byteBuffer, 0);
                        }
                    } else {
                        if (this.isLogDebugEnabled) {
                            log.debug((Object)"Reusing cached Vertex Data");
                        }
                        needSetDataPointers = cachedVertexInfo.bindVertex(this.re);
                    }
                    if (needSetDataPointers) {
                        this.setDataPointers(nVertex, this.context.useVertexColor, nColor, useTexture, nTexCoord, this.context.vinfo.normal != 0, numberOfWeightsForBuffer, cachedVertexInfo == null);
                    }
                    this.drawArraysStatistics.start();
                    this.re.drawArrays(type, 0, numberOfVertex);
                    this.drawArraysStatistics.end();
                    this.maxSpriteHeight = Integer.MAX_VALUE;
                    this.maxSpriteWidth = Integer.MAX_VALUE;
                    break;
                }
                case 6: {
                    this.re.setVertexInfo(this.context.vinfo, false, this.context.useVertexColor, useTexture, 7);
                    this.re.disableFlag(5);
                    float[] mvpMatrix = null;
                    if (!this.context.vinfo.transform2D) {
                        mvpMatrix = new float[16];
                        Utilities.matrixMult(mvpMatrix, this.context.model_uploaded_matrix, this.context.view_uploaded_matrix);
                        Utilities.matrixMult(mvpMatrix, mvpMatrix, this.getProjectionMatrix());
                    }
                    if (cachedVertexInfo == null) {
                        this.vertexReadingStatistics.start();
                        for (int i = 0; i < numberOfVertex; i += 2) {
                            boolean flippedTexture;
                            float y2;
                            float x2;
                            float y1;
                            float x1;
                            int addr1 = this.context.vinfo.getAddress(mem, i);
                            int addr2 = this.context.vinfo.getAddress(mem, i + 1);
                            this.context.vinfo.readVertex(mem, addr1, this.v1, readTexture);
                            this.context.vinfo.readVertex(mem, addr2, this.v2, readTexture);
                            this.v1.p[2] = this.v2.p[2];
                            if (this.v2.p[1] > (float)this.maxSpriteHeight) {
                                this.maxSpriteHeight = (int)this.v2.p[1];
                            }
                            if (this.v2.p[1] > (float)this.maxSpriteWidth) {
                                this.maxSpriteWidth = (int)this.v2.p[1];
                            }
                            if (mvpMatrix == null) {
                                x1 = this.v1.p[0];
                                y1 = -this.v1.p[1];
                                x2 = this.v2.p[0];
                                y2 = -this.v2.p[1];
                            } else {
                                float[] mvpPosition = new float[2];
                                Utilities.vectorMult(mvpPosition, mvpMatrix, this.v1.p);
                                x1 = mvpPosition[0];
                                y1 = mvpPosition[1];
                                Utilities.vectorMult(mvpPosition, mvpMatrix, this.v2.p);
                                x2 = mvpPosition[0];
                                y2 = mvpPosition[1];
                            }
                            boolean bl2 = flippedTexture = y1 < y2 && x1 < x2 || y1 > y2 && x1 > x2;
                            if (this.isLogDebugEnabled) {
                                VideoEngine.log(String.format("  sprite (%.0f,%.0f)-(%.0f,%.0f) at (%.0f,%.0f,%.0f)-(%.0f,%.0f,%.0f)%s", Float.valueOf(this.v1.t[0]), Float.valueOf(this.v1.t[1]), Float.valueOf(this.v2.t[0]), Float.valueOf(this.v2.t[1]), Float.valueOf(this.v1.p[0]), Float.valueOf(this.v1.p[1]), Float.valueOf(this.v1.p[2]), Float.valueOf(this.v2.p[0]), Float.valueOf(this.v2.p[1]), Float.valueOf(this.v2.p[2]), flippedTexture ? " flipped" : ""));
                            }
                            if (this.context.vinfo.texture != 0) {
                                floatBuffer.put(this.v1.t);
                            }
                            if (this.context.useVertexColor) {
                                floatBuffer.put(this.v2.c);
                            }
                            if (this.context.vinfo.normal != 0) {
                                floatBuffer.put(this.v2.n);
                            }
                            if (this.context.vinfo.position != 0) {
                                floatBuffer.put(this.v1.p);
                            }
                            if (this.context.vinfo.texture != 0) {
                                if (flippedTexture) {
                                    floatBuffer.put(this.v2.t[0]).put(this.v1.t[1]);
                                } else {
                                    floatBuffer.put(this.v1.t[0]).put(this.v2.t[1]);
                                }
                            }
                            if (this.context.useVertexColor) {
                                floatBuffer.put(this.v2.c);
                            }
                            if (this.context.vinfo.normal != 0) {
                                floatBuffer.put(this.v2.n);
                            }
                            if (this.context.vinfo.position != 0) {
                                floatBuffer.put(this.v1.p[0]).put(this.v2.p[1]).put(this.v2.p[2]);
                            }
                            if (this.context.vinfo.texture != 0) {
                                floatBuffer.put(this.v2.t);
                            }
                            if (this.context.useVertexColor) {
                                floatBuffer.put(this.v2.c);
                            }
                            if (this.context.vinfo.normal != 0) {
                                floatBuffer.put(this.v2.n);
                            }
                            if (this.context.vinfo.position != 0) {
                                floatBuffer.put(this.v2.p);
                            }
                            if (this.context.vinfo.texture != 0) {
                                if (flippedTexture) {
                                    floatBuffer.put(this.v1.t[0]).put(this.v2.t[1]);
                                } else {
                                    floatBuffer.put(this.v2.t[0]).put(this.v1.t[1]);
                                }
                            }
                            if (this.context.useVertexColor) {
                                floatBuffer.put(this.v2.c);
                            }
                            if (this.context.vinfo.normal != 0) {
                                floatBuffer.put(this.v2.n);
                            }
                            if (this.context.vinfo.position == 0) continue;
                            floatBuffer.put(this.v2.p[0]).put(this.v1.p[1]).put(this.v2.p[2]);
                        }
                        this.vertexReadingStatistics.end();
                        if (this.useVertexCache) {
                            cachedVertexInfo = new VertexInfo(this.context.vinfo);
                            VertexCache.getInstance().addVertex(this.re, cachedVertexInfo, numberOfVertex, this.context.bone_uploaded_matrix, numberOfWeightsForBuffer);
                            int size = floatBuffer.position();
                            floatBuffer.rewind();
                            needSetDataPointers = cachedVertexInfo.loadVertex(this.re, floatBuffer, size);
                        } else {
                            this.bufferManager.setBufferData(this.bufferId, floatBuffer.position() * SIZEOF_FLOAT, byteBuffer, 0);
                        }
                    } else {
                        if (this.isLogDebugEnabled) {
                            log.debug((Object)"Reusing cached Vertex Data");
                        }
                        needSetDataPointers = cachedVertexInfo.bindVertex(this.re);
                    }
                    if (needSetDataPointers) {
                        this.setDataPointers(nVertex, this.context.useVertexColor, nColor, useTexture, nTexCoord, this.context.vinfo.normal != 0, 0, cachedVertexInfo == null);
                    }
                    this.drawArraysStatistics.start();
                    this.re.drawArrays(7, 0, numberOfVertex * 2);
                    this.drawArraysStatistics.end();
                    this.context.cullFaceFlag.updateEnabled();
                }
            }
        }
        this.vertexStatistics.end();
        if (State.captureGeNextFrame) {
            if (!this.isVertexBufferEmbedded()) {
                log.info((Object)"Capture PRIM");
                CaptureManager.captureRAM(this.context.vinfo.ptr_vertex, this.context.vinfo.vertexSize * numberOfVertex);
            }
            this.display.captureGeImage();
            this.textureChanged = true;
        }
        if (this.export3D) {
            this.exportCommandPRIM(numberOfVertex, type);
        }
        this.endRendering(numberOfVertex);
    }

    private void exportCommandPRIM(int numberOfVertex, int type) {
        if (this.context.vinfo.transform2D) {
            return;
        }
        if (type != 3 && type != 4) {
            return;
        }
        this.exporter.startPrimitive(numberOfVertex, type);
        Memory mem = Memory.getInstance();
        float[] position = new float[4];
        float[] modelViewMatrix = new float[16];
        float[] vertexPosition = new float[4];
        float[] normalizedN = new float[3];
        VertexState transformedV = new VertexState();
        Utilities.matrixMult(modelViewMatrix, this.context.view_uploaded_matrix, this.context.model_uploaded_matrix);
        for (int i = 0; i < numberOfVertex; ++i) {
            int addr = this.context.vinfo.getAddress(mem, i);
            this.context.vinfo.readVertex(mem, addr, this.v, true);
            if (this.context.vinfo.weight != 0 && this.context.vinfo.position != 0) {
                VideoEngine.doSkinning(this.context.bone_uploaded_matrix, this.context.vinfo, this.v);
            }
            vertexPosition[0] = this.v.p[0];
            vertexPosition[1] = this.v.p[1];
            vertexPosition[2] = this.v.p[2];
            vertexPosition[3] = 1.0f;
            Utilities.vectorMult44(position, modelViewMatrix, vertexPosition);
            float invertedW = 1.0f / position[3];
            transformedV.p[0] = position[0] * invertedW;
            transformedV.p[1] = position[1] * invertedW;
            transformedV.p[2] = position[2] * invertedW;
            transformedV.c[0] = this.v.c[0];
            transformedV.c[1] = this.v.c[1];
            transformedV.c[2] = this.v.c[2];
            transformedV.n[0] = this.v.n[0];
            transformedV.n[1] = this.v.n[1];
            transformedV.n[2] = this.v.n[2];
            transformedV.t[0] = this.v.t[0];
            transformedV.t[1] = this.v.t[1];
            switch (this.context.tex_map_mode) {
                case 0: {
                    transformedV.t[0] = this.v.t[0] * this.context.tex_scale_x + this.context.tex_translate_x;
                    transformedV.t[1] = this.v.t[1] * this.context.tex_scale_y + this.context.tex_translate_y;
                    break;
                }
                case 1: {
                    float x = this.v.t[0];
                    float y = this.v.t[1];
                    float z = 0.0f;
                    switch (this.context.tex_proj_map_mode) {
                        case 0: {
                            x = this.v.p[0];
                            y = this.v.p[1];
                            z = this.v.p[2];
                            break;
                        }
                        case 1: {
                            x = this.v.t[0];
                            y = this.v.t[1];
                            z = 0.0f;
                            break;
                        }
                        case 2: {
                            Utilities.normalize3(normalizedN, this.v.n);
                            x = normalizedN[0];
                            y = normalizedN[1];
                            z = normalizedN[2];
                            break;
                        }
                        case 3: {
                            x = this.v.n[0];
                            y = this.v.n[1];
                            z = this.v.n[2];
                        }
                    }
                    transformedV.t[0] = x * this.context.texture_uploaded_matrix[0] + y * this.context.texture_uploaded_matrix[4] + z * this.context.texture_uploaded_matrix[8] + this.context.texture_uploaded_matrix[12];
                    transformedV.t[1] = x * this.context.texture_uploaded_matrix[1] + y * this.context.texture_uploaded_matrix[5] + z * this.context.texture_uploaded_matrix[9] + this.context.texture_uploaded_matrix[13];
                    break;
                }
            }
            transformedV.t[1] = 1.0f - transformedV.t[1];
            this.exporter.exportVertex(this.v, transformedV);
        }
        this.exporter.endVertex(numberOfVertex, type);
        String textureFileName = null;
        if (this.context.textureFlag.isEnabled()) {
            boolean level = false;
            int textureAddr = this.context.texture_base_pointer[0];
            int textureWidth = this.context.texture_width[0];
            int textureHeight = this.context.texture_height[0];
            int textureBufferWidth = this.context.texture_buffer_width[0];
            IMemoryReader imageReader = ImageReader.getImageReader(textureAddr, textureWidth, textureHeight, textureBufferWidth, this.context.texture_storage, this.context.texture_swizzle, this.context.tex_clut_addr, this.context.tex_clut_mode, this.context.tex_clut_num_blocks, this.context.tex_clut_start, this.context.tex_clut_shift, this.context.tex_clut_mask, this.clut_buffer32, this.clut_buffer16);
            CaptureImage captureImage = new CaptureImage(textureAddr, 0, imageReader, textureWidth, textureHeight, textureBufferWidth, false, true, null);
            captureImage.setDirectory(this.export3DDirectory);
            captureImage.setFileFormat("png");
            if (IRenderingEngine.isTextureTypeIndexed[this.context.texture_storage]) {
                String fileNameSuffix = String.format("_%08X", this.context.tex_clut_addr);
                captureImage.setFileNameSuffix(fileNameSuffix);
            }
            try {
                if (!captureImage.fileExists()) {
                    captureImage.write();
                }
                textureFileName = captureImage.getFileName();
            }
            catch (IOException e) {
                log.error((Object)"Export Texture", (Throwable)e);
            }
        }
        this.exporter.exportTexture(textureFileName);
        this.exporter.endPrimitive(numberOfVertex, type);
    }

    private void executeCommandTRXKICK() {
        this.context.textureTx_pixelSize = this.normalArgument & 1;
        this.context.textureTx_sourceAddress &= 0x3FFFFFFF;
        this.context.textureTx_destinationAddress &= 0x3FFFFFFF;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s from 0x%08X(%d,%d) to 0x%08X(%d,%d), width=%d, height=%d, pixelSize=%d", helper.getCommandString(234), this.context.textureTx_sourceAddress, this.context.textureTx_sx, this.context.textureTx_sy, this.context.textureTx_destinationAddress, this.context.textureTx_dx, this.context.textureTx_dy, this.context.textureTx_width, this.context.textureTx_height, this.context.textureTx_pixelSize));
        }
        if (!Memory.isAddressGood(this.context.textureTx_sourceAddress)) {
            this.error(String.format("%s invalid source address 0x%08X", helper.getCommandString(234), this.context.textureTx_sourceAddress));
            return;
        }
        if (!Memory.isAddressGood(this.context.textureTx_destinationAddress)) {
            this.error(String.format("%s invalid destination address 0x%08X", helper.getCommandString(234), this.context.textureTx_destinationAddress));
            return;
        }
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeCmd(234);
        }
        this.updateGeBuf();
        int pixelFormatGe = this.context.psm;
        int bpp = this.context.textureTx_pixelSize == 0 ? 2 : 4;
        int bppGe = sceDisplay.getPixelFormatBytes(pixelFormatGe);
        this.memoryForGEUpdated();
        if (!this.display.isGeAddress(this.context.textureTx_destinationAddress) || bpp != bppGe || this.display.isUsingSoftwareRenderer()) {
            if (this.isLogDebugEnabled) {
                if (bpp != bppGe) {
                    VideoEngine.log(helper.getCommandString(234) + " BPP not compatible with GE");
                } else {
                    VideoEngine.log(helper.getCommandString(234) + " not in Ge Address space");
                }
            }
            this.usingTRXKICK = true;
            if (this.canCacheTexture(this.context.textureTx_destinationAddress)) {
                TextureCache textureCache = TextureCache.getInstance();
                textureCache.resetTextureAlreadyHashed(this.context.textureTx_destinationAddress, this.context.tex_clut_addr);
                textureCache.resetTextureAlreadyHashed(this.context.textureTx_destinationAddress, 0);
            }
            if (this.context.textureTx_destinationAddress == (this.context.texture_base_pointer[0] & 0x3FFFFFFF)) {
                this.textureChanged = true;
            }
            int width = this.context.textureTx_width;
            int height = this.context.textureTx_height;
            int srcAddress = this.context.textureTx_sourceAddress + (this.context.textureTx_sy * this.context.textureTx_sourceLineWidth + this.context.textureTx_sx) * bpp;
            int dstAddress = this.context.textureTx_destinationAddress + (this.context.textureTx_dy * this.context.textureTx_destinationLineWidth + this.context.textureTx_dx) * bpp;
            Memory memory = Memory.getInstance();
            if (this.context.textureTx_sourceLineWidth == width && this.context.textureTx_destinationLineWidth == width) {
                int copyLength = height * width * bpp;
                if (this.isLogDebugEnabled) {
                    VideoEngine.log(String.format("%s memcpy(0x%08X-0x%08X, 0x%08X, 0x%X)", helper.getCommandString(234), dstAddress, dstAddress + copyLength, srcAddress, copyLength));
                }
                memory.memcpy(dstAddress, srcAddress, copyLength);
            } else {
                int copyLength = width * bpp;
                int srcLineLength = this.context.textureTx_sourceLineWidth * bpp;
                int dstLineLength = this.context.textureTx_destinationLineWidth * bpp;
                for (int y = 0; y < height; ++y) {
                    if (this.isLogDebugEnabled) {
                        VideoEngine.log(String.format("%s memcpy(0x%08X-0x%08X, 0x%08X, 0x%X)", helper.getCommandString(234), dstAddress, dstAddress + copyLength, srcAddress, copyLength));
                    }
                    memory.memcpy(dstAddress, srcAddress, copyLength);
                    srcAddress += srcLineLength;
                    dstAddress += dstLineLength;
                }
            }
            if (State.captureGeNextFrame) {
                log.warn((Object)"TRXKICK outside of Ge Address space not supported in capture yet");
            }
        } else if (!this.skipThisFrame) {
            int width = this.context.textureTx_width;
            int height = this.context.textureTx_height;
            int dx = this.context.textureTx_dx;
            int dy = this.context.textureTx_dy;
            int lineWidth = this.context.textureTx_sourceLineWidth;
            int geAddr = this.display.getTopAddrGe();
            dy += (this.context.textureTx_destinationAddress - geAddr) / (this.display.getBufferWidthGe() * bpp);
            dx += (this.context.textureTx_destinationAddress - geAddr) % (this.display.getBufferWidthGe() * bpp) / bpp;
            if (this.isLogDebugEnabled) {
                VideoEngine.log(helper.getCommandString(234) + " in Ge Address space: dx=" + dx + ", dy=" + dy + ", width=" + width + ", height=" + height + ", lineWidth=" + lineWidth + ", bpp=" + bpp);
            }
            if (this.re.isVertexArrayAvailable()) {
                this.re.bindVertexArray(0);
            }
            int bufferHeight = Utilities.makePow2(height);
            int textureSize = lineWidth * bufferHeight * bpp;
            Buffer buffer = Memory.getInstance().getBuffer(this.context.textureTx_sourceAddress, textureSize);
            if (State.captureGeNextFrame) {
                log.info((Object)"Capture TRXKICK");
                CaptureManager.captureRAM(this.context.textureTx_sourceAddress, lineWidth * height * bpp);
            }
            int texture = this.re.genTexture();
            this.re.bindTexture(texture);
            this.re.setTextureFormat(pixelFormatGe, false);
            this.re.setTexImage(0, pixelFormatGe, lineWidth, bufferHeight, pixelFormatGe, pixelFormatGe, 0, null);
            this.re.setTextureMipmapMinFilter(0);
            this.re.setTextureMipmapMagFilter(0);
            this.re.setTextureMipmapMinLevel(0);
            this.re.setTextureMipmapMaxLevel(0);
            this.re.setTextureWrapMode(1, 1);
            this.re.setPixelStore(lineWidth, bpp);
            this.re.setTexSubImage(0, this.context.textureTx_sx, this.context.textureTx_sy, width, height, pixelFormatGe, pixelFormatGe, textureSize, buffer);
            this.re.startDirectRendering(true, false, true, true, false, 480, 272);
            this.re.setTextureFormat(pixelFormatGe, false);
            float texCoordX = (float)width / (float)lineWidth;
            float texCoordY = (float)height / (float)bufferHeight;
            IREBufferManager bufferManager = this.re.getBufferManager();
            ByteBuffer drawByteBuffer = bufferManager.getBuffer(this.bufferId);
            drawByteBuffer.clear();
            FloatBuffer drawFloatBuffer = drawByteBuffer.asFloatBuffer();
            drawFloatBuffer.clear();
            drawFloatBuffer.put(texCoordX);
            drawFloatBuffer.put(texCoordY);
            drawFloatBuffer.put(width);
            drawFloatBuffer.put(height);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(texCoordY);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(height);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(texCoordX);
            drawFloatBuffer.put(0.0f);
            drawFloatBuffer.put(width);
            drawFloatBuffer.put(0.0f);
            this.re.setVertexInfo(null, false, false, true, 7);
            this.re.enableClientState(0);
            this.re.disableClientState(1);
            this.re.disableClientState(2);
            this.re.enableClientState(3);
            bufferManager.setTexCoordPointer(this.bufferId, 2, 6, 4 * SIZEOF_FLOAT, 0);
            bufferManager.setVertexPointer(this.bufferId, 2, 6, 4 * SIZEOF_FLOAT, 2 * SIZEOF_FLOAT);
            bufferManager.setBufferData(this.bufferId, drawFloatBuffer.position() * SIZEOF_FLOAT, drawByteBuffer.rewind(), 0);
            this.re.drawArrays(7, 0, 4);
            this.re.endDirectRendering();
            this.re.deleteTexture(texture);
            this.somethingDisplayed = true;
        }
    }

    private void executeCommandBBOX() {
        Memory mem = Memory.getInstance();
        int numberOfVertexBoundingBox = this.normalArgument & 0xFF;
        if (this.context.vinfo.ptr_vertex == 0) {
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("%s null vertex address", helper.getCommandString(7)));
            }
            return;
        }
        if (!Memory.isAddressGood(this.context.vinfo.ptr_vertex)) {
            this.error(String.format("%s Invalid vertex address 0x%08X", helper.getCommandString(7), this.context.vinfo.ptr_vertex));
            return;
        }
        if (this.context.vinfo.position == 0) {
            log.warn((Object)(helper.getCommandString(7) + " no positions for vertex!"));
            return;
        }
        if (!this.re.hasBoundingBox()) {
            if (!this.bboxWarningDisplayed) {
                log.warn((Object)("Not supported by your OpenGL version (but can be ignored): " + helper.getCommandString(7) + " numberOfVertex=" + numberOfVertexBoundingBox));
                this.bboxWarningDisplayed = true;
            }
            return;
        }
        if (numberOfVertexBoundingBox % 8 != 0) {
            log.warn((Object)(helper.getCommandString(7) + " unsupported numberOfVertex=" + numberOfVertexBoundingBox));
        } else if (this.isLogDebugEnabled) {
            log.debug((Object)(helper.getCommandString(7) + " numberOfVertex=" + numberOfVertexBoundingBox));
        }
        if (this.skipThisFrame) {
            return;
        }
        this.isBoundingBox = true;
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeCmd(7);
        }
        this.initRendering();
        this.re.beginBoundingBox(numberOfVertexBoundingBox);
        for (int i = 0; i < numberOfVertexBoundingBox; ++i) {
            int addr = this.context.vinfo.getAddress(mem, i);
            this.context.vinfo.readVertex(mem, addr, this.v, false);
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("%s (%f,%f,%f)", helper.getCommandString(7), Float.valueOf(this.v.p[0]), Float.valueOf(this.v.p[1]), Float.valueOf(this.v.p[2])));
            }
            int vertexIndex = i % 8;
            this.bboxVertices[vertexIndex][0] = this.v.p[0];
            this.bboxVertices[vertexIndex][1] = this.v.p[1];
            this.bboxVertices[vertexIndex][2] = this.v.p[2];
            if (vertexIndex != 7) continue;
            this.re.drawBoundingBox(this.bboxVertices);
        }
        this.re.endBoundingBox(this.context.vinfo);
        this.endRendering(numberOfVertexBoundingBox);
        this.isBoundingBox = false;
    }

    private void executeCommandBJUMP() {
        boolean takeConditionalJump = false;
        if (this.skipThisFrame) {
            takeConditionalJump = true;
        } else if (this.export3D && !this.export3DOnlyVisible) {
            takeConditionalJump = false;
        } else if (this.re.hasBoundingBox()) {
            boolean bl = takeConditionalJump = !this.re.isBoundingBoxVisible();
        }
        if (takeConditionalJump) {
            int oldPc = this.currentList.getPc();
            this.currentList.jumpRelativeOffset(this.normalArgument);
            int newPc = this.currentList.getPc();
            if (this.isLogDebugEnabled) {
                VideoEngine.log(String.format("%s old PC: 0x%08X, new PC: 0x%08X", helper.getCommandString(9), oldPc, newPc));
            }
        } else if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s not taking Conditional Jump", helper.getCommandString(9)));
        }
    }

    private void executeCommandBONE() {
        int matrixIndex = this.boneMatrixIndex / 12;
        int elementIndex = this.boneMatrixIndex % 12;
        if (matrixIndex >= 8) {
            if (this.isLogDebugEnabled) {
                VideoEngine.log("Ignoring BONE matrix element: boneMatrixIndex=" + this.boneMatrixIndex);
            }
        } else {
            float floatArgument;
            this.context.bone_uploaded_matrix[matrixIndex][elementIndex] = floatArgument = VideoEngine.floatArgument(this.normalArgument);
            this.context.boneMatrixLinear[this.boneMatrixIndex / 3 * 4 + this.boneMatrixIndex % 3] = floatArgument;
            if (matrixIndex >= this.boneMatrixLinearUpdatedMatrix) {
                this.boneMatrixLinearUpdatedMatrix = matrixIndex + 1;
            }
            ++this.boneMatrixIndex;
            if (this.isLogDebugEnabled && this.boneMatrixIndex % 12 == 0) {
                for (int x = 0; x < 3; ++x) {
                    log.debug((Object)String.format("bone matrix %d %.2f %.2f %.2f %.2f", matrixIndex, Float.valueOf(this.context.bone_uploaded_matrix[matrixIndex][x + 0]), Float.valueOf(this.context.bone_uploaded_matrix[matrixIndex][x + 3]), Float.valueOf(this.context.bone_uploaded_matrix[matrixIndex][x + 6]), Float.valueOf(this.context.bone_uploaded_matrix[matrixIndex][x + 9])));
                }
            }
        }
    }

    private void executeCommandNOP() {
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(0));
        }
        this.checkCurrentListPc();
    }

    private void executeCommandVADDR() {
        this.context.vinfo.ptr_vertex = this.currentList.getAddressRelOffset(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(1) + " " + String.format("%08x", this.context.vinfo.ptr_vertex));
        }
    }

    private void executeCommandIADDR() {
        this.context.vinfo.ptr_index = this.currentList.getAddressRelOffset(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(2) + " " + String.format("%08x", this.context.vinfo.ptr_index));
        }
    }

    private void executeCommandBEZIER() {
        int ucount = this.normalArgument & 0xFF;
        int vcount = this.normalArgument >> 8 & 0xFF;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(5) + " ucount=" + ucount + ", vcount=" + vcount);
        }
        if (this.skipThisFrame) {
            this.endRendering(ucount * vcount);
            return;
        }
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeCmd(5);
        }
        this.updateGeBuf();
        this.somethingDisplayed = true;
        this.loadTexture();
        this.drawBezier(ucount, vcount);
    }

    private void executeCommandSPLINE() {
        int sp_ucount = this.normalArgument & 0xFF;
        int sp_vcount = this.normalArgument >> 8 & 0xFF;
        int sp_utype = this.normalArgument >> 16 & 3;
        int sp_vtype = this.normalArgument >> 18 & 3;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(6) + " sp_ucount=" + sp_ucount + ", sp_vcount=" + sp_vcount + " sp_utype=" + sp_utype + ", sp_vtype=" + sp_vtype);
        }
        if (this.skipThisFrame) {
            this.endRendering(sp_ucount * sp_vcount);
            return;
        }
        this.updateGeBuf();
        this.somethingDisplayed = true;
        if (this.isGeProfilerEnabled) {
            GEProfiler.startGeCmd(6);
        }
        this.loadTexture();
        this.drawSpline(sp_ucount, sp_vcount, sp_utype, sp_vtype);
    }

    private void executeCommandJUMP() {
        int oldPc = this.currentList.getPc();
        this.currentList.jumpRelativeOffset(this.normalArgument);
        int newPc = this.currentList.getPc();
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s old PC: 0x%08X, new PC: 0x%08X", helper.getCommandString(8), oldPc, newPc));
        }
    }

    private void executeCommandCALL() {
        int oldPc = this.currentList.getPc();
        this.currentList.callRelativeOffset(this.normalArgument);
        int newPc = this.currentList.getPc();
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s old PC: 0x%08X, new PC: 0x%08X", helper.getCommandString(10), oldPc, newPc));
        }
    }

    private void executeCommandRET() {
        int oldPc = this.currentList.getPc();
        this.currentList.ret();
        int newPc = this.currentList.getPc();
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s old PC: 0x%08X, new PC: 0x%08X", helper.getCommandString(11), oldPc, newPc));
        }
    }

    private void executeCommandEND() {
        this.currentList.endList();
        this.currentList.pauseList();
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(12) + " pc=0x" + Integer.toHexString(this.currentList.getPc()));
        }
        this.updateGeBuf();
    }

    private void executeCommandSIGNAL() {
        int behavior = this.normalArgument >> 16 & 0xFF;
        int signal = this.normalArgument & 0xFFFF;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s (behavior=%d, signal=0x%X)", helper.getCommandString(14), behavior, signal));
        }
        switch (behavior) {
            case 8: {
                Memory mem = Memory.getInstance();
                if (VideoEngine.command(mem.read32(this.currentList.getPc())) == 12) {
                    this.currentList.readNextInstruction();
                    if (VideoEngine.command(mem.read32(this.currentList.getPc())) == 15) {
                        this.currentList.readNextInstruction();
                        if (VideoEngine.command(mem.read32(this.currentList.getPc())) == 12) {
                            this.currentList.readNextInstruction();
                        }
                    }
                }
                if (!this.isLogDebugEnabled) break;
                VideoEngine.log(String.format("PSP_GE_SIGNAL_SYNC ignored PC: 0x%08X", this.currentList.getPc()));
                break;
            }
            case 17: {
                Memory mem = Memory.getInstance();
                if (VideoEngine.command(mem.read32(this.currentList.getPc())) != 12) break;
                int hi16 = signal & 0xFFF;
                int lo16 = this.currentList.readNextInstruction() & 0xFFFF;
                int addr = hi16 << 16 | lo16;
                int oldPc = this.currentList.getPc();
                this.currentList.callAbsolute(addr);
                int newPc = this.currentList.getPc();
                if (!this.isLogDebugEnabled) break;
                VideoEngine.log(String.format("PSP_GE_SIGNAL_CALL old PC: 0x%08X, new PC: 0x%08X", oldPc, newPc));
                break;
            }
            case 18: {
                Memory mem = Memory.getInstance();
                if (VideoEngine.command(mem.read32(this.currentList.getPc())) != 12) break;
                this.currentList.readNextInstruction();
                int oldPc = this.currentList.getPc();
                this.currentList.ret();
                int newPc = this.currentList.getPc();
                if (!this.isLogDebugEnabled) break;
                VideoEngine.log(String.format("PSP_GE_SIGNAL_RETURN old PC: 0x%08X, new PC: 0x%08X", oldPc, newPc));
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                int addr;
                Memory mem = Memory.getInstance();
                if (VideoEngine.command(mem.read32(this.currentList.getPc())) != 12) break;
                int hi16 = signal & 0xFFFF;
                int ins = this.currentList.readNextInstruction();
                int lo16 = ins & 0xFFFF;
                int width = ins >> 16 & 0xFF;
                this.context.texture_base_pointer[behavior - 32] = addr = this.currentList.getAddressRel(hi16 << 16 | lo16);
                this.context.texture_buffer_width[behavior - 32] = width;
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                int addr;
                Memory mem = Memory.getInstance();
                if (VideoEngine.command(mem.read32(this.currentList.getPc())) != 12) break;
                int hi16 = signal & 0xFFFF;
                int ins = this.currentList.readNextInstruction();
                int lo16 = ins & 0xFFFF;
                int width = ins >> 16 & 0xFF;
                this.context.texture_base_pointer[behavior - 40] = addr = this.currentList.getAddressRelOffset(hi16 << 16 | lo16);
                this.context.texture_buffer_width[behavior - 47] = width;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.currentList.clearRestart();
                this.currentList.pushSignalCallback(this.currentList.id, behavior, signal);
                break;
            }
            default: {
                if (!this.isLogWarnEnabled) break;
                log.warn((Object)String.format("%s (behavior=%d, signal=0x%X) unknown behavior at 0x%08X", helper.getCommandString(14), behavior, signal, this.currentList.getPc() - 4));
            }
        }
    }

    private void executeCommandFINISH() {
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(15) + " " + this.getArgumentLog(this.normalArgument));
        }
        this.currentList.clearRestart();
        this.currentList.finishList();
        this.currentList.pushFinishCallback(this.currentList.id, this.normalArgument);
    }

    private void executeCommandBASE() {
        this.context.base = this.normalArgument << 8 & 0xFF000000;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(16) + " " + String.format("%08x", this.context.base));
        }
    }

    private void executeCommandVTYPE() {
        boolean vertex_hasColor;
        int old_transform_mode = this.context.transform_mode;
        boolean old_vertex_hasColor = this.context.vinfo.color != 0;
        this.context.vinfo.processType(this.normalArgument);
        this.context.transform_mode = this.normalArgument >> 23 & 1;
        boolean bl = vertex_hasColor = this.context.vinfo.color != 0;
        if (old_transform_mode != this.context.transform_mode) {
            this.projectionMatrixUpload.setChanged(true);
            this.modelMatrixUpload.setChanged(true);
            this.viewMatrixUpload.setChanged(true);
            this.textureMatrixUpload.setChanged(true);
            this.viewportChanged = true;
            this.depthChanged = true;
            this.materialChanged = true;
            if (this.context.transform_mode == 0) {
                this.lightingChanged = true;
            }
        } else if (old_vertex_hasColor != vertex_hasColor) {
            this.materialChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(18) + " " + this.context.vinfo.toString());
        }
    }

    private void executeCommandOFFSET_ADDR() {
        this.context.baseOffset = this.normalArgument << 8;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s 0x%08X", helper.getCommandString(19), this.context.baseOffset));
        }
    }

    private void executeCommandORIGIN_ADDR() {
        this.context.baseOffset = this.currentList.getPc() - 4;
        if (this.normalArgument != 0) {
            log.warn((Object)String.format("%s unknown argument 0x%08X", helper.getCommandString(20), this.normalArgument));
        } else if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s 0x%08X originAddr=0x%08X", helper.getCommandString(20), this.normalArgument, this.context.baseOffset));
        }
    }

    private void executeCommandREGION1() {
        int old_region_x1 = this.context.region_x1;
        int old_region_y1 = this.context.region_y1;
        this.context.region_x1 = this.normalArgument & 0x3FF;
        this.context.region_y1 = this.normalArgument >> 10 & 0x3FF;
        if (old_region_x1 != this.context.region_x1 || old_region_y1 != this.context.region_y1) {
            this.scissorChanged = true;
        }
    }

    private void executeCommandREGION2() {
        int old_region_x2 = this.context.region_x2;
        int old_region_y2 = this.context.region_y2;
        this.context.region_x2 = this.normalArgument & 0x3FF;
        this.context.region_y2 = this.normalArgument >> 10 & 0x3FF;
        this.context.region_width = this.context.region_x2 + 1 - this.context.region_x1;
        this.context.region_height = this.context.region_y2 + 1 - this.context.region_y1;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("drawRegion(" + this.context.region_x1 + "," + this.context.region_y1 + "," + this.context.region_width + "," + this.context.region_height + ")");
        }
        if (old_region_x2 != this.context.region_x2 || old_region_y2 != this.context.region_y2) {
            this.scissorChanged = true;
        }
    }

    private void executeCommandLTE() {
        this.context.lightingFlag.setEnabled(this.normalArgument);
        if (this.context.lightingFlag.isEnabled()) {
            this.lightingChanged = true;
            this.materialChanged = true;
        }
    }

    private void executeCommandLTEn() {
        int lnum = this.command - 24;
        GeContext.EnableDisableFlag lightFlag = this.context.lightFlags[lnum];
        lightFlag.setEnabled(this.normalArgument);
        if (lightFlag.isEnabled()) {
            this.lightingChanged = true;
        }
    }

    private void executeCommandCPE() {
        this.context.clipPlanesFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandBCE() {
        this.context.cullFaceFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandTME() {
        this.context.textureFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandFGE() {
        this.context.fogFlag.setEnabled(this.normalArgument);
        if (this.context.fogFlag.isEnabled()) {
            this.re.setFogHint();
        }
    }

    private void executeCommandDTE() {
        this.context.ditherFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandABE() {
        this.context.blendFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandATE() {
        this.context.alphaTestFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandZTE() {
        this.context.depthTestFlag.setEnabled(this.normalArgument);
        if (this.context.depthTestFlag.isEnabled()) {
            this.depthChanged = true;
        }
    }

    private void executeCommandSTE() {
        this.context.stencilTestFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandAAE() {
        this.context.lineSmoothFlag.setEnabled(this.normalArgument);
        if (this.context.lineSmoothFlag.isEnabled()) {
            this.re.setLineSmoothHint();
        }
    }

    private void executeCommandPCE() {
        this.context.patchCullFaceFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandCTE() {
        this.context.colorTestFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandLOE() {
        this.context.colorLogicOpFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandBOFS() {
        this.boneMatrixIndex = this.normalArgument;
        if (this.isLogDebugEnabled) {
            this.log("bone matrix offset", this.normalArgument);
        }
    }

    private void executeCommandMWn() {
        float floatArgument;
        int index = this.command - 44;
        this.context.morph_weight[index] = floatArgument = VideoEngine.floatArgument(this.normalArgument);
        this.re.setMorphWeight(index, floatArgument);
        if (this.isLogDebugEnabled) {
            this.log("morph weight " + index, floatArgument);
        }
    }

    private void executeCommandPSUB() {
        this.context.patch_div_s = this.normalArgument & 0xFF;
        this.context.patch_div_t = this.normalArgument >> 8 & 0xFF;
        this.re.setPatchDiv(this.context.patch_div_s, this.context.patch_div_t);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(54) + " patch_div_s=" + this.context.patch_div_s + ", patch_div_t=" + this.context.patch_div_t);
        }
    }

    private void executeCommandPPRIM() {
        this.context.patch_prim = this.normalArgument & 3;
        this.re.setPatchPrim(this.context.patch_prim);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(55) + " patch_prim=" + this.context.patch_prim);
        }
    }

    private void executeCommandPFACE() {
        this.context.patchFaceFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandMMS() {
        this.modelMatrixUpload.startUpload(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGumMatrixMode GU_MODEL " + this.normalArgument);
        }
    }

    private void executeCommandMODEL() {
        if (this.modelMatrixUpload.uploadValue(VideoEngine.floatArgument(this.normalArgument))) {
            this.log("glLoadMatrixf", this.context.model_uploaded_matrix);
        }
    }

    private void executeCommandVMS() {
        this.viewMatrixUpload.startUpload(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGumMatrixMode GU_VIEW " + this.normalArgument);
        }
    }

    private void executeCommandVIEW() {
        if (this.viewMatrixUpload.uploadValue(VideoEngine.floatArgument(this.normalArgument))) {
            this.log("glLoadMatrixf", this.context.view_uploaded_matrix);
        }
    }

    private void executeCommandPMS() {
        this.projectionMatrixUpload.startUpload(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGumMatrixMode GU_PROJECTION " + this.normalArgument);
        }
    }

    private void executeCommandPROJ() {
        if (this.projectionMatrixUpload.uploadValue(VideoEngine.floatArgument(this.normalArgument))) {
            this.log("glLoadMatrixf", this.context.proj_uploaded_matrix);
        }
    }

    private void executeCommandTMS() {
        this.textureMatrixUpload.startUpload(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGumMatrixMode GU_TEXTURE " + this.normalArgument);
        }
    }

    private void executeCommandTMATRIX() {
        if (this.textureMatrixUpload.uploadValue(VideoEngine.floatArgument(this.normalArgument))) {
            this.log("glLoadMatrixf", this.context.texture_uploaded_matrix);
        }
    }

    private void executeCommandXSCALE() {
        int old_viewport_width = this.context.viewport_width;
        this.context.viewport_width = (int)VideoEngine.floatArgument(this.normalArgument);
        if (old_viewport_width != this.context.viewport_width) {
            this.viewportChanged = true;
            if (old_viewport_width < 0 && this.context.viewport_width > 0 || old_viewport_width > 0 && this.context.viewport_width < 0) {
                this.projectionMatrixUpload.setChanged(true);
            }
        }
    }

    private void executeCommandYSCALE() {
        int old_viewport_height = this.context.viewport_height;
        this.context.viewport_height = (int)VideoEngine.floatArgument(this.normalArgument);
        if (old_viewport_height != this.context.viewport_height) {
            this.viewportChanged = true;
            if (old_viewport_height < 0 && this.context.viewport_height > 0 || old_viewport_height > 0 && this.context.viewport_height < 0) {
                this.projectionMatrixUpload.setChanged(true);
            }
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuViewport(cx=" + this.context.viewport_cx + ", cy=" + this.context.viewport_cy + ", w=" + this.context.viewport_width + ", h=" + this.context.viewport_height + ")"));
        }
    }

    private void executeCommandZSCALE() {
        float old_zscale = this.context.zscale;
        float floatArgument = VideoEngine.floatArgument(this.normalArgument);
        this.context.zscale = floatArgument / 65535.0f;
        if (old_zscale != this.context.zscale) {
            this.depthChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(68) + " " + floatArgument);
        }
    }

    private void executeCommandXPOS() {
        int old_viewport_cx = this.context.viewport_cx;
        this.context.viewport_cx = (int)VideoEngine.floatArgument(this.normalArgument);
        if (old_viewport_cx != this.context.viewport_cx) {
            this.viewportChanged = true;
        }
    }

    private void executeCommandYPOS() {
        int old_viewport_cy = this.context.viewport_cy;
        this.context.viewport_cy = (int)VideoEngine.floatArgument(this.normalArgument);
        if (old_viewport_cy != this.context.viewport_cy) {
            this.viewportChanged = true;
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuViewport(cx=" + this.context.viewport_cx + ", cy=" + this.context.viewport_cy + ", w=" + this.context.viewport_width + ", h=" + this.context.viewport_height + ")"));
        }
    }

    private void executeCommandZPOS() {
        float old_zpos = this.context.zpos;
        float floatArgument = VideoEngine.floatArgument(this.normalArgument);
        this.context.zpos = floatArgument / 65535.0f;
        if (old_zpos != this.context.zpos) {
            this.depthChanged = true;
        }
        if (this.isLogDebugEnabled) {
            this.log(helper.getCommandString(71), floatArgument);
        }
    }

    private void executeCommandUSCALE() {
        float old_tex_scale_x = this.context.tex_scale_x;
        this.context.tex_scale_x = VideoEngine.floatArgument(this.normalArgument);
        if (old_tex_scale_x != this.context.tex_scale_x) {
            this.textureMatrixUpload.setChanged(true);
        }
    }

    private void executeCommandVSCALE() {
        float old_tex_scale_y = this.context.tex_scale_y;
        this.context.tex_scale_y = VideoEngine.floatArgument(this.normalArgument);
        if (old_tex_scale_y != this.context.tex_scale_y) {
            this.textureMatrixUpload.setChanged(true);
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexScale(u=" + this.context.tex_scale_x + ", v=" + this.context.tex_scale_y + ")");
        }
    }

    private void executeCommandUOFFSET() {
        float old_tex_translate_x = this.context.tex_translate_x;
        this.context.tex_translate_x = VideoEngine.floatArgument(this.normalArgument);
        if (old_tex_translate_x != this.context.tex_translate_x) {
            this.textureMatrixUpload.setChanged(true);
        }
    }

    private void executeCommandVOFFSET() {
        float old_tex_translate_y = this.context.tex_translate_y;
        this.context.tex_translate_y = VideoEngine.floatArgument(this.normalArgument);
        if (old_tex_translate_y != this.context.tex_translate_y) {
            this.textureMatrixUpload.setChanged(true);
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexOffset(u=" + this.context.tex_translate_x + ", v=" + this.context.tex_translate_y + ")");
        }
    }

    private void executeCommandOFFSETX() {
        int old_offset_x = this.context.offset_x;
        this.context.offset_x = this.normalArgument >> 4;
        if (old_offset_x != this.context.offset_x) {
            this.viewportChanged = true;
        }
    }

    private void executeCommandOFFSETY() {
        int old_offset_y = this.context.offset_y;
        this.context.offset_y = this.normalArgument >> 4;
        if (old_offset_y != this.context.offset_y) {
            this.viewportChanged = true;
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuOffset(x=" + this.context.offset_x + ",y=" + this.context.offset_y + ")"));
        }
    }

    private void executeCommandSHADE() {
        this.context.shadeModel = this.normalArgument & 1;
        this.re.setShadeModel(this.context.shadeModel);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuShadeModel(" + (this.context.shadeModel != 0 ? "smooth" : "flat") + ")");
        }
    }

    private void executeCommandRNORM() {
        this.context.faceNormalReverseFlag.setEnabled(this.normalArgument);
    }

    private void executeCommandCMAT() {
        int old_mat_flags = this.context.mat_flags;
        this.context.mat_flags = this.normalArgument & 7;
        if (old_mat_flags != this.context.mat_flags) {
            this.materialChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuColorMaterial " + this.context.mat_flags);
        }
    }

    private void executeCommandEMC() {
        this.context.mat_emissive[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.mat_emissive[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.mat_emissive[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.mat_emissive[3] = 1.0f;
        this.materialChanged = true;
        this.re.setMaterialEmissiveColor(this.context.mat_emissive);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("material emission " + String.format("r=%.1f g=%.1f b=%.1f (%08X)", Float.valueOf(this.context.mat_emissive[0]), Float.valueOf(this.context.mat_emissive[1]), Float.valueOf(this.context.mat_emissive[2]), this.normalArgument));
        }
    }

    private void executeCommandAMC() {
        this.context.mat_ambient[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.mat_ambient[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.mat_ambient[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.materialChanged = true;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("material ambient r=%.1f g=%.1f b=%.1f (%08X)", Float.valueOf(this.context.mat_ambient[0]), Float.valueOf(this.context.mat_ambient[1]), Float.valueOf(this.context.mat_ambient[2]), this.normalArgument));
        }
    }

    private void executeCommandDMC() {
        this.context.mat_diffuse[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.mat_diffuse[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.mat_diffuse[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.mat_diffuse[3] = 1.0f;
        this.materialChanged = true;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("material diffuse " + String.format("r=%.1f g=%.1f b=%.1f (%08X)", Float.valueOf(this.context.mat_diffuse[0]), Float.valueOf(this.context.mat_diffuse[1]), Float.valueOf(this.context.mat_diffuse[2]), this.normalArgument));
        }
    }

    private void executeCommandSMC() {
        this.context.mat_specular[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.mat_specular[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.mat_specular[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.mat_specular[3] = 1.0f;
        this.materialChanged = true;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("material specular " + String.format("r=%.1f g=%.1f b=%.1f (%08X)", Float.valueOf(this.context.mat_specular[0]), Float.valueOf(this.context.mat_specular[1]), Float.valueOf(this.context.mat_specular[2]), this.normalArgument));
        }
    }

    private void executeCommandAMA() {
        this.context.mat_ambient[3] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.materialChanged = true;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("material ambient a=%.1f (%02X)", Float.valueOf(this.context.mat_ambient[3]), this.normalArgument & 0xFF));
        }
    }

    private void executeCommandSPOW() {
        this.context.materialShininess = VideoEngine.floatArgument(this.normalArgument);
        this.re.setMaterialShininess(this.context.materialShininess);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("material shininess " + this.context.materialShininess);
        }
    }

    private void executeCommandALC() {
        this.context.ambient_light[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.ambient_light[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.ambient_light[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.re.setLightModelAmbientColor(this.context.ambient_light);
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("ambient light r=%.1f g=%.1f b=%.1f (%06X)", Float.valueOf(this.context.ambient_light[0]), Float.valueOf(this.context.ambient_light[1]), Float.valueOf(this.context.ambient_light[2]), this.normalArgument));
        }
    }

    private void executeCommandALA() {
        this.context.ambient_light[3] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.re.setLightModelAmbientColor(this.context.ambient_light);
    }

    private void executeCommandLMODE() {
        this.context.lightMode = this.normalArgument & 1;
        this.re.setLightMode(this.context.lightMode);
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuLightMode(" + (this.context.lightMode != 0 ? "GU_SEPARATE_SPECULAR_COLOR" : "GU_SINGLE_COLOR") + ")"));
        }
        if ((this.normalArgument & 0xFFFFFFFE) != 0) {
            log.warn((Object)String.format("Unknown light mode sceGuLightMode(%06X)", this.normalArgument));
        }
    }

    private void executeCommandLTn() {
        int lnum = this.command - 95;
        int old_light_type = this.context.light_type[lnum];
        int old_light_kind = this.context.light_kind[lnum];
        this.context.light_type[lnum] = this.normalArgument >> 8 & 3;
        this.context.light_kind[lnum] = this.normalArgument & 3;
        if (old_light_type != this.context.light_type[lnum] || old_light_kind != this.context.light_kind[lnum]) {
            this.lightingChanged = true;
        }
        switch (this.context.light_type[lnum]) {
            case 0: {
                this.context.light_pos[lnum][3] = 0.0f;
                break;
            }
            case 1: {
                this.re.setLightSpotCutoff(lnum, 180.0f);
                this.context.light_pos[lnum][3] = 1.0f;
                break;
            }
            case 2: {
                this.context.light_pos[lnum][3] = 1.0f;
                break;
            }
            default: {
                this.error("Unknown light type : " + this.normalArgument);
            }
        }
        this.re.setLightType(lnum, this.context.light_type[lnum], this.context.light_kind[lnum]);
        if (this.isLogDebugEnabled) {
            log.debug((Object)("Light " + lnum + " type " + (this.normalArgument >> 8) + " kind " + (this.normalArgument & 3)));
        }
    }

    private void executeCommandLXPn() {
        int lnum = (this.command - 99) / 3;
        int component = (this.command - 99) % 3;
        float old_light_pos = this.context.light_pos[lnum][component];
        this.context.light_pos[lnum][component] = VideoEngine.floatArgument(this.normalArgument);
        if (old_light_pos != this.context.light_pos[lnum][component]) {
            this.lightingChanged = true;
            if (this.context.tex_map_mode == 2 && (this.context.tex_shade_u == lnum || this.context.tex_shade_v == lnum)) {
                this.textureMatrixUpload.setChanged(true);
            }
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("Light %d position (%f, %f, %f)", lnum, Float.valueOf(this.context.light_pos[lnum][0]), Float.valueOf(this.context.light_pos[lnum][1]), Float.valueOf(this.context.light_pos[lnum][2])));
        }
    }

    private void executeCommandLXDn() {
        int lnum = (this.command - 111) / 3;
        int component = (this.command - 111) % 3;
        float old_light_dir = this.context.light_dir[lnum][component];
        this.context.light_dir[lnum][component] = -VideoEngine.floatArgument(this.normalArgument);
        if (old_light_dir != this.context.light_dir[lnum][component]) {
            this.lightingChanged = true;
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("Light %d direction (%f, %f, %f)", lnum, Float.valueOf(this.context.light_dir[lnum][0]), Float.valueOf(this.context.light_dir[lnum][1]), Float.valueOf(this.context.light_dir[lnum][2])));
        }
    }

    private void executeCommandLCAn() {
        int lnum = (this.command - 123) / 3;
        this.context.lightConstantAttenuation[lnum] = VideoEngine.floatArgument(this.normalArgument);
        this.re.setLightConstantAttenuation(lnum, this.context.lightConstantAttenuation[lnum]);
    }

    private void executeCommandLLAn() {
        int lnum = (this.command - 124) / 3;
        this.context.lightLinearAttenuation[lnum] = VideoEngine.floatArgument(this.normalArgument);
        this.re.setLightLinearAttenuation(lnum, this.context.lightLinearAttenuation[lnum]);
    }

    private void executeCommandLQAn() {
        int lnum = (this.command - 125) / 3;
        this.context.lightQuadraticAttenuation[lnum] = VideoEngine.floatArgument(this.normalArgument);
        this.re.setLightQuadraticAttenuation(lnum, this.context.lightQuadraticAttenuation[lnum]);
    }

    private void executeCommandSLEn() {
        int lnum = this.command - 135;
        float old_spotLightExponent = this.context.spotLightExponent[lnum];
        this.context.spotLightExponent[lnum] = VideoEngine.floatArgument(this.normalArgument);
        if (old_spotLightExponent != this.context.spotLightExponent[lnum]) {
            this.lightingChanged = true;
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuLightSpot(" + lnum + ",X," + this.context.spotLightExponent[lnum] + ",X)"));
        }
    }

    private void executeCommandSLFn() {
        int lnum = this.command - 139;
        float old_spotLightCutoff = this.context.spotLightCutoff[lnum];
        float floatArgument = VideoEngine.floatArgument(this.normalArgument);
        float degreeCutoff = (float)Math.toDegrees(Math.acos(floatArgument));
        if (degreeCutoff >= 0.0f && degreeCutoff <= 90.0f || degreeCutoff == 180.0f) {
            this.context.spotLightCutoff[lnum] = degreeCutoff;
            this.context.spotLightCosCutoff[lnum] = floatArgument;
            if (old_spotLightCutoff != this.context.spotLightCutoff[lnum]) {
                this.lightingChanged = true;
            }
            if (this.isLogDebugEnabled) {
                log.debug((Object)("sceGuLightSpot(" + lnum + ",X,X," + floatArgument + "=" + degreeCutoff + ")"));
            }
        } else {
            log.warn((Object)("sceGuLightSpot(" + lnum + ",X,X," + floatArgument + ") invalid argument value"));
        }
    }

    private void executeCommandALCn() {
        int lnum = (this.command - 143) / 3;
        this.context.lightAmbientColor[lnum][0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.lightAmbientColor[lnum][1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.lightAmbientColor[lnum][2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.lightAmbientColor[lnum][3] = 1.0f;
        this.re.setLightAmbientColor(lnum, this.context.lightAmbientColor[lnum]);
        VideoEngine.log("sceGuLightColor (GU_LIGHT0, GU_AMBIENT)");
    }

    private void executeCommandDLCn() {
        int lnum = (this.command - 144) / 3;
        this.context.lightDiffuseColor[lnum][0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.lightDiffuseColor[lnum][1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.lightDiffuseColor[lnum][2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.lightDiffuseColor[lnum][3] = 1.0f;
        this.re.setLightDiffuseColor(lnum, this.context.lightDiffuseColor[lnum]);
        VideoEngine.log("sceGuLightColor (GU_LIGHT0, GU_DIFFUSE)");
    }

    private void executeCommandSLCn() {
        int lnum = (this.command - 145) / 3;
        float old_lightSpecularColor0 = this.context.lightSpecularColor[lnum][0];
        float old_lightSpecularColor1 = this.context.lightSpecularColor[lnum][1];
        float old_lightSpecularColor2 = this.context.lightSpecularColor[lnum][2];
        this.context.lightSpecularColor[lnum][0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.lightSpecularColor[lnum][1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.lightSpecularColor[lnum][2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.lightSpecularColor[lnum][3] = 1.0f;
        if (old_lightSpecularColor0 != this.context.lightSpecularColor[lnum][0] || old_lightSpecularColor1 != this.context.lightSpecularColor[lnum][1] || old_lightSpecularColor2 != this.context.lightSpecularColor[lnum][2]) {
            this.lightingChanged = true;
        }
        this.re.setLightSpecularColor(lnum, this.context.lightDiffuseColor[lnum]);
        VideoEngine.log("sceGuLightColor (GU_LIGHT0, GU_SPECULAR)");
    }

    private void executeCommandFFACE() {
        this.context.frontFaceCw = this.normalArgument != 0;
        this.re.setFrontFace(this.context.frontFaceCw);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(155) + " " + (this.normalArgument != 0 ? "clockwise" : "counter-clockwise"));
        }
    }

    private void executeCommandFBP() {
        this.context.fbp = this.context.fbp & 0xFF000000 | this.normalArgument;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s fbp=0x%08X, fbw=%d", helper.getCommandString(156), this.context.fbp, this.context.fbw));
        }
        this.geBufChanged = true;
    }

    private void executeCommandFBW() {
        this.context.fbp = this.context.fbp & 0xFFFFFF | this.normalArgument << 8 & 0xFF000000;
        this.context.fbw = this.normalArgument & 0xFFFF;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s fbp=0x%08X, fbw=%d", helper.getCommandString(157), this.context.fbp, this.context.fbw));
        }
        this.geBufChanged = true;
    }

    private void executeCommandZBP() {
        this.context.zbp = this.context.zbp & 0xFF000000 | this.normalArgument;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s zbp=0x%08X, zbw=%d", helper.getCommandString(158), this.context.zbp, this.context.zbw));
        }
    }

    private void executeCommandZBW() {
        this.context.zbp = this.context.zbp & 0xFFFFFF | this.normalArgument << 8 & 0xFF000000;
        this.context.zbw = this.normalArgument & 0xFFFF;
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s zbp=0x%08X, zbw=%d", helper.getCommandString(159), this.context.zbp, this.context.zbw));
        }
    }

    private void executeCommandTBPn() {
        int level = this.command - 160;
        int old_texture_base_pointer = this.context.texture_base_pointer[level];
        this.context.texture_base_pointer[level] = this.context.texture_base_pointer[level] & 0xFF000000 | this.normalArgument;
        if (old_texture_base_pointer != this.context.texture_base_pointer[level]) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuTexImage(level=%d, X, X, X, lo(pointer=0x%08X)", level, this.context.texture_base_pointer[level]));
        }
    }

    private void executeCommandTBWn() {
        int level = this.command - 168;
        int old_texture_base_pointer = this.context.texture_base_pointer[level];
        int old_texture_buffer_width = this.context.texture_buffer_width[level];
        this.context.texture_base_pointer[level] = this.context.texture_base_pointer[level] & 0xFFFFFF | this.normalArgument << 8 & 0xFF000000;
        this.context.texture_buffer_width[level] = this.normalArgument & 0xFFFF;
        if (old_texture_base_pointer != this.context.texture_base_pointer[level] || old_texture_buffer_width != this.context.texture_buffer_width[level]) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuTexImage(level=%d, X, X, texBufferWidth=%d, hi(pointer=0x%08X))", level, this.context.texture_buffer_width[level], this.context.texture_base_pointer[level]));
        }
    }

    private void executeCommandCBP() {
        int old_tex_clut_addr = this.context.tex_clut_addr;
        this.context.tex_clut_addr = this.context.tex_clut_addr & 0xFF000000 | this.normalArgument;
        this.clutIsDirty = true;
        if (old_tex_clut_addr != this.context.tex_clut_addr) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuClutLoad(X, lo(cbp=0x%08X)", this.context.tex_clut_addr));
        }
    }

    private void executeCommandCBPH() {
        int old_tex_clut_addr = this.context.tex_clut_addr;
        this.context.tex_clut_addr = this.context.tex_clut_addr & 0xFFFFFF | this.normalArgument << 8 & 0xF000000;
        this.clutIsDirty = true;
        if (old_tex_clut_addr != this.context.tex_clut_addr) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuClutLoad(X, hi(cbp=0x%08X)", this.context.tex_clut_addr));
        }
    }

    private void executeCommandTRXSBP() {
        this.context.textureTx_sourceAddress = this.context.textureTx_sourceAddress & 0xFF000000 | this.normalArgument;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s sourceAddress=0x%08X", helper.getCommandString(this.command), this.context.textureTx_sourceAddress));
        }
    }

    private void executeCommandTRXSBW() {
        this.context.textureTx_sourceAddress = this.context.textureTx_sourceAddress & 0xFFFFFF | this.normalArgument << 8 & 0xFF000000;
        this.context.textureTx_sourceLineWidth = this.normalArgument & 0xFFFF;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s sourceAddress=0x%08X, sourceLineWidth=%d", helper.getCommandString(this.command), this.context.textureTx_sourceAddress, this.context.textureTx_sourceLineWidth));
        }
        this.context.textureTx_sx = 0;
        this.context.textureTx_sy = 0;
    }

    private void executeCommandTRXDBP() {
        this.context.textureTx_destinationAddress = this.context.textureTx_destinationAddress & 0xFF000000 | this.normalArgument;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s destinationAddress=0x%08X", helper.getCommandString(this.command), this.context.textureTx_destinationAddress));
        }
    }

    private void executeCommandTRXDBW() {
        this.context.textureTx_destinationAddress = this.context.textureTx_destinationAddress & 0xFFFFFF | this.normalArgument << 8 & 0xFF000000;
        this.context.textureTx_destinationLineWidth = this.normalArgument & 0xFFFF;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s destinationAddress=0x%08X, destinationLineWidth=%d", helper.getCommandString(this.command), this.context.textureTx_destinationAddress, this.context.textureTx_destinationLineWidth));
        }
        this.context.textureTx_dx = 0;
        this.context.textureTx_dy = 0;
    }

    private void executeCommandTSIZEn() {
        int level = this.command - 184;
        int old_texture_height = this.context.texture_height[level];
        int old_texture_width = this.context.texture_width[level];
        int height_exp2 = Math.min(this.normalArgument >> 8 & 0xF, 9);
        int width_exp2 = Math.min(this.normalArgument & 0xF, 9);
        this.context.texture_height[level] = 1 << height_exp2;
        this.context.texture_width[level] = 1 << width_exp2;
        if (old_texture_height != this.context.texture_height[level] || old_texture_width != this.context.texture_width[level]) {
            if (this.context.transform_mode == 1 && level == 0) {
                this.textureMatrixUpload.setChanged(true);
            }
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuTexImage(level=%d, width=%d, height=%d, X, X)", level, this.context.texture_width[level], this.context.texture_height[level]));
        }
    }

    private void executeCommandTMAP() {
        int old_tex_map_mode = this.context.tex_map_mode;
        this.context.tex_map_mode = this.normalArgument & 3;
        this.context.tex_proj_map_mode = this.normalArgument >> 8 & 3;
        if (old_tex_map_mode != this.context.tex_map_mode) {
            this.textureMatrixUpload.setChanged(true);
        }
        if (this.context.tex_map_mode == 3) {
            if (this.isLogWarnEnabled) {
                log.warn((Object)String.format("sceGuTexMapMode unknown mode=%d, assuming TMAP_TEXTURE_MAP_MODE_TEXTURE_COORDIATES_UV", this.context.tex_map_mode));
            }
            this.context.tex_map_mode = 0;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexMapMode(mode=" + this.context.tex_map_mode + ", X, X)");
            VideoEngine.log("sceGuTexProjMapMode(mode=" + this.context.tex_proj_map_mode + ")");
        }
    }

    private void executeCommandTEXTURE_ENV_MAP_MATRIX() {
        this.context.tex_shade_u = this.normalArgument >> 0 & 3;
        this.context.tex_shade_v = this.normalArgument >> 8 & 3;
        this.textureMatrixUpload.setChanged(true);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexMapMode(X, " + this.context.tex_shade_u + ", " + this.context.tex_shade_v + ")");
        }
    }

    private void executeCommandTMODE() {
        int old_texture_num_mip_maps = this.context.texture_num_mip_maps;
        boolean old_mipmapShareClut = this.context.mipmapShareClut;
        boolean old_texture_swizzle = this.context.texture_swizzle;
        this.context.texture_num_mip_maps = this.normalArgument >> 16 & 7;
        this.context.mipmapShareClut = (this.normalArgument >> 8 & 1) == 0;
        boolean bl = this.context.texture_swizzle = (this.normalArgument & 1) != 0;
        if (old_texture_num_mip_maps != this.context.texture_num_mip_maps || old_mipmapShareClut != this.context.mipmapShareClut || old_texture_swizzle != this.context.texture_swizzle) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexMode(X, mipmaps=" + this.context.texture_num_mip_maps + ", mipmapShareClut=" + this.context.mipmapShareClut + ", swizzle=" + this.context.texture_swizzle + ")");
        }
    }

    private void executeCommandTPSM() {
        int old_texture_storage = this.context.texture_storage;
        this.context.texture_storage = this.normalArgument & 0xF;
        if (old_texture_storage != this.context.texture_storage) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexMode(tpsm=" + this.context.texture_storage + "(" + VideoEngine.getPsmName(this.context.texture_storage) + "), X, X, X)");
        }
    }

    private void executeCommandCLOAD() {
        int old_tex_clut_num_blocks = this.context.tex_clut_num_blocks;
        this.context.tex_clut_num_blocks = this.normalArgument & 0x3F;
        this.clutIsDirty = true;
        if (old_tex_clut_num_blocks != this.context.tex_clut_num_blocks) {
            this.textureChanged = true;
        }
        this.readClut();
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuClutLoad(num_blocks=" + this.context.tex_clut_num_blocks + ", X)");
        }
    }

    private void executeCommandCMODE() {
        int old_tex_clut_mode = this.context.tex_clut_mode;
        int old_tex_clut_shift = this.context.tex_clut_shift;
        int old_tex_clut_mask = this.context.tex_clut_mask;
        int old_tex_clut_start = this.context.tex_clut_start;
        this.context.tex_clut_mode = this.normalArgument & 3;
        this.context.tex_clut_shift = this.normalArgument >> 2 & 0x1F;
        this.context.tex_clut_mask = this.normalArgument >> 8 & 0xFF;
        this.context.tex_clut_start = this.normalArgument >> 16 & 0x1F;
        this.clutIsDirty = true;
        if (old_tex_clut_mode != this.context.tex_clut_mode || old_tex_clut_shift != this.context.tex_clut_shift || old_tex_clut_mask != this.context.tex_clut_mask || old_tex_clut_start != this.context.tex_clut_start) {
            this.textureChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuClutMode(cpsm=" + this.context.tex_clut_mode + "(" + VideoEngine.getPsmName(this.context.tex_clut_mode) + "), shift=" + this.context.tex_clut_shift + ", mask=0x" + Integer.toHexString(this.context.tex_clut_mask) + ", start=" + this.context.tex_clut_start + ")");
        }
    }

    private void executeCommandTFLT() {
        int old_tex_mag_filter = this.context.tex_mag_filter;
        int old_tex_min_filter = this.context.tex_min_filter;
        this.context.tex_min_filter = this.normalArgument & 7;
        this.context.tex_mag_filter = this.normalArgument >> 8 & 1;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuTexFilter(min=" + this.context.tex_min_filter + ", mag=" + this.context.tex_mag_filter + ") (mm#" + this.context.texture_num_mip_maps + ")");
        }
        if (this.context.tex_min_filter == 2 || this.context.tex_min_filter == 3) {
            log.warn((Object)("Unknown minimizing filter " + (this.normalArgument & 0xFF)));
            this.context.tex_min_filter = 0;
        }
        if (old_tex_mag_filter != this.context.tex_mag_filter || old_tex_min_filter != this.context.tex_min_filter) {
            this.textureChanged = true;
        }
    }

    private void executeCommandTWRAP() {
        this.context.tex_wrap_s = this.normalArgument & 1;
        this.context.tex_wrap_t = this.normalArgument >> 8 & 1;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("sceGuTexWrap(%d, %d)", this.context.tex_wrap_s, this.context.tex_wrap_t));
        }
    }

    private void executeCommandTBIAS() {
        this.context.tex_mipmap_mode = this.normalArgument & 3;
        byte biasValue = (byte)(this.normalArgument >> 16);
        this.context.tex_mipmap_bias_int = biasValue >> 4;
        this.context.tex_mipmap_bias = (float)biasValue / 16.0f;
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuTexLevelMode(mode=" + this.context.tex_mipmap_mode + ", bias=" + this.context.tex_mipmap_bias + ")"));
        }
    }

    private void executeCommandTEC() {
        this.context.tex_env_color[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.tex_env_color[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.tex_env_color[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.tex_env_color[3] = 1.0f;
        this.re.setTextureEnvColor(this.context.tex_env_color);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuTexEnvColor %06X (no alpha)", this.normalArgument));
        }
    }

    private void executeCommandTFLUSH() {
        if (this.isLogDebugEnabled) {
            VideoEngine.log("tflush (deferring to prim)");
        }
    }

    private void executeCommandTSYNC() {
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(204) + " wait for rendering completion.");
        }
        this.re.waitForRenderingCompletion();
    }

    private void executeCommandFFAR() {
        this.context.fog_far = VideoEngine.floatArgument(this.normalArgument);
    }

    private void executeCommandFDIST() {
        this.context.fog_dist = VideoEngine.floatArgument(this.normalArgument);
        if (this.context.fog_far != 0.0f && this.context.fog_dist != 0.0f) {
            float end = this.context.fog_far;
            float start = end - 1.0f / this.context.fog_dist;
            if (this.isLogDebugEnabled) {
                VideoEngine.log(String.format("sceGuFog(near=%f, far=%f, X)", Float.valueOf(start), Float.valueOf(end)));
            }
            this.re.setFogDist(start, end);
        }
    }

    private void executeCommandFCOL() {
        this.context.fog_color[0] = (float)(this.normalArgument & 0xFF) / 255.0f;
        this.context.fog_color[1] = (float)(this.normalArgument >> 8 & 0xFF) / 255.0f;
        this.context.fog_color[2] = (float)(this.normalArgument >> 16 & 0xFF) / 255.0f;
        this.context.fog_color[3] = 1.0f;
        this.re.setFogColor(this.context.fog_color);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuFog(X, X, color=0x%06X) (no alpha)", this.normalArgument));
        }
    }

    private void executeCommandTSLOPE() {
        this.context.tslope_level = VideoEngine.floatArgument(this.normalArgument);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(helper.getCommandString(208) + " tslope_level=" + this.context.tslope_level);
        }
    }

    private void executeCommandPSM() {
        this.context.psm = this.normalArgument;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("psm=" + this.normalArgument + "(" + VideoEngine.getPsmName(this.normalArgument) + ")");
        }
        this.geBufChanged = true;
    }

    private void executeCommandSCISSOR1() {
        this.context.scissor_x1 = this.normalArgument & 0x3FF;
        this.context.scissor_y1 = this.normalArgument >> 10 & 0x3FF;
        this.context.scissor_width = 1 + this.context.scissor_x2 - this.context.scissor_x1;
        this.context.scissor_height = 1 + this.context.scissor_y2 - this.context.scissor_y1;
        this.scissorChanged = true;
    }

    private void executeCommandSCISSOR2() {
        this.context.scissor_x2 = this.normalArgument & 0x3FF;
        this.context.scissor_y2 = this.normalArgument >> 10 & 0x3FF;
        this.context.scissor_width = 1 + this.context.scissor_x2 - this.context.scissor_x1;
        this.context.scissor_height = 1 + this.context.scissor_y2 - this.context.scissor_y1;
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuScissor(" + this.context.scissor_x1 + "," + this.context.scissor_y1 + "," + this.context.scissor_width + "," + this.context.scissor_height + ")");
        }
        this.scissorChanged = true;
    }

    private void executeCommandNEARZ() {
        float old_nearZ = this.context.nearZ;
        this.context.nearZ = (float)(this.normalArgument & 0xFFFF) / 65535.0f;
        if (old_nearZ != this.context.nearZ) {
            this.depthChanged = true;
        }
    }

    private void executeCommandFARZ() {
        float old_farZ = this.context.farZ;
        this.context.farZ = (float)(this.normalArgument & 0xFFFF) / 65535.0f;
        if (old_farZ != this.context.farZ) {
            this.depthChanged = true;
        }
        if (this.depthChanged) {
            this.re.setDepthRange(this.context.zpos, this.context.zscale, this.context.nearZ, this.context.farZ);
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuDepthRange(" + this.context.nearZ + ", " + this.context.farZ + ")"));
        }
    }

    private void executeCommandCTST() {
        this.context.colorTestFunc = this.normalArgument & 3;
        this.re.setColorTestFunc(this.context.colorTestFunc);
    }

    private void executeCommandCREF() {
        this.context.colorTestRef[0] = this.normalArgument & 0xFF;
        this.context.colorTestRef[1] = this.normalArgument >> 8 & 0xFF;
        this.context.colorTestRef[2] = this.normalArgument >> 16 & 0xFF;
        this.re.setColorTestReference(this.context.colorTestRef);
    }

    private void executeCommandCMSK() {
        this.context.colorTestMsk[0] = this.normalArgument & 0xFF;
        this.context.colorTestMsk[1] = this.normalArgument >> 8 & 0xFF;
        this.context.colorTestMsk[2] = this.normalArgument >> 16 & 0xFF;
        this.re.setColorTestMask(this.context.colorTestMsk);
    }

    private void executeCommandATST() {
        this.context.alphaFunc = this.normalArgument & 7;
        this.context.alphaRef = this.normalArgument >> 8 & 0xFF;
        this.re.setAlphaFunc(this.context.alphaFunc, this.context.alphaRef);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuAlphaFunc(func=%d, ref=0x%02X)", this.context.alphaFunc, this.context.alphaRef));
        }
    }

    private void executeCommandSTST() {
        this.context.stencilFunc = this.normalArgument & 7;
        this.context.stencilRef = this.normalArgument >> 8 & 0xFF;
        switch (this.context.psm) {
            case 0: {
                this.context.stencilRef = 0;
                break;
            }
            case 1: {
                this.context.stencilRef &= 0x80;
                break;
            }
            case 2: {
                this.context.stencilRef &= 0xF0;
            }
        }
        this.context.stencilMask = this.normalArgument >> 16 & 0xFF;
        this.re.setStencilFunc(this.context.stencilFunc, this.context.stencilRef, this.context.stencilMask);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("sceGuStencilFunc(func=%d, ref=0x%02X, mask=0x%02X)", this.context.stencilFunc, this.context.stencilRef, this.context.stencilMask));
        }
    }

    private void executeCommandSOP() {
        this.context.stencilOpFail = this.normalArgument & 0xFF;
        this.context.stencilOpZFail = this.normalArgument >> 8 & 0xFF;
        this.context.stencilOpZPass = this.normalArgument >> 16 & 0xFF;
        if (this.context.stencilOpFail > 5) {
            log.warn((Object)("Unknown stencil operation " + this.context.stencilOpFail));
            this.context.stencilOpFail &= 7;
        }
        if (this.context.stencilOpZFail > 5) {
            log.warn((Object)("Unknown stencil operation " + this.context.stencilOpZFail));
            this.context.stencilOpZFail &= 7;
        }
        if (this.context.stencilOpZPass > 5) {
            log.warn((Object)("Unknown stencil operation " + this.context.stencilOpZPass));
            this.context.stencilOpZPass &= 7;
        }
        this.re.setStencilOp(this.context.stencilOpFail, this.context.stencilOpZFail, this.context.stencilOpZPass);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuStencilOp(fail=" + (this.normalArgument & 0xFF) + ", zfail=" + (this.normalArgument >> 8 & 0xFF) + ", zpass=" + (this.normalArgument >> 16 & 0xFF) + ")");
        }
    }

    private void executeCommandZTST() {
        int oldDepthFunc = this.context.depthFunc;
        this.context.depthFunc = this.normalArgument & 0xFF;
        if (this.context.depthFunc > 7) {
            log.warn((Object)String.format("Unknown ztst function %d", this.context.depthFunc));
            this.context.depthFunc &= 7;
        }
        if (oldDepthFunc != this.context.depthFunc) {
            this.depthChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuDepthFunc(" + this.normalArgument + ")");
        }
    }

    private void executeCommandALPHA() {
        this.context.blend_src = this.normalArgument & 0xF;
        this.context.blend_dst = this.normalArgument >> 4 & 0xF;
        this.context.blendEquation = this.normalArgument >> 8 & 0xF;
        if (this.context.blendEquation > 5) {
            log.warn((Object)("Unhandled blend operation " + this.context.blendEquation));
            this.context.blendEquation = 0;
        }
        if (this.context.blend_src > 10) {
            this.error("Unhandled alpha blend src used " + this.context.blend_src);
            this.context.blend_src = 2;
        }
        if (this.context.blend_dst > 10) {
            this.error("Unhandled alpha blend dst used " + this.context.blend_dst);
            this.context.blend_dst = 3;
        }
        this.re.setBlendEquation(this.context.blendEquation);
        this.re.setBlendFunc(this.context.blend_src, this.context.blend_dst);
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuBlendFunc(op=" + this.context.blendEquation + ", src=" + this.context.blend_src + ", dst=" + this.context.blend_dst + ")");
        }
    }

    private void executeCommandSFIX() {
        this.context.sfix = this.normalArgument;
        this.context.sfix_color[0] = (float)(this.context.sfix & 0xFF) / 255.0f;
        this.context.sfix_color[1] = (float)(this.context.sfix >> 8 & 0xFF) / 255.0f;
        this.context.sfix_color[2] = (float)(this.context.sfix >> 16 & 0xFF) / 255.0f;
        this.context.sfix_color[3] = 1.0f;
        this.re.setBlendSFix(this.context.sfix, this.context.sfix_color);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s : 0x%06X", helper.getCommandString(224), this.context.sfix));
        }
    }

    private void executeCommandDFIX() {
        this.context.dfix = this.normalArgument;
        this.context.dfix_color[0] = (float)(this.context.dfix & 0xFF) / 255.0f;
        this.context.dfix_color[1] = (float)(this.context.dfix >> 8 & 0xFF) / 255.0f;
        this.context.dfix_color[2] = (float)(this.context.dfix >> 16 & 0xFF) / 255.0f;
        this.context.dfix_color[3] = 1.0f;
        this.re.setBlendDFix(this.context.dfix, this.context.dfix_color);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s : 0x%06X", helper.getCommandString(225), this.context.dfix));
        }
    }

    private void executeCommandDTH0() {
        this.context.dither_matrix[0] = this.normalArgument & 0xF;
        this.context.dither_matrix[1] = this.normalArgument >> 4 & 0xF;
        this.context.dither_matrix[2] = this.normalArgument >> 8 & 0xF;
        this.context.dither_matrix[3] = this.normalArgument >> 12 & 0xF;
    }

    private void executeCommandDTH1() {
        this.context.dither_matrix[4] = this.normalArgument & 0xF;
        this.context.dither_matrix[5] = this.normalArgument >> 4 & 0xF;
        this.context.dither_matrix[6] = this.normalArgument >> 8 & 0xF;
        this.context.dither_matrix[7] = this.normalArgument >> 12 & 0xF;
    }

    private void executeCommandDTH2() {
        this.context.dither_matrix[8] = this.normalArgument & 0xF;
        this.context.dither_matrix[9] = this.normalArgument >> 4 & 0xF;
        this.context.dither_matrix[10] = this.normalArgument >> 8 & 0xF;
        this.context.dither_matrix[11] = this.normalArgument >> 12 & 0xF;
    }

    private void executeCommandDTH3() {
        this.context.dither_matrix[12] = this.normalArgument & 0xF;
        this.context.dither_matrix[13] = this.normalArgument >> 4 & 0xF;
        this.context.dither_matrix[14] = this.normalArgument >> 8 & 0xF;
        this.context.dither_matrix[15] = this.normalArgument >> 12 & 0xF;
        for (int i = 0; i < 16; ++i) {
            if (this.context.dither_matrix[i] <= 7) continue;
            int n = i;
            this.context.dither_matrix[n] = this.context.dither_matrix[n] | 0xFFFFFFF0;
        }
        if (this.isLogDebugEnabled) {
            log.debug((Object)("DTH0:  " + this.context.dither_matrix[0] + "  " + this.context.dither_matrix[1] + "  " + this.context.dither_matrix[2] + "  " + this.context.dither_matrix[3]));
            log.debug((Object)("DTH1:  " + this.context.dither_matrix[4] + "  " + this.context.dither_matrix[5] + "  " + this.context.dither_matrix[6] + "  " + this.context.dither_matrix[7]));
            log.debug((Object)("DTH2:  " + this.context.dither_matrix[8] + "  " + this.context.dither_matrix[9] + "  " + this.context.dither_matrix[10] + "  " + this.context.dither_matrix[11]));
            log.debug((Object)("DTH3:  " + this.context.dither_matrix[12] + "  " + this.context.dither_matrix[13] + "  " + this.context.dither_matrix[14] + "  " + this.context.dither_matrix[15]));
        }
    }

    private void executeCommandLOP() {
        this.context.logicOp = this.normalArgument & 0xF;
        this.re.setLogicOp(this.context.logicOp);
        if (this.isLogDebugEnabled) {
            log.debug((Object)("sceGuLogicalOp(LogicOp=" + this.context.logicOp + "(" + VideoEngine.getLOpName(this.context.logicOp) + "))"));
        }
    }

    private void executeCommandZMSK() {
        this.context.depthMask = this.normalArgument == 0;
        this.re.setDepthMask(this.context.depthMask);
        if (this.context.depthMask) {
            this.depthChanged = true;
        }
        if (this.isLogDebugEnabled) {
            VideoEngine.log("sceGuDepthMask(" + (this.normalArgument != 0 ? "disableWrites" : "enableWrites") + ")");
        }
    }

    private void executeCommandPMSKC() {
        this.context.colorMask[0] = this.normalArgument & 0xFF;
        this.context.colorMask[1] = this.normalArgument >> 8 & 0xFF;
        this.context.colorMask[2] = this.normalArgument >> 16 & 0xFF;
        this.re.setColorMask(this.context.colorMask[0], this.context.colorMask[1], this.context.colorMask[2], this.context.colorMask[3]);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s color mask=0x%06X", helper.getCommandString(232), this.normalArgument));
        }
    }

    private void executeCommandPMSKA() {
        this.context.colorMask[3] = this.normalArgument & 0xFF;
        this.re.setColorMask(this.context.colorMask[0], this.context.colorMask[1], this.context.colorMask[2], this.context.colorMask[3]);
        if (this.isLogDebugEnabled) {
            VideoEngine.log(String.format("%s alpha mask=0x%02X", helper.getCommandString(233), this.normalArgument));
        }
    }

    private void executeCommandTRXPOS() {
        this.context.textureTx_sx = this.normalArgument & 0x1FF;
        this.context.textureTx_sy = this.normalArgument >> 10 & 0x1FF;
    }

    private void executeCommandTRXDPOS() {
        this.context.textureTx_dx = this.normalArgument & 0x1FF;
        this.context.textureTx_dy = this.normalArgument >> 10 & 0x1FF;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s dx=%d, dy=%d", helper.getCommandString(this.command), this.context.textureTx_dx, this.context.textureTx_dy));
        }
    }

    private void executeCommandTRXSIZE() {
        this.context.textureTx_width = (this.normalArgument & 0x3FF) + 1;
        this.context.textureTx_height = (this.normalArgument >> 10 & 0x3FF) + 1;
        if (this.isLogDebugEnabled) {
            log.debug((Object)String.format("%s width=%d, height=%d", helper.getCommandString(this.command), this.context.textureTx_width, this.context.textureTx_height));
        }
    }

    private void executeCommandVSCX() {
        int coordX = this.normalArgument & 0xFFFF;
        log.warn((Object)("Unimplemented VSCX: coordX=" + coordX));
    }

    private void executeCommandVSCY() {
        int coordY = this.normalArgument & 0xFFFF;
        log.warn((Object)("Unimplemented VSCY: coordY=" + coordY));
    }

    private void executeCommandVSCZ() {
        int coordZ = this.normalArgument & 0xFFFF;
        log.warn((Object)("Unimplemented VSCZ: coordZ=" + coordZ));
    }

    private void executeCommandVTCS() {
        float coordS = VideoEngine.floatArgument(this.normalArgument);
        log.warn((Object)("Unimplemented VTCS: coordS=" + coordS));
    }

    private void executeCommandVTCT() {
        float coordT = VideoEngine.floatArgument(this.normalArgument);
        log.warn((Object)("Unimplemented VTCT: coordT=" + coordT));
    }

    private void executeCommandVTCQ() {
        float coordQ = VideoEngine.floatArgument(this.normalArgument);
        log.warn((Object)("Unimplemented VTCQ: coordQ=" + coordQ));
    }

    private void executeCommandVCV() {
        int colorR = this.normalArgument & 0xFF;
        int colorG = this.normalArgument >> 8 & 0xFF;
        int colorB = this.normalArgument >> 16 & 0xFF;
        log.warn((Object)("Unimplemented VCV: colorR=" + colorR + ", colorG=" + colorG + ", colorB=" + colorB));
    }

    private void executeCommandVAP() {
        int alpha = this.normalArgument & 0xFF;
        int prim_type = this.normalArgument >> 8 & 7;
        log.warn((Object)String.format("Unimplemented VAP: alpha=%d, prim_type=%d, unknown=0x%04X", alpha, prim_type, this.normalArgument >> 11));
    }

    private void executeCommandVFC() {
        int fog = this.normalArgument & 0xFF;
        log.warn((Object)("Unimplemented VFC: fog=" + fog));
    }

    private void executeCommandVSCV() {
        int colorR2 = this.normalArgument & 0xFF;
        int colorG2 = this.normalArgument >> 8 & 0xFF;
        int colorB2 = this.normalArgument >> 16 & 0xFF;
        log.warn((Object)("Unimplemented VSCV: colorR2=" + colorR2 + ", colorG2=" + colorG2 + ", colorB2=" + colorB2));
    }

    private void executeCommandDUMMY() {
        if (this.isLogDebugEnabled) {
            log.debug((Object)"Ignored DUMMY video command.");
        }
    }

    private void enableClientState(boolean useVertexColor, boolean useTexture) {
        if (useTexture) {
            this.re.enableClientState(0);
        } else {
            this.re.disableClientState(0);
        }
        if (useVertexColor) {
            this.re.enableClientState(1);
        } else {
            this.re.disableClientState(1);
        }
        if (this.context.vinfo.normal != 0) {
            this.re.enableClientState(2);
        } else {
            this.re.disableClientState(2);
        }
        this.re.enableClientState(3);
    }

    private void setTexCoordPointer(boolean useTexture, int nTexCoord, int type, int stride, int offset, boolean isNative, boolean useBufferManager) {
        if (useTexture) {
            if (!useBufferManager) {
                this.re.setTexCoordPointer(nTexCoord, type, stride, offset);
            } else if (isNative) {
                this.bufferManager.setTexCoordPointer(this.nativeBufferId, nTexCoord, type, this.context.vinfo.vertexSize, offset);
            } else {
                this.bufferManager.setTexCoordPointer(this.bufferId, nTexCoord, type, stride, offset);
            }
        }
    }

    private void setColorPointer(boolean useVertexColor, int nColor, int type, int stride, int offset, boolean isNative, boolean useBufferManager) {
        if (useVertexColor) {
            if (!useBufferManager) {
                this.re.setColorPointer(nColor, type, stride, offset);
            } else if (isNative) {
                this.bufferManager.setColorPointer(this.nativeBufferId, nColor, type, this.context.vinfo.vertexSize, offset);
            } else {
                this.bufferManager.setColorPointer(this.bufferId, nColor, type, stride, offset);
            }
        }
    }

    private void setVertexPointer(int nVertex, int type, int stride, int offset, boolean isNative, boolean useBufferManager) {
        if (!useBufferManager) {
            this.re.setVertexPointer(nVertex, type, stride, offset);
        } else if (isNative) {
            this.bufferManager.setVertexPointer(this.nativeBufferId, nVertex, type, this.context.vinfo.vertexSize, offset);
        } else {
            this.bufferManager.setVertexPointer(this.bufferId, nVertex, type, stride, offset);
        }
    }

    private void setNormalPointer(int type, int stride, int offset, boolean isNative, boolean useBufferManager) {
        if (this.context.vinfo.normal != 0) {
            if (!useBufferManager) {
                this.re.setNormalPointer(type, stride, offset);
            } else if (isNative) {
                this.bufferManager.setNormalPointer(this.nativeBufferId, type, this.context.vinfo.vertexSize, offset);
            } else {
                this.bufferManager.setNormalPointer(this.bufferId, type, stride, offset);
            }
        }
    }

    private void setWeightPointer(int numberOfWeightsForBuffer, int type, int stride, int offset, boolean isNative, boolean useBufferManager) {
        if (numberOfWeightsForBuffer > 0) {
            if (!useBufferManager) {
                this.re.setWeightPointer(numberOfWeightsForBuffer, type, stride, offset);
            } else if (isNative) {
                this.re.setWeightPointer(numberOfWeightsForBuffer, type, this.context.vinfo.vertexSize, offset);
            } else {
                this.re.setWeightPointer(numberOfWeightsForBuffer, type, stride, offset);
            }
        }
    }

    private void setDataPointers(int nVertex, boolean useVertexColor, int nColor, boolean useTexture, int nTexCoord, boolean useNormal, int numberOfWeightsForBuffer, boolean useBufferManager) {
        int stride = 0;
        int cpos = 0;
        int npos = 0;
        int vpos = 0;
        int wpos = 0;
        if (this.context.vinfo.texture != 0 || useTexture) {
            npos = vpos = (stride += SIZEOF_FLOAT * nTexCoord);
            cpos = vpos;
        }
        if (useVertexColor) {
            npos = vpos = (stride += SIZEOF_FLOAT * 4);
        }
        if (useNormal) {
            vpos = stride += SIZEOF_FLOAT * 3;
        }
        stride += SIZEOF_FLOAT * 3;
        if (numberOfWeightsForBuffer > 0) {
            wpos = stride;
            stride += SIZEOF_FLOAT * numberOfWeightsForBuffer;
        }
        this.enableClientState(useVertexColor, useTexture);
        this.setTexCoordPointer(useTexture, nTexCoord, 6, stride, 0, false, useBufferManager);
        this.setColorPointer(useVertexColor, nColor, 6, stride, cpos, false, useBufferManager);
        this.setNormalPointer(6, stride, npos, false, useBufferManager);
        this.setWeightPointer(numberOfWeightsForBuffer, 6, stride, wpos, false, useBufferManager);
        this.setVertexPointer(nVertex, 6, stride, vpos, false, useBufferManager);
    }

    public void doPositionSkinning(VertexInfo vinfo, float[] boneWeights, float[] position) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < this.context.vinfo.skinningWeightCount; ++i) {
            if (boneWeights[i] == 0.0f) continue;
            x += (position[0] * this.context.bone_uploaded_matrix[i][0] + position[1] * this.context.bone_uploaded_matrix[i][3] + position[2] * this.context.bone_uploaded_matrix[i][6] + this.context.bone_uploaded_matrix[i][9]) * boneWeights[i];
            y += (position[0] * this.context.bone_uploaded_matrix[i][1] + position[1] * this.context.bone_uploaded_matrix[i][4] + position[2] * this.context.bone_uploaded_matrix[i][7] + this.context.bone_uploaded_matrix[i][10]) * boneWeights[i];
            z += (position[0] * this.context.bone_uploaded_matrix[i][2] + position[1] * this.context.bone_uploaded_matrix[i][5] + position[2] * this.context.bone_uploaded_matrix[i][8] + this.context.bone_uploaded_matrix[i][11]) * boneWeights[i];
        }
        position[0] = x;
        position[1] = y;
        position[2] = z;
    }

    public void doNormalSkinning(VertexInfo vinfo, float[] boneWeights, float[] normal) {
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        for (int i = 0; i < this.context.vinfo.skinningWeightCount; ++i) {
            if (boneWeights[i] == 0.0f) continue;
            nx += (normal[0] * this.context.bone_uploaded_matrix[i][0] + normal[1] * this.context.bone_uploaded_matrix[i][3] + normal[2] * this.context.bone_uploaded_matrix[i][6]) * boneWeights[i];
            ny += (normal[0] * this.context.bone_uploaded_matrix[i][1] + normal[1] * this.context.bone_uploaded_matrix[i][4] + normal[2] * this.context.bone_uploaded_matrix[i][7]) * boneWeights[i];
            nz += (normal[0] * this.context.bone_uploaded_matrix[i][2] + normal[1] * this.context.bone_uploaded_matrix[i][5] + normal[2] * this.context.bone_uploaded_matrix[i][8]) * boneWeights[i];
        }
        normal[0] = nx;
        normal[1] = ny;
        normal[2] = nz;
    }

    public static void doSkinning(float[][] boneMatrix, VertexInfo vinfo, VertexState v) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float nx = 0.0f;
        float ny = 0.0f;
        float nz = 0.0f;
        boolean hasNormal = vinfo.normal != 0;
        for (int i = 0; i < vinfo.skinningWeightCount; ++i) {
            float boneWeight = v.boneWeights[i];
            if (boneWeight == 0.0f) continue;
            x += (v.p[0] * boneMatrix[i][0] + v.p[1] * boneMatrix[i][3] + v.p[2] * boneMatrix[i][6] + boneMatrix[i][9]) * boneWeight;
            y += (v.p[0] * boneMatrix[i][1] + v.p[1] * boneMatrix[i][4] + v.p[2] * boneMatrix[i][7] + boneMatrix[i][10]) * boneWeight;
            z += (v.p[0] * boneMatrix[i][2] + v.p[1] * boneMatrix[i][5] + v.p[2] * boneMatrix[i][8] + boneMatrix[i][11]) * boneWeight;
            if (!hasNormal) continue;
            nx += (v.n[0] * boneMatrix[i][0] + v.n[1] * boneMatrix[i][3] + v.n[2] * boneMatrix[i][6]) * boneWeight;
            ny += (v.n[0] * boneMatrix[i][1] + v.n[1] * boneMatrix[i][4] + v.n[2] * boneMatrix[i][7]) * boneWeight;
            nz += (v.n[0] * boneMatrix[i][2] + v.n[1] * boneMatrix[i][5] + v.n[2] * boneMatrix[i][8]) * boneWeight;
        }
        v.p[0] = x;
        v.p[1] = y;
        v.p[2] = z;
        if (hasNormal) {
            v.n[0] = nx;
            v.n[1] = ny;
            v.n[2] = nz;
        }
    }

    private void log(String commandString, float floatArgument) {
        if (this.isLogDebugEnabled) {
            VideoEngine.log(commandString + ' ' + floatArgument);
        }
    }

    private void log(String commandString, int value) {
        if (this.isLogDebugEnabled) {
            VideoEngine.log(commandString + ' ' + value);
        }
    }

    private void log(String commandString, float[] matrix) {
        if (this.isLogDebugEnabled) {
            for (int y = 0; y < 4; ++y) {
                VideoEngine.log(commandString + ' ' + String.format("%.4f %.4f %.4f %.4f", Float.valueOf(matrix[0 + y * 4]), Float.valueOf(matrix[1 + y * 4]), Float.valueOf(matrix[2 + y * 4]), Float.valueOf(matrix[3 + y * 4])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVideoTexture(int tex_addr) {
        if (!this.videoTextures.isEmpty()) {
            LinkedList<AddressRange> linkedList = this.videoTextures;
            synchronized (linkedList) {
                for (AddressRange addressRange : this.videoTextures) {
                    if (!addressRange.contains(tex_addr)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canCacheTexture(int tex_addr) {
        if (this.context.texture_storage >= 8) {
            return true;
        }
        if (this.display.isGeAddress(tex_addr)) {
            return false;
        }
        return !this.isVideoTexture(tex_addr);
    }

    private void setFlippedTexture(GETexture geTexture) {
        float newTextureFlipTranslateY = (float)geTexture.getHeight() / (float)this.context.texture_height[0];
        if (!this.textureFlipped || this.textureFlipTranslateY != newTextureFlipTranslateY) {
            this.textureFlipped = true;
            this.textureFlipTranslateY = newTextureFlipTranslateY;
            this.textureMatrixUpload.setChanged(true);
        }
    }

    private boolean loadGETexture(int tex_addr) {
        GETexture geTexture;
        if (!this.display.getSaveGEToTexture() || this.isVideoTexture(tex_addr)) {
            return false;
        }
        int widthGe = this.display.getWidthGe();
        int heightGe = this.display.getHeightGe();
        int bufferWidth = this.context.texture_buffer_width[0];
        int pixelFormat = this.context.texture_storage;
        if (IRenderingEngine.isTextureTypeIndexed[pixelFormat]) {
            if (pixelFormat == 7) {
                geTexture = GETextureManager.getInstance().checkGETexture(tex_addr, bufferWidth, widthGe, heightGe, 3);
            } else {
                geTexture = null;
                if (this.context.tex_clut_mode >= 0 && this.context.tex_clut_mode <= 2) {
                    geTexture = GETextureManager.getInstance().checkGETexture(tex_addr, bufferWidth, widthGe, heightGe, this.context.tex_clut_mode);
                }
                if (geTexture == null) {
                    for (int i = 0; i <= 2 && (geTexture = GETextureManager.getInstance().checkGETexture(tex_addr, bufferWidth, widthGe, heightGe, i)) == null; ++i) {
                    }
                }
            }
            if (geTexture != null) {
                if (tex_addr == this.display.getTopAddrGe()) {
                    geTexture.copyScreenToTexture(this.re);
                }
                if (!this.re.canNativeClut(tex_addr) || this.context.texture_swizzle) {
                    geTexture.copyTextureToMemory(this.re);
                    return false;
                }
                geTexture = GETextureManager.getInstance().getGEIndexedTexture(this.re, geTexture, tex_addr, bufferWidth, this.context.texture_width[0], this.context.texture_height[0], pixelFormat);
                geTexture.bind(this.re, true);
                this.setFlippedTexture(geTexture);
                return true;
            }
        } else {
            geTexture = GETextureManager.getInstance().checkGETexture(tex_addr, bufferWidth, widthGe, heightGe, pixelFormat);
        }
        if (geTexture == null) {
            return false;
        }
        if (tex_addr == this.display.getTopAddrGe()) {
            geTexture.copyScreenToTexture(this.re);
        }
        int width = this.context.texture_width[0];
        int height = this.context.texture_height[0];
        if (geTexture.getWidth() == width && geTexture.getHeight() == height) {
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("Reusing GETexture %s", geTexture));
            }
        } else {
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("Resizing GETexture %s to %dx%d", geTexture, width, height));
            }
            geTexture = GETextureManager.getInstance().getGEResizedTexture(this.re, geTexture, tex_addr, bufferWidth, width, height, pixelFormat);
        }
        geTexture.bind(this.re, true);
        this.setFlippedTexture(geTexture);
        return true;
    }

    private int getValidNumberMipmaps() {
        for (int level = 0; level <= this.context.texture_num_mip_maps; ++level) {
            int texaddr = this.context.texture_base_pointer[level] & 0x3FFFFFFF;
            if (!Memory.isAddressGood(texaddr)) {
                if (texaddr == 0) {
                    if (this.isLogDebugEnabled) {
                        log.debug((Object)String.format("Invalid texture address 0x%08X for texture level %d", texaddr, level));
                    }
                } else if (this.isLogWarnEnabled) {
                    log.warn((Object)String.format("Invalid texture address 0x%08X for texture level %d", texaddr, level));
                }
                return Math.max(level - 1, 0);
            }
            if (level <= 0) continue;
            int previousWidth = this.context.texture_width[level - 1];
            int currentWidth = this.context.texture_width[level];
            int previousHeight = this.context.texture_height[level - 1];
            int currentHeight = this.context.texture_height[level];
            if (currentWidth * 2 == previousWidth && currentHeight * 2 == previousHeight) continue;
            if (this.isLogWarnEnabled) {
                log.warn((Object)String.format("Texture mipmap with invalid dimension at level %d: (%dx%d)@0x%08X -> (%dx%d)@0x%08X", level, previousWidth, previousHeight, this.context.texture_base_pointer[level - 1] & 0x3FFFFFFF, currentWidth, currentHeight, texaddr));
                if (this.context.tex_mipmap_mode == 1 && this.context.tex_mipmap_bias_int >= level) {
                    log.warn((Object)String.format("... and this invalid Texture mipmap will be used with mipmap_mode=%d, mipmap_bias=%d", this.context.tex_mipmap_mode, this.context.tex_mipmap_bias_int));
                }
            }
            return level - 1;
        }
        return this.context.texture_num_mip_maps;
    }

    private String getModdedTextureDirectory() {
        String tmpPath = Settings.getInstance().readString("emu.tmppath");
        char sep = File.separatorChar;
        return String.format("%s%c%s%cTextures%c", tmpPath, Character.valueOf(sep), State.discId, Character.valueOf(sep), Character.valueOf(sep));
    }

    private boolean hasModdedTexture(int level, StringBuilder moddedTextureFileName) {
        if (!this.hasModdedTextureDirectory) {
            return false;
        }
        String directory = this.getModdedTextureDirectory();
        int origLength = moddedTextureFileName.length();
        for (String extension : ImageIO.getReaderFileSuffixes()) {
            moddedTextureFileName.setLength(origLength);
            String fileNameSuffix = "";
            if (IRenderingEngine.isTextureTypeIndexed[this.context.texture_storage]) {
                fileNameSuffix = String.format("_%08X", this.context.tex_clut_addr);
            }
            moddedTextureFileName.append(String.format("%sImage%08X%s.%s", directory, this.context.texture_base_pointer[level], fileNameSuffix, extension));
            File moddedTextureFile = new File(moddedTextureFileName.toString());
            if (!moddedTextureFile.canRead()) continue;
            return true;
        }
        return false;
    }

    public static int alignBufferWidth(int bufferWidth, int pixelFormat) {
        int alignment = IRenderingEngine.alignementOfTextureBufferWidth[pixelFormat] - 1;
        if (alignment <= 0) {
            return bufferWidth;
        }
        return bufferWidth + alignment & ~alignment;
    }

    private static int readLittleEndianShort(InputStream is) throws IOException {
        byte[] buffer = new byte[2];
        if (is.read(buffer) != buffer.length) {
            return -1;
        }
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8;
    }

    private static int readLittleEndianInt(InputStream is) throws IOException {
        byte[] buffer = new byte[4];
        if (is.read(buffer) != buffer.length) {
            return -1;
        }
        return buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8 | (buffer[2] & 0xFF) << 16 | (buffer[3] & 0xFF) << 24;
    }

    private void loadTexture() {
        Texture texture;
        if (this.display.isGeAddress(this.context.texture_base_pointer[0])) {
            this.textureChanged = true;
            this.re.waitForRenderingCompletion();
        }
        if (!this.textureChanged) {
            return;
        }
        if (this.context.texture_base_pointer[0] == 0) {
            return;
        }
        if (!this.context.textureFlag.isEnabled() || this.context.clearMode) {
            return;
        }
        int tex_addr = this.context.texture_base_pointer[0] & 0x3FFFFFFF;
        if (!Memory.isAddressGood(tex_addr)) {
            if (this.isLogWarnEnabled) {
                log.warn((Object)String.format("Invalid texture address 0x%08X for texture level 0", tex_addr));
            }
            return;
        }
        this.re.setTextureFormat(this.context.texture_storage, this.context.texture_swizzle);
        if (this.loadGETexture(tex_addr)) {
            this.re.setTextureMipmapMagFilter(this.context.tex_mag_filter);
            this.re.setTextureMipmapMinFilter(this.context.tex_min_filter);
            this.checkTextureMinFilter(false, this.context.texture_num_mip_maps);
            this.textureChanged = false;
            return;
        }
        if (!this.canCacheTexture(tex_addr)) {
            texture = null;
            if (this.textureId == -1) {
                this.textureId = this.re.genTexture();
            }
            this.re.bindTexture(this.textureId);
        } else {
            TextureCache textureCache = TextureCache.getInstance();
            boolean textureRequiresClut = IRenderingEngine.isTextureTypeIndexed[this.context.texture_storage];
            if (textureRequiresClut && this.re.canNativeClut(tex_addr) && this.context.texture_storage >= 5 && this.context.texture_storage <= 7) {
                textureRequiresClut = false;
            }
            this.textureCacheLookupStatistics.start();
            texture = textureRequiresClut ? textureCache.getTexture(this.context.texture_base_pointer[0], this.context.texture_buffer_width[0], this.context.texture_width[0], this.context.texture_height[0], this.context.texture_storage, this.context.tex_clut_addr, this.context.tex_clut_mode, this.context.tex_clut_start, this.context.tex_clut_shift, this.context.tex_clut_mask, this.context.tex_clut_num_blocks, this.context.texture_num_mip_maps, this.context.mipmapShareClut, null, null) : textureCache.getTexture(this.context.texture_base_pointer[0], this.context.texture_buffer_width[0], this.context.texture_width[0], this.context.texture_height[0], this.context.texture_storage, 0, 0, 0, 0, 0, 0, this.context.texture_num_mip_maps, false, null, null);
            this.textureCacheLookupStatistics.end();
            if (texture == null) {
                texture = textureRequiresClut ? new Texture(textureCache, this.context.texture_base_pointer[0], this.context.texture_buffer_width[0], this.context.texture_width[0], this.context.texture_height[0], this.context.texture_storage, this.context.tex_clut_addr, this.context.tex_clut_mode, this.context.tex_clut_start, this.context.tex_clut_shift, this.context.tex_clut_mask, this.context.tex_clut_num_blocks, this.context.texture_num_mip_maps, this.context.mipmapShareClut, null, null) : new Texture(textureCache, this.context.texture_base_pointer[0], this.context.texture_buffer_width[0], this.context.texture_width[0], this.context.texture_height[0], this.context.texture_storage, 0, 0, 0, 0, 0, 0, this.context.texture_num_mip_maps, false, null, null);
                textureCache.addTexture(this.re, texture);
            }
            texture.bindTexture(this.re);
        }
        if (this.textureFlipped) {
            this.textureFlipped = false;
            this.textureMatrixUpload.setChanged(true);
        }
        if (texture == null || !texture.isLoaded() || State.captureGeNextFrame) {
            if (this.isLogDebugEnabled) {
                VideoEngine.log(helper.getCommandString(203) + " " + String.format("0x%08X", this.context.texture_base_pointer[0]) + ", buffer_width=" + this.context.texture_buffer_width[0] + " (" + this.context.texture_width[0] + "," + this.context.texture_height[0] + ")");
                VideoEngine.log(helper.getCommandString(203) + " texture_storage=0x" + Integer.toHexString(this.context.texture_storage) + "(" + VideoEngine.getPsmName(this.context.texture_storage) + "), tex_clut_mode=0x" + Integer.toHexString(this.context.tex_clut_mode) + ", tex_clut_addr=" + String.format("0x%08X", this.context.tex_clut_addr) + ", texture_swizzle=" + this.context.texture_swizzle);
            }
            if (this.isGeProfilerEnabled) {
                GEProfiler.loadTexture();
            }
            if (tex_addr == (this.context.fbp | 0x4000000) && this.context.texture_storage == this.context.psm && this.context.texture_buffer_width[0] == this.context.fbw) {
                this.display.copyGeToMemory(true);
            }
            Buffer final_buffer = null;
            int texclut = this.context.tex_clut_addr;
            int textureByteAlignment = 4;
            boolean compressedTexture = false;
            int numberMipmaps = this.getValidNumberMipmaps();
            this.re.setTextureMipmapMagFilter(this.context.tex_mag_filter);
            this.re.setTextureMipmapMinFilter(this.context.tex_min_filter);
            this.checkTextureMinFilter(compressedTexture, numberMipmaps);
            for (int level = 0; level <= numberMipmaps; ++level) {
                int texaddr = this.context.texture_base_pointer[level] & 0x3FFFFFFF;
                compressedTexture = false;
                int compressedTextureSize = 0;
                int buffer_storage = this.context.texture_storage;
                int textureBufferWidthInPixels = VideoEngine.alignBufferWidth(this.context.texture_buffer_width[level], this.context.texture_storage);
                StringBuilder moddedTextureFileName = new StringBuilder();
                if (this.enableTextureModding && this.hasModdedTexture(level, moddedTextureFileName)) {
                    try {
                        File moddedTextureFile = new File(moddedTextureFileName.toString());
                        int width = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]);
                        int height = this.context.texture_height[level];
                        boolean readUsingImageIO = true;
                        if (moddedTextureFile.getName().endsWith(".bmp")) {
                            BufferedInputStream is = new BufferedInputStream(new FileInputStream(moddedTextureFile));
                            int magic = VideoEngine.readLittleEndianShort(is);
                            int fileSize = VideoEngine.readLittleEndianInt(is);
                            ((InputStream)is).skip(4L);
                            int dataOffset = VideoEngine.readLittleEndianInt(is);
                            int dibHeaderLength = VideoEngine.readLittleEndianInt(is);
                            int imageWidth = VideoEngine.readLittleEndianInt(is);
                            int imageHeight = VideoEngine.readLittleEndianInt(is);
                            int numberPlanes = VideoEngine.readLittleEndianShort(is);
                            int bitsPerPixel = VideoEngine.readLittleEndianShort(is);
                            ((InputStream)is).skip(dataOffset - 14 - 16);
                            if (magic == 19778 && dibHeaderLength >= 16 && fileSize >= dataOffset && numberPlanes == 1 && bitsPerPixel == 32 && imageWidth == width && imageHeight == height) {
                                for (int y = height - 1; y >= 0; --y) {
                                    int x = 0;
                                    int i = y * width;
                                    while (x < width) {
                                        int abgr;
                                        int argb = VideoEngine.readLittleEndianInt(is);
                                        this.tmp_texture_buffer32[i] = abgr = argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
                                        ++x;
                                        ++i;
                                    }
                                }
                                readUsingImageIO = false;
                            }
                            ((InputStream)is).close();
                        }
                        if (readUsingImageIO) {
                            BufferedImage img = ImageIO.read(moddedTextureFile);
                            for (int y = height - 1; y >= 0; --y) {
                                int x = 0;
                                int i = y * width;
                                while (x < width) {
                                    int abgr;
                                    int argb = img.getRGB(x, y);
                                    this.tmp_texture_buffer32[i] = abgr = argb & 0xFF00FF00 | (argb & 0xFF0000) >> 16 | (argb & 0xFF) << 16;
                                    ++x;
                                    ++i;
                                }
                            }
                        }
                        final_buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                        textureByteAlignment = 4;
                        buffer_storage = 3;
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while reading modded texture file", (Throwable)e);
                        return;
                    }
                } else {
                    block1 : switch (this.context.texture_storage) {
                        case 4: {
                            if (texclut == 0) {
                                return;
                            }
                            buffer_storage = this.context.tex_clut_mode;
                            switch (this.context.tex_clut_mode) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    int index;
                                    int n;
                                    int index2;
                                    int length;
                                    int clutSharingOffset;
                                    textureByteAlignment = 2;
                                    short[] clut = this.readClut16(level);
                                    int n2 = clutSharingOffset = this.context.mipmapShareClut ? 0 : level * 16;
                                    if (!this.context.texture_swizzle) {
                                        length = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]) * this.context.texture_height[level];
                                        IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, length / 2, 1);
                                        for (int i = 0; i < length; i += 2) {
                                            index2 = memoryReader.readNext();
                                            this.tmp_texture_buffer16[i] = clut[this.getClutIndex(index2 & 0xF) + clutSharingOffset];
                                            this.tmp_texture_buffer16[i + 1] = clut[this.getClutIndex(index2 >> 4 & 0xF) + clutSharingOffset];
                                        }
                                        final_buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                                        if (!State.captureGeNextFrame) break block1;
                                        log.info((Object)"Capture loadTexture clut 4/16 unswizzled");
                                        CaptureManager.captureRAM(texaddr, length / 2);
                                        break block1;
                                    }
                                    this.unswizzleTextureFromMemory(texaddr, 0, level, textureBufferWidthInPixels);
                                    int pixels = textureBufferWidthInPixels * this.context.texture_height[level];
                                    int i = 0;
                                    int j = 0;
                                    while (i < pixels) {
                                        n = this.tmp_texture_buffer32[j];
                                        index = n & 0xF;
                                        this.tmp_texture_buffer16[i + 0] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 4 & 0xF;
                                        this.tmp_texture_buffer16[i + 1] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 8 & 0xF;
                                        this.tmp_texture_buffer16[i + 2] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 12 & 0xF;
                                        this.tmp_texture_buffer16[i + 3] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 16 & 0xF;
                                        this.tmp_texture_buffer16[i + 4] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 20 & 0xF;
                                        this.tmp_texture_buffer16[i + 5] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 24 & 0xF;
                                        this.tmp_texture_buffer16[i + 6] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 28 & 0xF;
                                        this.tmp_texture_buffer16[i + 7] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        i += 8;
                                        ++j;
                                    }
                                    final_buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                                    break block1;
                                }
                                case 3: {
                                    int clutSharingOffset;
                                    int index;
                                    int n;
                                    int index2;
                                    int length;
                                    int[] clut = this.readClut32(level);
                                    int n3 = clutSharingOffset = this.context.mipmapShareClut ? 0 : level * 16;
                                    if (!this.context.texture_swizzle) {
                                        length = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]) * this.context.texture_height[level];
                                        IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, length / 2, 1);
                                        for (int i = 0; i < length; i += 2) {
                                            index2 = memoryReader.readNext();
                                            this.tmp_texture_buffer32[i + 1] = clut[this.getClutIndex(index2 >> 4 & 0xF) + clutSharingOffset];
                                            this.tmp_texture_buffer32[i] = clut[this.getClutIndex(index2 & 0xF) + clutSharingOffset];
                                        }
                                        final_buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                                        if (!State.captureGeNextFrame) break block1;
                                        log.info((Object)"Capture loadTexture clut 4/32 unswizzled");
                                        CaptureManager.captureRAM(texaddr, length / 2);
                                        break block1;
                                    }
                                    this.unswizzleTextureFromMemory(texaddr, 0, level, textureBufferWidthInPixels);
                                    int pixels = textureBufferWidthInPixels * this.context.texture_height[level];
                                    int i = pixels - 8;
                                    int j = pixels / 8 - 1;
                                    while (i >= 0) {
                                        n = this.tmp_texture_buffer32[j];
                                        index = n & 0xF;
                                        this.tmp_texture_buffer32[i + 0] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 4 & 0xF;
                                        this.tmp_texture_buffer32[i + 1] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 8 & 0xF;
                                        this.tmp_texture_buffer32[i + 2] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 12 & 0xF;
                                        this.tmp_texture_buffer32[i + 3] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 16 & 0xF;
                                        this.tmp_texture_buffer32[i + 4] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 20 & 0xF;
                                        this.tmp_texture_buffer32[i + 5] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 24 & 0xF;
                                        this.tmp_texture_buffer32[i + 6] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        index = n >> 28 & 0xF;
                                        this.tmp_texture_buffer32[i + 7] = clut[this.getClutIndex(index) + clutSharingOffset];
                                        i -= 8;
                                        --j;
                                    }
                                    final_buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                                    break block1;
                                }
                                default: {
                                    this.error("Unhandled clut4 texture mode " + this.context.tex_clut_mode);
                                    return;
                                }
                            }
                        }
                        case 5: {
                            if (this.re.canNativeClut(texaddr)) {
                                final_buffer = this.getTextureBuffer(texaddr, 1, level, textureBufferWidthInPixels);
                                textureByteAlignment = 1;
                                break;
                            }
                            final_buffer = this.readIndexedTexture(level, texaddr, texclut, 1, textureBufferWidthInPixels);
                            buffer_storage = this.context.tex_clut_mode;
                            textureByteAlignment = textureByteAlignmentMapping[this.context.tex_clut_mode];
                            break;
                        }
                        case 6: {
                            if (this.re.canNativeClut(texaddr)) {
                                final_buffer = this.getTextureBuffer(texaddr, 2, level, textureBufferWidthInPixels);
                                textureByteAlignment = 2;
                                break;
                            }
                            final_buffer = this.readIndexedTexture(level, texaddr, texclut, 2, textureBufferWidthInPixels);
                            buffer_storage = this.context.tex_clut_mode;
                            textureByteAlignment = textureByteAlignmentMapping[this.context.tex_clut_mode];
                            break;
                        }
                        case 7: {
                            if (this.re.canNativeClut(texaddr)) {
                                final_buffer = this.getTextureBuffer(texaddr, 4, level, textureBufferWidthInPixels);
                                textureByteAlignment = 4;
                                break;
                            }
                            final_buffer = this.readIndexedTexture(level, texaddr, texclut, 4, textureBufferWidthInPixels);
                            buffer_storage = this.context.tex_clut_mode;
                            textureByteAlignment = textureByteAlignmentMapping[this.context.tex_clut_mode];
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 2: {
                            textureByteAlignment = 2;
                            if (!this.context.texture_swizzle) {
                                int length = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]) * this.context.texture_height[level];
                                final_buffer = Memory.getInstance().getBuffer(texaddr, length * 2);
                                if (final_buffer == null) {
                                    IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, length * 2, 2);
                                    for (int i = 0; i < length; ++i) {
                                        int pixel = memoryReader.readNext();
                                        this.tmp_texture_buffer16[i] = (short)pixel;
                                    }
                                    final_buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                                }
                                if (!State.captureGeNextFrame) break;
                                log.info((Object)"Capture loadTexture 16 unswizzled");
                                CaptureManager.captureRAM(texaddr, length * 2);
                                break;
                            }
                            final_buffer = this.unswizzleTextureFromMemory(texaddr, 2, level, textureBufferWidthInPixels);
                            break;
                        }
                        case 3: {
                            final_buffer = this.getTextureBuffer(texaddr, 4, level, textureBufferWidthInPixels);
                            break;
                        }
                        case 8: {
                            int y;
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)("Loading texture TPSM_PIXEL_STORAGE_MODE_DXT1 " + Integer.toHexString(texaddr)));
                            }
                            compressedTexture = true;
                            compressedTextureSize = this.getCompressedTextureSize(level, 8);
                            IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, compressedTextureSize, 4);
                            int i = 0;
                            for (y = 0; y < this.context.texture_height[level]; y += 4) {
                                int x = 0;
                                while (x < this.context.texture_buffer_width[level]) {
                                    this.tmp_texture_buffer32[i + 1] = memoryReader.readNext();
                                    this.tmp_texture_buffer32[i + 0] = memoryReader.readNext();
                                    x += 4;
                                    i += 2;
                                }
                                x = this.context.texture_buffer_width[level];
                                while (x < this.context.texture_width[level]) {
                                    this.tmp_texture_buffer32[i + 0] = 0;
                                    this.tmp_texture_buffer32[i + 1] = 0;
                                    x += 4;
                                    i += 2;
                                }
                            }
                            final_buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                            break;
                        }
                        case 9: {
                            int y;
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)("Loading texture TPSM_PIXEL_STORAGE_MODE_DXT3 " + Integer.toHexString(texaddr)));
                            }
                            compressedTexture = true;
                            compressedTextureSize = this.getCompressedTextureSize(level, 4);
                            IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, compressedTextureSize, 4);
                            int i = 0;
                            for (y = 0; y < this.context.texture_height[level]; y += 4) {
                                int x = 0;
                                while (x < this.context.texture_buffer_width[level]) {
                                    this.tmp_texture_buffer32[i + 3] = memoryReader.readNext();
                                    this.tmp_texture_buffer32[i + 2] = memoryReader.readNext();
                                    this.tmp_texture_buffer32[i + 0] = memoryReader.readNext();
                                    this.tmp_texture_buffer32[i + 1] = memoryReader.readNext();
                                    x += 4;
                                    i += 4;
                                }
                                x = this.context.texture_buffer_width[level];
                                while (x < this.context.texture_width[level]) {
                                    this.tmp_texture_buffer32[i + 0] = 0;
                                    this.tmp_texture_buffer32[i + 1] = 0;
                                    this.tmp_texture_buffer32[i + 2] = 0;
                                    this.tmp_texture_buffer32[i + 3] = 0;
                                    x += 4;
                                    i += 4;
                                }
                            }
                            final_buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                            break;
                        }
                        case 10: {
                            int y;
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)("Loading texture TPSM_PIXEL_STORAGE_MODE_DXT5 " + Integer.toHexString(texaddr)));
                            }
                            compressedTexture = true;
                            compressedTextureSize = this.getCompressedTextureSize(level, 4);
                            IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, compressedTextureSize, 2);
                            int i = 0;
                            for (y = 0; y < this.context.texture_height[level]; y += 4) {
                                int x = 0;
                                while (x < this.context.texture_buffer_width[level]) {
                                    this.tmp_texture_buffer16[i + 6] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 7] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 4] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 5] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 1] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 2] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 3] = (short)memoryReader.readNext();
                                    this.tmp_texture_buffer16[i + 0] = (short)memoryReader.readNext();
                                    x += 4;
                                    i += 8;
                                }
                                x = this.context.texture_buffer_width[level];
                                while (x < this.context.texture_width[level]) {
                                    this.tmp_texture_buffer16[i + 0] = 0;
                                    this.tmp_texture_buffer16[i + 1] = 0;
                                    this.tmp_texture_buffer16[i + 2] = 0;
                                    this.tmp_texture_buffer16[i + 3] = 0;
                                    this.tmp_texture_buffer16[i + 4] = 0;
                                    this.tmp_texture_buffer16[i + 5] = 0;
                                    this.tmp_texture_buffer16[i + 6] = 0;
                                    this.tmp_texture_buffer16[i + 7] = 0;
                                    x += 4;
                                    i += 8;
                                }
                            }
                            final_buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                            break;
                        }
                        default: {
                            this.error("Unhandled texture storage " + this.context.texture_storage);
                            return;
                        }
                    }
                }
                this.re.setPixelStore(textureBufferWidthInPixels, textureByteAlignment);
                if (compressedTexture) {
                    this.re.setCompressedTexImage(level, buffer_storage, this.context.texture_width[level], this.context.texture_height[level], compressedTextureSize, final_buffer);
                } else {
                    int textureSize = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]) * this.context.texture_height[level] * textureByteAlignment;
                    this.re.setTexImage(level, buffer_storage, this.context.texture_width[level], this.context.texture_height[level], buffer_storage, buffer_storage, textureSize, final_buffer);
                }
                if (State.captureGeNextFrame) {
                    boolean overwriteFile;
                    boolean vramImage = VideoEngine.isVRAM(tex_addr);
                    boolean bl = overwriteFile = !vramImage;
                    if (vramImage || !CaptureManager.isImageCaptured(texaddr)) {
                        CaptureManager.captureImage(texaddr, level, final_buffer, this.context.texture_width[level], this.context.texture_height[level], this.context.texture_buffer_width[level], buffer_storage, compressedTexture, compressedTextureSize, false, overwriteFile);
                    }
                }
                if (texture == null) continue;
                texture.setIsLoaded();
                if (!this.isLogDebugEnabled) continue;
                VideoEngine.log(helper.getCommandString(203) + " Loaded texture " + texture.getGlId());
            }
        } else {
            boolean compressedTexture = this.context.texture_storage >= 8 && this.context.texture_storage <= 10;
            this.re.setTextureMipmapMagFilter(this.context.tex_mag_filter);
            this.re.setTextureMipmapMinFilter(this.context.tex_min_filter);
            this.checkTextureMinFilter(compressedTexture, this.context.texture_num_mip_maps);
            if (this.isLogDebugEnabled) {
                VideoEngine.log(helper.getCommandString(203) + " Reusing cached texture " + texture.getGlId());
            }
        }
        this.textureChanged = false;
    }

    private void checkTextureMinFilter(boolean compressedTexture, int numberMipmaps) {
        int new_tex_min_filter;
        if (compressedTexture && (new_tex_min_filter = this.context.tex_min_filter == 0 || this.context.tex_min_filter == 6 || this.context.tex_min_filter == 4 ? 0 : 1) != this.context.tex_min_filter) {
            this.re.setTextureMipmapMinFilter(new_tex_min_filter);
            if (this.isLogDebugEnabled) {
                VideoEngine.log("Overwriting texture min filter, no mipmap was generated but filter was set to use mipmap");
            }
        }
    }

    private Buffer readIndexedTexture(int level, int texaddr, int texclut, int bytesPerIndex, int textureBufferWidthInPixels) {
        Buffer buffer = null;
        int length = textureBufferWidthInPixels * this.context.texture_height[level];
        switch (this.context.tex_clut_mode) {
            case 0: 
            case 1: 
            case 2: {
                if (texclut == 0) {
                    return null;
                }
                short[] clut = this.readClut16(level);
                if (!this.context.texture_swizzle) {
                    IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, length * bytesPerIndex, bytesPerIndex);
                    for (int i = 0; i < length; ++i) {
                        int index = memoryReader.readNext();
                        this.tmp_texture_buffer16[i] = clut[this.getClutIndex(index)];
                    }
                    buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                    if (!State.captureGeNextFrame) break;
                    log.info((Object)"Capture loadTexture clut 8/16 unswizzled");
                    CaptureManager.captureRAM(texaddr, length * bytesPerIndex);
                    break;
                }
                this.unswizzleTextureFromMemory(texaddr, bytesPerIndex, level, textureBufferWidthInPixels);
                switch (bytesPerIndex) {
                    case 1: {
                        int i = 0;
                        int j = 0;
                        while (i < length) {
                            int n = this.tmp_texture_buffer32[j];
                            int index = n & 0xFF;
                            this.tmp_texture_buffer16[i + 0] = clut[this.getClutIndex(index)];
                            index = n >> 8 & 0xFF;
                            this.tmp_texture_buffer16[i + 1] = clut[this.getClutIndex(index)];
                            index = n >> 16 & 0xFF;
                            this.tmp_texture_buffer16[i + 2] = clut[this.getClutIndex(index)];
                            index = n >> 24 & 0xFF;
                            this.tmp_texture_buffer16[i + 3] = clut[this.getClutIndex(index)];
                            i += 4;
                            ++j;
                        }
                        break;
                    }
                    case 2: {
                        int i = 0;
                        int j = 0;
                        while (i < length) {
                            int n = this.tmp_texture_buffer32[j];
                            this.tmp_texture_buffer16[i + 0] = clut[this.getClutIndex(n & 0xFFFF)];
                            this.tmp_texture_buffer16[i + 1] = clut[this.getClutIndex(n >>> 16)];
                            i += 2;
                            ++j;
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < length; ++i) {
                            int n = this.tmp_texture_buffer32[i];
                            this.tmp_texture_buffer16[i] = clut[this.getClutIndex(n)];
                        }
                        break;
                    }
                }
                buffer = ShortBuffer.wrap(this.tmp_texture_buffer16);
                break;
            }
            case 3: {
                if (texclut == 0) {
                    return null;
                }
                int[] clut = this.readClut32(level);
                if (!this.context.texture_swizzle) {
                    IMemoryReader memoryReader = MemoryReader.getMemoryReader(texaddr, length * bytesPerIndex, bytesPerIndex);
                    for (int i = 0; i < length; ++i) {
                        int index = memoryReader.readNext();
                        this.tmp_texture_buffer32[i] = clut[this.getClutIndex(index)];
                    }
                    buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                    if (!State.captureGeNextFrame) break;
                    log.info((Object)"Capture loadTexture clut 8/32 unswizzled");
                    CaptureManager.captureRAM(texaddr, length * bytesPerIndex);
                    break;
                }
                this.unswizzleTextureFromMemory(texaddr, bytesPerIndex, level, textureBufferWidthInPixels);
                switch (bytesPerIndex) {
                    case 1: {
                        int i = length - 4;
                        int j = length / 4 - 1;
                        while (i >= 0) {
                            int n = this.tmp_texture_buffer32[j];
                            int index = n & 0xFF;
                            this.tmp_texture_buffer32[i + 0] = clut[this.getClutIndex(index)];
                            index = n >> 8 & 0xFF;
                            this.tmp_texture_buffer32[i + 1] = clut[this.getClutIndex(index)];
                            index = n >> 16 & 0xFF;
                            this.tmp_texture_buffer32[i + 2] = clut[this.getClutIndex(index)];
                            index = n >> 24 & 0xFF;
                            this.tmp_texture_buffer32[i + 3] = clut[this.getClutIndex(index)];
                            i -= 4;
                            --j;
                        }
                        break;
                    }
                    case 2: {
                        int i = length - 2;
                        int j = length / 2 - 1;
                        while (i >= 0) {
                            int n = this.tmp_texture_buffer32[j];
                            this.tmp_texture_buffer32[i + 0] = clut[this.getClutIndex(n & 0xFFFF)];
                            this.tmp_texture_buffer32[i + 1] = clut[this.getClutIndex(n >>> 16)];
                            i -= 2;
                            --j;
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < length; ++i) {
                            int n = this.tmp_texture_buffer32[i];
                            this.tmp_texture_buffer32[i] = clut[this.getClutIndex(n)];
                        }
                        break;
                    }
                }
                buffer = IntBuffer.wrap(this.tmp_texture_buffer32);
                break;
            }
            default: {
                this.error("Unhandled clut8 texture mode " + this.context.tex_clut_mode);
            }
        }
        return buffer;
    }

    private void setScissor() {
        if (this.context.scissor_x1 >= 0 && this.context.scissor_y1 >= 0 && this.context.scissor_width <= this.context.region_width && this.context.scissor_height <= this.context.region_height) {
            int scissorX = this.context.scissor_x1;
            int scissorY = this.context.scissor_y1;
            int scissorWidth = this.context.scissor_width;
            int scissorHeight = this.context.scissor_height;
            if (scissorHeight < 272) {
                scissorY = 272 - scissorHeight - scissorY;
            }
            this.re.setScissor(scissorX, scissorY, scissorWidth, scissorHeight);
            this.context.scissorTestFlag.setEnabled(true);
        } else {
            this.context.scissorTestFlag.setEnabled(false);
        }
    }

    private float[] getProjectionMatrix() {
        if (this.context.transform_mode == 1) {
            return null;
        }
        if (this.context.viewport_height <= 0 && this.context.viewport_width >= 0) {
            return this.context.proj_uploaded_matrix;
        }
        float[] flippedMatrix = new float[16];
        System.arraycopy(this.context.proj_uploaded_matrix, 0, flippedMatrix, 0, flippedMatrix.length);
        if (this.context.viewport_height > 0) {
            flippedMatrix[5] = -flippedMatrix[5];
            flippedMatrix[13] = -flippedMatrix[13];
        }
        if (this.context.viewport_width < 0) {
            flippedMatrix[0] = -flippedMatrix[0];
            flippedMatrix[12] = -flippedMatrix[12];
        }
        return flippedMatrix;
    }

    private void initRendering() {
        int i;
        boolean modelViewMatrixChanged;
        if (this.scissorChanged) {
            this.setScissor();
            this.scissorChanged = false;
        }
        if (this.projectionMatrixUpload.isChanged()) {
            this.re.setProjectionMatrix(this.getProjectionMatrix());
            this.projectionMatrixUpload.setChanged(false);
            this.viewportChanged = true;
        }
        boolean loadOrtho2D = false;
        if (this.viewportChanged) {
            if (this.context.transform_mode == 1) {
                this.re.setViewport(0, 0, 480, 272);
                loadOrtho2D = true;
            } else {
                int halfHeight = Math.abs(this.context.viewport_height);
                int halfWidth = Math.abs(this.context.viewport_width);
                int viewportX = this.context.viewport_cx - halfWidth - this.context.offset_x;
                int viewportY = this.context.viewport_cy - halfHeight - this.context.offset_y;
                int viewportWidth = 2 * halfWidth;
                int viewportHeight = 2 * halfHeight;
                viewportY = 272 - viewportY - viewportHeight;
                this.re.setViewport(viewportX, viewportY, viewportWidth, viewportHeight);
            }
            this.viewportChanged = false;
        }
        if (this.depthChanged) {
            if (this.context.transform_mode == 0) {
                this.re.setDepthFunc(this.context.depthFunc);
                this.re.setDepthRange(this.context.zpos, this.context.zscale, this.context.zpos - this.context.zscale, this.context.zpos + this.context.zscale);
            } else {
                this.re.setDepthFunc(this.context.depthFunc);
                this.re.setDepthRange(0.5f, 0.5f, 0.0f, 1.0f);
            }
            this.depthChanged = false;
        }
        if (loadOrtho2D) {
            this.re.setProjectionMatrix(VideoEngine.getOrthoMatrix(0.0f, 480.0f, 272.0f, 0.0f, 0.0f, -65535.0f));
        }
        if (this.context.transform_mode == 1) {
            this.re.disableFlag(10);
            this.re.disableFlag(7);
            this.modelMatrixUpload.setChanged(true);
        } else {
            this.context.lightingFlag.update();
            this.context.fogFlag.update();
        }
        boolean loadLightingSettings = (this.viewMatrixUpload.isChanged() || this.lightingChanged) && this.context.lightingFlag.isEnabled() && this.context.transform_mode == 0;
        boolean bl = modelViewMatrixChanged = this.modelMatrixUpload.isChanged() || this.viewMatrixUpload.isChanged() || loadLightingSettings;
        if (modelViewMatrixChanged) {
            if (this.context.transform_mode == 0) {
                this.re.setViewMatrix(this.context.view_uploaded_matrix);
            } else {
                this.re.setViewMatrix(null);
            }
            this.viewMatrixUpload.setChanged(false);
        }
        if (loadLightingSettings || this.context.tex_map_mode == 2 && !this.context.vinfo.transform2D) {
            for (i = 0; i < 4; ++i) {
                if (!this.context.lightFlags[i].isEnabled() && (this.context.tex_map_mode != 2 || this.context.tex_shade_u != i && this.context.tex_shade_v != i)) continue;
                this.re.setLightPosition(i, this.context.light_pos[i]);
                this.re.setLightDirection(i, this.context.light_dir[i]);
                if (this.context.light_type[i] == 2) {
                    this.re.setLightSpotExponent(i, this.context.spotLightExponent[i]);
                    this.re.setLightSpotCutoff(i, this.context.spotLightCutoff[i]);
                } else {
                    this.re.setLightSpotExponent(i, 0.0f);
                    this.re.setLightSpotCutoff(i, 180.0f);
                }
                if (this.context.light_kind[i] != 0) {
                    this.re.setLightSpecularColor(i, this.context.lightSpecularColor[i]);
                    continue;
                }
                this.re.setLightSpecularColor(i, blackColor);
            }
            this.lightingChanged = false;
        }
        if (modelViewMatrixChanged) {
            if (this.context.transform_mode == 0) {
                this.re.setModelMatrix(this.context.model_uploaded_matrix);
            } else {
                this.re.setModelMatrix(null);
            }
            this.modelMatrixUpload.setChanged(false);
            this.re.endModelViewMatrixUpdate();
        }
        if (this.textureMatrixUpload.isChanged()) {
            if (this.context.transform_mode != 0) {
                this.re.setTextureMapMode(0, 1);
                this.context.reTextureGenS.setEnabled(false);
                this.context.reTextureGenT.setEnabled(false);
                float[] textureMatrix = new float[]{1.0f / (float)this.context.texture_width[0], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / (float)this.context.texture_height[0], 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                if (this.textureFlipped) {
                    textureMatrix[5] = -textureMatrix[5];
                    textureMatrix[13] = this.textureFlipTranslateY;
                    if (this.isLogDebugEnabled) {
                        log.debug((Object)"Flipped 2D");
                    }
                }
                this.re.setTextureMatrix(textureMatrix);
            } else {
                this.re.setTextureMapMode(this.context.tex_map_mode, this.context.tex_proj_map_mode);
                switch (this.context.tex_map_mode) {
                    case 0: {
                        this.context.reTextureGenS.setEnabled(false);
                        this.context.reTextureGenT.setEnabled(false);
                        float[] textureMatrix = new float[]{this.context.tex_scale_x, 0.0f, 0.0f, 0.0f, 0.0f, this.context.tex_scale_y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this.context.tex_translate_x, this.context.tex_translate_y, 0.0f, 1.0f};
                        if (this.textureFlipped) {
                            textureMatrix[5] = -textureMatrix[5];
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)"Flipped TMAP_TEXTURE_MAP_MODE_TEXTURE_COORDIATES_UV");
                            }
                        }
                        this.re.setTextureMatrix(textureMatrix);
                        break;
                    }
                    case 1: {
                        this.context.reTextureGenS.setEnabled(false);
                        this.context.reTextureGenT.setEnabled(false);
                        float[] textureMatrix = this.context.texture_uploaded_matrix;
                        if (this.textureFlipped) {
                            float[] flippedTextureMatrix = new float[]{textureMatrix[0], textureMatrix[1], textureMatrix[2], textureMatrix[3], -textureMatrix[4], -textureMatrix[5], -textureMatrix[6], textureMatrix[7], textureMatrix[8], textureMatrix[9], textureMatrix[10], textureMatrix[11], textureMatrix[12] + textureMatrix[4], textureMatrix[13] + textureMatrix[5], textureMatrix[14] + textureMatrix[6], textureMatrix[15]};
                            textureMatrix = flippedTextureMatrix;
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)"Flipped TMAP_TEXTURE_MAP_MODE_TEXTURE_MATRIX");
                            }
                        }
                        this.re.setTextureMatrix(textureMatrix);
                        break;
                    }
                    case 2: {
                        this.re.setTextureEnvironmentMapping(this.context.tex_shade_u, this.context.tex_shade_v);
                        this.context.reTextureGenS.setEnabled(true);
                        this.context.reTextureGenT.setEnabled(true);
                        for (i = 0; i < 3; ++i) {
                            this.context.tex_envmap_matrix[i + 0] = this.context.light_pos[this.context.tex_shade_u][i];
                            this.context.tex_envmap_matrix[i + 4] = this.context.light_pos[this.context.tex_shade_v][i];
                        }
                        float[] textureMatrix = this.context.tex_envmap_matrix;
                        if (this.textureFlipped) {
                            float[] flippedTextureMatrix = new float[]{textureMatrix[0], textureMatrix[1], textureMatrix[2], textureMatrix[3], -textureMatrix[4], -textureMatrix[5], -textureMatrix[6], textureMatrix[7], textureMatrix[8], textureMatrix[9], textureMatrix[10], textureMatrix[11], textureMatrix[12] + textureMatrix[4], textureMatrix[13] + textureMatrix[5], textureMatrix[14] + textureMatrix[6], textureMatrix[15]};
                            textureMatrix = flippedTextureMatrix;
                            if (this.isLogDebugEnabled) {
                                log.debug((Object)"Flipped TMAP_TEXTURE_MAP_MODE_ENVIRONMENT_MAP");
                            }
                        }
                        this.re.setTextureMatrix(textureMatrix);
                        break;
                    }
                    default: {
                        log.warn((Object)String.format("Unhandled texture matrix mode %d", this.context.tex_map_mode));
                    }
                }
            }
            this.textureMatrixUpload.setChanged(false);
        }
        this.context.useVertexColor = false;
        if (!this.context.lightingFlag.isEnabled() || this.context.transform_mode == 1) {
            this.context.reColorMaterial.setEnabled(false);
            if (this.context.vinfo.color != 0) {
                this.context.useVertexColor = true;
            } else {
                this.re.setVertexColor(this.context.mat_ambient);
            }
        } else if (this.context.vinfo.color != 0 && this.context.mat_flags != 0) {
            this.context.useVertexColor = true;
            if (this.materialChanged) {
                boolean ambient = (this.context.mat_flags & 1) != 0;
                boolean diffuse = (this.context.mat_flags & 2) != 0;
                boolean specular = (this.context.mat_flags & 4) != 0;
                this.re.setColorMaterial(ambient, diffuse, specular);
                this.context.reColorMaterial.setEnabled(true);
                if (!ambient) {
                    this.re.setMaterialAmbientColor(this.context.mat_ambient);
                }
                if (!diffuse) {
                    this.re.setMaterialDiffuseColor(this.context.mat_diffuse);
                }
                if (!specular) {
                    this.re.setMaterialSpecularColor(this.context.mat_specular);
                }
                this.materialChanged = false;
            }
            this.re.setVertexColor(this.context.mat_ambient);
        } else {
            this.context.reColorMaterial.setEnabled(false);
            if (this.materialChanged) {
                this.re.setColorMaterial(false, false, false);
                this.re.setMaterialAmbientColor(this.context.mat_ambient);
                this.re.setMaterialDiffuseColor(this.context.mat_diffuse);
                this.re.setMaterialSpecularColor(this.context.mat_specular);
                this.materialChanged = false;
            }
            this.re.setVertexColor(this.context.mat_ambient);
        }
        if (this.context.textureFlag.isEnabled() && !this.context.clearMode && !this.isBoundingBox) {
            this.re.setTextureWrapMode(this.context.tex_wrap_s, this.context.tex_wrap_t);
            int validNumberMipmaps = this.getValidNumberMipmaps();
            int mipmapBaseLevel = 0;
            int mipmapMaxLevel = validNumberMipmaps;
            if (this.context.tex_mipmap_mode == 1) {
                mipmapBaseLevel = this.context.tex_mipmap_bias_int;
                mipmapMaxLevel = this.context.tex_mipmap_bias_int;
                if (this.isLogDebugEnabled) {
                    log.debug((Object)("TBIAS_MODE_CONST " + this.context.tex_mipmap_bias_int));
                }
            } else if (this.context.tex_mipmap_mode != 0 && this.context.tex_mipmap_mode == 2) {
                mipmapMaxLevel = mipmapBaseLevel = (int)(Math.log(Math.abs(this.context.tslope_level) / Math.abs(this.context.zpos)) / Math.log(2.0) + (double)this.context.tex_mipmap_bias);
                if (this.isLogDebugEnabled) {
                    log.debug((Object)("TBIAS_MODE_SLOPE " + this.context.tex_mipmap_bias + ", slope=" + this.context.tslope_level));
                }
            }
            mipmapBaseLevel = Math.max(0, Math.min(mipmapBaseLevel, validNumberMipmaps));
            mipmapMaxLevel = Math.max(mipmapBaseLevel, Math.min(mipmapMaxLevel, validNumberMipmaps));
            if (this.isLogDebugEnabled) {
                log.debug((Object)String.format("Texture Mipmap base=%d, max=%d, validNumberMipmaps=%d", mipmapBaseLevel, mipmapMaxLevel, validNumberMipmaps));
            }
            this.re.setTextureMipmapMinLevel(mipmapBaseLevel);
            this.re.setTextureMipmapMaxLevel(mipmapMaxLevel);
        }
    }

    private void endRendering(int numberOfVertex) {
        if (this.context.vinfo.index == 0) {
            this.context.vinfo.ptr_vertex = this.context.vinfo.getAddress(Memory.getInstance(), numberOfVertex);
        } else {
            this.context.vinfo.ptr_index += numberOfVertex * this.context.vinfo.index;
        }
    }

    public static float[] getOrthoMatrix(float left, float right, float bottom, float top, float near, float far) {
        float dx = right - left;
        float dy = top - bottom;
        float dz = far - near;
        float[] orthoMatrix = new float[]{2.0f / dx, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f / dy, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f / dz, 0.0f, -(right + left) / dx, -(top + bottom) / dy, -(far + near) / dz, 1.0f};
        return orthoMatrix;
    }

    float spline_n(int i, int j, float u, int[] knot) {
        if (j == 0) {
            if ((float)knot[i] <= u && u < (float)knot[i + 1]) {
                return 1.0f;
            }
            return 0.0f;
        }
        float res = 0.0f;
        if (knot[i + j] - knot[i] != 0) {
            res += (u - (float)knot[i]) / (float)(knot[i + j] - knot[i]) * this.spline_n(i, j - 1, u, knot);
        }
        if (knot[i + j + 1] - knot[i + 1] != 0) {
            res += ((float)knot[i + j + 1] - u) / (float)(knot[i + j + 1] - knot[i + 1]) * this.spline_n(i + 1, j - 1, u, knot);
        }
        return res;
    }

    int[] spline_knot(int n, int type) {
        int[] knot = new int[n + 5];
        for (int i = 0; i < n - 1; ++i) {
            knot[i + 3] = i;
        }
        if ((type & 1) == 0) {
            knot[0] = -3;
            knot[1] = -2;
            knot[2] = -1;
        }
        if ((type & 2) == 0) {
            knot[n + 2] = n - 1;
            knot[n + 3] = n;
            knot[n + 4] = n + 1;
        } else {
            knot[n + 2] = n - 2;
            knot[n + 3] = n - 2;
            knot[n + 4] = n - 2;
        }
        return knot;
    }

    private void drawSpline(int ucount, int vcount, int utype, int vtype) {
        if (ucount < 4 || vcount < 4) {
            log.warn((Object)("Unsupported spline parameters uc=" + ucount + " vc=" + vcount));
            return;
        }
        if (this.context.patch_div_s <= 0 || this.context.patch_div_t <= 0) {
            log.warn((Object)("Unsupported spline patches patch_div_s=" + this.context.patch_div_s + " patch_div_t=" + this.context.patch_div_t));
            return;
        }
        this.initRendering();
        boolean useTexture = this.context.vinfo.texture != 0 || this.context.textureFlag.isEnabled();
        boolean useNormal = this.context.lightingFlag.isEnabled();
        VertexState[][] ctrlpoints = this.getControlPoints(ucount, vcount);
        if (State.captureGeNextFrame && !this.isVertexBufferEmbedded()) {
            log.info((Object)"Capture drawSpline");
            CaptureManager.captureRAM(this.context.vinfo.ptr_vertex, this.context.vinfo.vertexSize * ucount * vcount);
        }
        VertexState[][] patch = new VertexState[this.context.patch_div_s + 1][this.context.patch_div_t + 1];
        int n = ucount - 1;
        int m = vcount - 1;
        int[] knot_u = this.spline_knot(n, utype);
        int[] knot_v = this.spline_knot(m, vtype);
        float limit = 2.000001f;
        for (int j = 0; j <= this.context.patch_div_t; ++j) {
            float v = (float)j * ((float)m - limit) / (float)this.context.patch_div_t;
            for (int i = 0; i <= this.context.patch_div_s; ++i) {
                float u = (float)i * ((float)n - limit) / (float)this.context.patch_div_s;
                patch[i][j] = new VertexState();
                VertexState p = patch[i][j];
                for (int ii = 0; ii <= n; ++ii) {
                    for (int jj = 0; jj <= m; ++jj) {
                        float f = this.spline_n(ii, 3, u, knot_u) * this.spline_n(jj, 3, v, knot_v);
                        if (f == 0.0f) continue;
                        this.pointMultAdd(p, ctrlpoints[ii][jj], f, this.context.useVertexColor, useTexture, useNormal);
                    }
                }
                if (!useTexture || this.context.vinfo.texture != 0) continue;
                p.t[0] = u;
                p.t[1] = v;
            }
        }
        this.drawCurvedSurface(patch, ucount, vcount, this.context.useVertexColor, useTexture, useNormal);
    }

    private void pointMultAdd(VertexState dest, VertexState src, float f, boolean useVertexColor, boolean useTexture, boolean useNormal) {
        dest.p[0] = dest.p[0] + f * src.p[0];
        dest.p[1] = dest.p[1] + f * src.p[1];
        dest.p[2] = dest.p[2] + f * src.p[2];
        if (useTexture) {
            dest.t[0] = dest.t[0] + f * src.t[0];
            dest.t[1] = dest.t[1] + f * src.t[1];
        }
        if (useVertexColor) {
            dest.c[0] = dest.c[0] + f * src.c[0];
            dest.c[1] = dest.c[1] + f * src.c[1];
            dest.c[2] = dest.c[2] + f * src.c[2];
            dest.c[3] = dest.c[3] + f * src.c[3];
        }
        if (useNormal) {
            dest.n[0] = dest.n[0] + f * src.n[0];
            dest.n[1] = dest.n[1] + f * src.n[1];
            dest.n[2] = dest.n[2] + f * src.n[2];
        }
    }

    private void drawBezier(int ucount, int vcount) {
        if ((ucount - 1) % 3 != 0 || (vcount - 1) % 3 != 0) {
            log.warn((Object)("Unsupported bezier parameters ucount=" + ucount + " vcount=" + vcount));
            return;
        }
        if (this.context.patch_div_s <= 0 || this.context.patch_div_t <= 0) {
            log.warn((Object)("Unsupported bezier patches patch_div_s=" + this.context.patch_div_s + " patch_div_t=" + this.context.patch_div_t));
            return;
        }
        this.initRendering();
        boolean useTexture = this.context.vinfo.texture != 0 || this.context.textureFlag.isEnabled();
        boolean useNormal = this.context.lightingFlag.isEnabled();
        VertexState[][] anchors = this.getControlPoints(ucount, vcount);
        if (State.captureGeNextFrame && !this.isVertexBufferEmbedded()) {
            log.info((Object)"Capture drawBezier");
            CaptureManager.captureRAM(this.context.vinfo.ptr_vertex, this.context.vinfo.vertexSize * ucount * vcount);
        }
        VertexState[][] patch = new VertexState[this.context.patch_div_s + 1][this.context.patch_div_t + 1];
        int upcount = ucount / 3;
        int vpcount = vcount / 3;
        float[][] ucoeff = new float[this.context.patch_div_s + 1][];
        for (int j = 0; j <= this.context.patch_div_t; ++j) {
            float vglobal = (float)j * (float)vpcount / (float)this.context.patch_div_t;
            int vpatch = (int)vglobal;
            float v = vglobal - (float)vpatch;
            if (j == this.context.patch_div_t) {
                --vpatch;
                v = 1.0f;
            }
            float[] vcoeff = this.BernsteinCoeff(v);
            for (int i = 0; i <= this.context.patch_div_s; ++i) {
                VertexState p;
                float uglobal = (float)i * (float)upcount / (float)this.context.patch_div_s;
                int upatch = (int)uglobal;
                float u = uglobal - (float)upatch;
                if (i == this.context.patch_div_s) {
                    --upatch;
                    u = 1.0f;
                }
                ucoeff[i] = this.BernsteinCoeff(u);
                patch[i][j] = p = new VertexState();
                for (int ii = 0; ii < 4; ++ii) {
                    for (int jj = 0; jj < 4; ++jj) {
                        this.pointMultAdd(p, anchors[3 * upatch + ii][3 * vpatch + jj], ucoeff[i][ii] * vcoeff[jj], this.context.useVertexColor, useTexture, useNormal);
                    }
                }
                if (!useTexture || this.context.vinfo.texture != 0) continue;
                p.t[0] = uglobal;
                p.t[1] = vglobal;
            }
        }
        this.drawCurvedSurface(patch, ucount, vcount, this.context.useVertexColor, useTexture, useNormal);
    }

    private void drawCurvedSurface(VertexState[][] patch, int ucount, int vcount, boolean useVertexColor, boolean useTexture, boolean useNormal) {
        if (this.re.isVertexArrayAvailable()) {
            this.re.bindVertexArray(0);
        }
        int type = this.patch_prim_types[this.context.patch_prim];
        this.re.setVertexInfo(this.context.vinfo, false, useVertexColor, useTexture, type);
        this.setDataPointers(3, useVertexColor, 4, useTexture, 2, useNormal, 0, true);
        ByteBuffer drawByteBuffer = this.bufferManager.getBuffer(this.bufferId);
        drawByteBuffer.clear();
        FloatBuffer drawFloatBuffer = drawByteBuffer.asFloatBuffer();
        for (int j = 0; j <= this.context.patch_div_t - 1; ++j) {
            drawFloatBuffer.clear();
            for (int i = 0; i <= this.context.patch_div_s; ++i) {
                VertexState v1 = patch[i][j];
                VertexState v2 = patch[i][j + 1];
                if (useTexture) {
                    drawFloatBuffer.put(v1.t);
                }
                if (useVertexColor) {
                    drawFloatBuffer.put(v1.c);
                }
                if (useNormal) {
                    drawFloatBuffer.put(v1.n);
                }
                drawFloatBuffer.put(v1.p);
                if (useTexture) {
                    drawFloatBuffer.put(v2.t);
                }
                if (useVertexColor) {
                    drawFloatBuffer.put(v2.c);
                }
                if (useNormal) {
                    drawFloatBuffer.put(v2.n);
                }
                drawFloatBuffer.put(v2.p);
            }
            this.bufferManager.setBufferData(this.bufferId, drawFloatBuffer.position() * SIZEOF_FLOAT, drawByteBuffer.rewind(), 0);
            this.drawArraysStatistics.start();
            this.re.drawArrays(type, 0, (this.context.patch_div_s + 1) * 2);
            this.drawArraysStatistics.end();
        }
        if (State.captureGeNextFrame) {
            this.display.captureGeImage();
            this.textureChanged = true;
        }
        this.endRendering(ucount * vcount);
    }

    private VertexState[][] getControlPoints(int ucount, int vcount) {
        VertexState[][] controlPoints = new VertexState[ucount][vcount];
        boolean readTexture = this.context.textureFlag.isEnabled();
        Memory mem = Memory.getInstance();
        for (int u = 0; u < ucount; ++u) {
            for (int v = 0; v < vcount; ++v) {
                int addr = this.context.vinfo.getAddress(mem, v * ucount + u);
                VertexState vs = this.context.vinfo.readVertex(mem, addr, readTexture);
                if (this.isLogDebugEnabled) {
                    VideoEngine.log(String.format("control point #%d,%d p(%f,%f,%f) t(%f,%f), c(0x%08X)", u, v, Float.valueOf(vs.p[0]), Float.valueOf(vs.p[1]), Float.valueOf(vs.p[2]), Float.valueOf(vs.t[0]), Float.valueOf(vs.t[1]), PixelColor.getColor(vs.c)));
                }
                controlPoints[u][v] = vs;
            }
        }
        return controlPoints;
    }

    private float[] BernsteinCoeff(float u) {
        float uPow2 = u * u;
        float uPow3 = uPow2 * u;
        float u1 = 1.0f - u;
        float u1Pow2 = u1 * u1;
        float u1Pow3 = u1Pow2 * u1;
        return new float[]{u1Pow3, 3.0f * u * u1Pow2, 3.0f * uPow2 * u1, uPow3};
    }

    private Buffer getTextureBuffer(int texaddr, int bytesPerPixel, int level, int textureBufferWidthInPixels) {
        Buffer final_buffer = null;
        if (!this.context.texture_swizzle) {
            int bufferlen = Math.max(textureBufferWidthInPixels, this.context.texture_width[level]) * this.context.texture_height[level] * bytesPerPixel;
            final_buffer = Memory.getInstance().getBuffer(texaddr, bufferlen);
            if (State.captureGeNextFrame) {
                log.info((Object)"Capture getTextureBuffer unswizzled");
                CaptureManager.captureRAM(texaddr, bufferlen);
            }
        } else {
            final_buffer = this.unswizzleTextureFromMemory(texaddr, bytesPerPixel, level, textureBufferWidthInPixels);
        }
        return final_buffer;
    }

    public static final String getPsmName(int psm) {
        return psm >= 0 && psm < psm_names.length ? psm_names[psm % psm_names.length] : "PSM_UNKNOWN" + psm;
    }

    public static final String getLOpName(int ops) {
        return ops >= 0 && ops < logical_ops_names.length ? logical_ops_names[ops % logical_ops_names.length] : "UNKNOWN_LOP" + ops;
    }

    private int getCompressedTextureSize(int level, int compressionRatio) {
        return VideoEngine.getCompressedTextureSize(this.context.texture_width[level], this.context.texture_height[level], compressionRatio);
    }

    public static int getCompressedTextureSize(int width, int height, int compressionRatio) {
        int compressedTextureWidth = (width + 3) / 4 * 4;
        int compressedTextureHeight = (height + 3) / 4 * 4;
        int compressedTextureSize = compressedTextureWidth * compressedTextureHeight * 4 / compressionRatio;
        return compressedTextureSize;
    }

    private void updateGeBuf() {
        if (this.geBufChanged) {
            this.display.hleDisplaySetGeBuf(this.context.fbp, this.context.fbw, this.context.psm, this.somethingDisplayed, this.forceLoadGEToScreen);
            TextureCache.getInstance().deleteVramTextures(this.re, this.context.fbp, this.context.fbw * this.context.scissor_y2 * IRenderingEngine.sizeOfTextureType[this.context.psm]);
            this.forceLoadGEToScreen = false;
            this.geBufChanged = false;
            this.textureChanged = true;
            this.maxSpriteHeight = 0;
            this.maxSpriteWidth = 0;
            this.projectionMatrixUpload.setChanged(true);
            this.modelMatrixUpload.setChanged(true);
            this.viewMatrixUpload.setChanged(true);
            this.textureMatrixUpload.setChanged(true);
            this.viewportChanged = true;
            this.depthChanged = true;
            this.materialChanged = true;
        }
    }

    public int getFBP() {
        return this.context.fbp;
    }

    public int getFBW() {
        return this.context.fbw;
    }

    public int getZBP() {
        return this.context.zbp;
    }

    public int getZBW() {
        return this.context.zbw;
    }

    public int getPSM() {
        return this.context.psm;
    }

    private boolean isVertexBufferEmbedded() {
        return this.context.vinfo.ptr_vertex >= this.currentList.list_addr && this.context.vinfo.ptr_vertex < this.currentList.getStallAddr();
    }

    public static boolean isVRAM(int addr) {
        return (addr &= 0x3FFFFFFF) >= 0x4000000 && addr <= 0x41FFFFF;
    }

    public int getClutNumEntries() {
        return Integer.highestOneBit(this.context.tex_clut_mask | this.context.tex_clut_start << 4) << 1;
    }

    private void hlePerformAction(IAction action, Semaphore sync) {
        this.hleAction = action;
        while (true) {
            try {
                sync.acquire();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void hleSaveContext(int addr) {
        if (this.hasDrawLists() || this.currentList != null) {
            Semaphore sync = new Semaphore(0);
            this.hlePerformAction(new SaveContextAction(addr, sync), sync);
        } else {
            this.saveContext(addr);
        }
    }

    public void hleRestoreContext(int addr) {
        if (this.hasDrawLists() || this.currentList != null) {
            Semaphore sync = new Semaphore(0);
            this.hlePerformAction(new RestoreContextAction(addr, sync), sync);
        } else {
            this.restoreContext(addr);
        }
    }

    private void saveContext(int addr) {
        this.context.write(Memory.getInstance(), addr);
    }

    private void restoreContext(int addr) {
        this.context.read(Memory.getInstance(), addr);
        this.context.setDirty();
        this.projectionMatrixUpload.setChanged(true);
        this.modelMatrixUpload.setChanged(true);
        this.viewMatrixUpload.setChanged(true);
        this.textureMatrixUpload.setChanged(true);
        this.lightingChanged = true;
        this.textureChanged = true;
        this.geBufChanged = true;
        this.viewportChanged = true;
        this.depthChanged = true;
        this.materialChanged = true;
    }

    public boolean isUsingTRXKICK() {
        return this.usingTRXKICK;
    }

    public int getMaxSpriteHeight() {
        return this.maxSpriteHeight;
    }

    public int getMaxSpriteWidth() {
        return this.maxSpriteWidth;
    }

    private void setUseVertexCache(boolean useVertexCache) {
        if (this.bufferManager != null && !this.bufferManager.useVBO()) {
            useVertexCache = false;
        }
        this.useVertexCache = useVertexCache;
        if (useVertexCache) {
            if (this.useAsyncVertexCache) {
                AsyncVertexCache.getInstance();
                if (this.useOptimisticVertexCache) {
                    log.info((Object)"Using Optimistic Async Vertex Cache");
                } else {
                    log.info((Object)"Using Async Vertex Cache");
                }
            } else {
                VertexCache.getInstance();
                if (this.useOptimisticVertexCache) {
                    log.info((Object)"Using Optimistic Vertex Cache");
                } else {
                    log.info((Object)"Using Vertex Cache");
                }
            }
        }
    }

    public boolean useAsyncVertexCache() {
        return this.useVertexCache && this.useAsyncVertexCache;
    }

    public boolean disableOptimizedVertexInfoReading() {
        return this.disableOptimizedVertexInfoReading;
    }

    private void setDisableOptimizedVertexInfoReading(boolean disableOptimizedVertexInfoReading) {
        this.disableOptimizedVertexInfoReading = disableOptimizedVertexInfoReading;
        if (disableOptimizedVertexInfoReading) {
            log.info((Object)"Using non-optimized VertexInfo reading");
        }
    }

    public int getBase() {
        return this.context.base;
    }

    public void setBase(int base) {
        this.context.base = base;
    }

    public int getBaseOffset() {
        return this.context.baseOffset;
    }

    public void setBaseOffset(int baseOffset) {
        this.context.baseOffset = baseOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoTexture(int startAddress, int endAddress) {
        LinkedList<AddressRange> linkedList = this.videoTextures;
        synchronized (linkedList) {
            for (AddressRange addressRange : this.videoTextures) {
                if (!addressRange.equals(startAddress, endAddress)) continue;
                return;
            }
            AddressRange addressRange = new AddressRange(startAddress, endAddress);
            this.videoTextures.add(addressRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetVideoTextures() {
        LinkedList<AddressRange> linkedList = this.videoTextures;
        synchronized (linkedList) {
            this.videoTextures.clear();
        }
    }

    public boolean isUseTextureAnisotropicFilter() {
        return this.useTextureAnisotropicFilter;
    }

    public void setUseTextureAnisotropicFilter(boolean useTextureAnisotropicFilter) {
        this.useTextureAnisotropicFilter = useTextureAnisotropicFilter;
    }

    public void setSkipThisFrame(boolean skipThisFrame) {
        this.skipThisFrame = skipThisFrame;
    }

    public boolean isSkipThisFrame() {
        return this.skipThisFrame;
    }

    static {
        log = Logger.getLogger((String)"ge");
        blackColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        drawBufferSize = 0x200000 * SIZEOF_FLOAT;
    }

    private static class AddressRange {
        private int start;
        private int end;

        public AddressRange(int start, int end) {
            this.start = start & 0x3FFFFFFF;
            this.end = end & 0x3FFFFFFF;
        }

        public boolean contains(int address) {
            return (address &= 0x3FFFFFFF) >= this.start && address < this.end;
        }

        public boolean equals(int start, int end) {
            return (start &= 0x3FFFFFFF) == this.start && (end &= 0x3FFFFFFF) == this.end;
        }
    }

    private class RestoreContextAction
    implements IAction {
        private int addr;
        private Semaphore sync;

        public RestoreContextAction(int addr, Semaphore sync) {
            this.addr = addr;
            this.sync = sync;
        }

        @Override
        public void execute() {
            VideoEngine.this.restoreContext(this.addr);
            VideoEngine.this.context.update();
            this.sync.release();
        }
    }

    private class SaveContextAction
    implements IAction {
        private int addr;
        private Semaphore sync;

        public SaveContextAction(int addr, Semaphore sync) {
            this.addr = addr;
            this.sync = sync;
        }

        @Override
        public void execute() {
            VideoEngine.this.saveContext(this.addr);
            this.sync.release();
        }
    }

    private class DisableOptimizedVertexInfoReadingListener
    extends AbstractBoolSettingsListener {
        private DisableOptimizedVertexInfoReadingListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            VideoEngine.this.setDisableOptimizedVertexInfoReading(value);
        }
    }

    private class UseTextureAnisotropicFilterSettingsListerner
    extends AbstractBoolSettingsListener {
        private UseTextureAnisotropicFilterSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            VideoEngine.this.setUseTextureAnisotropicFilter(value);
        }
    }

    private class UseVertexCacheSettingsListerner
    extends AbstractBoolSettingsListener {
        private UseVertexCacheSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            VideoEngine.this.setUseVertexCache(value);
        }
    }

    public static class MatrixUpload {
        private final float[] matrix;
        private boolean changed = true;
        private int[] matrixIndex;
        private int index;
        private int maxIndex;

        public MatrixUpload(float[] matrix, int matrixWidth, int matrixHeight) {
            this.matrix = matrix;
            for (int y = 0; y < 4; ++y) {
                for (int x = 0; x < 4; ++x) {
                    matrix[y * 4 + x] = x == y ? 1 : 0;
                }
            }
            this.maxIndex = matrixWidth * matrixHeight;
            this.matrixIndex = new int[this.maxIndex];
            for (int i = 0; i < this.maxIndex; ++i) {
                this.matrixIndex[i] = i % matrixWidth + i / matrixWidth * 4;
            }
        }

        public void startUpload(int startIndex) {
            this.index = startIndex;
        }

        public final boolean uploadValue(float value) {
            if (this.index >= this.maxIndex) {
                if (VideoEngine.getInstance().isLogDebugEnabled) {
                    VideoEngine.log(String.format("Ignored Matrix upload value (idx=%08X)", this.index));
                }
            } else {
                int i = this.matrixIndex[this.index];
                if (this.matrix[i] != value) {
                    this.matrix[i] = value;
                    this.changed = true;
                }
            }
            ++this.index;
            return this.index >= this.maxIndex;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setChanged(boolean changed) {
            this.changed = changed;
        }
    }
}

