/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import jpcsp.Memory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryReaderWriter;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;

public class MemoryReaderWriter {
    private static IMemoryReaderWriter getFastMemoryReaderWriter(FastMemory mem, int address, int step) {
        int[] memoryInt = mem.getAll();
        switch (step) {
            case 2: {
                return new MemoryReaderWriterIntArray16(memoryInt, address);
            }
            case 4: {
                return new MemoryReaderWriterIntArray32(memoryInt, address);
            }
        }
        return new MemoryReaderWriterGeneric(address, step);
    }

    public static IMemoryReaderWriter getMemoryReaderWriter(int address, int length, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryReaderWriter.getFastMemoryReaderWriter((FastMemory)mem, address, step);
        }
        return new MemoryReaderWriterGeneric(address, length, step);
    }

    public static IMemoryReaderWriter getMemoryReaderWriter(int address, int step) {
        Memory mem = Memory.getInstance();
        address &= 0x3FFFFFFF;
        if (mem instanceof FastMemory) {
            return MemoryReaderWriter.getFastMemoryReaderWriter((FastMemory)mem, address, step);
        }
        return new MemoryReaderWriterGeneric(address, step);
    }

    private static final class MemoryReaderWriterIntArray16
    implements IMemoryReaderWriter {
        private int index;
        private int offset;
        private int value;
        private final int[] buffer;

        public MemoryReaderWriterIntArray16(int[] buffer, int addr) {
            this.buffer = buffer;
            this.offset = addr >> 2;
            this.index = addr >> 1 & 1;
            if (this.index != 0) {
                this.value = buffer[this.offset] & 0xFFFF;
            }
        }

        @Override
        public void writeNext(int n) {
            if (this.index == 0) {
                this.value = n & 0xFFFF;
                this.index = 1;
            } else {
                this.buffer[this.offset++] = n << 16 | this.value;
                this.index = 0;
            }
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                this.flush();
                this.index += n;
                this.offset += this.index >> 1;
                this.index &= 1;
                if (this.index != 0) {
                    this.value = this.buffer[this.offset] & 0xFFFF;
                }
            }
        }

        @Override
        public void flush() {
            if (this.index != 0) {
                this.buffer[this.offset] = this.buffer[this.offset] & 0xFFFF0000 | this.value;
            }
        }

        @Override
        public int getCurrentAddress() {
            return (this.offset << 2) + (this.index << 1);
        }

        @Override
        public int readCurrent() {
            if (this.index == 0) {
                return this.buffer[this.offset] & 0xFFFF;
            }
            return this.buffer[this.offset] >>> 16;
        }
    }

    private static final class MemoryReaderWriterIntArray32
    implements IMemoryReaderWriter {
        private int offset;
        private final int[] buffer;

        public MemoryReaderWriterIntArray32(int[] buffer, int addr) {
            this.offset = addr >> 2;
            this.buffer = buffer;
        }

        @Override
        public void writeNext(int value) {
            this.buffer[this.offset++] = value;
        }

        @Override
        public void skip(int n) {
            this.offset += n;
        }

        @Override
        public void flush() {
        }

        @Override
        public int getCurrentAddress() {
            return this.offset << 2;
        }

        @Override
        public int readCurrent() {
            return this.buffer[this.offset];
        }
    }

    private static final class MemoryReaderWriterGeneric
    implements IMemoryReaderWriter {
        private IMemoryReader memoryReader;
        private IMemoryWriter memoryWriter;
        private int currentValue;

        public MemoryReaderWriterGeneric(int address, int length, int step) {
            this.memoryReader = MemoryReader.getMemoryReader(address, length, step);
            this.memoryWriter = MemoryWriter.getMemoryWriter(address, length, step);
            this.currentValue = this.memoryReader.readNext();
        }

        public MemoryReaderWriterGeneric(int address, int step) {
            this.memoryReader = MemoryReader.getMemoryReader(address, step);
            this.memoryWriter = MemoryWriter.getMemoryWriter(address, step);
            this.currentValue = this.memoryReader.readNext();
        }

        @Override
        public void writeNext(int value) {
            this.memoryWriter.writeNext(value);
            this.currentValue = this.memoryReader.readNext();
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                this.memoryWriter.skip(n);
                this.memoryReader.skip(n - 1);
                this.currentValue = this.memoryReader.readNext();
            }
        }

        @Override
        public void flush() {
            this.memoryWriter.flush();
        }

        @Override
        public int getCurrentAddress() {
            return this.memoryWriter.getCurrentAddress();
        }

        @Override
        public int readCurrent() {
            return this.currentValue;
        }
    }
}

