/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

public class MemorySection {
    private int baseAddress;
    private int length;
    private boolean read;
    private boolean write;
    private boolean execute;

    public MemorySection(int baseAddress, int length, boolean read, boolean write, boolean execute) {
        this.baseAddress = baseAddress & 0x3FFFFFFF;
        this.length = length;
        this.read = read;
        this.write = write;
        this.execute = execute;
    }

    public int getBaseAddress() {
        return this.baseAddress;
    }

    public int getEndAddress() {
        return this.baseAddress + this.length - 1;
    }

    public int getLength() {
        return this.length;
    }

    public boolean canRead() {
        return this.read;
    }

    public boolean canWrite() {
        return this.write;
    }

    public boolean canExecute() {
        return this.execute;
    }

    public boolean contains(int address) {
        return this.getBaseAddress() <= (address &= 0x3FFFFFFF) && address <= this.getEndAddress();
    }

    public String toString() {
        return String.format("MemorySection[0x%08X-0x%08X(length=0x%X) %s%s%s]", this.getBaseAddress(), this.getEndAddress(), this.getLength(), this.canRead() ? "R" : "", this.canWrite() ? "W" : "", this.canExecute() ? "X" : "");
    }
}

