/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.adhoc;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.Memory;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocBufferMessage;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocObject;
import jpcsp.util.Utilities;

public abstract class PdpObject
extends AdhocObject {
    private pspNetMacAddress macAddress;
    protected int rcvdData;
    private LinkedList<AdhocBufferMessage> rcvdMessages = new LinkedList();
    protected static final int BLOCKED_OPERATION_POLLING_MICROS = 10000;

    public PdpObject(INetworkAdapter networkAdapter) {
        super(networkAdapter);
    }

    public PdpObject(PdpObject pdpObject) {
        super(pdpObject);
        this.macAddress = pdpObject.macAddress;
    }

    public pspNetMacAddress getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(pspNetMacAddress macAddress) {
        this.macAddress = macAddress;
    }

    public int getRcvdData() {
        return this.rcvdData;
    }

    public int create(pspNetMacAddress macAddress, int port, int bufSize) {
        int result = this.getId();
        this.setMacAddress(macAddress);
        this.setPort(port);
        this.setBufSize(bufSize);
        try {
            this.openSocket();
        }
        catch (BindException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"create", (Throwable)e);
            }
            result = -2143222006;
        }
        catch (SocketException e) {
            log.error((Object)"create", (Throwable)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)"create", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"create", (Throwable)e);
        }
        return result;
    }

    public int send(pspNetMacAddress destMacAddress, int destPort, TPointer data, int length, int timeout, int nonblock) {
        int result = 0;
        try {
            this.openSocket();
            this.setTimeout(timeout, nonblock);
            AdhocMessage adhocMessage = this.networkAdapter.createAdhocPdpMessage(data.getAddress(), length, destMacAddress.macAddress);
            this.send(adhocMessage, destPort);
        }
        catch (SocketException e) {
            log.error((Object)"send", (Throwable)e);
        }
        catch (UnknownHostException e) {
            result = -2143222014;
            log.error((Object)"send", (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            log.error((Object)"send", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"send", (Throwable)e);
        }
        return result;
    }

    private void addReceivedMessage(AdhocMessage adhocMessage, int port) {
        AdhocBufferMessage bufferMessage = new AdhocBufferMessage();
        bufferMessage.length = adhocMessage.getDataLength();
        bufferMessage.macAddress.setMacAddress(adhocMessage.getFromMacAddress());
        bufferMessage.port = Modules.sceNetAdhocModule.getClientPortFromRealPort(adhocMessage.getFromMacAddress(), port);
        bufferMessage.offset = this.rcvdData;
        adhocMessage.writeDataToMemory(this.buffer.addr + bufferMessage.offset);
        Modules.sceNetAdhocctlModule.hleNetAdhocctlPeerUpdateTimestamp(adhocMessage.getFromMacAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Successfully received %d bytes from %s on port %d(%d)", bufferMessage.length, bufferMessage.macAddress, bufferMessage.port, port));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Message data: %s", Utilities.getMemoryDump(this.buffer.addr + bufferMessage.offset, bufferMessage.length)));
            }
        }
        this.rcvdData += bufferMessage.length;
        this.rcvdMessages.add(bufferMessage);
    }

    private void removeFirstReceivedMessage() {
        AdhocBufferMessage bufferMessage = this.rcvdMessages.removeFirst();
        if (bufferMessage == null) {
            return;
        }
        if (this.rcvdData > bufferMessage.length) {
            Memory.getInstance().memcpy(this.buffer.addr, this.buffer.addr + bufferMessage.length, this.rcvdData - bufferMessage.length);
            for (AdhocBufferMessage rcvdMessage : this.rcvdMessages) {
                rcvdMessage.offset -= bufferMessage.length;
            }
        }
        this.rcvdData -= bufferMessage.length;
    }

    public int recv(TPointer srcMacAddr, TPointer16 portAddr, TPointer data, TPointer32 dataLengthAddr, int timeout, int nonblock) {
        int result = 0;
        try {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (this.pollRecv(srcMacAddr, portAddr, data, dataLengthAddr, thread)) {
                result = thread.cpuContext.gpr[2];
            } else if (nonblock != 0) {
                result = -2143222007;
            } else {
                BlockedPdpRecv blockedPdpAction = new BlockedPdpRecv(this, srcMacAddr, portAddr, data, dataLengthAddr, timeout);
                blockedPdpAction.blockCurrentThread();
            }
        }
        catch (IOException e) {
            result = -2143222004;
            log.error((Object)"recv", (Throwable)e);
        }
        return result;
    }

    public boolean pollRecv(TPointer srcMacAddr, TPointer16 portAddr, TPointer data, TPointer32 dataLengthAddr, SceKernelThreadInfo thread) throws IOException {
        int length = dataLengthAddr.getValue();
        boolean completed = false;
        if (this.rcvdMessages.isEmpty()) {
            this.update();
        }
        if (!this.rcvdMessages.isEmpty()) {
            AdhocBufferMessage bufferMessage = this.rcvdMessages.getFirst();
            if (length < bufferMessage.length) {
                dataLengthAddr.setValue(bufferMessage.length);
                PdpObject.setReturnValue(thread, -2143287546);
            } else {
                dataLengthAddr.setValue(bufferMessage.length);
                Memory.getInstance().memcpy(data.getAddress(), this.buffer.addr + bufferMessage.offset, bufferMessage.length);
                if (srcMacAddr != null && !srcMacAddr.isNull()) {
                    bufferMessage.macAddress.write(Memory.getInstance(), srcMacAddr.getAddress());
                }
                if (portAddr != null && !portAddr.isNull()) {
                    portAddr.setValue(bufferMessage.port);
                }
                this.removeFirstReceivedMessage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Returned received data: %d bytes from %s on port %d", dataLengthAddr.getValue(), bufferMessage.macAddress, portAddr.getValue()));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Returned data: %s", Utilities.getMemoryDump(data.getAddress(), dataLengthAddr.getValue())));
                    }
                }
                PdpObject.setReturnValue(thread, 0);
            }
            completed = true;
        }
        return completed;
    }

    public void update() throws IOException {
        while (this.rcvdData < this.getBufSize()) {
            try {
                this.openSocket();
                this.socket.setTimeout(1);
                byte[] bytes = new byte[this.getBufSize() - this.rcvdData + 13];
                int length = this.socket.receive(bytes, bytes.length);
                int receivedPort = this.socket.getReceivedPort();
                InetAddress receivedAddress = this.socket.getReceivedAddress();
                AdhocMessage adhocMessage = this.createAdhocMessage(bytes, length);
                if (this.isForMe(adhocMessage, receivedPort, receivedAddress)) {
                    if (this.getRcvdData() + adhocMessage.getDataLength() <= this.getBufSize()) {
                        this.addReceivedMessage(adhocMessage, receivedPort);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Discarded message, receive buffer full (%d of %d): %s", this.getRcvdData(), this.getBufSize(), adhocMessage));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Received message not for me: %s", adhocMessage));
            }
            catch (SocketException e) {
                log.error((Object)"update", (Throwable)e);
                break;
            }
            catch (SocketTimeoutException e) {
                break;
            }
        }
    }

    protected AdhocMessage createAdhocMessage(byte[] message, int length) {
        return this.networkAdapter.createAdhocPdpMessage(message, length);
    }

    protected boolean isForMe(AdhocMessage adhocMessage, int port, InetAddress address) {
        return adhocMessage.isForMe();
    }

    protected static void setReturnValue(SceKernelThreadInfo thread, int value) {
        thread.cpuContext.gpr[2] = value;
    }

    public String toString() {
        return String.format("PdpObject[id=%d, macAddress=%s, port=%d, bufSize=%d, rcvdData=%d]", this.getId(), this.macAddress, this.getPort(), this.getBufSize(), this.rcvdData);
    }

    protected static class BlockedPdpRecv
    extends BlockedPdpAction {
        protected final TPointer srcMacAddr;
        protected final TPointer16 portAddr;
        protected final TPointer data;
        protected final TPointer32 dataLengthAddr;

        public BlockedPdpRecv(PdpObject pdpObject, TPointer srcMacAddr, TPointer16 portAddr, TPointer data, TPointer32 dataLengthAddr, long timeout) {
            super(pdpObject, timeout);
            this.srcMacAddr = srcMacAddr;
            this.portAddr = portAddr;
            this.data = data;
            this.dataLengthAddr = dataLengthAddr;
        }

        @Override
        protected boolean poll() throws IOException {
            return this.pdpObject.pollRecv(this.srcMacAddr, this.portAddr, this.data, this.dataLengthAddr, this.thread);
        }

        @Override
        protected int getExceptionResult(IOException e) {
            return -2143221995;
        }
    }

    protected static abstract class BlockedPdpAction
    implements IAction {
        protected final PdpObject pdpObject;
        protected final long timeoutMicros;
        protected final int threadUid;
        protected final SceKernelThreadInfo thread;

        public BlockedPdpAction(PdpObject pdpObject, long timeout) {
            this.pdpObject = pdpObject;
            this.timeoutMicros = Emulator.getClock().microTime() + timeout;
            this.threadUid = Modules.ThreadManForUserModule.getCurrentThreadID();
            this.thread = Modules.ThreadManForUserModule.getThreadById(this.threadUid);
            if (AdhocObject.log.isDebugEnabled()) {
                AdhocObject.log.debug((Object)String.format("BlockedPdpAction for thread %s", this.thread));
            }
        }

        public void blockCurrentThread() {
            long schedule = Emulator.getClock().microTime() + 10000L;
            Emulator.getScheduler().addAction(schedule, this);
            Modules.ThreadManForUserModule.hleBlockCurrentThread();
        }

        @Override
        public void execute() {
            if (AdhocObject.log.isDebugEnabled()) {
                AdhocObject.log.debug((Object)String.format("BlockedPdpAction: poll on %s, thread %s", this.pdpObject, this.thread));
            }
            try {
                if (this.poll()) {
                    if (AdhocObject.log.isDebugEnabled()) {
                        AdhocObject.log.debug((Object)String.format("BlockedPdpAction: unblocking thread %s", this.thread));
                    }
                    Modules.ThreadManForUserModule.hleUnblockThread(this.threadUid);
                } else {
                    long now = Emulator.getClock().microTime();
                    if (now >= this.timeoutMicros) {
                        if (AdhocObject.log.isDebugEnabled()) {
                            AdhocObject.log.debug((Object)String.format("BlockedPdpAction: timeout for thread %s", this.thread));
                        }
                        PdpObject.setReturnValue(this.thread, -2143221995);
                        Modules.ThreadManForUserModule.hleUnblockThread(this.threadUid);
                    } else {
                        if (AdhocObject.log.isDebugEnabled()) {
                            AdhocObject.log.debug((Object)String.format("BlockedPdpAction: continue polling", new Object[0]));
                        }
                        long schedule = now + 10000L;
                        Emulator.getScheduler().addAction(schedule, this);
                    }
                }
            }
            catch (IOException e) {
                PdpObject.setReturnValue(this.thread, this.getExceptionResult(e));
                AdhocObject.log.error((Object)this.getClass().getSimpleName(), (Throwable)e);
            }
        }

        protected abstract boolean poll() throws IOException;

        protected abstract int getExceptionResult(IOException var1);
    }
}

