/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import jpcsp.Allegrex.GprState;

public class MduState
extends GprState {
    public long hilo;

    public void setHi(int value) {
        this.hilo = this.hilo & 0xFFFFFFFFL | (long)value << 32;
    }

    public int getHi() {
        return (int)(this.hilo >>> 32);
    }

    public void setLo(int value) {
        this.hilo = this.hilo & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL;
    }

    public int getLo() {
        return (int)(this.hilo & 0xFFFFFFFFL);
    }

    @Override
    public void reset() {
        this.hilo = 0L;
    }

    @Override
    public void resetAll() {
        super.resetAll();
        this.hilo = 0L;
    }

    public MduState() {
        this.hilo = 0L;
    }

    public void copy(MduState that) {
        super.copy(that);
        this.hilo = that.hilo;
    }

    public MduState(MduState that) {
        super(that);
        this.hilo = that.hilo;
    }

    public static final long signedDivMod(int x, int y) {
        return (long)(x % y) << 32 | (long)(x / y) & 0xFFFFFFFFL;
    }

    public static final long unsignedDivMod(long x, long y) {
        return x % y << 32 | x / y & 0xFFFFFFFFL;
    }

    public final void doMFHI(int rd) {
        if (rd != 0) {
            this.gpr[rd] = this.getHi();
        }
    }

    public final void doMTHI(int rs) {
        int hi = this.gpr[rs];
        this.hilo = (long)hi << 32 | this.hilo & 0xFFFFFFFFL;
    }

    public final void doMFLO(int rd) {
        if (rd != 0) {
            this.gpr[rd] = this.getLo();
        }
    }

    public final void doMTLO(int rs) {
        int lo = this.gpr[rs];
        this.hilo = this.hilo & 0xFFFFFFFF00000000L | (long)lo & 0xFFFFFFFFL;
    }

    public final void doMULT(int rs, int rt) {
        this.hilo = (long)this.gpr[rs] * (long)this.gpr[rt];
    }

    public final void doMULTU(int rs, int rt) {
        this.hilo = ((long)this.gpr[rs] & 0xFFFFFFFFL) * ((long)this.gpr[rt] & 0xFFFFFFFFL);
    }

    public final void doDIV(int rs, int rt) {
        if (this.gpr[rt] != 0) {
            int lo = this.gpr[rs] / this.gpr[rt];
            int hi = this.gpr[rs] % this.gpr[rt];
            this.hilo = (long)hi << 32 | (long)lo & 0xFFFFFFFFL;
        }
    }

    public final void doDIVU(int rs, int rt) {
        if (this.gpr[rt] != 0) {
            long x = (long)this.gpr[rs] & 0xFFFFFFFFL;
            long y = (long)this.gpr[rt] & 0xFFFFFFFFL;
            this.hilo = x % y << 32 | x / y & 0xFFFFFFFFL;
        }
    }

    public final void doMADD(int rs, int rt) {
        this.hilo += (long)this.gpr[rs] * (long)this.gpr[rt];
    }

    public final void doMADDU(int rs, int rt) {
        this.hilo += ((long)this.gpr[rs] & 0xFFFFFFFFL) * ((long)this.gpr[rt] & 0xFFFFFFFFL);
    }

    public final void doMSUB(int rs, int rt) {
        this.hilo -= (long)this.gpr[rs] * (long)this.gpr[rt];
    }

    public final void doMSUBU(int rs, int rt) {
        this.hilo -= ((long)this.gpr[rs] & 0xFFFFFFFFL) * ((long)this.gpr[rt] & 0xFFFFFFFFL);
    }
}

