/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.Resource;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class MemoryViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private int startaddress;
    private Point lastLocation = null;
    private JTextField AddressField;
    private JButton DumpRawRam;
    private JButton GoToButton;
    private JButton GoToButton1;
    private JButton GoToSP;
    private JScrollPane jScrollPane1;
    private JTextArea memoryview;

    public MemoryViewer() {
        this.startaddress = Emulator.getProcessor().cpu.pc;
        this.initComponents();
        this.RefreshMemory();
    }

    public static char converttochar(int character) {
        if (character < 32 || character >= 127 && character <= 160 || character == 173) {
            return '.';
        }
        return (char)(character & 0xFF);
    }

    private static byte safeRead8(Memory mem, int address) {
        byte value = 0;
        if (Memory.isAddressGood(address)) {
            value = (byte)mem.read8(address);
        }
        return value;
    }

    public static String getMemoryView(int addr) {
        byte[] line = new byte[16];
        Memory mem = Memory.getInstance();
        for (int i = 0; i < line.length; ++i) {
            line[i] = MemoryViewer.safeRead8(mem, addr + i);
        }
        return String.format("%08x : %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c", addr, line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7], line[8], line[9], line[10], line[11], line[12], line[13], line[14], line[15], Character.valueOf(MemoryViewer.converttochar(line[0])), Character.valueOf(MemoryViewer.converttochar(line[1])), Character.valueOf(MemoryViewer.converttochar(line[2])), Character.valueOf(MemoryViewer.converttochar(line[3])), Character.valueOf(MemoryViewer.converttochar(line[4])), Character.valueOf(MemoryViewer.converttochar(line[5])), Character.valueOf(MemoryViewer.converttochar(line[6])), Character.valueOf(MemoryViewer.converttochar(line[7])), Character.valueOf(MemoryViewer.converttochar(line[8])), Character.valueOf(MemoryViewer.converttochar(line[9])), Character.valueOf(MemoryViewer.converttochar(line[10])), Character.valueOf(MemoryViewer.converttochar(line[11])), Character.valueOf(MemoryViewer.converttochar(line[12])), Character.valueOf(MemoryViewer.converttochar(line[13])), Character.valueOf(MemoryViewer.converttochar(line[14])), Character.valueOf(MemoryViewer.converttochar(line[15])));
    }

    public void RefreshMemory() {
        int addr = this.startaddress;
        this.memoryview.setText("");
        for (int y = 0; y < 22; ++y) {
            if (y > 0) {
                this.memoryview.append("\n");
            }
            this.memoryview.append(MemoryViewer.getMemoryView(addr));
            addr += 16;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.memoryview = new JTextArea();
        this.AddressField = new JTextField();
        this.GoToButton = new JButton();
        this.GoToSP = new JButton();
        this.DumpRawRam = new JButton();
        this.GoToButton1 = new JButton();
        this.setTitle(Resource.get("memoryviewer"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent evt) {
                MemoryViewer.this.formWindowDeactivated(evt);
            }
        });
        this.memoryview.setColumns(20);
        this.memoryview.setEditable(false);
        this.memoryview.setFont(new Font("Courier New", 0, 12));
        this.memoryview.setRows(5);
        this.memoryview.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                MemoryViewer.this.memoryviewMouseWheelMoved(evt);
            }
        });
        this.memoryview.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MemoryViewer.this.memoryviewKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.memoryview);
        this.AddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MemoryViewer.this.onKeyPressed(evt);
            }
        });
        this.GoToButton.setText(Resource.get("gotoaddress"));
        this.GoToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.GoToButtonActionPerformed(evt);
            }
        });
        this.GoToSP.setText(Resource.get("gotosp"));
        this.GoToSP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.GoToSPActionPerformed(evt);
            }
        });
        this.DumpRawRam.setText(Resource.get("dumprawram"));
        this.DumpRawRam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.DumpRawRamActionPerformed(evt);
            }
        });
        this.GoToButton1.setText(Resource.get("gotovram"));
        this.GoToButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.GoToButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.AddressField, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GoToButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GoToButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.GoToSP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 114, Short.MAX_VALUE).addComponent(this.DumpRawRam)).addComponent(this.jScrollPane1, -1, 646, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.DumpRawRam).addComponent(this.AddressField, -2, -1, -2).addComponent(this.GoToButton).addComponent(this.GoToSP).addComponent(this.GoToButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 314, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void memoryviewKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 40) {
            this.startaddress += 16;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 38) {
            this.startaddress -= 16;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 33) {
            this.startaddress -= 352;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 34) {
            this.startaddress += 352;
            evt.consume();
            this.RefreshMemory();
        }
    }

    private void GoToButtonActionPerformed(ActionEvent evt) {
        this.GoToAddress();
    }

    private void GoToAddress() {
        int value;
        String gettext = this.AddressField.getText();
        try {
            value = Utilities.parseAddress(gettext);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Resource.get("numbernotcorrect"));
            return;
        }
        this.startaddress = value;
        this.RefreshMemory();
    }

    private void memoryviewMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() > 0) {
            this.startaddress += 16;
            evt.consume();
            this.RefreshMemory();
        } else {
            this.startaddress -= 16;
            evt.consume();
            this.RefreshMemory();
        }
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (Settings.getInstance().readBool("gui.saveWindowPos")) {
            Point location = this.getLocation();
            if (this.lastLocation == null || location.x != this.lastLocation.x || location.y != this.lastLocation.y) {
                Settings.getInstance().writeWindowPos("memoryview", location);
                this.lastLocation = location;
            }
        }
    }

    private void GoToSPActionPerformed(ActionEvent evt) {
        this.startaddress = Emulator.getProcessor().cpu.gpr[29];
        this.RefreshMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void DumpRawRamActionPerformed(ActionEvent evt) {
        File f = new File("ramdump.bin");
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            Memory mem = Memory.getInstance();
            for (int i = 0x8000000; i <= 0x9FFFFFF; ++i) {
                out.write(MemoryViewer.safeRead8(mem, i));
            }
        }
        catch (IOException e) {
            Utilities.close(out);
            catch (Throwable throwable) {
                Utilities.close(out);
                throw throwable;
            }
        }
        Utilities.close(out);
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.GoToAddress();
        }
    }

    private void GoToButton1ActionPerformed(ActionEvent evt) {
        this.startaddress = 0x4000000;
        this.RefreshMemory();
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

