/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.GUI.UmdBrowserPmf;
import jpcsp.GUI.UmdBrowserSound;
import jpcsp.MainGUI;
import jpcsp.Resource;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.format.PSF;
import jpcsp.settings.Settings;

public class UmdBrowser
extends JDialog {
    private static final String windowNameForSettings = "umdbrowser";
    private static final long serialVersionUID = 7788144302296106541L;
    private JButton loadButton;
    private JLabel pic1Label;
    private JLabel pic0Label;
    private JLabel icon0Label;
    private JTable table;
    private File[] programs;
    private ImageIcon[] icons;
    private PSF[] psfs;
    private volatile boolean[] umdInfoLoaded;
    private MainGUI gui;
    private UmdBrowserPmf umdBrowserPmf;
    private UmdBrowserSound umdBrowserSound;
    private int lastRowIndex = -1;

    public UmdBrowser(MainGUI gui, File[] paths) {
        super(gui);
        this.gui = gui;
        this.setModal(true);
        this.setTitle(Resource.get("umdIsoCsobrowser"));
        this.setDefaultCloseOperation(2);
        this.table = new JTable(new MemStickTableModel(paths), new MemStickTableColumnModel());
        this.table.setFillsViewportHeight(true);
        this.table.setRowHeight(80);
        this.table.setAutoResizeMode(1);
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()));
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                UmdBrowser.this.onSelectionChanged(event);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() == 2 && arg0.getButton() == 1) {
                    UmdBrowser.this.loadSelectedfile();
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                UmdBrowser.this.scrollTo(e.getKeyChar());
            }
        });
        for (int c = 0; c < this.table.getColumnCount() - 1; ++c) {
            DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
            TableColumn col = colModel.getColumn(c);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int r = 0; r < 1; ++r) {
                renderer = this.table.getCellRenderer(r, c);
                comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(r, c), false, false, r, c);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            col.setPreferredWidth(width += 2 * colModel.getColumnMargin());
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        GroupLayout layout = new GroupLayout(this.getRootPane());
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        CancelButton cancelButton = new CancelButton(this);
        this.loadButton = new JButton(Resource.get("load"));
        this.loadButton.setEnabled(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UmdBrowser.this.loadSelectedfile();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        JPanel imagePanel = new JPanel(new GridBagLayout());
        this.icon0Label = new JLabel();
        this.icon0Label.setBorder(BorderFactory.createEmptyBorder(0, 22, 0, 0));
        this.icon0Label.setBorder(new PmfBorder());
        constraints.anchor = 17;
        imagePanel.add((Component)this.icon0Label, constraints);
        this.pic0Label = new JLabel();
        Dimension pic0Size = new Dimension(310, 180);
        this.pic0Label.setMinimumSize(pic0Size);
        this.pic0Label.setMaximumSize(pic0Size);
        constraints.anchor = 13;
        imagePanel.add((Component)this.pic0Label, constraints);
        this.pic1Label = new JLabel();
        Dimension pic1Size = new Dimension(480, 272);
        this.pic1Label.setMinimumSize(pic1Size);
        this.pic1Label.setMaximumSize(pic1Size);
        constraints.anchor = 10;
        imagePanel.add((Component)this.pic1Label, constraints);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(imagePanel).addComponent(scrollPane)).addGroup(layout.createSequentialGroup().addComponent(this.loadButton).addComponent(cancelButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(imagePanel).addComponent(scrollPane)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadButton).addComponent(cancelButton)));
        this.getRootPane().setLayout(layout);
        this.setLocation(Settings.getInstance().readWindowPos(windowNameForSettings));
        this.setSize(Settings.getInstance().readWindowSize(windowNameForSettings, 1000, 350));
    }

    private String getUmdBrowseCacheDirectory(String name) {
        return String.format("%1$s%2$cUmdBrowserCache%2$c%3$s%2$c", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), name);
    }

    private void writeUmdBrowseCacheFile(String cacheDirectory, String name, byte[] content) {
        try {
            FileOutputStream os = new FileOutputStream(cacheDirectory + name);
            ((OutputStream)os).write(content);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            Emulator.log.error((Object)e);
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
    }

    private void loadUmdInfo(int rowIndex) {
        if (this.umdInfoLoaded[rowIndex]) {
            return;
        }
        try {
            if (this.programs[rowIndex].isDirectory()) {
                File[] eboot = this.programs[rowIndex].listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File arg0) {
                        return arg0.getName().equalsIgnoreCase("eboot.pbp");
                    }
                });
                this.programs[rowIndex] = eboot[0];
            }
            if (!this.programs[rowIndex].isDirectory()) {
                String cacheDirectory = this.getUmdBrowseCacheDirectory(this.programs[rowIndex].getName());
                File sfoFile = new File(cacheDirectory + "param.sfo");
                if (sfoFile.canRead()) {
                    byte[] sfo = new byte[(int)sfoFile.length()];
                    FileInputStream is = new FileInputStream(sfoFile);
                    ((InputStream)is).read(sfo);
                    ((InputStream)is).close();
                    this.psfs[rowIndex] = new PSF();
                    this.psfs[rowIndex].read(ByteBuffer.wrap(sfo));
                    File icon0File = new File(cacheDirectory + "ICON0.PNG");
                    this.icons[rowIndex] = icon0File.canRead() ? new ImageIcon(icon0File.getPath()) : new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
                } else {
                    new File(cacheDirectory).mkdirs();
                    UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
                    UmdIsoFile paramSfo = iso.getFile("PSP_GAME/param.sfo");
                    byte[] sfo = new byte[(int)paramSfo.length()];
                    paramSfo.read(sfo);
                    paramSfo.close();
                    this.writeUmdBrowseCacheFile(cacheDirectory, "param.sfo", sfo);
                    ByteBuffer buf = ByteBuffer.wrap(sfo);
                    this.psfs[rowIndex] = new PSF();
                    this.psfs[rowIndex].read(buf);
                    UmdIsoFile icon0umd = iso.getFile("PSP_GAME/ICON0.PNG");
                    byte[] icon0 = new byte[(int)icon0umd.length()];
                    icon0umd.read(icon0);
                    icon0umd.close();
                    this.writeUmdBrowseCacheFile(cacheDirectory, "ICON0.PNG", icon0);
                    this.icons[rowIndex] = new ImageIcon(icon0);
                }
            }
        }
        catch (FileNotFoundException e) {
            try {
                UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
                UmdIsoFile paramSfo = iso.getFile("UMD_VIDEO/param.sfo");
                UmdIsoFile umdDataFile = iso.getFile("UMD_DATA.BIN");
                byte[] umdDataId = new byte[10];
                String umdDataIdString = "";
                umdDataFile.readFully(umdDataId, 0, 9);
                umdDataIdString = new String(umdDataId);
                byte[] sfo = new byte[(int)paramSfo.length()];
                paramSfo.read(sfo);
                paramSfo.close();
                ByteBuffer buf = ByteBuffer.wrap(sfo);
                this.psfs[rowIndex] = new PSF();
                this.psfs[rowIndex].read(buf);
                this.psfs[rowIndex].put("DISC_ID", umdDataIdString);
                UmdIsoFile icon0umd = iso.getFile("UMD_VIDEO/ICON0.PNG");
                byte[] icon0 = new byte[(int)icon0umd.length()];
                icon0umd.read(icon0);
                icon0umd.close();
                this.icons[rowIndex] = new ImageIcon(icon0);
            }
            catch (FileNotFoundException ve) {
                this.icons[rowIndex] = new ImageIcon(this.getClass().getResource("/jpcsp/images/icon0.png"));
            }
            catch (IOException ve) {
                Emulator.log.error((Object)ve);
            }
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        this.umdInfoLoaded[rowIndex] = true;
    }

    private void onSelectionChanged(ListSelectionEvent event) {
        this.loadButton.setEnabled(!((ListSelectionModel)event.getSource()).isSelectionEmpty());
        ImageIcon pic0Icon = null;
        ImageIcon pic1Icon = null;
        ImageIcon icon0Icon = null;
        try {
            int rowIndex = this.table.getSelectedRow();
            UmdIsoReader iso = new UmdIsoReader(this.programs[rowIndex].getPath());
            try {
                UmdIsoFile pic0umd = iso.getFile("PSP_GAME/PIC0.PNG");
                byte[] pic0 = new byte[(int)pic0umd.length()];
                pic0umd.read(pic0);
                pic0umd.close();
                pic0Icon = new ImageIcon(pic0);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            try {
                UmdIsoFile pic1umd = iso.getFile("PSP_GAME/PIC1.PNG");
                byte[] pic1 = new byte[(int)pic1umd.length()];
                pic1umd.read(pic1);
                pic1umd.close();
                pic1Icon = new ImageIcon(pic1);
            }
            catch (FileNotFoundException e) {
                try {
                    UmdIsoFile pic1umd = iso.getFile("UMD_VIDEO/PIC1.PNG");
                    byte[] pic1 = new byte[(int)pic1umd.length()];
                    pic1umd.read(pic1);
                    pic1umd.close();
                    pic1Icon = new ImageIcon(pic1);
                }
                catch (FileNotFoundException ve) {
                    pic1Icon = new ImageIcon();
                    BufferedImage image = new BufferedImage(480, 272, 2);
                    pic1Icon.setImage(image);
                }
                catch (IOException ve) {
                    Emulator.log.error((Object)ve);
                }
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            icon0Icon = this.icons[rowIndex];
            if (this.lastRowIndex != rowIndex) {
                this.stopVideo();
                this.umdBrowserPmf = new UmdBrowserPmf(iso, "PSP_GAME/ICON1.PMF", this.icon0Label);
                this.umdBrowserSound = new UmdBrowserSound(iso, "PSP_GAME/SND0.AT3");
            }
            this.lastRowIndex = rowIndex;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        this.pic0Label.setIcon(pic0Icon);
        this.pic1Label.setIcon(pic1Icon);
        this.icon0Label.setIcon(icon0Icon);
    }

    private String getTitle(int rowIndex) {
        String title;
        if (this.psfs[rowIndex] == null || (title = this.psfs[rowIndex].getString("TITLE")) == null) {
            title = this.programs[rowIndex].getParentFile().getName();
        }
        return title;
    }

    private void scrollTo(char c) {
        c = Character.toLowerCase(c);
        int scrollToRow = -1;
        for (int rowIndex = 0; rowIndex < this.programs.length; ++rowIndex) {
            char firstChar;
            String title = this.getTitle(rowIndex);
            if (title == null || title.length() <= 0 || (firstChar = Character.toLowerCase(title.charAt(0))) != c) continue;
            scrollToRow = rowIndex;
            break;
        }
        if (scrollToRow >= 0) {
            this.table.scrollRectToVisible(this.table.getCellRect(scrollToRow, 0, true));
        }
    }

    private void stopVideo() {
        if (this.umdBrowserPmf != null) {
            this.umdBrowserPmf.stopVideo();
            this.umdBrowserPmf = null;
        }
        if (this.umdBrowserSound != null) {
            this.umdBrowserSound.stopVideo();
            this.umdBrowserSound = null;
        }
    }

    private void loadSelectedfile() {
        this.stopVideo();
        Settings.getInstance().writeWindowPos(windowNameForSettings, this.getLocation());
        Settings.getInstance().writeWindowSize(windowNameForSettings, this.getSize());
        File selectedFile = this.programs[this.table.getSelectedRow()];
        this.gui.loadUMD(selectedFile);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void dispose() {
        this.stopVideo();
        super.dispose();
    }

    private static void sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ File[] access$102(UmdBrowser x0, File[] x1) {
        x0.programs = x1;
        return x1;
    }

    static /* synthetic */ ImageIcon[] access$202(UmdBrowser x0, ImageIcon[] x1) {
        x0.icons = x1;
        return x1;
    }

    static /* synthetic */ PSF[] access$302(UmdBrowser x0, PSF[] x1) {
        x0.psfs = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$402(UmdBrowser x0, boolean[] x1) {
        x0.umdInfoLoaded = x1;
        return x1;
    }

    private class PmfBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -700510222853542503L;
        private static final int leftSpace = 20;
        private static final int topSpace = 8;
        private static final int borderWidth = 8;
        private static final int millisPerBeat = 1500;

        private PmfBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(8, 20, 8, 8);
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UmdBrowser.this.icon0Label.getIcon() == null) {
                return;
            }
            long now = System.currentTimeMillis();
            float beat = (float)(now % 1500L) / 1500.0f;
            float noBeat = 0.5f;
            for (int i = 0; i < 8; ++i) {
                int alpha = this.getAlpha(noBeat, i);
                this.setColor(g, beat, alpha);
                g.drawLine(x + width - 8 + i, y + 8, x + width - 8 + i, y + height - 8);
                g.drawLine(x + 20, y + height - 8 + i, x + width - 8, y + height - 8 + i);
                alpha = this.getAlpha(beat, i);
                this.setColor(g, noBeat, alpha);
                g.drawLine(x + 20 - i, y + 8, x + 20 - i, y + height - 8);
                g.drawLine(x + 20, y + 8 - i, x + width - 8, y + 8 - i);
            }
            this.drawCorner(g, beat, noBeat, x + 20 - 8, y + 8 - 8, 8, 8);
            this.drawCorner(g, beat, noBeat, x + width - 8, y + 8 - 8, 0, 8);
            this.drawCorner(g, beat, noBeat, x + 20 - 8, y + height - 8, 8, 0);
            this.drawCorner(g, noBeat, beat, x + width - 8, y + height - 8, 0, 0);
        }

        private void drawCorner(Graphics g, float alphaBeat, float colorBeat, int x, int y, int centerX, int centerY) {
            for (int ix = 1; ix < 8; ++ix) {
                for (int iy = 1; iy < 8; ++iy) {
                    int alpha = this.getAlpha(alphaBeat, ix - centerX, iy - centerY);
                    this.setColor(g, colorBeat, alpha);
                    this.drawPoint(g, x + ix, y + iy);
                }
            }
        }

        private int getAlpha(float beat, int distanceX, int distanceY) {
            float distance = (float)Math.sqrt(distanceX * distanceX + distanceY * distanceY);
            return this.getAlpha(beat, distance);
        }

        private int getAlpha(float beat, float distance) {
            float maxDistance = 8.0f;
            int maxAlpha = 240;
            maxAlpha = beat < 0.5f ? (int)((float)maxAlpha * beat * 2.0f) : (int)((float)maxAlpha * (1.0f - beat) * 2.0f);
            distance = Math.abs(distance);
            distance = Math.min(distance, 8.0f);
            return maxAlpha - (int)(distance * (float)maxAlpha / 8.0f);
        }

        private void setColor(Graphics g, float beat, int alpha) {
            int color = 160;
            color = beat < 0.5f ? (int)((float)color * beat * 2.0f) : (int)((float)color * (1.0f - beat) * 2.0f);
            g.setColor(new Color(color, color, color, alpha));
        }

        private void drawPoint(Graphics g, int x, int y) {
            g.drawLine(x, y, x, y);
        }
    }

    private class UmdInfoLoader
    extends Thread {
        private UmdInfoLoader() {
        }

        @Override
        public void run() {
            for (int i = 0; i < UmdBrowser.this.umdInfoLoaded.length; ++i) {
                UmdBrowser.this.loadUmdInfo(i);
            }
        }
    }

    private final class MemStickTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1675488447176776560L;
        private UmdInfoLoader umdInfoLoader;
        private String pathPrefix;

        public MemStickTableModel(File[] paths) {
            ArrayList<File> programList = new ArrayList<File>();
            for (File path : paths) {
                if (!path.isDirectory()) {
                    Emulator.log.error((Object)(path + Resource.get("nodirectory")));
                    return;
                }
                try {
                    this.pathPrefix = path.getCanonicalPath();
                }
                catch (IOException e) {
                    this.pathPrefix = path.getPath();
                }
                File[] pathPrograms = path.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        String lower = file.getName().toLowerCase();
                        if (lower.endsWith(".cso") || lower.endsWith(".iso")) {
                            return true;
                        }
                        if (file.isDirectory()) {
                            File[] eboot = file.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    return file.getName().equalsIgnoreCase("eboot.pbp");
                                }
                            });
                            return eboot.length != 0;
                        }
                        return false;
                    }
                });
                programList.addAll(Arrays.asList(pathPrograms));
            }
            Collections.sort(programList, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    String name2;
                    if (file1 == null) {
                        return file2 == null ? 0 : 1;
                    }
                    if (file2 == null) {
                        return -1;
                    }
                    String name1 = file1.getName().toLowerCase();
                    if (name1.equals(name2 = file2.getName().toLowerCase())) {
                        return this.compare(file1.getParentFile(), file2.getParentFile());
                    }
                    return name1.compareTo(name2);
                }
            });
            UmdBrowser.access$102(UmdBrowser.this, programList.toArray(new File[programList.size()]));
            UmdBrowser.access$202(UmdBrowser.this, new ImageIcon[UmdBrowser.this.programs.length]);
            UmdBrowser.access$302(UmdBrowser.this, new PSF[UmdBrowser.this.programs.length]);
            UmdBrowser.access$402(UmdBrowser.this, new boolean[UmdBrowser.this.programs.length]);
            for (int i = 0; i < UmdBrowser.this.programs.length; ++i) {
                ((UmdBrowser)UmdBrowser.this).umdInfoLoaded[i] = false;
            }
            UmdBrowser.this.loadUmdInfo(0);
            this.umdInfoLoader = new UmdInfoLoader();
            this.umdInfoLoader.setName("Umd Browser - Umd Info Loader");
            this.umdInfoLoader.setPriority(1);
            this.umdInfoLoader.setDaemon(true);
            this.umdInfoLoader.start();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (UmdBrowser.this.programs == null) {
                return 0;
            }
            return UmdBrowser.this.programs.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                while (!UmdBrowser.this.umdInfoLoaded[rowIndex]) {
                    UmdBrowser.sleep(1L);
                }
                switch (columnIndex) {
                    case 0: {
                        return UmdBrowser.this.icons[rowIndex];
                    }
                    case 1: {
                        String prgPath;
                        String firmware;
                        String discid;
                        String title = UmdBrowser.this.getTitle(rowIndex);
                        if (UmdBrowser.this.psfs[rowIndex] == null || (discid = UmdBrowser.this.psfs[rowIndex].getString("DISC_ID")) == null) {
                            discid = "No ID";
                        }
                        if (UmdBrowser.this.psfs[rowIndex] == null || (firmware = UmdBrowser.this.psfs[rowIndex].getString("PSP_SYSTEM_VER")) == null) {
                            firmware = "Not found";
                        }
                        if ((prgPath = UmdBrowser.this.programs[rowIndex].getCanonicalPath()).startsWith(this.pathPrefix)) {
                            prgPath = prgPath.substring(this.pathPrefix.length() + 1);
                        } else {
                            String cwdPath = new File(".").getCanonicalPath();
                            if (prgPath.startsWith(cwdPath)) {
                                prgPath = prgPath.substring(cwdPath.length() + 1);
                            }
                        }
                        String text = String.format("%s\n%s\n%s\n%s", title, discid, firmware, prgPath);
                        return text;
                    }
                }
            }
            catch (IOException e) {
                Emulator.log.error((Object)e);
            }
            return null;
        }
    }

    private static final class MemStickTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -6321946514015824875L;

        public MemStickTableColumnModel() {
            this.setColumnMargin(0);
            CellRenderer cellRenderer = new CellRenderer();
            TableColumn tableColumn = new TableColumn(0, 144, cellRenderer, null);
            tableColumn.setHeaderValue(Resource.get("icon"));
            tableColumn.setMaxWidth(154);
            tableColumn.setMinWidth(144);
            TableColumn tableColumn2 = new TableColumn(1, 100, cellRenderer, null);
            tableColumn2.setHeaderValue(Resource.get("title"));
            this.addColumn(tableColumn);
            this.addColumn(tableColumn2);
        }

        private static final class CellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 6767267483048658105L;

            private CellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
                if (obj instanceof Icon) {
                    this.setIcon((Icon)obj);
                    return this;
                }
                if (obj instanceof String) {
                    JTextArea textArea = new JTextArea((String)obj);
                    textArea.setFont(this.getFont());
                    if (isSelected) {
                        textArea.setForeground(table.getSelectionForeground());
                        textArea.setBackground(table.getSelectionBackground());
                    } else {
                        textArea.setForeground(table.getForeground());
                        textArea.setBackground(table.getBackground());
                    }
                    return textArea;
                }
                this.setIcon(null);
                return super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            }
        }
    }
}

