/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.filesystems.SeekableRandomFile;

public class LocalVirtualFileSystem
extends AbstractVirtualFileSystem {
    protected final String localPath;

    public LocalVirtualFileSystem(String localPath) {
        this.localPath = localPath;
    }

    protected File getFile(String fileName) {
        return new File(this.localPath + fileName);
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        SeekableRandomFile raf;
        File file = this.getFile(fileName);
        if (file.exists() && LocalVirtualFileSystem.hasFlag(flags, 512) && LocalVirtualFileSystem.hasFlag(flags, 2048)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"hleIoOpen - file already exists (PSP_O_CREAT + PSP_O_EXCL)");
            }
            throw new SceKernelErrorException(-2147418095);
        }
        if (!file.exists() && LocalVirtualFileSystem.hasFlag(flags, 512)) {
            String parentDir = file.getParent();
            new File(parentDir).mkdirs();
        }
        try {
            raf = new SeekableRandomFile(file, LocalVirtualFileSystem.getMode(mode));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (LocalVirtualFileSystem.hasFlag(flags, 2) && LocalVirtualFileSystem.hasFlag(flags, 1024)) {
            try {
                raf.setLength(0L);
            }
            catch (IOException e) {
                log.error((Object)"ioOpen.setLength", (Throwable)e);
            }
        }
        return new LocalVirtualFile(raf);
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        File file = this.getFile(fileName);
        if (!file.exists()) {
            return -2147418110;
        }
        int attr = 0;
        if (file.isDirectory()) {
            attr |= 0x10;
        }
        if (file.isFile()) {
            attr |= 0x20;
        }
        int mode = (file.canRead() ? 4 : 0) + (file.canWrite() ? 2 : 0) + (file.canExecute() ? 1 : 0);
        mode = mode + (mode << 3) + (mode << 6);
        ScePspDateTime ctime = ScePspDateTime.fromUnixTime(file.lastModified());
        ScePspDateTime atime = ScePspDateTime.fromUnixTime(0L);
        ScePspDateTime mtime = ScePspDateTime.fromUnixTime(file.lastModified());
        stat.init(mode |= attr << 8, attr, file.length(), ctime, atime, mtime);
        return 0;
    }

    @Override
    public int ioRemove(String name) {
        File file = this.getFile(name);
        if (!file.delete()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String[] ioDopen(String dirName) {
        File file = this.getFile(dirName);
        if (!file.isDirectory()) {
            if (file.exists()) {
                log.warn((Object)String.format("ioDopen file '%s' is not a directory", dirName));
            } else {
                log.warn((Object)String.format("ioDopen directory '%s' not found", dirName));
            }
            return null;
        }
        return file.list();
    }

    @Override
    public int ioMkdir(String name, int mode) {
        File file = this.getFile(name);
        if (file.exists()) {
            return -2147418095;
        }
        if (!file.mkdir()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int ioRmdir(String name) {
        File file = this.getFile(name);
        if (!file.exists()) {
            return -2147418110;
        }
        if (!file.delete()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int ioChstat(String fileName, SceIoStat stat, int bits) {
        File file = this.getFile(fileName);
        int mode = stat.mode;
        boolean successful = true;
        if ((bits & 1) != 0 && !file.setExecutable((mode & 1) != 0)) {
            successful = false;
        }
        if ((bits & 2) != 0 && !file.setWritable((mode & 2) != 0)) {
            successful = false;
        }
        if ((bits & 4) != 0 && !file.setReadable((mode & 4) != 0)) {
            successful = false;
        }
        if ((bits & 0x40) != 0 && !file.setExecutable((mode & 0x40) != 0, true)) {
            successful = false;
        }
        if ((bits & 0x80) != 0 && !file.setWritable((mode & 0x80) != 0, true)) {
            successful = false;
        }
        if ((bits & 0x100) != 0 && !file.setReadable((mode & 0x100) != 0, true)) {
            successful = false;
        }
        return successful ? 0 : -1;
    }
}

