/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SysMemUserForUser
extends HLEModule {
    protected static Logger log = Modules.getLogger("SysMemUserForUser");
    protected static Logger stdout = Logger.getLogger((String)"stdout");
    protected static HashMap<Integer, SysMemInfo> blockList;
    protected static MemoryChunkList freeMemoryChunks;
    protected int firmwareVersion = 150;
    public static final int defaultSizeAlignment = 256;
    protected boolean memory64MB = false;
    public static final int PSP_SMEM_Low = 0;
    public static final int PSP_SMEM_High = 1;
    public static final int PSP_SMEM_Addr = 2;
    public static final int PSP_SMEM_LowAligned = 3;
    public static final int PSP_SMEM_HighAligned = 4;
    public static final int KERNEL_PARTITION_ID = 1;
    public static final int USER_PARTITION_ID = 2;
    protected boolean started = false;

    @Override
    public String getName() {
        return "SysMemUserForUser";
    }

    @Override
    public void start() {
        if (!this.started) {
            this.reset();
            this.started = true;
        }
        super.start();
    }

    @Override
    public void stop() {
        this.started = false;
        super.stop();
    }

    public void reset() {
        blockList = new HashMap();
        int startFreeMem = 0x8800000;
        int endFreeMem = MemoryMap.END_USERSPACE;
        MemoryChunk initialMemory = new MemoryChunk(startFreeMem, endFreeMem - startFreeMem + 1);
        freeMemoryChunks = new MemoryChunkList(initialMemory);
    }

    public void setMemory64MB(boolean isMemory64MB) {
        if (this.memory64MB != isMemory64MB) {
            this.memory64MB = isMemory64MB;
            if (this.memory64MB) {
                MemoryMap.END_RAM = 0xBBFFFFF;
                MemoryMap.END_USERSPACE = 0xBBFFFFF;
            } else {
                MemoryMap.END_RAM = 0x9FFFFFF;
                MemoryMap.END_USERSPACE = 0x9FFFFFF;
            }
            MemoryMap.SIZE_RAM = MemoryMap.END_RAM - 0x8000000 + 1;
            if (!Memory.getInstance().allocate()) {
                log.error((Object)String.format("Failed to resize the PSP memory from %s to %s", this.memory64MB ? "32MB" : "64MB", this.memory64MB ? "64MB" : "32MB"));
                Emulator.PauseEmuWithStatus(12);
            }
            this.reset();
        }
    }

    protected static String getTypeName(int type) {
        String typeName;
        switch (type) {
            case 0: {
                typeName = "PSP_SMEM_Low";
                break;
            }
            case 1: {
                typeName = "PSP_SMEM_High";
                break;
            }
            case 2: {
                typeName = "PSP_SMEM_Addr";
                break;
            }
            case 3: {
                typeName = "PSP_SMEM_LowAligned";
                break;
            }
            case 4: {
                typeName = "PSP_SMEM_HighAligned";
                break;
            }
            default: {
                typeName = "UNHANDLED " + type;
            }
        }
        return typeName;
    }

    public SysMemInfo malloc(int partitionid, String name, int type, int size, int addr) {
        SysMemInfo sysMemInfo;
        int allocatedAddress = 0;
        int alignment = 255;
        int allocatedSize = Utilities.alignUp(size, alignment);
        if (type == 3 || type == 4) {
            alignment = addr - 1;
        }
        switch (type) {
            case 0: 
            case 3: {
                allocatedAddress = freeMemoryChunks.allocLow(allocatedSize, alignment);
                break;
            }
            case 1: 
            case 4: {
                allocatedAddress = freeMemoryChunks.allocHigh(allocatedSize, alignment);
                break;
            }
            case 2: {
                allocatedAddress = freeMemoryChunks.alloc(addr, allocatedSize);
                break;
            }
            default: {
                log.warn((Object)String.format("malloc: unknown type %s", SysMemUserForUser.getTypeName(type)));
            }
        }
        if (allocatedAddress == 0) {
            log.warn((Object)String.format("malloc cannot allocate partition=%d, type=%s, size=0x%X, addr=0x%08X", partitionid, SysMemUserForUser.getTypeName(type), size, addr));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Free list: " + freeMemoryChunks));
                log.trace((Object)("Allocated blocks:\n" + this.getDebugAllocatedMem() + "\n"));
            }
            sysMemInfo = null;
        } else {
            sysMemInfo = new SysMemInfo(partitionid, name, type, size, allocatedSize, allocatedAddress);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("malloc partition=%d, type=%s, size=0x%X, addr=0x%08X: returns 0x%08X", partitionid, SysMemUserForUser.getTypeName(type), size, addr, allocatedAddress));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Free list after malloc: " + this.getDebugFreeMem()));
                    log.trace((Object)("Allocated blocks after malloc:\n" + this.getDebugAllocatedMem() + "\n"));
                }
            }
        }
        return sysMemInfo;
    }

    public String getDebugFreeMem() {
        return freeMemoryChunks.toString();
    }

    public String getDebugAllocatedMem() {
        StringBuilder result = new StringBuilder();
        ArrayList<SysMemInfo> sortedBlockList = Collections.list(Collections.enumeration(blockList.values()));
        Collections.sort(sortedBlockList);
        for (SysMemInfo sysMemInfo : sortedBlockList) {
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(sysMemInfo.toString());
        }
        return result.toString();
    }

    public void free(SysMemInfo info) {
        if (info != null) {
            info.free();
            MemoryChunk memoryChunk = new MemoryChunk(info.addr, info.allocatedSize);
            freeMemoryChunks.add(memoryChunk);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("free %s", info.toString()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Free list after free: " + this.getDebugFreeMem()));
                    log.trace((Object)("Allocated blocks after free:\n" + this.getDebugAllocatedMem() + "\n"));
                }
            }
        }
    }

    public int maxFreeMemSize() {
        int maxFreeMemSize = 0;
        MemoryChunk memoryChunk = freeMemoryChunks.getLowMemoryChunk();
        while (memoryChunk != null) {
            if (memoryChunk.size > maxFreeMemSize) {
                maxFreeMemSize = memoryChunk.size;
            }
            memoryChunk = memoryChunk.next;
        }
        return maxFreeMemSize;
    }

    public int totalFreeMemSize() {
        int totalFreeMemSize = 0;
        MemoryChunk memoryChunk = freeMemoryChunks.getLowMemoryChunk();
        while (memoryChunk != null) {
            totalFreeMemSize += memoryChunk.size;
            memoryChunk = memoryChunk.next;
        }
        return totalFreeMemSize;
    }

    public void setFirmwareVersion(int firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void dumpSysMemInfo() {
        int i;
        int MEMORY_SIZE = 0x1800000;
        int SLOT_COUNT = 64;
        int SLOT_SIZE = 393216;
        boolean[] allocated = new boolean[64];
        boolean[] fragmented = new boolean[64];
        int allocatedSize = 0;
        int fragmentedSize = 0;
        for (SysMemInfo info : blockList.values()) {
            for (i = info.addr; i < info.addr + info.size; i += 393216) {
                if (i < 0x8800000 || i >= 0xA000000) continue;
                allocated[(i - 0x8800000) / 393216] = true;
            }
            allocatedSize += info.size;
        }
        MemoryChunk memoryChunk = freeMemoryChunks.getLowMemoryChunk();
        while (memoryChunk != null) {
            for (int i2 = memoryChunk.addr; i2 < memoryChunk.addr + memoryChunk.size; i2 += 393216) {
                if (i2 < 0x8800000 || i2 >= 0xA000000) continue;
                fragmented[(i2 - 0x8800000) / 393216] = true;
            }
            fragmentedSize += memoryChunk.size;
            memoryChunk = memoryChunk.next;
        }
        StringBuilder allocatedDiagram = new StringBuilder();
        allocatedDiagram.append("[");
        for (int i3 = 0; i3 < 64; ++i3) {
            allocatedDiagram.append(allocated[i3] ? "X" : " ");
        }
        allocatedDiagram.append("]");
        StringBuilder fragmentedDiagram = new StringBuilder();
        fragmentedDiagram.append("[");
        for (i = 0; i < 64; ++i) {
            fragmentedDiagram.append(fragmented[i] ? "X" : " ");
        }
        fragmentedDiagram.append("]");
        DumpDebugState.log("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        DumpDebugState.log(String.format("Allocated memory:  %08X %d bytes", allocatedSize, allocatedSize));
        DumpDebugState.log(allocatedDiagram.toString());
        DumpDebugState.log(String.format("Fragmented memory: %08X %d bytes", fragmentedSize, fragmentedSize));
        DumpDebugState.log(fragmentedDiagram.toString());
        DumpDebugState.log("Free list: " + this.getDebugFreeMem());
        DumpDebugState.log("Allocated blocks:\n" + this.getDebugAllocatedMem() + "\n");
    }

    public int hleKernelPrintf(CpuState cpu, Logger logger, String sceFunctionName) {
        int string_addr = cpu.gpr[4];
        String msg = Utilities.readStringNZ(string_addr, 256);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s(string_addr=0x%08X) '%s'", sceFunctionName, string_addr, msg));
        }
        if (logger.isInfoEnabled()) {
            String formattedMsg = msg;
            try {
                int[] gpr = cpu.gpr;
                Object[] formatParameters = new Object[]{gpr[5], gpr[6], gpr[7], gpr[8], gpr[9], gpr[10], gpr[11]};
                String javaMsg = msg;
                javaMsg = javaMsg.replaceAll("\\%[ui]", "%d");
                javaMsg = javaMsg.replaceAll("\\%p", "%08X");
                if (javaMsg.contains("%s")) {
                    formatParameters[0] = Utilities.readStringZ(gpr[5]);
                }
                formattedMsg = String.format(javaMsg, formatParameters[0], formatParameters[1], formatParameters[2], formatParameters[3], formatParameters[4], formatParameters[5], formatParameters[6]);
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.info((Object)formattedMsg);
        }
        return 0;
    }

    @HLEFunction(nid=-1567493881, version=150)
    public int sceKernelMaxFreeMemSize() {
        int maxFreeMemSize = this.maxFreeMemSize();
        maxFreeMemSize &= 0xFFFFFFF0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelMaxFreeMemSize %d(hex=0x%1$X)", maxFreeMemSize));
        }
        return maxFreeMemSize;
    }

    @HLEFunction(nid=-115739096, version=150)
    public int sceKernelTotalFreeMemSize() {
        int totalFreeMemSize = this.totalFreeMemSize();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelTotalFreeMemSize %d(hex=0x%1$X)", totalFreeMemSize));
        }
        return totalFreeMemSize;
    }

    @HLEFunction(nid=595443023, version=150)
    public int sceKernelAllocPartitionMemory(int partitionid, String name, int type, int size, int addr) {
        addr &= 0x3FFFFFFF;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelAllocPartitionMemory(partition=%d, name='%s', type=%s, size=0x%X, addr=0x%08X", partitionid, name, SysMemUserForUser.getTypeName(type), size, addr));
        }
        if (type < 0 || type > 4) {
            return -2147352360;
        }
        SysMemInfo info = this.malloc(partitionid, name, type, size, addr);
        if (info == null) {
            return -2147352359;
        }
        return info.uid;
    }

    @HLEFunction(nid=-1227481854, version=150)
    public int sceKernelFreePartitionMemory(int uid) {
        SceUidManager.checkUidPurpose(uid, "SysMem", true);
        SysMemInfo info = blockList.remove(uid);
        if (info == null) {
            log.warn((Object)("sceKernelFreePartitionMemory unknown SceUID=" + Integer.toHexString(uid)));
            return -2147352354;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelFreePartitionMemory SceUID=" + Integer.toHexString(info.uid) + " name:'" + info.name + "'"));
        }
        this.free(info);
        return 0;
    }

    @HLEFunction(nid=-1650828383, version=150)
    public int sceKernelGetBlockHeadAddr(int uid) {
        SceUidManager.checkUidPurpose(uid, "SysMem", true);
        SysMemInfo info = blockList.get(uid);
        if (info == null) {
            log.warn((Object)("sceKernelGetBlockHeadAddr unknown SceUID=" + Integer.toHexString(uid)));
            return -2147352354;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceKernelGetBlockHeadAddr SceUID=" + Integer.toHexString(info.uid) + " name:'" + info.name + "' headAddr:" + Integer.toHexString(info.addr)));
        }
        return info.addr;
    }

    @HLEFunction(nid=329624559, version=150)
    public int sceKernelPrintf(CpuState cpu) {
        return this.hleKernelPrintf(cpu, stdout, "sceKernelPrintf");
    }

    @HLEFunction(nid=1070181994, version=150)
    public int sceKernelDevkitVersion() {
        int major = this.firmwareVersion / 100;
        int minor = this.firmwareVersion / 10 % 10;
        int revision = this.firmwareVersion % 10;
        int devkitVersion = major << 24 | minor << 16 | revision << 8 | 0x10;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelDevkitVersion return:0x%08X", devkitVersion));
        }
        return devkitVersion;
    }

    @HLEFunction(nid=-656516066, version=150)
    public int SysMemUserForUser_D8DE5C1E() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SysMemUserForUser_D8DE5C1E");
        }
        return 0;
    }

    public static class SysMemInfo
    implements Comparable<SysMemInfo> {
        public final int uid;
        public final int partitionid;
        public final String name;
        public final int type;
        public final int size;
        public final int allocatedSize;
        public final int addr;

        public SysMemInfo(int partitionid, String name, int type, int size, int allocatedSize, int addr) {
            this.partitionid = partitionid;
            this.name = name;
            this.type = type;
            this.size = size;
            this.allocatedSize = allocatedSize;
            this.addr = addr;
            this.uid = SceUidManager.getNewUid("SysMem");
            blockList.put(this.uid, this);
        }

        public String toString() {
            return String.format("SysMemInfo[addr=0x%08X-0x%08X, uid=%x, partition=%d, name='%s', type=%s, size=0x%X (allocated=0x%X)]", this.addr, this.addr + this.allocatedSize, this.uid, this.partitionid, this.name, SysMemUserForUser.getTypeName(this.type), this.size, this.allocatedSize);
        }

        public void free() {
            blockList.remove(this.uid);
        }

        @Override
        public int compareTo(SysMemInfo o) {
            if (this.addr == o.addr) {
                log.warn((Object)("Set invariant broken for SysMemInfo " + this));
                return 0;
            }
            return this.addr < o.addr ? -1 : 1;
        }
    }
}

