/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceNetAdhocDiscoverParam;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class sceNetAdhocDiscover
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceNetAdhocDiscover");
    protected static final int NET_ADHOC_DISCOVER_STATUS_NONE = 0;
    protected static final int NET_ADHOC_DISCOVER_STATUS_IN_PROGRESS = 1;
    protected static final int NET_ADHOC_DISCOVER_STATUS_COMPLETED = 2;
    protected int status;
    protected SceNetAdhocDiscoverParam netAdhocDiscoverParam;
    protected long discoverStartMillis;
    protected static final int DISCOVER_DURATION_MILLIS = 2000;

    @Override
    public String getName() {
        return "sceNetAdhocDiscover";
    }

    @Override
    public void start() {
        this.status = 0;
        super.start();
    }

    @HLEFunction(nid=-1810155401, version=150)
    public int sceNetAdhocDiscoverInitStart(TPointer param) {
        this.netAdhocDiscoverParam = new SceNetAdhocDiscoverParam();
        this.netAdhocDiscoverParam.read(Memory.getInstance(), param.getAddress());
        log.warn((Object)String.format("PARTIAL sceNetAdhocDiscoverInitStart param=%s(%s)", param, this.netAdhocDiscoverParam));
        this.status = 1;
        this.discoverStartMillis = Emulator.getClock().currentTimeMillis();
        return 0;
    }

    @HLEFunction(nid=1390287767, version=150)
    public int sceNetAdhocDiscoverUpdate() {
        long now;
        log.warn((Object)String.format("PARTIAL sceNetAdhocDiscoverUpdate", new Object[0]));
        if (this.status == 1 && (now = Emulator.getClock().currentTimeMillis()) >= this.discoverStartMillis + 2000L) {
            this.status = 2;
            this.netAdhocDiscoverParam.result = 2;
        }
        this.netAdhocDiscoverParam.write(Memory.getInstance());
        return 0;
    }

    @HLEFunction(nid=-1806836794, version=150)
    public int sceNetAdhocDiscoverGetStatus() {
        log.warn((Object)String.format("PARTIAL sceNetAdhocDiscoverGetStatus returning %d", this.status));
        return this.status;
    }

    @HLEFunction(nid=-1574672876, version=150)
    public int sceNetAdhocDiscoverTerm() {
        log.warn((Object)String.format("PARTIAL sceNetAdhocDiscoverTerm", new Object[0]));
        this.status = 0;
        return 0;
    }

    @HLEFunction(nid=-137285100, version=150)
    public int sceNetAdhocDiscoverStop() {
        log.warn((Object)String.format("PARTIAL sceNetAdhocDiscoverStop", new Object[0]));
        this.status = 2;
        this.netAdhocDiscoverParam.write(Memory.getInstance());
        return 0;
    }

    @HLEFunction(nid=-1541168613, version=150)
    public int sceNetAdhocDiscoverRequestSuspend(Processor processor) {
        log.warn((Object)String.format("Unimplemented sceNetAdhocDiscoverRequestSuspend", new Object[0]));
        return 0;
    }
}

