/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Processor;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUsb
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceUsb");
    public static final String PSP_USBBUS_DRIVERNAME = "USBBusDriver";
    public static final int PSP_USB_CONNECTION_ESTABLISHED = 2;
    public static final int PSP_USB_CABLE_CONNECTED = 32;
    public static final int PSP_USB_ACTIVATED = 512;
    protected boolean usbActivated = false;
    protected boolean usbStarted = false;

    @Override
    public String getName() {
        return "sceUsb";
    }

    protected int getUsbState() {
        int state = 32;
        if (this.usbActivated) {
            state |= 0x200;
        }
        if (this.usbStarted) {
            state |= 2;
        }
        return state;
    }

    @HLEFunction(nid=-1369577809, version=150)
    public void sceUsbStart(Processor processor) {
        CpuState cpu = processor.cpu;
        int driverNameAddr = cpu.gpr[4];
        int size = cpu.gpr[5];
        int args = cpu.gpr[6];
        String driverName = Utilities.readStringZ(driverNameAddr);
        log.warn((Object)String.format("Unimplemented sceUsbStart driverName=0x%08X('%s'), size=%d, args=0x%08X", driverNameAddr, driverName, size, args));
        this.usbStarted = true;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1035579488, version=150)
    public void sceUsbStop(Processor processor) {
        CpuState cpu = processor.cpu;
        int driverNameAddr = cpu.gpr[4];
        int size = cpu.gpr[5];
        int args = cpu.gpr[6];
        String driverName = Utilities.readStringZ(driverNameAddr);
        log.warn((Object)String.format("Unimplemented sceUsbStop driverName=0x%08X('%s'), size=%d, args=0x%08X", driverNameAddr, driverName, size, args));
        this.usbStarted = false;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-1038727772, version=150)
    public void sceUsbGetState(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUsbGetState returning %d", this.getUsbState()));
        }
        cpu.gpr[2] = this.getUsbState();
    }

    @HLEFunction(nid=1314091878, version=150)
    public void sceUsbGetDrvList(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)String.format("Unimplemented sceUsbGetDrvList", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=288147793, version=150)
    public void sceUsbGetDrvState(Processor processor) {
        CpuState cpu = processor.cpu;
        int driverNameAddr = cpu.gpr[4];
        String driverName = Utilities.readStringZ(driverNameAddr);
        log.warn((Object)String.format("Unimplemented sceUsbGetDrvState driverName=0x%08X('%s')", driverNameAddr, driverName));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1483585580, version=150)
    public void sceUsbActivate(Processor processor) {
        CpuState cpu = processor.cpu;
        int pid = cpu.gpr[4];
        log.warn((Object)String.format("Unimplemented sceUsbActivate pid=0x%X", pid));
        this.usbActivated = true;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=-982341176, version=150)
    public void sceUsbDeactivate(Processor processor) {
        CpuState cpu = processor.cpu;
        int pid = cpu.gpr[4];
        log.warn((Object)String.format("Unimplemented sceUsbDeactivate pid=0x%08X", pid));
        this.usbActivated = false;
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=1541464066, version=150)
    public void sceUsbWaitState(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)String.format("Unimplemented sceUsbWaitState", new Object[0]));
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=473302837, version=150)
    public void sceUsbWaitCancel(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)String.format("Unimplemented sceUsbWaitCancel", new Object[0]));
        cpu.gpr[2] = 0;
    }
}

