/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules271;

import java.util.HashMap;
import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.Processor;

public class sceUtility
extends jpcsp.HLE.modules200.sceUtility {
    public static final String[] utilityAvModuleNames = new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_AV_MODULE_SASCORE", "PSP_AV_MODULE_ATRAC3PLUS", "PSP_AV_MODULE_MPEGBASE", "PSP_AV_MODULE_MP3", "PSP_AV_MODULE_VAUDIO", "PSP_AV_MODULE_AAC", "PSP_AV_MODULE_G729"};
    public static final String[] utilityUsbModuleNames = new String[]{"PSP_USB_MODULE_UNKNOWN_0", "PSP_USB_MODULE_PSPCM", "PSP_USB_MODULE_ACC", "PSP_USB_MODULE_MIC", "PSP_USB_MODULE_CAM", "PSP_USB_MODULE_GPS"};
    public static final int PSP_AV_MODULE_AVCODEC = 0;
    public static final int PSP_AV_MODULE_SASCORE = 1;
    public static final int PSP_AV_MODULE_ATRAC3PLUS = 2;
    public static final int PSP_AV_MODULE_MPEGBASE = 3;
    public static final int PSP_AV_MODULE_MP3 = 4;
    public static final int PSP_AV_MODULE_VAUDIO = 5;
    public static final int PSP_AV_MODULE_AAC = 6;
    public static final int PSP_AV_MODULE_G729 = 7;
    public static final int PSP_USB_MODULE_PSPCM = 1;
    public static final int PSP_USB_MODULE_ACC = 2;
    public static final int PSP_USB_MODULE_MIC = 3;
    public static final int PSP_USB_MODULE_CAM = 4;
    public static final int PSP_USB_MODULE_GPS = 5;
    protected HashMap<Integer, SceModule> loadedAvModules = new HashMap();
    protected HashMap<Integer, String> waitingAvModules = new HashMap();
    protected HashMap<Integer, SceModule> loadedUsbModules = new HashMap();
    protected HashMap<Integer, String> waitingUsbModules = new HashMap();

    private String getAvModuleName(int module) {
        if (module < 0 || module >= utilityAvModuleNames.length) {
            return "PSP_AV_MODULE_UNKNOWN_" + module;
        }
        return utilityAvModuleNames[module];
    }

    private String getUsbModuleName(int module) {
        if (module < 0 || module >= utilityUsbModuleNames.length) {
            return "PSP_USB_MODULE_UNKNOWN_" + module;
        }
        return utilityUsbModuleNames[module];
    }

    protected int hleUtilityLoadAvModule(int module, String moduleName) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (this.loadedAvModules.containsKey(module) || this.waitingAvModules.containsKey(module)) {
            return -2146365694;
        }
        if (!moduleManager.hasFlash0Module(moduleName)) {
            this.waitingAvModules.put(module, moduleName);
            return -2146365695;
        }
        int sceModuleId = moduleManager.LoadFlash0Module(moduleName);
        SceModule sceModule = Managers.modules.getModuleByUID(sceModuleId);
        this.loadedAvModules.put(module, sceModule);
        return 0;
    }

    protected int hleUtilityLoadUsbModule(int module, String moduleName) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (this.loadedUsbModules.containsKey(module) || this.waitingUsbModules.containsKey(module)) {
            return -2146365694;
        }
        if (!moduleManager.hasFlash0Module(moduleName)) {
            this.waitingUsbModules.put(module, moduleName);
            return -2146365695;
        }
        int sceModuleId = moduleManager.LoadFlash0Module(moduleName);
        SceModule sceModule = Managers.modules.getModuleByUID(sceModuleId);
        this.loadedUsbModules.put(module, sceModule);
        return 0;
    }

    protected int hleUtilityUnloadAvModule(int module) {
        if (this.loadedAvModules.containsKey(module)) {
            HLEModuleManager moduleManager = HLEModuleManager.getInstance();
            SceModule sceModule = this.loadedAvModules.remove(module);
            moduleManager.UnloadFlash0Module(sceModule);
            return 0;
        }
        if (this.waitingAvModules.containsKey(module)) {
            this.waitingAvModules.remove(module);
            return 0;
        }
        return -2146365693;
    }

    @HLEFunction(nid=-970346714, version=270, checkInsideInterrupt=true)
    public void sceUtilityLoadAvModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        String moduleName = this.getAvModuleName(module);
        int result = this.hleUtilityLoadAvModule(module, moduleName);
        if (result == -2146365695) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadAvModule(module=0x%04X) %s", module, moduleName));
            result = 0;
        } else {
            log.info((Object)String.format("sceUtilityLoadAvModule(module=0x%04X) %s loaded", module, moduleName));
        }
        cpu.gpr[2] = result;
    }

    @HLEFunction(nid=-136785774, version=270, checkInsideInterrupt=true)
    public void sceUtilityUnloadAvModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        String moduleName = this.getAvModuleName(module);
        log.info((Object)String.format("sceUtilityUnloadAvModule(module=0x%04X) %s unloaded", module, moduleName));
        cpu.gpr[2] = this.hleUtilityUnloadAvModule(module);
    }

    @HLEFunction(nid=1227406742, version=270, checkInsideInterrupt=true)
    public void sceUtilityMsgDialogAbort(Processor processor) {
        CpuState cpu = processor.cpu;
        log.warn((Object)"PARTIAL: sceUtilityMsgDialogAbort()");
        this.msgDialogState.abort();
        cpu.gpr[2] = 0;
    }

    @HLEFunction(nid=224118482, version=270, checkInsideInterrupt=true)
    public void sceUtilityLoadUsbModule(Processor processor) {
        CpuState cpu = processor.cpu;
        int module = cpu.gpr[4];
        String moduleName = this.getUsbModuleName(module);
        int result = this.hleUtilityLoadUsbModule(module, moduleName);
        if (result == -2146365695) {
            log.info((Object)String.format("IGNORING: sceUtilityLoadUsbModule(module=0x%04X) %s", module, moduleName));
            result = 0;
        } else {
            log.info((Object)String.format("sceUtilityLoadUsbModule(module=0x%04X) %s loaded", module, moduleName));
        }
        cpu.gpr[2] = result;
    }
}

