/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool;

import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.MediaReader;
import com.xuggle.mediatool.MediaViewer;
import com.xuggle.mediatool.MediaWriter;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.TestAudioSamplesGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaWriterTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final IMediaViewer.Mode mViewerMode;
    final String PREFIX;
    public static final String TEST_FILE_DIR = "fixtures";
    public static final String TEST_FILE = "fixtures/testfile_bw_pattern.flv";
    MediaReader mReader;

    public MediaWriterTest() {
        this.log.trace("<init>");
        this.mViewerMode = IMediaViewer.Mode.valueOf((String)System.getProperty(this.getClass().getName() + ".ViewerMode", IMediaViewer.Mode.DISABLED.name()));
        this.PREFIX = this.getClass().getName() + "-";
    }

    @Before
    public void beforeTest() {
        this.mReader = new MediaReader(TEST_FILE);
        this.mReader.setBufferedImageTypeToGenerate(5);
    }

    @After
    public void afterTest() {
        if (this.mReader.isOpen()) {
            this.mReader.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void improperReaderConfigTest() {
        File file = new File(this.PREFIX + "should-not-be-created.flv");
        file.delete();
        assert (!file.exists());
        this.mReader.setAddDynamicStreams(true);
        this.mReader.addListener((IMediaListener)new MediaWriter(file.toString(), (IMediaReader)this.mReader));
        assert (!file.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void improperUrlTest() {
        File file = new File("/tmp/foo/bar/baz/should-not-be-created.flv");
        file.delete();
        assert (!file.exists());
        this.mReader.addListener((IMediaListener)new MediaWriter(file.toString(), (IMediaReader)this.mReader));
        this.mReader.readPacket();
        assert (!file.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void improperInputContainerTypeTest() {
        File file = new File(this.PREFIX + "should-not-be-created.flv");
        MediaWriter writer = new MediaWriter(file.toString(), (IMediaReader)this.mReader);
        this.mReader.addListener((IMediaListener)writer);
        this.mReader.readPacket();
        file.delete();
        new MediaWriter(file.toString(), writer.getContainer());
    }

    @Test
    public void transcodeToFlvTest() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        File file = new File(this.PREFIX + "transcode-to-flv.flv");
        file.delete();
        assert (!file.exists());
        MediaWriter writer = new MediaWriter(file.toString(), (IMediaReader)this.mReader);
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        this.mReader.addListener((IMediaListener)writer);
        while (this.mReader.readPacket() == null) {
        }
        assert (file.exists());
        Assert.assertEquals((float)1062946.0f, (float)file.length(), (float)300.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void transcodeToMovTest() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        File file = new File(this.PREFIX + "transcode-to-mov.mov");
        file.delete();
        assert (!file.exists());
        MediaWriter writer = new MediaWriter(file.toString(), (IMediaReader)this.mReader);
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        this.mReader.addListener((IMediaListener)writer);
        while (this.mReader.readPacket() == null) {
        }
        assert (file.exists());
        Assert.assertEquals((float)928504.0f, (float)file.length(), (float)100000.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void transcodeWithContainer() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        File file = new File(this.PREFIX + "transcode-container.mov");
        file.delete();
        assert (!file.exists());
        MediaWriter writer = new MediaWriter(file.toString(), this.mReader.getContainer());
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        this.mReader.addListener((IMediaListener)writer);
        while (this.mReader.readPacket() == null) {
        }
        assert (file.exists());
        Assert.assertEquals((float)928504.0f, (float)file.length(), (float)100000.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void customVideoStream() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        File file = new File(this.PREFIX + "customVideo.flv");
        file.delete();
        assert (!file.exists());
        int videoStreamIndex = 0;
        int videoStreamId = 0;
        long deltaTime = 15000L;
        long time = 0L;
        int w = 200;
        int h = 200;
        MediaWriter writer = new MediaWriter(file.toString());
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        ICodec codec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_FLV1);
        writer.addVideoStream(videoStreamIndex, videoStreamId, codec, w, h);
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)w, (int)h);
        double deltaTheta = 0.031415926535897934;
        for (double theta = 0.0; theta < Math.PI * 2; theta += deltaTheta) {
            BufferedImage image = new BufferedImage(w, h, 5);
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.RED);
            g.rotate(theta, w / 2, h / 2);
            g.fillRect(50, 50, 100, 100);
            picture.setPts(time);
            writer.encodeVideo(videoStreamIndex, image, time, Global.DEFAULT_TIME_UNIT);
            time += deltaTime;
        }
        writer.close();
        assert (file.exists());
        Assert.assertEquals((float)file.length(), (float)291186.0f, (float)60000.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void customAudioStream() {
        File file = new File(this.PREFIX + "customAudio.mp3");
        file.delete();
        assert (!file.exists());
        int audioStreamIndex = 0;
        int audioStreamId = 0;
        int channelCount = 2;
        int sampleRate = 44100;
        int totalSeconds = 5;
        MediaWriter writer = new MediaWriter(file.toString());
        ICodec codec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        IContainer container = writer.getContainer();
        IStream stream = container.getStream((long)writer.addAudioStream(audioStreamIndex, audioStreamId, codec, channelCount, sampleRate));
        int sampleCount = stream.getStreamCoder().getDefaultAudioFrameSize();
        IAudioSamples samples = IAudioSamples.make((long)sampleCount, (long)channelCount);
        TestAudioSamplesGenerator generator = new TestAudioSamplesGenerator();
        generator.prepare(channelCount, sampleRate);
        int totalSamples = 0;
        while (totalSamples < sampleRate * totalSeconds) {
            generator.fillNextSamples(samples, (long)sampleCount);
            writer.encodeAudio(audioStreamIndex, samples);
            totalSamples = (int)((long)totalSamples + samples.getNumSamples());
        }
        writer.close();
        assert (file.exists());
        Assert.assertEquals((float)file.length(), (float)40365.0f, (float)100.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void customAudioStreamWithoutTimeStamps() {
        File file = new File(this.PREFIX + "customAudioWithoutTimeStamps.mp3");
        file.delete();
        assert (!file.exists());
        int audioStreamIndex = 0;
        int audioStreamId = 0;
        int channelCount = 2;
        int sampleRate = 44100;
        int totalSeconds = 5;
        MediaWriter writer = new MediaWriter(file.toString());
        ICodec codec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        IContainer container = writer.getContainer();
        int streamIndex = writer.addAudioStream(audioStreamIndex, audioStreamId, codec, channelCount, sampleRate);
        IStream stream = container.getStream((long)streamIndex);
        int sampleCount = stream.getStreamCoder().getDefaultAudioFrameSize();
        IAudioSamples samples = IAudioSamples.make((long)sampleCount, (long)channelCount);
        TestAudioSamplesGenerator generator = new TestAudioSamplesGenerator();
        generator.prepare(channelCount, sampleRate);
        int totalSamples = 0;
        short[] javaSamples = new short[sampleCount * channelCount];
        while (totalSamples < sampleRate * totalSeconds) {
            generator.fillNextSamples(samples, (long)sampleCount);
            samples.get(0, javaSamples, 0, javaSamples.length);
            writer.encodeAudio(streamIndex, javaSamples);
            totalSamples = (int)((long)totalSamples + samples.getNumSamples());
        }
        writer.close();
        assert (file.exists());
        Assert.assertEquals((float)file.length(), (float)40365.0f, (float)100.0f);
        this.log.debug("manually check: " + file);
    }

    @Test
    public void customAudioVideoStream() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        File file = new File(this.PREFIX + "customAudioVideo.flv");
        file.delete();
        assert (!file.exists());
        int videoStreamIndex = 0;
        int videoStreamId = 0;
        long deltaTime = 15000L;
        int w = 200;
        int h = 200;
        int audioStreamIndex = 1;
        int audioStreamId = 0;
        int channelCount = 2;
        int sampleRate = 44100;
        MediaWriter writer = new MediaWriter(file.toString());
        writer.addListener((IMediaListener)new MediaViewer(this.mViewerMode, true));
        ICodec videoCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_FLV1);
        writer.addVideoStream(videoStreamIndex, videoStreamId, videoCodec, w, h);
        ICodec audioCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        IContainer container = writer.getContainer();
        IStream stream = container.getStream((long)writer.addAudioStream(audioStreamIndex, audioStreamId, audioCodec, channelCount, sampleRate));
        int sampleCount = stream.getStreamCoder().getDefaultAudioFrameSize();
        IAudioSamples samples = IAudioSamples.make((long)sampleCount, (long)channelCount);
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.YUV420P, (int)w, (int)h);
        TestAudioSamplesGenerator generator = new TestAudioSamplesGenerator();
        generator.prepare(channelCount, sampleRate);
        long videoTime = 0L;
        long audioTime = 0L;
        long totalSeconds = 6L;
        for (long totalSamples = 0L; totalSamples < (long)sampleRate * totalSeconds; totalSamples += samples.getNumSamples()) {
            audioTime = totalSamples * 1000L * 1000L / (long)sampleRate;
            if (audioTime >= videoTime) {
                BufferedImage image = new BufferedImage(w, h, 5);
                Graphics2D g = image.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double theta = (double)videoTime / 1000000.0;
                g.setColor(Color.RED);
                g.rotate(theta, w / 2, h / 2);
                g.fillRect(50, 50, 100, 100);
                picture.setPts(videoTime);
                writer.encodeVideo(videoStreamIndex, image, videoTime, Global.DEFAULT_TIME_UNIT);
                videoTime += deltaTime;
            }
            generator.fillNextSamples(samples, (long)sampleCount);
            writer.encodeAudio(audioStreamIndex, samples);
        }
        writer.close();
        assert (file.exists());
        Assert.assertEquals((float)file.length(), (float)521938.0f, (float)120000.0f);
        this.log.debug("manually check: " + file);
    }

    @Test(expected=RuntimeException.class)
    public void lateStreamException() {
        File file = new File(this.PREFIX + "late-stream-exception.mp3");
        file.delete();
        assert (!file.exists());
        int audioStreamIndex = 0;
        int audioStreamId = 0;
        int channelCount = 2;
        int sampleRate = 44100;
        MediaWriter writer = new MediaWriter(file.toString());
        ICodec codec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        IContainer container = writer.getContainer();
        IStream stream = container.getStream((long)writer.addAudioStream(audioStreamIndex, audioStreamId, codec, channelCount, sampleRate));
        int sampleCount = stream.getStreamCoder().getDefaultAudioFrameSize();
        IAudioSamples samples = IAudioSamples.make((long)sampleCount, (long)channelCount);
        TestAudioSamplesGenerator generator = new TestAudioSamplesGenerator();
        generator.prepare(channelCount, sampleRate);
        generator.fillNextSamples(samples, (long)sampleCount);
        writer.encodeAudio(audioStreamIndex, samples);
        file.delete();
        generator.fillNextSamples(samples, (long)sampleCount);
        writer.encodeAudio(audioStreamIndex + 1, samples);
        assert (false);
    }

    @Test
    public void lateStreamExceptionMask() {
        File file = new File(this.PREFIX + "late-stream-exception.mp3");
        file.delete();
        assert (!file.exists());
        int audioStreamIndex = 0;
        int audioStreamId = 0;
        int channelCount = 2;
        int sampleRate = 44100;
        MediaWriter writer = new MediaWriter(file.toString());
        writer.setMaskLateStreamExceptions(true);
        ICodec codec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        IContainer container = writer.getContainer();
        IStream stream = container.getStream((long)writer.addAudioStream(audioStreamIndex, audioStreamId, codec, channelCount, sampleRate));
        int sampleCount = stream.getStreamCoder().getDefaultAudioFrameSize();
        IAudioSamples samples = IAudioSamples.make((long)sampleCount, (long)channelCount);
        TestAudioSamplesGenerator generator = new TestAudioSamplesGenerator();
        generator.prepare(channelCount, sampleRate);
        generator.fillNextSamples(samples, (long)sampleCount);
        writer.encodeAudio(audioStreamIndex, samples);
        generator.fillNextSamples(samples, (long)sampleCount);
        writer.encodeAudio(audioStreamIndex + 1, samples);
        file.delete();
    }

    @Test
    public void testTimebaseGuessingWhenCodecSpecifiedAllowed() {
        MediaWriter writer = new MediaWriter(this.PREFIX + "testTimebaseGuessingWhenCodecSpecifiedAllowed1.mpg");
        try {
            writer.addVideoStream(0, 0, IRational.make((int)27, (int)1), 100, 100);
            Assert.fail((String)"shouldn't get here");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        writer = new MediaWriter(this.PREFIX + "testTimebaseGuessingWhenCodecSpecifiedAllowed2.mpg");
        writer.addVideoStream(0, 0, 100, 100);
        IStreamCoder coder = writer.getContainer().getStream(0L).getStreamCoder();
        Assert.assertEquals((int)1, (int)coder.getTimeBase().getNumerator());
        Assert.assertEquals((int)60, (int)coder.getTimeBase().getDenominator());
    }
}

