/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.Helper;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IPacket;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IPacket mPacket = null;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
        if (this.mPacket != null) {
            this.mPacket.delete();
        }
        this.mPacket = null;
    }

    @Test
    public void testPacketCreation() {
        this.mPacket = IPacket.make();
        PacketTest.assertTrue((String)"could not create a packet", (this.mPacket != null ? 1 : 0) != 0);
        this.mPacket.delete();
        this.mPacket = null;
    }

    @Test
    public void testReadPacket() {
        Helper h = new Helper();
        int retval = 0;
        long pts = -1L;
        long dts = -1L;
        int size = -1;
        int index = -1;
        int flags = -1;
        long duration = -1L;
        long position = -1L;
        h.setupReadingObject(h.sampleFile);
        pts = h.mPacket.getPts();
        dts = h.mPacket.getDts();
        size = h.mPacket.getSize();
        index = h.mPacket.getStreamIndex();
        flags = h.mPacket.getFlags();
        duration = h.mPacket.getDuration();
        position = h.mPacket.getPosition();
        PacketTest.assertTrue((position == -1L ? 1 : 0) != 0);
        retval = h.mContainer.readNextPacket(h.mPacket);
        PacketTest.assertTrue((String)"Could not read packet", (retval >= 0 ? 1 : 0) != 0);
        pts = h.mPacket.getPts();
        dts = h.mPacket.getDts();
        size = h.mPacket.getSize();
        index = h.mPacket.getStreamIndex();
        flags = h.mPacket.getFlags();
        duration = h.mPacket.getDuration();
        position = h.mPacket.getPosition();
        this.log.debug("First packet from url: {}", (Object)h.sampleFile);
        this.log.debug("PTS: {}", (Object)pts);
        this.log.debug("DTS: {}", (Object)dts);
        this.log.debug("Size: {}", (Object)size);
        this.log.debug("Stream Index: {}", (Object)index);
        this.log.debug("Flags: {}", (Object)flags);
        this.log.debug("Duration: {}", (Object)duration);
        this.log.debug("Position: {}", (Object)position);
        PacketTest.assertTrue((pts == 0L ? 1 : 0) != 0);
        PacketTest.assertTrue((dts == 0L ? 1 : 0) != 0);
        PacketTest.assertTrue((size == 5516 ? 1 : 0) != 0);
        PacketTest.assertTrue((flags == 1 ? 1 : 0) != 0);
        PacketTest.assertTrue((duration == 0L ? 1 : 0) != 0);
        PacketTest.assertTrue((position == 284L ? 1 : 0) != 0);
    }

    @Test
    public void testReadFile() {
        Helper h = new Helper();
        int retval = 0;
        int audioStream = -1;
        int videoStream = -1;
        int numVidPkts = 0;
        int numAudPkts = 0;
        h.setupReadingObject(h.sampleFile);
        PacketTest.assertTrue((String)"unexpected number of streams", (h.mContainer.getNumStreams() == 2 ? 1 : 0) != 0);
        for (int i = 0; i < h.mContainer.getNumStreams(); ++i) {
            if (h.mCoders[i].getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                audioStream = i;
                continue;
            }
            if (h.mCoders[i].getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                videoStream = i;
                continue;
            }
            PacketTest.fail((String)"Unknown stream type");
        }
        PacketTest.assertTrue((String)"no audio stream", (audioStream >= 0 ? 1 : 0) != 0);
        PacketTest.assertTrue((String)"no video stream", (videoStream >= 0 ? 1 : 0) != 0);
        long lastPosition = -1L;
        do {
            if ((retval = h.mContainer.readNextPacket(h.mPacket)) != 0 || !h.mPacket.isComplete()) continue;
            if (h.mPacket.getStreamIndex() == videoStream) {
                ++numVidPkts;
            } else if (h.mPacket.getStreamIndex() == audioStream) {
                ++numAudPkts;
            } else {
                PacketTest.fail((String)("unexpected stream: " + h.mPacket.getStreamIndex()));
            }
            long newPosition = h.mPacket.getPosition();
            PacketTest.assertTrue((newPosition > lastPosition ? 1 : 0) != 0);
            lastPosition = newPosition;
        } while (retval >= 0);
        this.log.debug("got {} video packets", (Object)numVidPkts);
        this.log.debug("got {} audio packets", (Object)numAudPkts);
        PacketTest.assertTrue((String)"no video packets", (numVidPkts > 0 ? 1 : 0) != 0);
        PacketTest.assertTrue((String)"no audio packets", (numAudPkts > 0 ? 1 : 0) != 0);
        PacketTest.assertTrue((String)"unexpected number of video packets", (numVidPkts == 2236 ? 1 : 0) != 0);
        PacketTest.assertTrue((String)"unexpected number of audio packets", (numAudPkts == 5714 ? 1 : 0) != 0);
    }
}

