/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IRational;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RationalTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IRational mRational = null;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
        if (this.mRational != null) {
            this.mRational.delete();
        }
        this.mRational = null;
    }

    @Test
    public void testConstructorsAndGetters() {
        this.mRational = IRational.make();
        RationalTest.assertTrue((this.mRational.getNumerator() == 0 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 1 ? 1 : 0) != 0);
        this.mRational.delete();
        this.mRational = null;
        this.mRational = IRational.make((double)6.0);
        RationalTest.assertTrue((this.mRational.getNumerator() == 6 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 1 ? 1 : 0) != 0);
        this.mRational.delete();
        this.mRational = null;
        this.mRational = IRational.make((double)6.1);
        RationalTest.assertTrue((this.mRational.getNumerator() == 61 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 10 ? 1 : 0) != 0);
        this.mRational.delete();
        this.mRational = null;
    }

    @Test
    public void testReduction() {
        int retval = -1;
        this.mRational = IRational.make((double)2.2);
        RationalTest.assertTrue((this.mRational.getNumerator() == 11 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 5 ? 1 : 0) != 0);
        retval = this.mRational.reduce((long)(this.mRational.getNumerator() * 5), (long)(this.mRational.getDenominator() * 10), 100L);
        RationalTest.assertTrue((String)"not exact reduction", (retval == 1 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getNumerator() == 11 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 10 ? 1 : 0) != 0);
        retval = IRational.sReduce((IRational)this.mRational, (long)33L, (long)32L, (long)10L);
        RationalTest.assertTrue((String)"exact reduction?", (retval == 0 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getNumerator() == 1 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 1 ? 1 : 0) != 0);
        retval = this.mRational.reduce(33L, 0L, 10L);
        RationalTest.assertTrue((String)"exact reduction?", (retval == 1 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getNumerator() == 1 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareTo() {
        int retval = -1;
        IRational otherRational = IRational.make((double)5.0);
        this.mRational = IRational.make((double)4.0);
        retval = this.mRational.compareTo(otherRational);
        RationalTest.assertTrue((retval < 0 ? 1 : 0) != 0);
        retval = otherRational.compareTo(this.mRational);
        RationalTest.assertTrue((retval > 0 ? 1 : 0) != 0);
        retval = this.mRational.compareTo(this.mRational);
        RationalTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = IRational.sCompareTo((IRational)this.mRational, (IRational)otherRational);
        RationalTest.assertTrue((retval < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetDouble() {
        double retval = -1.0;
        this.mRational = IRational.make();
        retval = this.mRational.getDouble();
        RationalTest.assertTrue((retval == 0.0 ? 1 : 0) != 0);
        this.mRational = IRational.make();
        this.mRational.reduce(1L, 0L, 10L);
        retval = this.mRational.getDouble();
        RationalTest.assertTrue((String)("double is valid: " + retval), (boolean)Double.isInfinite(retval));
    }

    @Test
    public void testMultiply() {
        IRational a = IRational.make((double)12.0);
        IRational b = IRational.make((double)3.0);
        this.mRational = IRational.sMultiply((IRational)a, (IRational)b);
        RationalTest.assertTrue((this.mRational.getDouble() == 36.0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdd() {
        IRational a = IRational.make((double)12.0);
        IRational b = IRational.make((double)3.0);
        this.mRational = IRational.sAdd((IRational)a, (IRational)b);
        RationalTest.assertTrue((this.mRational.getDouble() == 15.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSubtract() {
        IRational a = IRational.make((double)12.0);
        IRational b = IRational.make((double)3.0);
        this.mRational = IRational.sSubtract((IRational)a, (IRational)b);
        RationalTest.assertTrue((this.mRational.getDouble() == 9.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDivision() {
        IRational a = IRational.make((double)12.0);
        IRational b = IRational.make((double)3.0);
        this.mRational = IRational.sDivide((IRational)a, (IRational)b);
        RationalTest.assertTrue((this.mRational.getDouble() == 4.0 ? 1 : 0) != 0);
        this.mRational = IRational.sDivide((IRational)IRational.make((double)1.0), (IRational)IRational.make((double)0.0));
        RationalTest.assertTrue((boolean)Double.isInfinite(this.mRational.getDouble()));
        this.mRational = IRational.sDivide((IRational)IRational.make((double)0.0), (IRational)IRational.make((double)0.0));
        RationalTest.assertTrue((boolean)Double.isNaN(this.mRational.getDouble()));
    }

    @Test
    public void testCreateFromNumAndDen() {
        this.mRational = IRational.make((int)1, (int)10);
        RationalTest.assertTrue((this.mRational.getDouble() == 0.1 ? 1 : 0) != 0);
        this.mRational = IRational.make((int)2, (int)10);
        RationalTest.assertTrue((this.mRational.getDouble() == 0.2 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getNumerator() == 1 ? 1 : 0) != 0);
        RationalTest.assertTrue((this.mRational.getDenominator() == 5 ? 1 : 0) != 0);
    }
}

