/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.Converter;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.Utils;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class RegressionsExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;
    private Converter converter = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testWrongPictureFormatConversionRegression18() throws ParseException {
        String[] args = new String[]{"--acodec", "libmp3lame", "fixtures/testfile.flv", this.getClass().getName() + "_" + this.mTestName + ".mov"};
        this.converter = new ConverterWrongPictureFormat();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        try {
            this.converter.run(cmdLine);
            Assert.fail((String)"should fail with an error");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testConversionNellymoser() throws ParseException {
        boolean testResampling = IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_IMAGERESCALING);
        String[] args = new String[]{"--containerformat", "flv", "--acodec", "nellymoser", "--asamplerate", "22050", "--achannels", "1", "--abitrate", "64000", "--aquality", "0", "--vcodec", "flv", "--vscalefactor", !testResampling ? "1.0" : "2.0", "--vbitrate", "300000", "--vquality", "0", "fixtures/testfile.flv", this.getClass().getName() + "_" + this.mTestName + ".flv"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    @Test
    public void testRegressionIssue51() throws ParseException {
        String[] args = new String[]{"--acodec", "libmp3lame", "--asamplerate", "22050", "fixtures/testfile_mpeg1video_mp2audio.mpg", this.getClass().getName() + "_" + this.mTestName + ".flv"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    @Test
    public void testRegressionIssue69() throws ParseException {
        String outFilename = this.getClass().getName() + "_" + this.mTestName + ".ogg";
        String[] args = new String[]{"--vno", "--acodec", "flac", "--asamplerate", "22050", "fixtures/testfile_videoonly_20sec.flv", outFilename};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
        File outFile = new File(outFilename);
        Assert.assertTrue((String)"output file not large enough", (outFile.length() > 160L ? 1 : 0) != 0);
    }

    @Test
    public void testRegressionIssue104() throws ParseException {
        String outFilename = this.getClass().getName() + "_" + this.mTestName + ".flv";
        String[] args = new String[]{"--vno", "--acodec", "libmp3lame", "--asamplerate", "22050", "fixtures/testfile_wmv3_wmav2_bad_audio_timestamps.wmv", outFilename};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
        File outFile = new File(outFilename);
        Assert.assertTrue((String)"output file not large enough", (outFile.length() > 160L ? 1 : 0) != 0);
    }

    @Test
    public void testRegressionIssue119() {
        IVideoPicture picture = Utils.getBlankFrame((int)10, (int)10, (int)0);
        Assert.assertNotNull((Object)picture);
        IStreamCoder coder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING);
        Assert.assertNotNull((Object)coder);
        coder.setTimeBase(IRational.make((int)1, (int)1000000));
        coder.setCodec(ICodec.ID.CODEC_ID_FLV1);
        coder.setPixelType(IPixelFormat.Type.YUV420P);
        coder.setWidth(20);
        coder.setHeight(20);
        Assert.assertTrue((coder.open() >= 0 ? 1 : 0) != 0);
        IPacket packet = IPacket.make();
        Assert.assertNotNull((Object)packet);
        Assert.assertTrue((coder.encodeVideo(packet, picture, 0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegressionIssue203() throws ParseException {
        String outFilename = this.getClass().getName() + "_" + this.mTestName + ".wav";
        String[] args = new String[]{"--icontainerformat", "s16le", "--iasamplerate", "16000", "--iachannels", "1", "fixtures/test.raw", outFilename};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        Assert.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
        File outFile = new File(outFilename);
        Assert.assertTrue((String)"output file not large enough", (outFile.length() > 160L ? 1 : 0) != 0);
    }

    @Test
    public void testRegressionIssue203_2() {
        IContainerFormat fmt = IContainerFormat.make();
        fmt.setInputFormat("s16le");
        IContainer container = IContainer.make();
        int retval = container.open("fixtures/test.raw", IContainer.Type.READ, fmt, false, false);
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        int numStreams = container.getNumStreams();
        Assert.assertEquals((long)1L, (long)numStreams);
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            coder.setSampleRate(16000);
        }
        IPacket pkt = IPacket.make();
        retval = container.readNextPacket(pkt);
        System.out.println("Duration: " + pkt.getDuration());
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRegressionIssue219() {
        for (ICodec c : ICodec.getInstalledCodecs()) {
            c.getID();
        }
    }

    class ConverterWrongPictureFormat
    extends Converter {
        ConverterWrongPictureFormat() {
        }

        protected IVideoPicture alterVideoFrame(IVideoPicture picture1) {
            IVideoPicture picture2;
            int h;
            int w = picture1.getWidth();
            IVideoResampler resampleToRgb32 = IVideoResampler.make((int)w, (int)(h = picture1.getHeight()), (IPixelFormat.Type)IPixelFormat.Type.ARGB, (int)w, (int)h, (IPixelFormat.Type)picture1.getPixelType());
            if (resampleToRgb32.resample(picture2 = IVideoPicture.make((IPixelFormat.Type)resampleToRgb32.getOutputPixelFormat(), (int)w, (int)h), picture1) < 0) {
                throw new RuntimeException("could not resample picture.");
            }
            return picture2;
        }
    }
}

