/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.DataInputOutputHandler;
import com.xuggle.xuggler.io.FileProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.InputOutputStreamHandler;
import com.xuggle.xuggler.io.ReadableWritableChannelHandler;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class XugglerIOExhaustiveTest {
    private static final String TEST_FILE = "fixtures/testfile.flv";
    private final IURLProtocolHandler mReadHandler;
    private final IURLProtocolHandler mWriteHandler;
    private final boolean mStreamable;

    @Parameterized.Parameters
    public static Collection<Object[]> getHandlersToTest() throws FileNotFoundException {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        retval.add(new Object[]{new InputOutputStreamHandler((InputStream)new FileInputStream(TEST_FILE), null, true), null, true});
        retval.add(new Object[]{null, new InputOutputStreamHandler(null, (OutputStream)new FileOutputStream(XugglerIOExhaustiveTest.class.getName() + "_" + "InputOutputStreamHandlerTest.flv"), true), true});
        retval.add(new Object[]{new DataInputOutputHandler((DataInput)new DataInputStream(new FileInputStream(TEST_FILE)), null, true), null, true});
        retval.add(new Object[]{null, new DataInputOutputHandler(null, (DataOutput)new DataOutputStream(new FileOutputStream(XugglerIOExhaustiveTest.class.getName() + "_" + "DataInputOutputHandlerTest.flv")), true), true});
        retval.add(new Object[]{new DataInputOutputHandler((DataInput)new RandomAccessFile(TEST_FILE, "r"), null, true), null, false});
        retval.add(new Object[]{null, new DataInputOutputHandler(null, (DataOutput)new RandomAccessFile(XugglerIOExhaustiveTest.class.getName() + "_" + "InputOutputStreamHandlerTest.flv", "rw"), true), false});
        retval.add(new Object[]{new ReadableWritableChannelHandler((ReadableByteChannel)new FileInputStream(TEST_FILE).getChannel(), null, true), null, true});
        retval.add(new Object[]{null, new ReadableWritableChannelHandler(null, (WritableByteChannel)new FileOutputStream(XugglerIOExhaustiveTest.class.getName() + "_" + "DataInputOutputHandlerTest.flv").getChannel(), true), true});
        return retval;
    }

    public XugglerIOExhaustiveTest(IURLProtocolHandler readHandler, IURLProtocolHandler writeHandler, boolean expectStreamable) {
        Assert.assertTrue((readHandler != null || writeHandler != null ? 1 : 0) != 0);
        this.mReadHandler = readHandler;
        this.mWriteHandler = null;
        this.mStreamable = expectStreamable;
    }

    @Test
    public void testIsStremable() {
        if (this.mReadHandler != null) {
            Assert.assertEquals((String)("unexpected streamable flag on: " + this.mReadHandler), (Object)this.mStreamable, (Object)this.mReadHandler.isStreamed(null, 0));
        }
        if (this.mWriteHandler != null) {
            Assert.assertEquals((String)("unexpected streamable flag on: " + this.mWriteHandler), (Object)this.mStreamable, (Object)this.mWriteHandler.isStreamed(null, 0));
        }
    }

    @Test
    public void testReading() {
        int retval = 0;
        if (this.mReadHandler == null) {
            return;
        }
        retval = this.mReadHandler.open(null, 0);
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        long bytesRead = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = this.mReadHandler.read(buffer, buffer.length)) > 0) {
            bytesRead += (long)retval;
        }
        retval = this.mReadHandler.close();
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)("unexpected byte count on: " + this.mReadHandler), (long)4546420L, (long)bytesRead);
    }

    @Test
    public void testWriting() {
        int retval = 0;
        if (this.mWriteHandler == null) {
            return;
        }
        retval = this.mWriteHandler.open(null, 1);
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        FileProtocolHandler readHandler = new FileProtocolHandler(TEST_FILE);
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        long bytesWritten = 0L;
        long totalBytes = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = readHandler.read(buffer, buffer.length)) > 0) {
            totalBytes += (long)retval;
            Assert.assertTrue(((retval = this.mWriteHandler.write(buffer, retval)) >= 0 ? 1 : 0) != 0);
            bytesWritten += (long)retval;
        }
        Assert.assertEquals((long)totalBytes, (long)bytesWritten);
        Assert.assertEquals((long)4546420L, (long)totalBytes);
        retval = this.mWriteHandler.close();
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        retval = readHandler.close();
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }
}

