/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.DataInputOutputHandler;
import com.xuggle.xuggler.io.FfmpegIO;
import com.xuggle.xuggler.io.FfmpegIOHandle;
import com.xuggle.xuggler.io.FileProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandler;
import com.xuggle.xuggler.io.IURLProtocolHandlerFactory;
import com.xuggle.xuggler.io.InputOutputStreamHandler;
import com.xuggle.xuggler.io.ReadableWritableChannelHandler;
import com.xuggle.xuggler.io.URLProtocolManager;
import com.xuggle.xuggler.io.XugglerIO;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class XugglerIOTest
extends TestCase {
    private XugglerIO mFactory = null;
    private IURLProtocolHandler mHandler = null;
    private final String mSampleFile = "fixtures/testfile.flv";
    private final String mProtocolString = "xuggler";

    @Before
    public void setUp() {
        this.mFactory = new XugglerIO();
        URLProtocolManager.getManager().registerFactory("xuggler", (IURLProtocolHandlerFactory)this.mFactory);
        this.mHandler = null;
    }

    @After
    public void tearDown() {
        this.mHandler = null;
    }

    @Test
    public void testValidFFMPEGURLFileOpenForReading() throws FileNotFoundException {
        int flags = 0;
        FileInputStream stream = new FileInputStream("fixtures/testfile.flv");
        String url = "xuggler:fixtures/testfile.flv";
        this.mFactory.mapIO(url, (IURLProtocolHandler)new InputOutputStreamHandler((InputStream)stream, null, true), false);
        int retval = -1;
        this.mHandler = this.mFactory.getHandler("xuggler", url, flags);
        XugglerIOTest.assertTrue((String)"could not find a mHandler using the mFactory", (this.mHandler != null ? 1 : 0) != 0);
        retval = this.mHandler.open(null, flags);
        XugglerIOTest.assertEquals((int)0, (int)retval);
        retval = this.mHandler.close();
        XugglerIOTest.assertEquals((int)0, (int)retval);
        retval = this.mHandler.open(url, flags);
        XugglerIOTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        retval = this.mHandler.close();
        XugglerIOTest.assertEquals((int)0, (int)retval);
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)url, (int)flags);
        XugglerIOTest.assertEquals((int)0, (int)retval);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        XugglerIOTest.assertTrue((retval == 0 ? 1 : 0) != 0);
        XugglerIOTest.assertNotNull((Object)this.mFactory.unmapIO(url));
    }

    @Test
    public void testAutoUnmapping() throws FileNotFoundException {
        int flags = 0;
        FileInputStream stream = new FileInputStream("fixtures/testfile.flv");
        String url = "xuggler:1";
        this.mFactory.mapIO(url, (IURLProtocolHandler)new InputOutputStreamHandler((InputStream)stream, null, true), true);
        int retval = -1;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)url, (int)flags);
        XugglerIOTest.assertEquals((int)0, (int)retval);
        XugglerIOTest.assertNull((String)"found handler when we expected it to be unmapped", (Object)this.mFactory.unmapIO(url));
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        XugglerIOTest.assertEquals((int)0, (int)retval);
    }

    @Test
    public void testFileRead() throws FileNotFoundException {
        FileInputStream stream = new FileInputStream("fixtures/testfile.flv");
        this.mHandler = new InputOutputStreamHandler((InputStream)stream, null, true);
        int retval = 0;
        retval = this.mHandler.open("fixtures/testfile.flv", 0);
        XugglerIOTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        long bytesRead = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = this.mHandler.read(buffer, buffer.length)) > 0) {
            bytesRead += (long)retval;
        }
        retval = this.mHandler.close();
        XugglerIOTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        XugglerIOTest.assertEquals((long)4546420L, (long)bytesRead);
    }

    @Test
    public void testFileWrite() throws FileNotFoundException {
        String copyFile = ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv";
        FileInputStream inStream = new FileInputStream("fixtures/testfile.flv");
        FileOutputStream outStream = new FileOutputStream(copyFile);
        this.mHandler = new InputOutputStreamHandler(null, (OutputStream)outStream, true);
        int retval = 0;
        retval = this.mHandler.open(copyFile, 1);
        XugglerIOTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        InputOutputStreamHandler reader = new InputOutputStreamHandler((InputStream)inStream, null, true);
        retval = reader.open(null, 0);
        long bytesWritten = 0L;
        long totalBytes = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = reader.read(buffer, buffer.length)) > 0) {
            totalBytes += (long)retval;
            XugglerIOTest.assertTrue(((retval = this.mHandler.write(buffer, retval)) >= 0 ? 1 : 0) != 0);
            bytesWritten += (long)retval;
        }
        XugglerIOTest.assertEquals((long)totalBytes, (long)bytesWritten);
        XugglerIOTest.assertEquals((long)4546420L, (long)totalBytes);
        retval = reader.close();
        XugglerIOTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
        retval = this.mHandler.close();
        XugglerIOTest.assertTrue((retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFFMPEGUrlRead() {
        this.testFFMPEGUrlReadTestFile("fixtures/testfile.flv");
    }

    @Test
    public void testFFMPEGIOUrlRead() throws FileNotFoundException {
        FileInputStream stream = new FileInputStream("fixtures/testfile.flv");
        this.mFactory.mapIO("fixtures/testfile.flv", (IURLProtocolHandler)new InputOutputStreamHandler((InputStream)stream, null, true), true);
        this.testFFMPEGUrlReadTestFile("xuggler:fixtures/testfile.flv");
    }

    private void testFFMPEGUrlReadTestFile(String filename) {
        long retval = 0L;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)filename, (int)0);
        XugglerIOTest.assertTrue((String)("url_open(" + filename + ") failed: " + retval), (retval >= 0L ? 1 : 0) != 0);
        long bytesRead = 0L;
        byte[] buffer = new byte[1024];
        while ((retval = (long)FfmpegIO.url_read((FfmpegIOHandle)handle, (byte[])buffer, (int)buffer.length)) > 0L) {
            bytesRead += retval;
        }
        XugglerIOTest.assertEquals((long)4546420L, (long)bytesRead);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        XugglerIOTest.assertTrue((String)("url_close failed: " + retval), (retval >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testFfmpegIoUrlWrite() throws FileNotFoundException {
        String outFile = ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".flv";
        FileOutputStream stream = new FileOutputStream(outFile);
        this.mFactory.mapIO(outFile, (IURLProtocolHandler)new InputOutputStreamHandler(null, (OutputStream)stream, true), true);
        this.testFFMPEGUrlWriteTestFile("xuggler:" + outFile);
    }

    private void testFFMPEGUrlWriteTestFile(String filename) {
        int retval = 0;
        FfmpegIOHandle handle = new FfmpegIOHandle();
        retval = FfmpegIO.url_open((FfmpegIOHandle)handle, (String)filename, (int)1);
        XugglerIOTest.assertTrue((String)("url_open failed for filename: " + filename + "; : " + retval), (retval >= 0 ? 1 : 0) != 0);
        byte[] buffer = new byte[]{70, 76, 86, 0};
        retval = FfmpegIO.url_write((FfmpegIOHandle)handle, (byte[])buffer, (int)buffer.length);
        XugglerIOTest.assertTrue((String)("url_write failed: " + retval), (retval == buffer.length ? 1 : 0) != 0);
        retval = FfmpegIO.url_close((FfmpegIOHandle)handle);
        XugglerIOTest.assertTrue((String)("url_close failed: " + retval), (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFFMPEGIORandomAccesssRead() throws FileNotFoundException {
        String inName = "fixtures/testfile.flv";
        RandomAccessFile stream = new RandomAccessFile(inName, "rw");
        this.mFactory.mapIO("fixtures/testfile.flv", (IURLProtocolHandler)new DataInputOutputHandler(stream), true);
        this.testFFMPEGUrlReadTestFile("xuggler:" + inName);
    }

    @Test
    public void testFFMPEGIORandomAccesssWrite() throws FileNotFoundException {
        String outName = ((Object)((Object)this)).getClass().getName() + this.getName() + ".flv";
        RandomAccessFile stream = new RandomAccessFile(outName, "rw");
        this.mFactory.mapIO(outName, (IURLProtocolHandler)new DataInputOutputHandler(stream), true);
        this.testFFMPEGUrlWriteTestFile("xuggler:" + outName);
    }

    @Test
    public void testFFMPEGIOFileChannelWrite() throws FileNotFoundException {
        String outName = ((Object)((Object)this)).getClass().getName() + this.getName() + ".flv";
        FileChannel channel = new FileOutputStream(outName).getChannel();
        this.mFactory.mapIO(outName, (IURLProtocolHandler)new ReadableWritableChannelHandler(null, (WritableByteChannel)channel, true), true);
        this.testFFMPEGUrlWriteTestFile("xuggler:" + outName);
    }

    @Test
    public void testFFMPEGIOFileChannelRead() throws FileNotFoundException {
        String inName = "fixtures/testfile.flv";
        FileChannel channel = new FileInputStream(inName).getChannel();
        this.mFactory.mapIO("fixtures/testfile.flv", (IURLProtocolHandler)new ReadableWritableChannelHandler((ReadableByteChannel)channel, null, true), true);
        this.testFFMPEGUrlReadTestFile("xuggler:fixtures/testfile.flv");
    }

    @Test
    public void testFFMPEGIOUrlProtocolHandlerRead() {
        FileProtocolHandler handler = new FileProtocolHandler("fixtures/testfile.flv");
        this.mFactory.mapIO("fixtures/testfile.flv", (IURLProtocolHandler)handler, true);
        this.testFFMPEGUrlReadTestFile("xuggler:fixtures/testfile.flv");
    }

    @Test
    public void testFFMPEGIOURLProtocolHandlerWrite() {
        String outName = ((Object)((Object)this)).getClass().getName() + this.getName() + ".flv";
        FileProtocolHandler handler = new FileProtocolHandler(outName);
        this.mFactory.mapIO(outName, (IURLProtocolHandler)handler, true);
        this.testFFMPEGUrlWriteTestFile("xuggler:" + outName);
    }
}

