/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.Utils;
import com.xuggle.xuggler.demos.VideoImage;
import java.awt.image.BufferedImage;

public class DecodeAndPlayVideo {
    private static VideoImage mScreen = null;

    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new IllegalArgumentException("must pass in a filename as the first argument");
        }
        String filename = args[0];
        if (!IVideoResampler.isSupported(IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            throw new RuntimeException("you must install the GPL version of Xuggler (with IVideoResampler support) for this demo to work");
        }
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        int numStreams = container.getNumStreams();
        int videoStreamId = -1;
        IStreamCoder videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStreamId = i;
            videoCoder = coder;
            break;
        }
        if (videoStreamId == -1) {
            throw new RuntimeException("could not find video stream in container: " + filename);
        }
        if (videoCoder.open() < 0) {
            throw new RuntimeException("could not open video decoder for container: " + filename);
        }
        IVideoResampler resampler = null;
        if (videoCoder.getPixelType() != IPixelFormat.Type.BGR24 && (resampler = IVideoResampler.make(videoCoder.getWidth(), videoCoder.getHeight(), IPixelFormat.Type.BGR24, videoCoder.getWidth(), videoCoder.getHeight(), videoCoder.getPixelType())) == null) {
            throw new RuntimeException("could not create color space resampler for: " + filename);
        }
        DecodeAndPlayVideo.openJavaWindow();
        IPacket packet = IPacket.make();
        long firstTimestampInStream = Global.NO_PTS;
        long systemClockStartTime = 0L;
        while (container.readNextPacket(packet) >= 0) {
            if (packet.getStreamIndex() != videoStreamId) continue;
            IVideoPicture picture = IVideoPicture.make(videoCoder.getPixelType(), videoCoder.getWidth(), videoCoder.getHeight());
            int offset = 0;
            while (offset < packet.getSize()) {
                int bytesDecoded = videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded < 0) {
                    throw new RuntimeException("got error decoding video in: " + filename);
                }
                offset += bytesDecoded;
                if (!picture.isComplete()) continue;
                IVideoPicture newPic = picture;
                if (resampler != null && resampler.resample(newPic = IVideoPicture.make(resampler.getOutputPixelFormat(), picture.getWidth(), picture.getHeight()), picture) < 0) {
                    throw new RuntimeException("could not resample video from: " + filename);
                }
                if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
                    throw new RuntimeException("could not decode video as BGR 24 bit data in: " + filename);
                }
                if (firstTimestampInStream == Global.NO_PTS) {
                    firstTimestampInStream = picture.getTimeStamp();
                    systemClockStartTime = System.currentTimeMillis();
                } else {
                    long systemClockCurrentTime = System.currentTimeMillis();
                    long millisecondsClockTimeSinceStartofVideo = systemClockCurrentTime - systemClockStartTime;
                    long millisecondsStreamTimeSinceStartOfVideo = (picture.getTimeStamp() - firstTimestampInStream) / 1000L;
                    long millisecondsTolerance = 50L;
                    long millisecondsToSleep = millisecondsStreamTimeSinceStartOfVideo - (millisecondsClockTimeSinceStartofVideo + 50L);
                    if (millisecondsToSleep > 0L) {
                        try {
                            Thread.sleep(millisecondsToSleep);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                BufferedImage javaImage = Utils.videoPictureToImage(newPic);
                DecodeAndPlayVideo.updateJavaWindow(javaImage);
            }
        }
        if (videoCoder != null) {
            videoCoder.close();
            videoCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
        DecodeAndPlayVideo.closeJavaWindow();
    }

    private static void updateJavaWindow(BufferedImage javaImage) {
        mScreen.setImage(javaImage);
    }

    private static void openJavaWindow() {
        mScreen = new VideoImage();
    }

    private static void closeJavaWindow() {
        System.exit(0);
    }
}

