/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractVirtualFile
implements IVirtualFile {
    protected static Logger log = AbstractVirtualFileSystem.log;
    protected final SeekableDataInput file;
    protected static final int IO_ERROR = -1;

    public AbstractVirtualFile(SeekableDataInput file) {
        this.file = file;
    }

    @Override
    public long getPosition() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException e) {
            log.error((Object)"getPosition", (Throwable)e);
            return Modules.IoFileMgrForUserModule.getPosition(this);
        }
    }

    protected void setPosition(long position) {
        Modules.IoFileMgrForUserModule.setPosition(this, position);
        this.ioLseek(position);
    }

    @Override
    public int ioClose() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            log.error((Object)"ioClose", (Throwable)e);
            return -1;
        }
        return 0;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        try {
            Utilities.readFully(this.file, outputPointer.getAddress(), outputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioRead", (Throwable)e);
            return -2147352272;
        }
        return outputLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        try {
            this.file.readFully(outputBuffer, outputOffset, outputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioRead", (Throwable)e);
            return -2147352272;
        }
        return outputLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return -1;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        try {
            this.file.seek(offset);
        }
        catch (IOException e) {
            log.error((Object)"ioLseek", (Throwable)e);
            return -1L;
        }
        return offset;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        if (log.isEnabledFor((Priority)Level.WARN)) {
            log.warn((Object)String.format("ioIoctl 0x%08X unsupported command, inlen=%d, outlen=%d", command, inputLength, outputLength));
            if (inputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioIoctl indata: %s", Utilities.getMemoryDump(inputPointer.getAddress(), inputLength)));
            }
            if (outputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioIoctl outdata: %s", Utilities.getMemoryDump(outputPointer.getAddress(), outputLength)));
            }
        }
        return -1;
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            log.error((Object)"length", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }
}

