/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.util.Utilities;

public class LocalVirtualFile
extends AbstractVirtualFile {
    protected SeekableRandomFile file;

    public LocalVirtualFile(SeekableRandomFile file) {
        super(file);
        this.file = file;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        try {
            Utilities.write(this.file, inputPointer.getAddress(), inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        try {
            this.file.write(inputBuffer, inputOffset, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }
}

