/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.sound.AudioBlockingOutputAction;
import jpcsp.sound.SoundChannel;
import org.apache.log4j.Logger;

public class sceAudio
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAudio");
    protected static final int PSP_AUDIO_VOLUME_MAX = 32768;
    protected static final int PSP_AUDIO_CHANNEL_MAX = 8;
    protected static final int PSP_AUDIO_SAMPLE_MIN = 64;
    protected static final int PSP_AUDIO_SAMPLE_MAX = 65472;
    protected static final int PSP_AUDIO_FORMAT_STEREO = 0;
    protected static final int PSP_AUDIO_FORMAT_MONO = 16;
    protected SoundChannel[] pspPCMChannels;
    protected SoundChannel pspSRCChannel;
    protected boolean disableChReserve;
    protected boolean disableBlockingAudio;

    @Override
    public String getName() {
        return "sceAudio";
    }

    @Override
    public void start() {
        SoundChannel.init();
        this.pspPCMChannels = new SoundChannel[8];
        for (int channel = 0; channel < this.pspPCMChannels.length; ++channel) {
            this.pspPCMChannels[channel] = new SoundChannel(channel);
        }
        this.pspSRCChannel = new SoundChannel(8);
        this.setSettingsListener("emu.disablesceAudio", new DisableAudioSettingsListerner());
        this.setSettingsListener("emu.disableblockingaudio", new DisableBlockingAudioSettingsListerner());
        super.start();
    }

    private void setChReserveEnabled(boolean enabled) {
        this.disableChReserve = !enabled;
        log.info((Object)("Audio ChReserve disabled: " + this.disableChReserve));
    }

    private void setBlockingEnabled(boolean enabled) {
        this.disableBlockingAudio = !enabled;
        log.info((Object)("Audio Blocking disabled: " + this.disableBlockingAudio));
    }

    protected int doAudioOutput(SoundChannel channel, int pvoid_buf) {
        int ret = -1;
        if (channel.isReserved()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doAudioOutput(%s, 0x%08X)", channel.toString(), pvoid_buf));
            }
            int bytesPerSample = channel.isFormatStereo() ? 4 : 2;
            int nbytes = bytesPerSample * channel.getSampleLength();
            byte[] data = new byte[nbytes];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(pvoid_buf, nbytes, 2);
            if (channel.isFormatMono()) {
                int volume = Audio.getVolume(channel.getLeftVolume());
                for (int i = 0; i < nbytes; i += 2) {
                    short sample = (short)memoryReader.readNext();
                    sample = SoundChannel.adjustSample(sample, volume);
                    SoundChannel.storeSample(sample, data, i);
                }
            } else {
                int leftVolume = Audio.getVolume(channel.getLeftVolume());
                int rightVolume = Audio.getVolume(channel.getRightVolume());
                for (int i = 0; i < nbytes; i += 4) {
                    short lsample = (short)memoryReader.readNext();
                    short rsample = (short)memoryReader.readNext();
                    lsample = SoundChannel.adjustSample(lsample, leftVolume);
                    rsample = SoundChannel.adjustSample(rsample, rightVolume);
                    SoundChannel.storeSample(lsample, data, i);
                    SoundChannel.storeSample(rsample, data, i + 2);
                }
            }
            channel.play(data);
            ret = channel.getSampleLength();
        } else {
            log.warn((Object)("doAudioOutput: channel " + channel.getIndex() + " not reserved"));
        }
        return ret;
    }

    protected void blockThreadOutput(SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        this.blockThreadOutput(threadMan.getCurrentThreadID(), channel, addr, leftVolume, rightVolume);
        threadMan.hleBlockCurrentThread();
    }

    protected void blockThreadOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        AudioBlockingOutputAction action = new AudioBlockingOutputAction(threadId, channel, addr, leftVolume, rightVolume);
        int delayMicros = channel.getUnblockOutputDelayMicros(addr == 0);
        long schedule = Emulator.getClock().microTime() + (long)delayMicros;
        Emulator.getScheduler().addAction(schedule, action);
    }

    public void hleAudioBlockingOutput(int threadId, SoundChannel channel, int addr, int leftVolume, int rightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioBlockingOutput %s", channel.toString()));
        }
        if (addr == 0) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                thread.cpuContext.gpr[2] = 0;
                threadMan.hleUnblockThread(threadId);
            }
        } else if (!channel.isOutputBlocking()) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo thread = threadMan.getThreadById(threadId);
            if (thread != null) {
                int ret;
                this.changeChannelVolume(channel, leftVolume, rightVolume);
                thread.cpuContext.gpr[2] = ret = this.doAudioOutput(channel, addr);
                threadMan.hleUnblockThread(threadId);
            }
        } else {
            this.blockThreadOutput(threadId, channel, addr, leftVolume, rightVolume);
        }
    }

    protected int changeChannelVolume(SoundChannel channel, int leftvol, int rightvol) {
        int ret = -1;
        if (channel.isReserved()) {
            channel.setLeftVolume(leftvol);
            channel.setRightVolume(rightvol);
            ret = 0;
        }
        return ret;
    }

    protected int hleAudioGetChannelRestLen(SoundChannel channel) {
        int len = channel.getRestLength();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleAudioGetChannelRestLen(%d) = %d", channel.getIndex(), len));
        }
        return len;
    }

    protected int hleAudioSRCChReserve(int sampleCount, int freq, int format) {
        if (this.disableChReserve) {
            log.warn((Object)String.format("IGNORED hleAudioSRCChReserve sampleCount=%d, freq=%d, format=%d", sampleCount, freq, format));
            return -1;
        }
        if (!this.pspSRCChannel.isReserved()) {
            this.pspSRCChannel.setSampleRate(freq);
            this.pspSRCChannel.setReserved(true);
            this.pspSRCChannel.setSampleLength(sampleCount);
            this.pspSRCChannel.setFormat(format);
        }
        return 0;
    }

    public int checkChannel(int channel) {
        if (channel < 0 || channel >= 8) {
            throw new SceKernelErrorException(-2144993277);
        }
        return channel;
    }

    public int checkReservedChannel(int channel) {
        if (!this.pspPCMChannels[channel = this.checkChannel(channel)].isReserved()) {
            throw new SceKernelErrorException(-2144993279);
        }
        return channel;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2131626016, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=554002423, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioEnd() {
        return 0;
    }

    @HLEFunction(nid=-1564562836, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioSetFrequency(int frequency) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioSetFrequency frequency=%d", frequency));
        }
        if (frequency != 44100 && frequency != 48000) {
            return -1;
        }
        for (int i = 0; i < this.pspPCMChannels.length; ++i) {
            this.pspPCMChannels[i].setSampleRate(frequency);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1240099392, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioLoopbackTest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1837448405, version=150, moduleName="sceAudio_driver", checkInsideInterrupt=true)
    public int sceAudioSetVolumeOffset() {
        return 0;
    }

    @HLEFunction(nid=-1945105998, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput(@CheckArgument(value="checkReservedChannel") int channel, int vol, @CanBeNull TPointer pvoid_buf) {
        if (this.pspPCMChannels[channel].isOutputBlocking()) {
            return -2144993278;
        }
        this.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
        int result = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        return result;
    }

    @HLEFunction(nid=325889873, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputBlocking(@CheckArgument(value="checkReservedChannel") int channel, int vol, @CanBeNull TPointer pvoid_buf) {
        if (pvoid_buf.isNull()) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), vol, vol);
            }
            return 0;
        }
        int result = 0;
        if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[not blocking] " + this.pspPCMChannels[channel].toString()));
            }
            this.changeChannelVolume(this.pspPCMChannels[channel], vol, vol);
            result = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputBlocking[not blocking] returning %d (%s)", result, this.pspPCMChannels[channel]));
            }
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceAudioOutputBlocking[blocking] " + this.pspPCMChannels[channel].toString()));
            }
            this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), vol, vol);
        }
        return result;
    }

    @HLEFunction(nid=-489329875, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputPanned(@CheckArgument(value="checkReservedChannel") int channel, int leftvol, int rightvol, @CanBeNull TPointer pvoid_buf) {
        if (this.pspPCMChannels[channel].isOutputBlocking()) {
            return -2144993278;
        }
        this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
        int result = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
        Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        return result;
    }

    @HLEFunction(nid=334860988, version=150, checkInsideInterrupt=true)
    public int sceAudioOutputPannedBlocking(@CheckArgument(value="checkReservedChannel") int channel, int leftvol, int rightvol, @CanBeNull TPointer pvoid_buf) {
        if (pvoid_buf.isNull()) {
            if (!this.pspPCMChannels[channel].isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioOutputPannedBlocking[pvoid_buf==0] blocking " + this.pspPCMChannels[channel].toString()));
                }
                this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), leftvol, rightvol);
            }
            return 0;
        }
        int result = 0;
        if (!this.pspPCMChannels[channel].isOutputBlocking() || this.disableBlockingAudio) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[not blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
            result = this.doAudioOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress());
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioOutputPannedBlocking[blocking] leftVol=%d, rightVol=%d, channel=%s", leftvol, rightvol, this.pspPCMChannels[channel].toString()));
            }
            this.blockThreadOutput(this.pspPCMChannels[channel], pvoid_buf.getAddress(), leftvol, rightvol);
        }
        return result;
    }

    @HLEFunction(nid=1590172757, version=150, checkInsideInterrupt=true)
    public int sceAudioChReserve(int channel, int sampleCount, int format) {
        if (this.disableChReserve) {
            log.warn((Object)String.format("IGNORED sceAudioChReserve channel=%d, sampleCount=%d, format=%d", channel, sampleCount, format));
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioChReserve channel=%d, sampleCount=%d, format=%d", channel, sampleCount, format));
        }
        if (channel != -1) {
            if (this.pspPCMChannels[channel = this.checkChannel(channel)].isReserved()) {
                log.warn((Object)String.format("sceAudioChReserve failed - channel %d already in use", channel));
                channel = -1;
            }
        } else {
            for (int i = 0; i < this.pspPCMChannels.length; ++i) {
                if (this.pspPCMChannels[i].isReserved()) continue;
                channel = i;
                break;
            }
            if (channel == -1) {
                log.warn((Object)"sceAudioChReserve failed - no free channels available");
            }
        }
        if (channel != -1) {
            this.pspPCMChannels[channel].setReserved(true);
            this.pspPCMChannels[channel].setSampleLength(sampleCount);
            this.pspPCMChannels[channel].setFormat(format);
        }
        return channel;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1106226663, version=150, checkInsideInterrupt=true)
    public int sceAudioOneshotOutput() {
        return 0;
    }

    @HLEFunction(nid=1875142739, version=150, checkInsideInterrupt=true)
    public int sceAudioChRelease(@CheckArgument(value="checkChannel") int channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioChRelease channel=%d", channel));
        }
        if (!this.pspPCMChannels[channel].isReserved()) {
            return -2144993272;
        }
        this.pspPCMChannels[channel].release();
        this.pspPCMChannels[channel].setReserved(false);
        return 0;
    }

    @HLEFunction(nid=-1341025745, version=150, checkInsideInterrupt=true)
    public int sceAudioGetChannelRestLength(@CheckArgument(value="checkReservedChannel") int channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioGetChannelRestLength channel=%d", channel));
        }
        return this.hleAudioGetChannelRestLen(this.pspPCMChannels[channel]);
    }

    @HLEFunction(nid=-886160482, version=150, checkInsideInterrupt=true)
    public int sceAudioSetChannelDataLen(@CheckArgument(value="checkReservedChannel") int channel, int sampleCount) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioSetChannelDataLen channel=%d, sampleCount=%d", channel, sampleCount));
        }
        this.pspPCMChannels[channel].setSampleLength(sampleCount);
        return 0;
    }

    @HLEFunction(nid=-1778578387, version=150, checkInsideInterrupt=true)
    public int sceAudioChangeChannelConfig(@CheckArgument(value="checkReservedChannel") int channel, int format) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioChangeChannelConfig channel=%d, format=%d", channel, format));
        }
        this.pspPCMChannels[channel].setFormat(format);
        return 0;
    }

    @HLEFunction(nid=-1209935641, version=150, checkInsideInterrupt=true)
    public int sceAudioChangeChannelVolume(@CheckArgument(value="checkReservedChannel") int channel, int leftvol, int rightvol) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioChangeChannelVolume channel=%d, leftvol=0x%X, rightvol=0x%X", channel, leftvol, rightvol));
        }
        return this.changeChannelVolume(this.pspPCMChannels[channel], leftvol, rightvol);
    }

    @HLEFunction(nid=22424483, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2Reserve(int sampleCount) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioOutput2Reserve sampleCount=%d", sampleCount));
        }
        return this.hleAudioSRCChReserve(sampleCount, 44100, 0);
    }

    @HLEFunction(nid=1125738565, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2Release() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceAudioOutput2Release redirecting to sceAudioSRCChRelease");
        }
        return this.sceAudioSRCChRelease();
    }

    @HLEFunction(nid=760476526, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2OutputBlocking(int vol, @CanBeNull TPointer buf) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceAudioOutput2OutputBlocking redirecting to sceAudioSRCOutputBlocking");
        }
        return this.sceAudioSRCOutputBlocking(vol, buf);
    }

    @HLEFunction(nid=1685909299, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2GetRestSample() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceAudioOutput2GetRestSample");
        }
        return this.hleAudioGetChannelRestLen(this.pspSRCChannel);
    }

    @HLEFunction(nid=1676839068, version=150, checkInsideInterrupt=true)
    public int sceAudioOutput2ChangeLength(int sampleCount) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioOutput2ChangeLength sampleCount=%d", sampleCount));
        }
        if (!this.pspSRCChannel.isReserved()) {
            return -1;
        }
        this.pspSRCChannel.setSampleLength(sampleCount);
        return 0;
    }

    @HLEFunction(nid=945107217, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCChReserve(int sampleCount, int freq, int format) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioSRCChReserve sampleCount=%d, freq=%d, format=%d", sampleCount, freq, format));
        }
        return this.hleAudioSRCChReserve(sampleCount, freq, format);
    }

    @HLEFunction(nid=1547157678, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCChRelease() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceAudioSRCChRelease");
        }
        if (this.pspSRCChannel.isReserved()) {
            this.pspSRCChannel.release();
            this.pspSRCChannel.setReserved(false);
        }
        return 0;
    }

    @HLEFunction(nid=-529371050, version=150, checkInsideInterrupt=true)
    public int sceAudioSRCOutputBlocking(int vol, @CanBeNull TPointer buf) {
        if (buf.isNull()) {
            if (!this.pspSRCChannel.isDrained()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sceAudioSRCOutputBlocking[buf==0] blocking " + this.pspSRCChannel));
                }
                this.blockThreadOutput(this.pspSRCChannel, buf.getAddress(), vol, vol);
            }
        } else {
            if (!this.pspSRCChannel.isOutputBlocking() || this.disableBlockingAudio) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceAudioSRCOutputBlocking[not blocking] %s to %s", buf, this.pspSRCChannel.toString()));
                }
                this.changeChannelVolume(this.pspSRCChannel, vol, vol);
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
                return this.doAudioOutput(this.pspSRCChannel, buf.getAddress());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudioSRCOutputBlocking[blocking] %s to %s", buf, this.pspSRCChannel.toString()));
            }
            this.blockThreadOutput(this.pspSRCChannel, buf.getAddress(), vol, vol);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=141449365, version=150, checkInsideInterrupt=true)
    public int sceAudioInputBlocking() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1833692264, version=150, checkInsideInterrupt=true)
    public int sceAudioInput() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1492597082, version=150, checkInsideInterrupt=true)
    public int sceAudioGetInputLength() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2018318767, version=150, checkInsideInterrupt=true)
    public int sceAudioWaitInputEnd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2112231048, version=150, checkInsideInterrupt=true)
    public int sceAudioInputInit() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-383331333, version=150, checkInsideInterrupt=true)
    public int sceAudioInputInitEx() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1506605938, version=150, checkInsideInterrupt=true)
    public int sceAudioPollInputEnd() {
        return 0;
    }

    @HLEFunction(nid=-371623679, version=150, checkInsideInterrupt=true)
    public int sceAudioGetChannelRestLen(@CheckArgument(value="checkReservedChannel") int channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudioGetChannelRestLen channel=%d", channel));
        }
        return this.hleAudioGetChannelRestLen(this.pspPCMChannels[channel]);
    }

    private class DisableBlockingAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableBlockingAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setBlockingEnabled(!value);
        }
    }

    private class DisableAudioSettingsListerner
    extends AbstractBoolSettingsListener {
        private DisableAudioSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAudio.this.setChReserveEnabled(!value);
        }
    }
}

