/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TErrorPointer32;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspFontStyle;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.sceDisplay;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.format.PGF;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceFont
extends HLEModule {
    private static Logger log = Modules.getLogger("sceFont");
    public int fontIndex;
    public int fontLibIndex;
    public static final int PGF_MAGIC = 1346848304;
    public static final String fontDirPath = "flash0:/font";
    public static final String customFontFile = "debug.jpft";
    public static final int PSP_FONT_PIXELFORMAT_4 = 0;
    public static final int PSP_FONT_PIXELFORMAT_4_REV = 1;
    public static final int PSP_FONT_PIXELFORMAT_8 = 2;
    public static final int PSP_FONT_PIXELFORMAT_24 = 3;
    public static final int PSP_FONT_PIXELFORMAT_32 = 4;
    public static final int PSP_FONT_MODE_FILE = 0;
    public static final int PSP_FONT_MODE_MEMORY = 1;
    private boolean useDebugFont = false;
    private static final boolean dumpFonts = false;
    private List<Font> internalFonts;
    private HashMap<Integer, FontLib> fontLibsMap;
    private HashMap<Integer, Font> fontsMap;
    protected String uidPurpose = "sceFont";
    private List<FontRegistryEntry> fontRegistry;
    protected static final float pointDPI = 72.0f;

    @Override
    public String getName() {
        return "sceFont";
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useDebugFont", new UseDebugFontSettingsListerner());
        this.fontIndex = -1;
        this.fontLibIndex = -1;
        this.internalFonts = new LinkedList<Font>();
        this.fontLibsMap = new HashMap();
        this.fontsMap = new HashMap();
        this.loadFontRegistry();
        this.loadDefaultSystemFont();
        this.loadAllFonts();
        super.start();
    }

    protected boolean getUseDebugFont() {
        return this.useDebugFont;
    }

    private void setUseDebugFont(boolean status) {
        this.useDebugFont = status;
    }

    protected void loadFontRegistry() {
        this.fontRegistry = new LinkedList<FontRegistryEntry>();
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 103, 0, 1, 0, 1, "jpn0.pgf", "FTT-NewRodin Pro DB", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 1, 0, 2, 0, 1, "ltn0.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 1, 0, 2, 0, 1, "ltn1.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 2, 0, 2, 0, 1, "ltn2.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 2, 0, 2, 0, 1, "ltn3.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 5, 0, 2, 0, 1, "ltn4.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 5, 0, 2, 0, 1, "ltn5.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 6, 0, 2, 0, 1, "ltn6.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 6, 0, 2, 0, 1, "ltn7.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 1, 0, 2, 0, 1, "ltn8.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 1, 0, 2, 0, 1, "ltn9.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 2, 0, 2, 0, 1, "ltn10.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 2, 0, 2, 0, 1, "ltn11.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 5, 0, 2, 0, 1, "ltn12.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 5, 0, 2, 0, 1, "ltn13.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 6, 0, 2, 0, 1, "ltn14.pgf", "FTT-NewRodin Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 6, 0, 2, 0, 1, "ltn15.pgf", "FTT-Matisse Pro Latin", 0, 0));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 1, 0, 3, 0, 3, "kr0.pgf", "AsiaNHH(512Johab)", 0, 0));
    }

    protected void loadDefaultSystemFont() {
        try {
            SeekableDataInput fontFile = Modules.IoFileMgrForUserModule.getFile("flash0:/font/debug.jpft", 1);
            if (fontFile != null) {
                fontFile.skipBytes(32);
                char[] c = new char[(int)fontFile.length() - 32];
                for (int i = 0; i < c.length; ++i) {
                    c[i] = (char)(fontFile.readByte() & 0xFF);
                }
                Debug.Font.setDebugFont(c);
                Debug.Font.setDebugCharSize(8);
                Debug.Font.setDebugCharHeight(8);
                Debug.Font.setDebugCharWidth(8);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected void dumpFont(Font font) {
        int bufferWidth;
        int addr = 0x4000000;
        int fontPixelFormat = 4;
        int bufferStorage = 3;
        int fontBufWidth = bufferWidth = 800;
        int fontBpl = bufferWidth * sceDisplay.getPixelFormatBytes(bufferStorage);
        int fontBufHeight = 0x200000 / fontBpl;
        int x = 0;
        int y = 0;
        SceFontInfo fontInfo = font.fontInfo;
        PGF pgf = font.pgf;
        int memoryLength = fontBpl * fontBufHeight * sceDisplay.getPixelFormatBytes(bufferStorage);
        Memory.getInstance().memset(addr, (byte)0, memoryLength);
        int maxGlyphWidth = pgf.getMaxSize()[0] >> 6;
        int maxGlyphHeight = pgf.getMaxSize()[1] >> 6;
        for (int charCode = pgf.getFirstGlyphInCharMap(); charCode <= pgf.getLastGlyphInCharMap(); ++charCode) {
            fontInfo.printFont(addr, fontBpl, fontBufWidth, fontBufHeight, x, y, fontPixelFormat, charCode, 32);
            if ((x += maxGlyphWidth) + maxGlyphWidth < fontBufWidth) continue;
            x = 0;
            if ((y += maxGlyphHeight) >= fontBufHeight) break;
        }
        Buffer memoryBuffer = Memory.getInstance().getBuffer(addr, memoryLength);
        String fileNamePrefix = String.format("Font-%s-", pgf.getFileNamez());
        CaptureImage image = new CaptureImage(addr, 0, memoryBuffer, fontBufWidth, fontBufHeight, bufferWidth, bufferStorage, false, 0, false, true, fileNamePrefix);
        try {
            image.write();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected Font openFontFile(ByteBuffer pgfBuffer, String fileName) {
        Font font = null;
        try {
            PGF pgfFile = new PGF(pgfBuffer);
            if (fileName != null) {
                pgfFile.setFileNamez(fileName);
            }
            SceFontInfo fontInfo = new SceFontInfo(pgfFile);
            font = new Font(pgfFile, fontInfo);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return font;
    }

    protected Font openFontFile(String fileName) {
        Font font = null;
        try {
            SeekableDataInput fontFile = Modules.IoFileMgrForUserModule.getFile(fileName, 1);
            byte[] pgfBytes = new byte[(int)fontFile.length()];
            fontFile.readFully(pgfBytes);
            fontFile.close();
            ByteBuffer pgfBuffer = ByteBuffer.wrap(pgfBytes);
            font = this.openFontFile(pgfBuffer, new File(fileName).getName());
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return font;
    }

    protected Font openFontFile(int addr, int length) {
        ByteBuffer pgfBuffer = ByteBuffer.allocate(length);
        Buffer memBuffer = Memory.getInstance().getBuffer(addr, length);
        Utilities.putBuffer(pgfBuffer, memBuffer, ByteOrder.LITTLE_ENDIAN, length);
        pgfBuffer.rewind();
        Font font = this.openFontFile(pgfBuffer, null);
        return font;
    }

    protected void setFontAttributesFromRegistry(Font font, FontRegistryEntry fontRegistryEntry) {
        pspFontStyle fontStyle = new pspFontStyle();
        fontStyle.fontH = (float)fontRegistryEntry.h_size / 64.0f;
        fontStyle.fontV = (float)fontRegistryEntry.v_size / 64.0f;
        fontStyle.fontHRes = (float)fontRegistryEntry.h_resolution / 64.0f;
        fontStyle.fontVRes = (float)fontRegistryEntry.v_resolution / 64.0f;
        fontStyle.fontWeight = fontRegistryEntry.weight;
        fontStyle.fontFamily = (short)fontRegistryEntry.family_code;
        fontStyle.fontStyle = (short)fontRegistryEntry.style;
        fontStyle.fontStyleSub = (short)fontRegistryEntry.sub_style;
        fontStyle.fontLanguage = (short)fontRegistryEntry.language_code;
        fontStyle.fontRegion = (short)fontRegistryEntry.region_code;
        fontStyle.fontCountry = (short)fontRegistryEntry.country_code;
        fontStyle.fontName = fontRegistryEntry.font_name;
        fontStyle.fontFileName = fontRegistryEntry.file_name;
        fontStyle.fontAttributes = fontRegistryEntry.extra_attributes;
        fontStyle.fontExpire = fontRegistryEntry.expire_date;
        font.fontInfo.setFontStyle(fontStyle);
    }

    protected void setFontAttributesFromRegistry(Font font) {
        for (FontRegistryEntry fontRegistryEntry : this.fontRegistry) {
            if (!fontRegistryEntry.file_name.equals(font.pgf.getFileNamez()) || !fontRegistryEntry.font_name.equals(font.pgf.getFontName())) continue;
            this.setFontAttributesFromRegistry(font, fontRegistryEntry);
            break;
        }
    }

    protected void loadAllFonts() {
        for (FontRegistryEntry fontRegistryEntry : this.fontRegistry) {
            Font font;
            String fontFileName = "flash0:/font/" + fontRegistryEntry.file_name;
            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(fontFileName);
            if (stat == null || (font = this.openFontFile(fontFileName)) == null) continue;
            this.setFontAttributesFromRegistry(font, fontRegistryEntry);
            this.internalFonts.add(font);
            log.info((Object)String.format("Loading font file '%s'. Font='%s' Type='%s'", fontRegistryEntry.file_name, font.pgf.getFontName(), font.pgf.getFontType()));
        }
    }

    protected static short getFontStyle(String styleString) {
        if ("Regular".equals(styleString)) {
            return 1;
        }
        if ("Italic".equals(styleString)) {
            return 2;
        }
        if ("Bold".equals(styleString)) {
            return 5;
        }
        if ("Bold Italic".equals(styleString)) {
            return 6;
        }
        return 0;
    }

    private boolean isFontMatchingStyle(Font font, pspFontStyle fontStyle) {
        if (font != null && font.fontInfo != null && font.fontInfo.getFontStyle() != null) {
            return font.fontInfo.getFontStyle().isMatching(fontStyle);
        }
        return true;
    }

    @HLEFunction(nid=1743879895, version=150, checkInsideInterrupt=true)
    public int sceFontNewLib(TPointer paramsPtr, TErrorPointer32 errorCodePtr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontNewLib paramsAddr=%s, errorCodeAddr=%s", paramsPtr, errorCodePtr));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        FontLib fontLib = new FontLib(paramsPtr.getAddress());
        this.fontLibsMap.put(fontLib.getHandle(), fontLib);
        return fontLib.getHandle();
    }

    @HLEFunction(nid=1476179763, version=150, checkInsideInterrupt=true)
    public int sceFontOpenUserFile(int fontLibHandle, int fileNameAddr, int mode, TErrorPointer32 errorCodePtr) {
        String fileName = Utilities.readStringZ(fileNameAddr);
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontOpenUserFile fontLib=%s, fileName=0x%08X ('%s'), mode=0x%08X, errorCodeAddr=0x%08X", fontLib, fileNameAddr, fileName, mode, errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        fontLib.triggerOpenCallback(fileNameAddr, errorCodePtr.getAddress());
        return fontLib.openFont(this.openFontFile(fileName)).getHandle();
    }

    @HLEFunction(nid=-1148289050, version=150, checkInsideInterrupt=true)
    public int sceFontOpenUserMemory(int fontLibHandle, TPointer memoryFontPtr, int memoryFontLength, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontOpenUserMemory fontLib=%s, memoryFontAddr=0x%08X, memoryFontLength=%d, errorCodeAddr=0x%08X", fontLib, memoryFontPtr.getAddress(), memoryFontLength, errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return fontLib.openFont(this.openFontFile(memoryFontPtr.getAddress(), memoryFontLength)).getHandle();
    }

    @HLEFunction(nid=229069662, version=150, checkInsideInterrupt=true)
    public int sceFontGetFontInfo(int fontHandle, TPointer fontInfoPtr) {
        Memory mem = fontInfoPtr.getMemory();
        int fontInfoAddr = fontInfoPtr.getAddress();
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontInfo font=%s, fontInfoAddr=0x%08X", font, fontInfoPtr.getAddress()));
        }
        if (font == null || font.isClosed()) {
            return -1;
        }
        PGF currentPGF = font.pgf;
        int maxGlyphWidthI = currentPGF.getMaxSize()[0];
        int maxGlyphHeightI = currentPGF.getMaxSize()[1];
        int maxGlyphAscenderI = currentPGF.getMaxBaseYAdjust();
        int maxGlyphDescenderI = currentPGF.getMaxBaseYAdjust() - currentPGF.getMaxSize()[1];
        int maxGlyphLeftXI = currentPGF.getMaxLeftXAdjust();
        int maxGlyphBaseYI = currentPGF.getMaxBaseYAdjust();
        int minGlyphCenterXI = currentPGF.getMinCenterXAdjust();
        int maxGlyphTopYI = currentPGF.getMaxTopYAdjust();
        int maxGlyphAdvanceXI = currentPGF.getMaxAdvance()[0];
        int maxGlyphAdvanceYI = currentPGF.getMaxAdvance()[1];
        float maxGlyphWidthF = Float.intBitsToFloat(maxGlyphWidthI);
        float maxGlyphHeightF = Float.intBitsToFloat(maxGlyphHeightI);
        float maxGlyphAscenderF = Float.intBitsToFloat(maxGlyphAscenderI);
        float maxGlyphDescenderF = Float.intBitsToFloat(maxGlyphDescenderI);
        float maxGlyphLeftXF = Float.intBitsToFloat(maxGlyphLeftXI);
        float maxGlyphBaseYF = Float.intBitsToFloat(maxGlyphBaseYI);
        float minGlyphCenterXF = Float.intBitsToFloat(minGlyphCenterXI);
        float maxGlyphTopYF = Float.intBitsToFloat(maxGlyphTopYI);
        float maxGlyphAdvanceXF = Float.intBitsToFloat(maxGlyphAdvanceXI);
        float maxGlyphAdvanceYF = Float.intBitsToFloat(maxGlyphAdvanceYI);
        pspFontStyle fontStyle = font.getFontStyle();
        mem.write32(fontInfoAddr + 0, maxGlyphWidthI);
        mem.write32(fontInfoAddr + 4, maxGlyphHeightI);
        mem.write32(fontInfoAddr + 8, maxGlyphAscenderI);
        mem.write32(fontInfoAddr + 12, maxGlyphDescenderI);
        mem.write32(fontInfoAddr + 16, maxGlyphLeftXI);
        mem.write32(fontInfoAddr + 20, maxGlyphBaseYI);
        mem.write32(fontInfoAddr + 24, minGlyphCenterXI);
        mem.write32(fontInfoAddr + 28, maxGlyphTopYI);
        mem.write32(fontInfoAddr + 32, maxGlyphAdvanceXI);
        mem.write32(fontInfoAddr + 36, maxGlyphAdvanceYI);
        mem.write32(fontInfoAddr + 40, Float.floatToRawIntBits(maxGlyphWidthF));
        mem.write32(fontInfoAddr + 44, Float.floatToRawIntBits(maxGlyphHeightF));
        mem.write32(fontInfoAddr + 48, Float.floatToRawIntBits(maxGlyphAscenderF));
        mem.write32(fontInfoAddr + 52, Float.floatToRawIntBits(maxGlyphDescenderF));
        mem.write32(fontInfoAddr + 56, Float.floatToRawIntBits(maxGlyphLeftXF));
        mem.write32(fontInfoAddr + 60, Float.floatToRawIntBits(maxGlyphBaseYF));
        mem.write32(fontInfoAddr + 64, Float.floatToRawIntBits(minGlyphCenterXF));
        mem.write32(fontInfoAddr + 68, Float.floatToRawIntBits(maxGlyphTopYF));
        mem.write32(fontInfoAddr + 72, Float.floatToRawIntBits(maxGlyphAdvanceXF));
        mem.write32(fontInfoAddr + 76, Float.floatToRawIntBits(maxGlyphAdvanceYF));
        mem.write16(fontInfoAddr + 80, (short)currentPGF.getMaxGlyphWidth());
        mem.write16(fontInfoAddr + 82, (short)currentPGF.getMaxGlyphHeight());
        mem.write32(fontInfoAddr + 84, currentPGF.getCharMapLength());
        mem.write32(fontInfoAddr + 88, currentPGF.getShadowMapLength());
        fontStyle.write(mem, fontInfoAddr + 92);
        mem.write8(fontInfoAddr + 260, (byte)4);
        mem.write8(fontInfoAddr + 261, (byte)0);
        mem.write8(fontInfoAddr + 262, (byte)0);
        mem.write8(fontInfoAddr + 263, (byte)0);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontInfo returning maxGlyphWidthI=%d, maxGlyphHeightI=%d, maxGlyphAscenderI=%d, maxGlyphDescenderI=%d, maxGlyphLeftXI=%d, maxGlyphBaseYI=%d, minGlyphCenterXI=%d, maxGlyphTopYI=%d, maxGlyphAdvanceXI=%d, maxGlyphAdvanceYI=%d, fontStyle=[%s]", maxGlyphWidthI, maxGlyphHeightI, maxGlyphAscenderI, maxGlyphDescenderI, maxGlyphLeftXI, maxGlyphBaseYI, minGlyphCenterXI, maxGlyphTopYI, maxGlyphAdvanceXI, maxGlyphAdvanceYI, fontStyle));
        }
        return 0;
    }

    @HLEFunction(nid=-590869457, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharInfo(int fontHandle, int charCode, TPointer charInfoPtr) {
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharInfo font=%s, charCode=%04X (%c), charInfoAddr=%08X", font, charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63)), charInfoPtr.getAddress()));
        }
        if (font == null || font.fontInfo == null) {
            return -1;
        }
        pspCharInfo pspCharInfo2 = null;
        if (!this.getUseDebugFont()) {
            pspCharInfo2 = font.fontInfo.getCharInfo(charCode);
        }
        if (pspCharInfo2 == null) {
            pspCharInfo2 = new pspCharInfo();
            pspCharInfo2.bitmapWidth = Debug.Font.charWidth * 2;
            pspCharInfo2.bitmapHeight = Debug.Font.charHeight * 2;
            pspCharInfo2.sfp26Width = pspCharInfo2.bitmapWidth << 6;
            pspCharInfo2.sfp26Height = pspCharInfo2.bitmapHeight << 6;
            pspCharInfo2.sfp26AdvanceH = pspCharInfo2.bitmapWidth << 6;
            pspCharInfo2.sfp26AdvanceV = pspCharInfo2.bitmapHeight << 6;
        }
        pspCharInfo2.write(charInfoPtr.getMemory(), charInfoPtr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharInfo returning %s", pspCharInfo2));
        }
        return 0;
    }

    @HLEFunction(nid=-1743828843, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharGlyphImage(int fontHandle, int charCode, TPointer glyphImagePtr) {
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharGlyphImage font=%s, charCode=%04X (%c), glyphImageAddr=%08X", font, charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63)), glyphImagePtr.getAddress()));
        }
        int pixelFormat = glyphImagePtr.getValue32(0);
        int xPos64 = glyphImagePtr.getValue32(4);
        int yPos64 = glyphImagePtr.getValue32(8);
        short bufWidth = glyphImagePtr.getValue16(12);
        short bufHeight = glyphImagePtr.getValue16(14);
        short bytesPerLine = glyphImagePtr.getValue16(16);
        int buffer = glyphImagePtr.getValue32(20);
        int xPosI = xPos64 >> 6;
        int yPosI = yPos64 >> 6;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceFontGetCharGlyphImage c=" + (char)charCode + ", xPos=" + xPosI + ", yPos=" + yPosI + ", buffer=0x" + Integer.toHexString(buffer) + ", bufWidth=" + bufWidth + ", bufHeight=" + bufHeight + ", bytesPerLine=" + bytesPerLine + ", pixelFormat=" + pixelFormat));
        }
        if (!this.getUseDebugFont()) {
            font.fontInfo.printFont(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, pixelFormat, charCode, font.fontLib.getAltCharCode());
        } else {
            yPosI -= font.pgf.getMaxBaseYAdjust() >> 6;
            Debug.printFontbuffer(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI += font.pgf.getMaxTopYAdjust() >> 6, pixelFormat, charCode, font.fontLib.getAltCharCode());
        }
        return 0;
    }

    @HLEFunction(nid=161411900, version=150, checkInsideInterrupt=false)
    public int sceFontFindOptimumFont(int fontLibHandle, TPointer fontStylePtr, TErrorPointer32 errorCodePtr) {
        int i;
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontFindOptimumFont fontLib=%s, fontStyleAddr=0x%08X, errorCodeAddr=0x%08X", fontLib, fontStylePtr.getAddress(), errorCodePtr.getAddress()));
        }
        pspFontStyle fontStyle = new pspFontStyle();
        fontStyle.read(fontStylePtr.getMemory(), fontStylePtr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontFindOptimumFont: %s", fontStyle.toString()));
        }
        errorCodePtr.setValue(0);
        for (i = 0; i < this.internalFonts.size(); ++i) {
            if (!this.isFontMatchingStyle(this.internalFonts.get(i), fontStyle)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceFontFindOptimumFont found font at index %d: %s", i, this.internalFonts.get(i).toString()));
            }
            return i;
        }
        if (fontStyle.fontStyle != 0) {
            fontStyle.fontStyle = 0;
            fontStyle.fontStyleSub = 0;
            for (i = 0; i < this.internalFonts.size(); ++i) {
                if (!this.isFontMatchingStyle(this.internalFonts.get(i), fontStyle)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceFontFindOptimumFont found font at index %d: %s", i, this.internalFonts.get(i).toString()));
                }
                return i;
            }
        }
        if (fontStyle.fontH != 0.0f || fontStyle.fontV != 0.0f) {
            fontStyle.fontH = 0.0f;
            fontStyle.fontV = 0.0f;
            for (i = 0; i < this.internalFonts.size(); ++i) {
                if (!this.isFontMatchingStyle(this.internalFonts.get(i), fontStyle)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceFontFindOptimumFont found font at index %d: %s", i, this.internalFonts.get(i).toString()));
                }
                return i;
            }
        }
        errorCodePtr.setValue(-1);
        return 0;
    }

    @HLEFunction(nid=988449974, version=150, checkInsideInterrupt=true)
    public int sceFontClose(int fontHandle) {
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontClose font=%s", font));
        }
        if (font != null && font.fontLib != null) {
            font.fontLib.closeFont(font);
        } else {
            log.debug((Object)String.format("sceFontClose font already closed font=%s", font));
        }
        return 0;
    }

    @HLEFunction(nid=1464561596, version=150, checkInsideInterrupt=true)
    public int sceFontDoneLib(int fontLibHandle) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontDoneLib fontLib=%s", fontLib));
        }
        if (fontLib != null) {
            fontLib.triggerFreeCallback();
            fontLib.triggerCloseCallback();
            fontLib.closeAllFonts();
            HLEUidObjectMapping.removeObject(fontLib);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontDoneLib font lib already done 0x%08X", fontLibHandle));
        }
        return 0;
    }

    @HLEFunction(nid=-1472974435, version=150, checkInsideInterrupt=false)
    public int sceFontOpen(int fontLibHandle, int index, int mode, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontOpen fontLib=%s, index=%d, mode=%d, errorCodeAddr=0x%08X", fontLib, index, mode, errorCodePtr.getAddress()));
        }
        if (index < 0) {
            errorCodePtr.setValue(-2142896125);
            return 0;
        }
        Font font = fontLib.openFont(this.internalFonts.get(index));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Opening '%s' - '%s', font=%s", font.pgf.getFontName(), font.pgf.getFontType(), font));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return font.getHandle();
    }

    @HLEFunction(nid=-903976635, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharGlyphImage_Clip(int fontHandle, int charCode, TPointer glyphImagePtr, int clipXPos, int clipYPos, int clipWidth, int clipHeight) {
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharGlyphImage_Clip fontHandle=0x%08X, charCode=%04X (%c), glyphImageAddr=%08X, clipXPos=%d, clipYPos=%d, clipWidth=%d, clipHeight=%d,", fontHandle, charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63)), glyphImagePtr.getAddress(), clipXPos, clipYPos, clipWidth, clipHeight));
        }
        int pixelFormat = glyphImagePtr.getValue32(0);
        int xPos64 = glyphImagePtr.getValue32(4);
        int yPos64 = glyphImagePtr.getValue32(8);
        short bufWidth = glyphImagePtr.getValue16(12);
        short bufHeight = glyphImagePtr.getValue16(14);
        short bytesPerLine = glyphImagePtr.getValue16(16);
        int buffer = glyphImagePtr.getValue32(20);
        int xPosI = xPos64 >> 6;
        int yPosI = yPos64 >> 6;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceFontGetCharGlyphImage_Clip c=" + (char)charCode + ", xPos=" + xPosI + ", yPos=" + yPosI + ", buffer=0x" + Integer.toHexString(buffer) + ", bufWidth=" + bufWidth + ", bufHeight=" + bufHeight + ", bytesPerLine=" + bytesPerLine + ", pixelFormat=" + pixelFormat));
        }
        if (!this.getUseDebugFont()) {
            font.fontInfo.printFont(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, pixelFormat, charCode, font.fontLib.getAltCharCode());
        } else {
            yPosI -= font.pgf.getMaxBaseYAdjust() >> 6;
            if ((yPosI += font.pgf.getMaxTopYAdjust() >> 6) < 0) {
                yPosI = 0;
            }
            Debug.printFontbuffer(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, pixelFormat, charCode, font.fontLib.getAltCharCode());
        }
        return 0;
    }

    @HLEFunction(nid=670492226, version=150, checkInsideInterrupt=true)
    public int sceFontGetNumFontList(int fontLibHandle, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetNumFontList libHandle=%s, errorCodeAddr=0x%08X", fontLib, errorCodePtr.getAddress()));
        }
        int numFonts = this.internalFonts.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetNumFontList returning %d", numFonts));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return numFonts;
    }

    @HLEFunction(nid=-1133127589, version=150, checkInsideInterrupt=true)
    public int sceFontGetFontList(int fontLibHandle, TPointer fontStylePtr, int numFonts) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontList fontLib=%s, fontListAddr=0x%08X, numFonts=%d", fontLib, fontStylePtr.getAddress(), numFonts));
        }
        int fontsNum = Math.min(this.internalFonts.size(), numFonts);
        Memory mem = fontStylePtr.getMemory();
        int fontStyleAddr = fontStylePtr.getAddress();
        for (int i = 0; i < fontsNum; ++i) {
            Font font = this.internalFonts.get(i);
            pspFontStyle fontStyle = font.getFontStyle();
            fontStyle.write(mem, fontStyleAddr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceFontGetFontList returning font #%d at 0x%08X: %s", i, fontStyleAddr, fontStyle.toString()));
            }
            fontStyleAddr += fontStyle.sizeof();
        }
        return 0;
    }

    @HLEFunction(nid=-299686895, version=150, checkInsideInterrupt=true)
    public int sceFontSetAltCharacterCode(int fontLibHandle, int charCode) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontSetAltCharacterCode fontLib=%s, charCode=%04X", fontLib, charCode));
        }
        fontLib.setAltCharCode(charCode);
        return 0;
    }

    @HLEFunction(nid=1547586206, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharImageRect(int fontHandle, int charCode, TPointer charRectPtr) {
        Font font = this.fontsMap.get(fontHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharImageRect font=%s, charCode=%04X , charRectAddr=0x%08X", font, charCode, charRectPtr.getAddress()));
        }
        charRectPtr.setValue16(0, (short)1);
        charRectPtr.setValue16(2, (short)1);
        return 0;
    }

    @HLEFunction(nid=1193710797, version=150)
    public float sceFontPointToPixelH(int fontLibHandle, float fontPointsH, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontPointToPixelH fontLib=%s, fontPointsH=%f, errorCodeAddr=0x%08X", fontLib, Float.valueOf(fontPointsH), errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return fontPointsH * fontLib.fontHRes / 72.0f;
    }

    @HLEFunction(nid=1395864109, version=150, checkInsideInterrupt=true)
    public int sceFontGetFontInfoByIndexNumber(int fontLibHandle, TPointer fontInfoPtr, int __unk, int fontIndex) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontInfoByIndexNumber fontLib=%s, fontInfoAddr=0x%08X, fontIndex=%d", fontLib, fontInfoPtr.getAddress(), fontIndex));
        }
        return this.sceFontGetFontInfo(this.fontLibsMap.get((Object)Integer.valueOf((int)fontLibHandle)).fonts.get(fontIndex).getHandle(), fontInfoPtr);
    }

    @HLEFunction(nid=1210659456, version=150, checkInsideInterrupt=true)
    public int sceFontSetResolution(int fontLibHandle, float hRes, float vRes) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontSetResolution fontLib=%s, hRes=%f, vRes=%f", fontLib, Float.valueOf(hRes), Float.valueOf(vRes)));
        }
        fontLib.fontHRes = hRes;
        fontLib.fontVRes = vRes;
        return 0;
    }

    @HLEFunction(nid=47708491, version=150, checkInsideInterrupt=true)
    public int sceFontFlush(int fontHandle) {
        return 0;
    }

    @HLEFunction(nid=1746821543, version=150, checkInsideInterrupt=true)
    public int sceFontFindFont(int fontLibHandle, TPointer fontStylePtr, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontFindFont fontLib=%s, fontStyleAddr=0x%08X, errorCodeAddr=0x%08X", fontLib, fontStylePtr.getAddress(), errorCodePtr.getAddress()));
        }
        pspFontStyle fontStyle = new pspFontStyle();
        fontStyle.read(fontStylePtr.getMemory(), fontStylePtr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontFindFont: %s", fontStyle.toString()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        int fontsNum = this.internalFonts.size();
        for (int i = 0; i < fontsNum; ++i) {
            if (!this.isFontMatchingStyle(this.internalFonts.get(i), fontStyle)) continue;
            return i;
        }
        return -1;
    }

    @HLEFunction(nid=1011580546, version=150)
    public float sceFontPointToPixelV(int fontLibHandle, float fontPointsV, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontPointToPixelV fontLib=%s, fontPointsV=%f, errorCodeAddr=0x%08X", fontLib, Float.valueOf(fontPointsV), errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return fontPointsV * fontLib.fontVRes / 72.0f;
    }

    @HLEFunction(nid=1957828353, version=150)
    public float sceFontPixelToPointH(int fontLibHandle, float fontPixelsH, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontPixelToPointH fontLib=%s, fontPixelsH=%f, errorCodeAddr=0x%08X", fontLib, Float.valueOf(fontPixelsH), errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return fontPixelsH * 72.0f / fontLib.fontHRes;
    }

    @HLEFunction(nid=-118459090, version=150)
    public float sceFontPixelToPointV(int fontLibHandle, float fontPixelsV, TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontPixelToPointV fontLib=%s, fontPixelsV=%f, errorCodeAddr=0x%08X", fontLib, Float.valueOf(fontPixelsV), errorCodePtr.getAddress()));
        }
        if (errorCodePtr.isAddressGood()) {
            errorCodePtr.setValue(0);
        }
        return fontPixelsV * 72.0f / fontLib.fontVRes;
    }

    @HLEUnimplemented
    @HLEFunction(nid=795293034, version=150)
    public int sceFontCalcMemorySize() {
        return -559038242;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1219519776, version=150)
    public int sceFontGetShadowImageRect() {
        return -559038242;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1452008726, version=150)
    public int sceFontGetShadowGlyphImage() {
        return -559038242;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1573873752, version=150)
    public int sceFontGetShadowGlyphImage_Clip() {
        return -559038242;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1438783563, version=150)
    public int sceFontGetShadowInfo() {
        return -559038242;
    }

    @HLEUidClass(errorValueOnNotFound=-2142896126)
    protected class FontLib {
        protected int userDataAddr;
        protected int numFonts;
        protected int cacheDataAddr;
        protected int allocFuncAddr;
        protected int freeFuncAddr;
        protected int openFuncAddr;
        protected int closeFuncAddr;
        protected int readFuncAddr;
        protected int seekFuncAddr;
        protected int errorFuncAddr;
        protected int ioFinishFuncAddr;
        protected int memFontAddr;
        protected int fileFontHandle;
        protected int altCharCode;
        protected float fontHRes = 128.0f;
        protected float fontVRes = 128.0f;
        protected int handle;
        protected List<Font> fonts;

        public FontLib(int params) {
            this.read(params);
            this.fonts = new LinkedList<Font>();
            this.makeHandle();
        }

        private void makeHandle() {
            this.handle = ++sceFont.this.fontLibIndex << 8 | 0x1B;
        }

        public int getNumFonts() {
            return this.numFonts;
        }

        private Font openFont(Font font) {
            if (font == null) {
                throw new SceKernelErrorException(-2142896125);
            }
            if (this.fonts.size() >= this.numFonts) {
                throw new SceKernelErrorException(-2142896119);
            }
            font = new Font(font, this);
            this.fonts.add(font);
            sceFont.this.fontsMap.put(font.getHandle(), font);
            return font;
        }

        private void closeFont(Font font) {
            HLEUidObjectMapping.removeObject(font);
            this.fonts.remove(font);
            font.fontLib = null;
            font.pgf = null;
            font.fontInfo = null;
        }

        public void closeAllFonts() {
            for (Font font : this.fonts) {
                this.closeFont(font);
            }
        }

        public int getHandle() {
            return this.handle;
        }

        protected void triggerAllocCallback(int size) {
            Modules.ThreadManForUserModule.executeCallback(null, this.allocFuncAddr, new AfterAllocCallback(), true, this.userDataAddr, size);
        }

        protected void triggerFreeCallback() {
            if (Memory.isAddressGood(this.memFontAddr)) {
                Modules.ThreadManForUserModule.executeCallback(null, this.freeFuncAddr, null, true, this.userDataAddr, this.memFontAddr);
            }
        }

        protected void triggerOpenCallback(int fileNameAddr, int errorCodeAddr) {
            Modules.ThreadManForUserModule.executeCallback(null, this.allocFuncAddr, new AfterOpenCallback(), true, this.userDataAddr, fileNameAddr, errorCodeAddr);
        }

        protected void triggerCloseCallback() {
            if (this.fileFontHandle != 0) {
                Modules.ThreadManForUserModule.executeCallback(null, this.freeFuncAddr, null, true, this.userDataAddr, this.fileFontHandle);
            }
        }

        private void read(int paramsAddr) {
            Memory mem = Memory.getInstance();
            this.userDataAddr = mem.read32(paramsAddr);
            this.numFonts = mem.read32(paramsAddr + 4);
            this.cacheDataAddr = mem.read32(paramsAddr + 8);
            this.allocFuncAddr = mem.read32(paramsAddr + 12);
            this.freeFuncAddr = mem.read32(paramsAddr + 16);
            this.openFuncAddr = mem.read32(paramsAddr + 20);
            this.closeFuncAddr = mem.read32(paramsAddr + 24);
            this.readFuncAddr = mem.read32(paramsAddr + 28);
            this.seekFuncAddr = mem.read32(paramsAddr + 32);
            this.errorFuncAddr = mem.read32(paramsAddr + 36);
            this.ioFinishFuncAddr = mem.read32(paramsAddr + 42);
        }

        public int getAltCharCode() {
            return this.altCharCode;
        }

        public void setAltCharCode(int altCharCode) {
            this.altCharCode = altCharCode;
        }

        public String toString() {
            return String.format("FontLib - Handle: '0x%08X', Fonts: '%d'", this.getHandle(), this.getNumFonts());
        }

        private class AfterOpenCallback
        implements IAction {
            private AfterOpenCallback() {
            }

            @Override
            public void execute() {
                FontLib.this.fileFontHandle = Emulator.getProcessor().cpu.gpr[2];
                log.info((Object)("FontLib's file open callback returned 0x" + Integer.toHexString(FontLib.this.fileFontHandle)));
            }
        }

        private class AfterAllocCallback
        implements IAction {
            private AfterAllocCallback() {
            }

            @Override
            public void execute() {
                FontLib.this.memFontAddr = Emulator.getProcessor().cpu.gpr[2];
                log.info((Object)("FontLib's allocation callback returned 0x" + Integer.toHexString(FontLib.this.memFontAddr)));
            }
        }
    }

    public class FontRegistryEntry {
        public int h_size;
        public int v_size;
        public int h_resolution;
        public int v_resolution;
        public int extra_attributes;
        public int weight;
        public int family_code;
        public int style;
        public int sub_style;
        public int language_code;
        public int region_code;
        public int country_code;
        public String file_name;
        public String font_name;
        public int expire_date;
        public int shadow_option;

        public FontRegistryEntry(int h_size, int v_size, int h_resolution, int v_resolution, int extra_attributes, int weight, int family_code, int style, int sub_style, int language_code, int region_code, int country_code, String file_name, String font_name, int expire_date, int shadow_option) {
            this.h_size = h_size;
            this.v_size = v_size;
            this.h_resolution = h_resolution;
            this.v_resolution = v_resolution;
            this.extra_attributes = extra_attributes;
            this.weight = weight;
            this.family_code = family_code;
            this.style = style;
            this.sub_style = sub_style;
            this.language_code = language_code;
            this.region_code = region_code;
            this.country_code = country_code;
            this.file_name = file_name;
            this.font_name = font_name;
            this.expire_date = expire_date;
            this.shadow_option = shadow_option;
        }
    }

    @HLEUidClass(errorValueOnNotFound=-2142896126)
    public class Font {
        public PGF pgf;
        public SceFontInfo fontInfo;
        public FontLib fontLib;
        private int handle;

        public Font(PGF pgf, SceFontInfo fontInfo) {
            this.pgf = pgf;
            this.fontInfo = fontInfo;
            this.fontLib = null;
            this.makeHandle();
        }

        public Font(Font font, FontLib fontLib) {
            this.pgf = font.pgf;
            this.fontInfo = font.fontInfo;
            this.fontLib = fontLib;
            this.makeHandle();
        }

        private void makeHandle() {
            this.handle = ++sceFont.this.fontIndex << 8 | 0x1C;
        }

        public pspFontStyle getFontStyle() {
            pspFontStyle fontStyle = this.fontInfo.getFontStyle();
            if (fontStyle == null) {
                fontStyle = new pspFontStyle();
                fontStyle.fontH = (float)this.pgf.getHSize() / 64.0f;
                fontStyle.fontV = (float)this.pgf.getVSize() / 64.0f;
                fontStyle.fontHRes = (float)this.pgf.getHResolution() / 64.0f;
                fontStyle.fontVRes = (float)this.pgf.getVResolution() / 64.0f;
                fontStyle.fontStyle = sceFont.getFontStyle(this.pgf.getFontType());
                fontStyle.fontName = this.pgf.getFontName();
                fontStyle.fontFileName = this.pgf.getFileNamez();
            }
            return fontStyle;
        }

        public int getHandle() {
            return this.handle;
        }

        public boolean isClosed() {
            return this.pgf == null;
        }

        public String toString() {
            if (this.isClosed()) {
                return String.format("Font[handle=0x%X closed]", this.getHandle());
            }
            return String.format("Font[handle=0x%X, '%s' - '%s']", this.getHandle(), this.pgf.getFileNamez(), this.pgf.getFontName());
        }
    }

    private class UseDebugFontSettingsListerner
    extends AbstractBoolSettingsListener {
        private UseDebugFontSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceFont.this.setUseDebugFont(value);
        }
    }
}

