/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.hardware.Battery;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class sceImpose
extends HLEModule {
    private static Logger log = Modules.getLogger("sceImpose");
    public static final int PSP_LANGUAGE_JAPANESE = 0;
    public static final int PSP_LANGUAGE_ENGLISH = 1;
    public static final int PSP_LANGUAGE_FRENCH = 2;
    public static final int PSP_LANGUAGE_SPANISH = 3;
    public static final int PSP_LANGUAGE_GERMAN = 4;
    public static final int PSP_LANGUAGE_ITALIAN = 5;
    public static final int PSP_LANGUAGE_DUTCH = 6;
    public static final int PSP_LANGUAGE_PORTUGUESE = 7;
    public static final int PSP_LANGUAGE_RUSSIAN = 8;
    public static final int PSP_LANGUAGE_KOREAN = 9;
    public static final int PSP_LANGUAGE_TRADITIONAL_CHINESE = 10;
    public static final int PSP_LANGUAGE_SIMPLIFIED_CHINESE = 11;
    private int languageMode_language;
    public static final int PSP_CONFIRM_BUTTON_CIRCLE = 0;
    public static final int PSP_CONFIRM_BUTTON_CROSS = 1;
    private int languageMode_button;
    public static final int PSP_UMD_POPUP_DISABLE = 0;
    public static final int PSP_UMD_POPUP_ENABLE = 1;
    private int umdPopupStatus;
    private int backlightOffTime;

    @Override
    public String getName() {
        return "sceImpose";
    }

    @Override
    public void start() {
        this.languageMode_language = Settings.getInstance().readInt("emu.impose.language", 1);
        this.languageMode_button = Settings.getInstance().readInt("emu.impose.button", 1);
        super.start();
    }

    @HLEUnimplemented
    @HLEFunction(nid=941349351, version=150)
    public int sceImposeHomeButton() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1435871002, version=150)
    public int sceImposeSetHomePopup() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=255073252, version=150)
    public int sceImposeGetHomePopup() {
        return 0;
    }

    @HLEFunction(nid=1914215496, version=150)
    public int sceImposeSetUMDPopup(int mode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeSetUMDPopup mode=%d", mode));
        }
        this.umdPopupStatus = mode;
        return 0;
    }

    @HLEFunction(nid=-527926328, version=150)
    public int sceImposeGetUMDPopup() {
        log.debug((Object)"sceImposeGetUMDPopup");
        return this.umdPopupStatus;
    }

    @HLEFunction(nid=917139089, version=150)
    public int sceImposeSetLanguageMode(int lang, int button) {
        if (log.isDebugEnabled()) {
            String langStr;
            switch (lang) {
                case 0: {
                    langStr = "JAP";
                    break;
                }
                case 1: {
                    langStr = "ENG";
                    break;
                }
                case 2: {
                    langStr = "FR";
                    break;
                }
                case 9: {
                    langStr = "KOR";
                    break;
                }
                default: {
                    langStr = "PSP_LANGUAGE_UNKNOWN" + lang;
                }
            }
            log.debug((Object)String.format("sceImposeSetLanguageMode lang=%d(%s), button=%d", lang, langStr, button));
        }
        this.languageMode_language = lang;
        this.languageMode_button = button;
        return 0;
    }

    @HLEFunction(nid=620592079, version=150)
    public int sceImposeGetLanguageMode(TPointer32 langPtr, TPointer32 buttonPtr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeGetLanguageMode langPtr=%s, buttonPtr=%s returning lang=%d, button=%d", langPtr, buttonPtr, this.languageMode_language, this.languageMode_button));
        }
        langPtr.setValue(this.languageMode_language);
        buttonPtr.setValue(this.languageMode_button);
        return 0;
    }

    @HLEFunction(nid=-1936445039, version=150)
    public int sceImposeGetBatteryIconStatus(TPointer32 chargingPtr, TPointer32 iconStatusPtr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeGetBatteryIconStatus chargingPtr=%s, iconStatusPtr=%s", chargingPtr, iconStatusPtr));
        }
        int batteryPowerPercent = Battery.getCurrentPowerPercent();
        int iconStatus = Math.min(batteryPowerPercent / 25, 3);
        boolean charging = Battery.isCharging();
        chargingPtr.setValue(charging ? 1 : 0);
        iconStatusPtr.setValue(iconStatus);
        return 0;
    }

    @HLEFunction(nid=-1888602856, version=150)
    public int sceImposeGetBacklightOffTime() {
        log.debug((Object)"sceImposeGetBacklightOffTime");
        return this.backlightOffTime;
    }

    @HLEFunction(nid=-1770033846, version=150)
    public int sceImposeSetBacklightOffTime(int time) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeSetBacklightOffTime time=%d", time));
        }
        this.backlightOffTime = time;
        return 0;
    }
}

