/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Debugger.DisassemblerModule.DisassemblerFrame;
import jpcsp.Debugger.DisassemblerModule.VfpuFrame;
import jpcsp.Debugger.ElfHeaderInfo;
import jpcsp.Debugger.ImageViewer;
import jpcsp.Debugger.InstructionCounter;
import jpcsp.Debugger.MemoryViewer;
import jpcsp.Debugger.StepLogger;
import jpcsp.Emulator;
import jpcsp.GUI.CheatsGUI;
import jpcsp.GUI.ControlsGUI;
import jpcsp.GUI.IMainGUI;
import jpcsp.GUI.LogGUI;
import jpcsp.GUI.MemStickBrowser;
import jpcsp.GUI.RecentElement;
import jpcsp.GUI.SettingsGUI;
import jpcsp.GUI.UmdBrowser;
import jpcsp.GUI.UmdVideoPlayer;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.autotests.AutoTestsRunner;
import jpcsp.connector.Connector;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.format.PSF;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.VideoEngine;
import jpcsp.hardware.Audio;
import jpcsp.hardware.Screen;
import jpcsp.log.LogWindow;
import jpcsp.log.LoggingOutputStream;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import jpcsp.settings.Settings;
import jpcsp.util.JpcspDialogManager;
import jpcsp.util.MetaInformation;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class MainGUI
extends JFrame
implements KeyListener,
ComponentListener,
MouseListener,
IMainGUI {
    private static final long serialVersionUID = -3647025845406693230L;
    public static final int MAX_RECENT = 10;
    LogWindow consolewin;
    ElfHeaderInfo elfheader;
    SettingsGUI setgui;
    ControlsGUI ctrlgui;
    LogGUI loggui;
    MemStickBrowser memstick;
    Emulator emulator;
    UmdBrowser umdbrowser;
    UmdVideoPlayer umdvideoplayer;
    InstructionCounter instructioncounter;
    File loadedFile;
    boolean umdLoaded;
    boolean useFullscreen;
    JPopupMenu fullScreenMenu;
    private Point mainwindowPos;
    private boolean snapConsole = true;
    private List<RecentElement> recentUMD = new LinkedList<RecentElement>();
    private List<RecentElement> recentFile = new LinkedList<RecentElement>();
    public static final String windowNameForSettings = "mainwindow";
    private static final String[] userDir = new String[]{"ms0/PSP/SAVEDATA", "ms0/PSP/GAME", "tmp"};
    private static final String logConfigurationSettingLeft = "    %1$-40s [%2$s]";
    private static final String logConfigurationSettingRight = "    [%2$s] %1$s";
    private static final String logConfigurationSettingLeftPatch = "    %1$-40s [%2$s] (%3$s)";
    private static final String logConfigurationSettingRightPatch = "    [%2$s] %1$s (%3$s)";
    public static final int displayModeBitDepth = 32;
    public static final int preferredDisplayModeRefreshRate = 60;
    private DisplayMode displayMode;
    private SetLocationThread setLocationThread;
    private JComponent fillerLeft;
    private JComponent fillerRight;
    private JComponent fillerTop;
    private JComponent fillerBottom;
    private JMenuItem About;
    private JMenu AudioOpt;
    private JMenuItem Catalan;
    private JMenu CheatsMenu;
    private JMenuItem ChinesePRC;
    private JMenuItem ChineseTW;
    private JMenuItem ConfigMenu;
    private JMenuItem ControlsConf;
    private JMenuItem CustomLogger;
    private JMenu DebugMenu;
    private JMenuItem DumpIso;
    private JMenuItem ElfHeaderViewer;
    private JMenuItem English;
    private JMenuItem EnterDebugger;
    private JMenuItem EnterImageViewer;
    private JMenuItem EnterMemoryViewer;
    private JMenuItem ExitEmu;
    private JMenuItem FileLog;
    private JMenu FileMenu;
    private JMenu FiltersMenu;
    private JMenuItem French;
    private JMenuItem German;
    private JMenu HelpMenu;
    private JMenuItem InstructionCounter;
    private JMenuItem Italian;
    private JMenuItem Japanese;
    private JMenu LanguageMenu;
    private JMenuItem Lithuanian;
    private JMenuItem LoadSnap;
    private JMenu LoggerMenu;
    private JMenuBar MenuBar;
    private JCheckBoxMenuItem MuteOpt;
    private JMenuItem OpenFile;
    private JMenuItem OpenMemStick;
    private JMenu OptionsMenu;
    private JToggleButton PauseButton;
    private JMenuItem Polish;
    private JMenuItem Portuguese;
    private JMenuItem PortugueseBR;
    private JMenu RecentMenu;
    private JButton ResetButton;
    private JMenuItem ResetProfiler;
    private JMenu ResizeMenu;
    private JMenu FrameSkipMenu;
    private JCheckBoxMenuItem FrameSkipNone;
    private JCheckBoxMenuItem FPS5;
    private JCheckBoxMenuItem FPS10;
    private JCheckBoxMenuItem FPS15;
    private JCheckBoxMenuItem FPS20;
    private JCheckBoxMenuItem FPS30;
    private JCheckBoxMenuItem FPS60;
    private JMenuItem RotateItem;
    private JMenu ExportMenu;
    private JMenuItem ExportVisibleElements;
    private JMenuItem ExportAllElements;
    private JToggleButton RunButton;
    private JMenuItem Russian;
    private JMenuItem SaveSnap;
    private JMenuItem ShotItem;
    private JMenuItem Spanish;
    private JCheckBoxMenuItem ToggleLogger;
    private JMenu ToolsSubMenu;
    private JMenuItem VfpuRegisters;
    private JMenu VideoOpt;
    private JCheckBoxMenuItem anisotropicCheck;
    private JMenuItem cwcheat;
    private ButtonGroup filtersGroup;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar mainToolBar;
    private JCheckBoxMenuItem noneCheck;
    private JCheckBoxMenuItem oneTimeResize;
    private JMenuItem openUmd;
    private ButtonGroup resGroup;
    private ButtonGroup frameSkipGroup;
    private JCheckBoxMenuItem fiveTimesResize;
    private JCheckBoxMenuItem fourTimesResize;
    private JCheckBoxMenuItem threeTimesResize;
    private JCheckBoxMenuItem twoTimesResize;

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public MainGUI() {
        DOMConfigurator.configure((String)"LogSettings.xml");
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.getLogger((String)"emu"), Level.INFO)));
        this.consolewin = new LogWindow();
        for (String dirName : userDir) {
            File dir = new File(dirName);
            if (dir.exists()) continue;
            dir.mkdirs();
        }
        this.emulator = new Emulator(this);
        Screen.start();
        Resource.setLanguage(Settings.getInstance().readString("emu.language"));
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.useFullscreen = Settings.getInstance().readBool("gui.fullscreen");
        if (this.useFullscreen && !this.isDisplayable()) {
            this.setUndecorated(true);
            this.setLocation(0, 0);
            this.setSize(MainGUI.getFullScreenDimension());
            this.setPreferredSize(MainGUI.getFullScreenDimension());
        } else {
            this.setLocation(Settings.getInstance().readWindowPos(windowNameForSettings));
        }
        String resolution = Settings.getInstance().readString("emu.graphics.resolution");
        if (resolution != null && !resolution.equals("Native") && resolution.contains("x")) {
            int width = Integer.parseInt(resolution.split("x")[0]);
            int heigth = Integer.parseInt(resolution.split("x")[1]);
            this.changeScreenResolution(width, heigth);
        }
        this.createComponents();
        State.fileLogger.setLocation(this.getLocation().x + 488, this.getLocation().y + 18);
        this.setTitle(MetaInformation.FULL_NAME);
        this.getContentPane().add((Component)Modules.sceDisplayModule.getCanvas(), "Center");
        Modules.sceDisplayModule.getCanvas().addKeyListener(this);
        Modules.sceDisplayModule.getCanvas().addMouseListener(this);
        this.addComponentListener(this);
        this.pack();
        Insets insets = this.getInsets();
        Dimension minSize = new Dimension(480 + insets.left + insets.right, 272 + insets.top + insets.bottom);
        this.setMinimumSize(minSize);
        this.snapConsole = Settings.getInstance().readBool("gui.snapLogwindow");
        if (this.snapConsole) {
            this.mainwindowPos = this.getLocation();
            this.consolewin.setLocation(this.mainwindowPos.x, this.mainwindowPos.y + this.getHeight());
        } else {
            this.consolewin.setLocation(Settings.getInstance().readWindowPos("logwindow"));
        }
    }

    private void initComponents() {
        this.filtersGroup = new ButtonGroup();
        this.resGroup = new ButtonGroup();
        this.frameSkipGroup = new ButtonGroup();
        this.mainToolBar = new JToolBar();
        this.RunButton = new JToggleButton();
        this.PauseButton = new JToggleButton();
        this.ResetButton = new JButton();
        this.MenuBar = new JMenuBar();
        this.FileMenu = new JMenu();
        this.openUmd = new JMenuItem();
        this.OpenFile = new JMenuItem();
        this.OpenMemStick = new JMenuItem();
        this.RecentMenu = new JMenu();
        this.jSeparator2 = new JSeparator();
        this.SaveSnap = new JMenuItem();
        this.LoadSnap = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.ExitEmu = new JMenuItem();
        this.OptionsMenu = new JMenu();
        this.VideoOpt = new JMenu();
        this.ResizeMenu = new JMenu();
        this.oneTimeResize = new JCheckBoxMenuItem();
        this.twoTimesResize = new JCheckBoxMenuItem();
        this.threeTimesResize = new JCheckBoxMenuItem();
        this.fourTimesResize = new JCheckBoxMenuItem();
        this.fiveTimesResize = new JCheckBoxMenuItem();
        this.FiltersMenu = new JMenu();
        this.noneCheck = new JCheckBoxMenuItem();
        this.anisotropicCheck = new JCheckBoxMenuItem();
        this.FrameSkipMenu = new JMenu();
        this.FrameSkipNone = new JCheckBoxMenuItem();
        this.FPS5 = new JCheckBoxMenuItem();
        this.FPS10 = new JCheckBoxMenuItem();
        this.FPS15 = new JCheckBoxMenuItem();
        this.FPS20 = new JCheckBoxMenuItem();
        this.FPS30 = new JCheckBoxMenuItem();
        this.FPS60 = new JCheckBoxMenuItem();
        this.ShotItem = new JMenuItem();
        this.RotateItem = new JMenuItem();
        this.ExportVisibleElements = new JMenuItem();
        this.ExportAllElements = new JMenuItem();
        this.ExportMenu = new JMenu();
        this.AudioOpt = new JMenu();
        this.MuteOpt = new JCheckBoxMenuItem();
        this.ControlsConf = new JMenuItem();
        this.ConfigMenu = new JMenuItem();
        this.DebugMenu = new JMenu();
        this.ToolsSubMenu = new JMenu();
        this.LoggerMenu = new JMenu();
        this.ToggleLogger = new JCheckBoxMenuItem();
        this.CustomLogger = new JMenuItem();
        this.EnterDebugger = new JMenuItem();
        this.EnterMemoryViewer = new JMenuItem();
        this.EnterImageViewer = new JMenuItem();
        this.VfpuRegisters = new JMenuItem();
        this.ElfHeaderViewer = new JMenuItem();
        this.FileLog = new JMenuItem();
        this.InstructionCounter = new JMenuItem();
        this.DumpIso = new JMenuItem();
        this.ResetProfiler = new JMenuItem();
        this.CheatsMenu = new JMenu();
        this.cwcheat = new JMenuItem();
        this.LanguageMenu = new JMenu();
        this.English = new JMenuItem();
        this.French = new JMenuItem();
        this.German = new JMenuItem();
        this.Lithuanian = new JMenuItem();
        this.Spanish = new JMenuItem();
        this.Catalan = new JMenuItem();
        this.PortugueseBR = new JMenuItem();
        this.Portuguese = new JMenuItem();
        this.Japanese = new JMenuItem();
        this.Russian = new JMenuItem();
        this.Polish = new JMenuItem();
        this.ChinesePRC = new JMenuItem();
        this.ChineseTW = new JMenuItem();
        this.Italian = new JMenuItem();
        this.HelpMenu = new JMenu();
        this.About = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setCursor(new Cursor(0));
        this.setForeground(Color.white);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainGUI.this.formWindowClosing(evt);
            }
        });
        this.mainToolBar.setFloatable(false);
        this.mainToolBar.setRollover(true);
        this.RunButton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PlayIcon.png")));
        this.RunButton.setText(Resource.get("run"));
        this.RunButton.setFocusable(false);
        this.RunButton.setHorizontalTextPosition(4);
        this.RunButton.setIconTextGap(2);
        this.RunButton.setVerticalTextPosition(3);
        this.RunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.RunButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.RunButton);
        this.PauseButton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PauseIcon.png")));
        this.PauseButton.setText(Resource.get("pause"));
        this.PauseButton.setFocusable(false);
        this.PauseButton.setHorizontalTextPosition(4);
        this.PauseButton.setIconTextGap(2);
        this.PauseButton.setVerticalTextPosition(3);
        this.PauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.PauseButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.PauseButton);
        this.ResetButton.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StopIcon.png")));
        this.ResetButton.setText(Resource.get("reset"));
        this.ResetButton.setFocusable(false);
        this.ResetButton.setHorizontalTextPosition(4);
        this.ResetButton.setIconTextGap(2);
        this.ResetButton.setVerticalTextPosition(3);
        this.ResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ResetButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.ResetButton);
        this.getContentPane().add((Component)this.mainToolBar, "North");
        this.FileMenu.setText(Resource.get("file"));
        this.openUmd.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openUmd.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadUmdIcon.png")));
        this.openUmd.setText(Resource.get("loadumd"));
        this.openUmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.openUmdActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.openUmd);
        this.OpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.OpenFile.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadFileIcon.png")));
        this.OpenFile.setText(Resource.get("loadfile"));
        this.OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.OpenFileActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.OpenFile);
        this.OpenMemStick.setAccelerator(KeyStroke.getKeyStroke(79, 1));
        this.OpenMemStick.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadMemoryStick.png")));
        this.OpenMemStick.setText(Resource.get("loadmemstick"));
        this.OpenMemStick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.OpenMemStickActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.OpenMemStick);
        this.RecentMenu.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/RecentIcon.png")));
        this.RecentMenu.setText(Resource.get("loadrecent"));
        this.FileMenu.add(this.RecentMenu);
        this.FileMenu.add(this.jSeparator2);
        this.SaveSnap.setAccelerator(KeyStroke.getKeyStroke(83, 1));
        this.SaveSnap.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SaveStateIcon.png")));
        this.SaveSnap.setText(Resource.get("savesnapshot"));
        this.SaveSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.SaveSnapActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.SaveSnap);
        this.LoadSnap.setAccelerator(KeyStroke.getKeyStroke(76, 1));
        this.LoadSnap.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/LoadStateIcon.png")));
        this.LoadSnap.setText(Resource.get("loadsnapshot"));
        this.LoadSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.LoadSnapActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.LoadSnap);
        this.ExportMenu.setText(Resource.get("export3D"));
        this.FileMenu.add(this.ExportMenu);
        this.ExportVisibleElements.setText(Resource.get("exportVisibleElements"));
        this.ExportVisibleElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ExportVisibleElementsActionPerformed(evt);
            }
        });
        this.ExportMenu.add(this.ExportVisibleElements);
        this.ExportAllElements.setText(Resource.get("exportAllElements"));
        this.ExportAllElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ExportAllElementsActionPerformed(evt);
            }
        });
        this.ExportMenu.add(this.ExportAllElements);
        this.FileMenu.add(this.jSeparator1);
        this.ExitEmu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.ExitEmu.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/CloseIcon.png")));
        this.ExitEmu.setText(Resource.get("exit"));
        this.ExitEmu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ExitEmuActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.ExitEmu);
        this.MenuBar.add(this.FileMenu);
        this.OptionsMenu.setText(Resource.get("options"));
        this.VideoOpt.setText(Resource.get("video"));
        this.ResizeMenu.setText(Resource.get("Resize"));
        this.resGroup.add(this.oneTimeResize);
        this.oneTimeResize.setSelected(true);
        this.oneTimeResize.setText("1x");
        this.oneTimeResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.oneTimeResizeActionPerformed(evt);
            }
        });
        this.ResizeMenu.add(this.oneTimeResize);
        this.resGroup.add(this.twoTimesResize);
        this.twoTimesResize.setText("2x");
        this.twoTimesResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.twoTimesResizeActionPerformed(evt);
            }
        });
        this.ResizeMenu.add(this.twoTimesResize);
        this.resGroup.add(this.threeTimesResize);
        this.threeTimesResize.setText("3x");
        this.threeTimesResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.threeTimesResizeActionPerformed(evt);
            }
        });
        this.ResizeMenu.add(this.threeTimesResize);
        this.resGroup.add(this.fourTimesResize);
        this.fourTimesResize.setText("4x");
        this.fourTimesResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.fourTimesResizeActionPerformed(evt);
            }
        });
        this.ResizeMenu.add(this.fourTimesResize);
        this.resGroup.add(this.fiveTimesResize);
        this.fiveTimesResize.setText("5x");
        this.fiveTimesResize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.fiveTimesResizeActionPerformed(evt);
            }
        });
        this.ResizeMenu.add(this.fiveTimesResize);
        this.VideoOpt.add(this.ResizeMenu);
        this.FiltersMenu.setText(Resource.get("Filters"));
        this.filtersGroup.add(this.noneCheck);
        this.noneCheck.setSelected(true);
        this.noneCheck.setText(Resource.get("none"));
        this.noneCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.noneCheckActionPerformed(evt);
            }
        });
        this.FiltersMenu.add(this.noneCheck);
        this.filtersGroup.add(this.anisotropicCheck);
        this.anisotropicCheck.setSelected(Settings.getInstance().readBool("emu.graphics.filters.anisotropic"));
        this.anisotropicCheck.setText(Resource.get("Anisotropic"));
        this.anisotropicCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.anisotropicCheckActionPerformed(evt);
            }
        });
        this.FiltersMenu.add(this.anisotropicCheck);
        this.VideoOpt.add(this.FiltersMenu);
        this.FrameSkipMenu.setText(Resource.get("frameSkipping"));
        this.frameSkipGroup.add(this.FrameSkipNone);
        this.FrameSkipNone.setSelected(true);
        this.FrameSkipNone.setText(Resource.get("none"));
        this.FrameSkipNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipNoneActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FrameSkipNone);
        this.frameSkipGroup.add(this.FPS5);
        this.FPS5.setText("5 FPS");
        this.FPS5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS5ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS5);
        this.frameSkipGroup.add(this.FPS10);
        this.FPS10.setText("10 FPS");
        this.FPS10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS10ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS10);
        this.frameSkipGroup.add(this.FPS15);
        this.FPS15.setText("15 FPS");
        this.FPS15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS15ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS15);
        this.frameSkipGroup.add(this.FPS20);
        this.FPS20.setText("20 FPS");
        this.FPS20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS20ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS20);
        this.frameSkipGroup.add(this.FPS30);
        this.FPS30.setText("30 FPS");
        this.FPS30.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS30ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS30);
        this.frameSkipGroup.add(this.FPS60);
        this.FPS60.setText("60 FPS");
        this.FPS60.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.frameSkipFPS60ActionPerformed(evt);
            }
        });
        this.FrameSkipMenu.add(this.FPS60);
        this.VideoOpt.add(this.FrameSkipMenu);
        this.ShotItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.ShotItem.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/ScreenshotIcon.png")));
        this.ShotItem.setText(Resource.get("screenshot"));
        this.ShotItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ShotItemActionPerformed(evt);
            }
        });
        this.VideoOpt.add(this.ShotItem);
        this.RotateItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.RotateItem.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/RotateIcon.png")));
        this.RotateItem.setText(Resource.get("rotate"));
        this.RotateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.RotateItemActionPerformed(evt);
            }
        });
        this.VideoOpt.add(this.RotateItem);
        this.OptionsMenu.add(this.VideoOpt);
        this.AudioOpt.setText(Resource.get("audio"));
        this.MuteOpt.setAccelerator(KeyStroke.getKeyStroke(77, 1));
        this.MuteOpt.setText(Resource.get("mute"));
        this.MuteOpt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.MuteOptActionPerformed(evt);
            }
        });
        this.AudioOpt.add(this.MuteOpt);
        this.OptionsMenu.add(this.AudioOpt);
        this.ControlsConf.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.ControlsConf.setText(Resource.get("controls"));
        this.ControlsConf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ControlsConfActionPerformed(evt);
            }
        });
        this.OptionsMenu.add(this.ControlsConf);
        this.ConfigMenu.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.ConfigMenu.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/SettingsIcon.png")));
        this.ConfigMenu.setText(Resource.get("settings"));
        this.ConfigMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ConfigMenuActionPerformed(evt);
            }
        });
        this.OptionsMenu.add(this.ConfigMenu);
        this.MenuBar.add(this.OptionsMenu);
        this.DebugMenu.setText(Resource.get("debug"));
        this.ToolsSubMenu.setText(Resource.get("toolsmenu"));
        this.LoggerMenu.setText("Logger");
        this.ToggleLogger.setText("Show Logger");
        this.ToggleLogger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ToggleLoggerActionPerformed(evt);
            }
        });
        this.LoggerMenu.add(this.ToggleLogger);
        this.CustomLogger.setText("Customize...");
        this.CustomLogger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.CustomLoggerActionPerformed(evt);
            }
        });
        this.LoggerMenu.add(this.CustomLogger);
        this.ToolsSubMenu.add(this.LoggerMenu);
        this.EnterDebugger.setText(Resource.get("enterdebugger"));
        this.EnterDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.EnterDebuggerActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.EnterDebugger);
        this.EnterMemoryViewer.setText(Resource.get("memoryviewer"));
        this.EnterMemoryViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.EnterMemoryViewerActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.EnterMemoryViewer);
        this.EnterImageViewer.setText(Resource.get("imageviewer"));
        this.EnterImageViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.EnterImageViewerActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.EnterImageViewer);
        this.VfpuRegisters.setText(Resource.get("vfpuregisters"));
        this.VfpuRegisters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.VfpuRegistersActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.VfpuRegisters);
        this.ElfHeaderViewer.setText(Resource.get("elfheaderinfo"));
        this.ElfHeaderViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ElfHeaderViewerActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.ElfHeaderViewer);
        this.FileLog.setText(Resource.get("filelog"));
        this.FileLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.FileLogActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.FileLog);
        this.InstructionCounter.setText(Resource.get("instructioncounter"));
        this.InstructionCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.InstructionCounterActionPerformed(evt);
            }
        });
        this.ToolsSubMenu.add(this.InstructionCounter);
        this.DebugMenu.add(this.ToolsSubMenu);
        this.DumpIso.setText(Resource.get("dumpisotoisoindex"));
        this.DumpIso.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.DumpIsoActionPerformed(evt);
            }
        });
        this.DebugMenu.add(this.DumpIso);
        this.ResetProfiler.setText(Resource.get("resetprofilerinformation"));
        this.ResetProfiler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ResetProfilerActionPerformed(evt);
            }
        });
        this.DebugMenu.add(this.ResetProfiler);
        this.MenuBar.add(this.DebugMenu);
        this.CheatsMenu.setText(Resource.get("cheatsmenu"));
        this.cwcheat.setText("CWCheat");
        this.cwcheat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.cwcheatActionPerformed(evt);
            }
        });
        this.CheatsMenu.add(this.cwcheat);
        this.MenuBar.add(this.CheatsMenu);
        this.LanguageMenu.setText(Resource.get("language"));
        this.English.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/en_EN.png")));
        this.English.setText(Resource.get("english"));
        this.English.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.EnglishActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.English);
        this.French.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/fr_FR.png")));
        this.French.setText(Resource.get("french"));
        this.French.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.FrenchActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.French);
        this.German.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/de_DE.png")));
        this.German.setText(Resource.get("german"));
        this.German.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.GermanActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.German);
        this.Lithuanian.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/lt_LT.png")));
        this.Lithuanian.setText(Resource.get("lithuanian"));
        this.Lithuanian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.LithuanianActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Lithuanian);
        this.Spanish.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/es_ES.png")));
        this.Spanish.setText(Resource.get("spanish"));
        this.Spanish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.SpanishActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Spanish);
        this.Catalan.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/es_CA.png")));
        this.Catalan.setText(Resource.get("catalan"));
        this.Catalan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.CatalanActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Catalan);
        this.PortugueseBR.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/pt_BR.png")));
        this.PortugueseBR.setText(Resource.get("portuguesebr"));
        this.PortugueseBR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.PortugueseBRActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.PortugueseBR);
        this.Portuguese.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/pt_PT.png")));
        this.Portuguese.setText(Resource.get("portuguese"));
        this.Portuguese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.PortugueseActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Portuguese);
        this.Japanese.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/jp_JP.png")));
        this.Japanese.setText(Resource.get("japanese"));
        this.Japanese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.JapaneseActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Japanese);
        this.Russian.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/ru_RU.png")));
        this.Russian.setText(Resource.get("russian"));
        this.Russian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.RussianActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Russian);
        this.Polish.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/pl_PL.png")));
        this.Polish.setText(Resource.get("polish"));
        this.Polish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.PolishActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Polish);
        this.ChinesePRC.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/cn_CN.png")));
        this.ChinesePRC.setText(Resource.get("chinesePRC"));
        this.ChinesePRC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ChinesePRCActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.ChinesePRC);
        this.ChineseTW.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/tw_TW.png")));
        this.ChineseTW.setText(Resource.get("chineseTW"));
        this.ChineseTW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ChineseTWActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.ChineseTW);
        this.Italian.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/flags/it_IT.png")));
        this.Italian.setText(Resource.get("italian"));
        this.Italian.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.ItalianActionPerformed(evt);
            }
        });
        this.LanguageMenu.add(this.Italian);
        this.MenuBar.add(this.LanguageMenu);
        this.HelpMenu.setText(Resource.get("help"));
        this.About.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.About.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/AboutIcon.png")));
        this.About.setText(Resource.get("about"));
        this.About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.AboutActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.About);
        this.MenuBar.add(this.HelpMenu);
        this.setJMenuBar(this.MenuBar);
        this.pack();
    }

    private void createComponents() {
        this.initComponents();
        if (this.useFullscreen) {
            this.MenuBar.setVisible(false);
            this.mainToolBar.setVisible(false);
            this.getContentPane().remove(this.mainToolBar);
            this.fillerLeft = new JLabel();
            this.fillerRight = new JLabel();
            this.fillerTop = new JLabel();
            this.fillerBottom = new JLabel();
            this.fillerLeft.setBackground(Color.BLACK);
            this.fillerRight.setBackground(Color.BLACK);
            this.fillerTop.setBackground(Color.BLACK);
            this.fillerBottom.setBackground(Color.BLACK);
            this.fillerLeft.setOpaque(true);
            this.fillerRight.setOpaque(true);
            this.fillerTop.setOpaque(true);
            this.fillerBottom.setOpaque(true);
            this.getContentPane().add((Component)this.fillerLeft, "Before");
            this.getContentPane().add((Component)this.fillerRight, "After");
            this.getContentPane().add((Component)this.fillerTop, "North");
            this.getContentPane().add((Component)this.fillerBottom, "South");
            this.makeFullScreenMenu();
        }
        this.populateRecentMenu();
    }

    private void changeLanguage(String language) {
        Resource.setLanguage(language);
        Settings.getInstance().writeString("emu.language", language);
        this.createComponents();
    }

    private void makeFullScreenMenu() {
        this.fullScreenMenu = new JPopupMenu();
        JMenuItem popupMenuItemRun = new JMenuItem(Resource.get("run"));
        popupMenuItemRun.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PlayIcon.png")));
        popupMenuItemRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.RunButtonActionPerformed(e);
            }
        });
        JMenuItem popupMenuItemPause = new JMenuItem(Resource.get("pause"));
        popupMenuItemPause.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/PauseIcon.png")));
        popupMenuItemPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.PauseButtonActionPerformed(e);
            }
        });
        JMenuItem popupMenuItemReset = new JMenuItem(Resource.get("reset"));
        popupMenuItemReset.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/icons/StopIcon.png")));
        popupMenuItemReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.ResetButtonActionPerformed(e);
            }
        });
        this.fullScreenMenu.add(popupMenuItemRun);
        this.fullScreenMenu.add(popupMenuItemPause);
        this.fullScreenMenu.add(popupMenuItemReset);
        this.fullScreenMenu.addSeparator();
        while (this.MenuBar.getMenuCount() > 0) {
            this.fullScreenMenu.add(this.MenuBar.getMenu(0));
        }
        this.fullScreenMenu.addSeparator();
        this.fullScreenMenu.add(this.ExitEmu);
        this.VideoOpt.remove(this.ResizeMenu);
    }

    public static Dimension getFullScreenDimension() {
        DisplayMode displayMode = Emulator.getMainGUI().getDisplayMode() != null ? Emulator.getMainGUI().getDisplayMode() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return new Dimension(displayMode.getWidth(), displayMode.getHeight());
    }

    @Override
    public void startWindowDialog(Window window) {
        GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (localDevice.getFullScreenWindow() != null) {
            localDevice.setFullScreenWindow(null);
        }
        window.setVisible(true);
    }

    @Override
    public void startBackgroundWindowDialog(Window window) {
        this.startWindowDialog(window);
        this.requestFocus();
        Modules.sceDisplayModule.getCanvas().requestFocusInWindow();
    }

    @Override
    public void endWindowDialog() {
        if (this.displayMode != null) {
            GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            if (localDevice.getFullScreenWindow() == null) {
                localDevice.setFullScreenWindow(this);
                this.setDisplayMode();
            }
            if (this.useFullscreen) {
                this.setFullScreenDisplaySize();
            }
        }
    }

    private void changeScreenResolution(int width, int height) {
        GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode[] displayModes = localDevice.getDisplayModes();
        DisplayMode bestDisplayMode = null;
        for (int i = 0; displayModes != null && i < displayModes.length; ++i) {
            DisplayMode displayMode = displayModes[i];
            if (displayMode.getWidth() != width || displayMode.getHeight() != height || displayMode.getBitDepth() != 32 || bestDisplayMode != null && (bestDisplayMode.getRefreshRate() >= displayMode.getRefreshRate() || bestDisplayMode.getRefreshRate() == 60)) continue;
            bestDisplayMode = displayMode;
        }
        if (bestDisplayMode != null) {
            this.changeScreenResolution(bestDisplayMode);
        }
    }

    private void setDisplayMode() {
        if (this.displayMode != null) {
            GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            localDevice.setDisplayMode(this.displayMode);
            if (this.setLocationThread == null) {
                this.setLocationThread = new SetLocationThread();
                this.setLocationThread.setName("Set MainGUI Location Thread");
                this.setLocationThread.setDaemon(true);
                this.setLocationThread.start();
            }
        }
    }

    @Override
    public void setLocation() {
        if (this.displayMode != null && this.useFullscreen) {
            if (this.fillerTop == null || this.fillerTop.getHeight() == 0) {
                if (this.getLocation().y != -1) {
                    this.setLocation(0, -1);
                }
            } else if (this.fillerLeft.getWidth() == 0 && this.getLocation().x != -1) {
                this.setLocation(-1, 0);
            }
        }
    }

    @Override
    public void setFullScreenDisplaySize() {
        Dimension size = new Dimension(sceDisplay.getResizedWidth(480), sceDisplay.getResizedHeight(272));
        this.setFullScreenDisplaySize(size);
    }

    private void setFullScreenDisplaySize(Dimension size) {
        Dimension fullScreenSize = MainGUI.getFullScreenDimension();
        this.setLocation();
        if (size.width < fullScreenSize.width) {
            this.fillerLeft.setSize((fullScreenSize.width - size.width) / 2, fullScreenSize.height);
            this.fillerRight.setSize(fullScreenSize.width - size.width - this.fillerLeft.getWidth(), fullScreenSize.height);
        } else {
            this.fillerLeft.setSize(0, 0);
            this.fillerRight.setSize(1, fullScreenSize.height);
            this.setSize(fullScreenSize.width + 1, fullScreenSize.height);
            this.setPreferredSize(this.getSize());
        }
        if (size.height < fullScreenSize.height) {
            this.fillerTop.setSize(fullScreenSize.width, (fullScreenSize.height - size.height) / 2);
            this.fillerBottom.setSize(fullScreenSize.width, fullScreenSize.height - size.height - this.fillerTop.getHeight());
        } else {
            this.fillerTop.setSize(0, 0);
            this.fillerBottom.setSize(fullScreenSize.width, 1);
            this.setSize(fullScreenSize.width, fullScreenSize.height + 1);
            this.setPreferredSize(this.getSize());
        }
        this.fillerLeft.setPreferredSize(this.fillerLeft.getSize());
        this.fillerRight.setPreferredSize(this.fillerRight.getSize());
        this.fillerTop.setPreferredSize(this.fillerTop.getSize());
        this.fillerBottom.setPreferredSize(this.fillerBottom.getSize());
    }

    private void changeScreenResolution(DisplayMode displayMode) {
        GraphicsDevice localDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (localDevice.isFullScreenSupported()) {
            this.displayMode = displayMode;
            localDevice.setFullScreenWindow(this);
            this.setDisplayMode();
            if (this.useFullscreen) {
                this.setSize(MainGUI.getFullScreenDimension());
                this.setPreferredSize(MainGUI.getFullScreenDimension());
                this.setLocation();
            }
            if (Emulator.log.isInfoEnabled()) {
                Emulator.log.info((Object)String.format("Changing resolution to %dx%d, %d bits, %d Hz", displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate()));
            }
        }
    }

    public LogWindow getConsoleWindow() {
        return this.consolewin;
    }

    private void populateRecentMenu() {
        JMenuItem item;
        this.RecentMenu.removeAll();
        this.recentUMD.clear();
        this.recentFile.clear();
        Settings.getInstance().readRecent("umd", this.recentUMD);
        Settings.getInstance().readRecent("file", this.recentFile);
        for (RecentElement umd : this.recentUMD) {
            item = new JMenuItem(umd.toString());
            item.addActionListener(new RecentElementActionListener(0, umd.path));
            this.RecentMenu.add(item);
        }
        if (!this.recentUMD.isEmpty() && !this.recentFile.isEmpty()) {
            this.RecentMenu.addSeparator();
        }
        for (RecentElement file : this.recentFile) {
            item = new JMenuItem(file.toString());
            item.addActionListener(new RecentElementActionListener(1, file.path));
            this.RecentMenu.add(item);
        }
    }

    private void EnterDebuggerActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        if (State.debugger == null) {
            State.debugger = new DisassemblerFrame(this.emulator);
            State.debugger.setLocation(Settings.getInstance().readWindowPos("disassembler"));
        } else {
            State.debugger.RefreshDebugger(false);
        }
        this.startWindowDialog(State.debugger);
    }

    private void RunButtonActionPerformed(ActionEvent evt) {
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.initVideo();
        }
        this.RunEmu();
    }

    private JFileChooser makeJFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Open Elf/Pbp File");
        fc.setCurrentDirectory(new File("."));
        return fc;
    }

    private void OpenFileActionPerformed(ActionEvent evt) {
        int returnVal;
        this.PauseEmu();
        JFileChooser fc = this.makeJFileChooser();
        String lastOpenedFolder = Settings.getInstance().readString("gui.lastOpenedFileFolder");
        if (lastOpenedFolder != null) {
            fc.setCurrentDirectory(new File(lastOpenedFolder));
        }
        if (!this.userChooseSomething(returnVal = fc.showOpenDialog(this))) {
            return;
        }
        Settings.getInstance().writeString("gui.lastOpenedFileFolder", fc.getSelectedFile().getParent());
        File file = fc.getSelectedFile();
        this.loadFile(file);
    }

    private String pspifyFilename(String pcfilename) {
        if (pcfilename.startsWith("ms0")) {
            return "ms0:" + pcfilename.substring(3).replaceAll("\\\\", "/");
        }
        try {
            String ms0path = new File("ms0").getCanonicalPath();
            if (pcfilename.startsWith(ms0path)) {
                return "ms0:" + pcfilename.substring(ms0path.length()).replaceAll("\\\\", "/");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pcfilename.replaceAll("\\\\", "/");
    }

    public void loadFile(File file) {
        try {
            boolean isHomebrew;
            String title;
            ByteBuffer readbuffer;
            if (this.consolewin != null) {
                this.consolewin.clearScreenMessages();
            }
            Emulator.log.info((Object)MetaInformation.FULL_NAME);
            this.umdLoaded = false;
            this.loadedFile = file;
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel roChannel = null;
            long size = raf.length();
            if (size > 0x100000L) {
                int len;
                byte[] bytes = new byte[(int)size];
                int offset = 0;
                while (offset < bytes.length && (len = raf.read(bytes, offset, Math.min(10240, bytes.length - offset))) >= 0) {
                    if (len <= 0) continue;
                    offset += len;
                }
                readbuffer = ByteBuffer.wrap(bytes, 0, offset);
            } else {
                roChannel = raf.getChannel();
                readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
            }
            SceModule module = this.emulator.load(this.pspifyFilename(file.getPath()), readbuffer);
            if (roChannel != null) {
                roChannel.close();
            }
            raf.close();
            PSF psf = module.psf;
            String discId = "[unknown, file]";
            if (psf != null) {
                title = psf.getPrintableString("TITLE");
                discId = psf.getString("DISC_ID");
                if (discId == null) {
                    discId = "[unknown, file]";
                }
                isHomebrew = psf.isLikelyHomebrew();
            } else {
                title = file.getParentFile().getName();
                isHomebrew = true;
            }
            this.setTitle(MetaInformation.FULL_NAME + " - " + title);
            this.addRecentFile(file, title);
            String filepath = file.getParent();
            String ms0path = new File("ms0").getCanonicalPath();
            if (filepath.startsWith(ms0path)) {
                filepath = filepath.substring(ms0path.length() - 3);
            }
            Modules.IoFileMgrForUserModule.setfilepath(filepath);
            Modules.IoFileMgrForUserModule.setIsoReader(null);
            Modules.sceUmdUserModule.setIsoReader(null);
            RuntimeContext.setIsHomebrew(isHomebrew);
            State.discId = discId;
            State.title = title;
            if (!isHomebrew) {
                Settings.getInstance().loadPatchSettings();
            }
            this.logConfigurationSettings();
            if (this.instructioncounter != null) {
                this.instructioncounter.RefreshWindow();
            }
            StepLogger.clear();
            StepLogger.setName(file.getPath());
        }
        catch (GeneralJpcspException e) {
            JpcspDialogManager.showError(this, Resource.get("generalError") + " : " + e.getMessage());
        }
        catch (IOException e) {
            if (file.getName().contains("iso") || file.getName().contains("cso")) {
                JpcspDialogManager.showError(this, Resource.get("criticalError") + " : " + Resource.get("wrongLoader"));
            } else {
                e.printStackTrace();
                JpcspDialogManager.showError(this, Resource.get("ioError") + " : " + e.getMessage());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex.getMessage() != null) {
                JpcspDialogManager.showError(this, Resource.get("criticalError") + " : " + ex.getMessage());
            }
            JpcspDialogManager.showError(this, Resource.get("criticalError") + " : Check console for details.");
        }
    }

    private void addRecentFile(File file, String title) {
        String s = file.getPath();
        for (int i = 0; i < this.recentFile.size(); ++i) {
            if (!this.recentFile.get((int)i).path.equals(s)) continue;
            this.recentFile.remove(i--);
        }
        this.recentFile.add(0, new RecentElement(s, title));
        while (this.recentFile.size() > 10) {
            this.recentFile.remove(10);
        }
        Settings.getInstance().writeRecent("file", this.recentFile);
        this.populateRecentMenu();
    }

    private void addRecentUMD(File file, String title) {
        try {
            String s = file.getCanonicalPath();
            for (int i = 0; i < this.recentUMD.size(); ++i) {
                if (!this.recentUMD.get((int)i).path.equals(s)) continue;
                this.recentUMD.remove(i--);
            }
            this.recentUMD.add(0, new RecentElement(s, title));
            while (this.recentUMD.size() > 10) {
                this.recentUMD.remove(10);
            }
            Settings.getInstance().writeRecent("umd", this.recentUMD);
            this.populateRecentMenu();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void PauseButtonActionPerformed(ActionEvent evt) {
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.pauseVideo();
        }
        this.TogglePauseEmu();
    }

    private void ElfHeaderViewerActionPerformed(ActionEvent evt) {
        if (this.elfheader == null) {
            this.elfheader = new ElfHeaderInfo();
            this.elfheader.setLocation(Settings.getInstance().readWindowPos("elfheader"));
        } else {
            this.elfheader.RefreshWindow();
        }
        this.startWindowDialog(this.elfheader);
    }

    private void EnterMemoryViewerActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        if (State.memoryViewer == null) {
            State.memoryViewer = new MemoryViewer();
            State.memoryViewer.setLocation(Settings.getInstance().readWindowPos("memoryview"));
        } else {
            State.memoryViewer.RefreshMemory();
        }
        this.startWindowDialog(State.memoryViewer);
    }

    private void EnterImageViewerActionPerformed(ActionEvent evt) {
        if (State.imageViewer == null) {
            State.imageViewer = new ImageViewer();
        } else {
            State.imageViewer.refreshImage();
        }
        this.startWindowDialog(State.imageViewer);
    }

    private void AboutActionPerformed(ActionEvent evt) {
        StringBuilder message = new StringBuilder();
        message.append("<html>").append("<h2>" + MetaInformation.FULL_NAME + "</h2>").append("<hr/>").append("Official site      : <a href='" + MetaInformation.OFFICIAL_SITE + "'>" + MetaInformation.OFFICIAL_SITE + "</a><br/>").append("Official forum     : <a href='" + MetaInformation.OFFICIAL_FORUM + "'>" + MetaInformation.OFFICIAL_FORUM + "</a><br/>").append("Official repository: <a href='" + MetaInformation.OFFICIAL_REPOSITORY + "'>" + MetaInformation.OFFICIAL_REPOSITORY + "</a><br/>").append("<hr/>").append("<i>Team:</i> <font color='gray'>" + MetaInformation.TEAM + "</font>").append("</html>");
        JOptionPane.showMessageDialog(this, message.toString(), MetaInformation.FULL_NAME, 1);
    }

    private void ConfigMenuActionPerformed(ActionEvent evt) {
        if (this.setgui == null) {
            this.setgui = new SettingsGUI();
            Point mainwindow = this.getLocation();
            this.setgui.setLocation(mainwindow.x + 100, mainwindow.y + 50);
        } else {
            this.setgui.RefreshWindow();
        }
        this.startWindowDialog(this.setgui);
    }

    private void ExitEmuActionPerformed(ActionEvent evt) {
        this.exitEmu();
    }

    private void OpenMemStickActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        if (this.memstick == null) {
            this.memstick = new MemStickBrowser(this, new File("ms0/PSP/GAME"));
            Point mainwindow = this.getLocation();
            this.memstick.setLocation(mainwindow.x + 100, mainwindow.y + 50);
        } else {
            this.memstick.refreshFiles();
        }
        this.memstick.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitEmu();
    }

    private void openUmdActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        if (Settings.getInstance().readBool("emu.umdbrowser")) {
            String umdPath;
            LinkedList<File> umdPaths = new LinkedList<File>();
            umdPaths.add(new File(Settings.getInstance().readString("emu.umdpath") + "/"));
            int i = 1;
            while ((umdPath = Settings.getInstance().readString(String.format("emu.umdpath.%d", i), null)) != null) {
                umdPaths.add(new File(umdPath + "/"));
                ++i;
            }
            this.umdbrowser = new UmdBrowser(this, umdPaths.toArray(new File[umdPaths.size()]));
            this.umdbrowser.setVisible(true);
        } else {
            JFileChooser fc = this.makeJFileChooser();
            String lastOpenedFolder = Settings.getInstance().readString("gui.lastOpenedUmdFolder");
            if (lastOpenedFolder != null) {
                fc.setCurrentDirectory(new File(lastOpenedFolder));
            }
            fc.setDialogTitle(Resource.get("openumd"));
            int returnVal = fc.showOpenDialog(this);
            if (this.userChooseSomething(returnVal)) {
                Settings.getInstance().writeString("gui.lastOpenedUmdFolder", fc.getSelectedFile().getParent());
                File file = fc.getSelectedFile();
                this.loadUMD(file);
            } else {
                return;
            }
        }
    }

    private boolean loadUMD(UmdIsoReader iso, String bootPath) throws IOException {
        boolean success = false;
        try {
            UmdIsoFile bootBin = iso.getFile(bootPath);
            if (bootBin.length() != 0L) {
                byte[] bootfile = new byte[(int)bootBin.length()];
                bootBin.read(bootfile);
                ByteBuffer buf = ByteBuffer.wrap(bootfile);
                this.emulator.load("disc0:/" + bootPath, buf);
                success = true;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (GeneralJpcspException e) {
            // empty catch block
        }
        return success;
    }

    private boolean loadUnpackedUMD(String filename) throws IOException, GeneralJpcspException {
        File file = new File(filename);
        if (file.exists()) {
            FileChannel roChannel = new RandomAccessFile(file, "r").getChannel();
            MappedByteBuffer readbuffer = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
            this.emulator.load("disc0:/PSP_GAME/SYSDIR/EBOOT.BIN", readbuffer);
            roChannel.close();
            Emulator.log.info((Object)"Using unpacked UMD EBOOT.BIN image");
            return true;
        }
        return false;
    }

    public void loadUMD(File file) {
        try {
            UmdIsoReader iso = new UmdIsoReader(file.getPath());
            iso.getFile("PSP_GAME/param.sfo");
            this.loadUMDGame(file);
        }
        catch (FileNotFoundException e) {
            try {
                UmdIsoReader iso = new UmdIsoReader(file.getPath());
                iso.getFile("UMD_VIDEO/param.sfo");
                this.loadUMDVideo(file);
            }
            catch (FileNotFoundException ve) {
                try {
                    UmdIsoReader iso = new UmdIsoReader(file.getPath());
                    iso.getFile("UMD_AUDIO/param.sfo");
                    this.loadUMDAudio(file);
                }
                catch (FileNotFoundException ae) {
                }
                catch (IOException aioe) {
                }
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadUMDGame(File file) {
        try {
            if (this.consolewin != null) {
                this.consolewin.clearScreenMessages();
            }
            Emulator.log.info((Object)String.format("Java version: %s (%s)", System.getProperty("java.version"), System.getProperty("java.runtime.version")));
            Emulator.log.info((Object)String.format("Java library path: %s", System.getProperty("java.library.path")));
            Modules.SysMemUserForUserModule.reset();
            Emulator.log.info((Object)MetaInformation.FULL_NAME);
            this.umdLoaded = true;
            this.loadedFile = file;
            UmdIsoReader iso = new UmdIsoReader(file.getPath());
            UmdIsoFile psfFile = iso.getFile("PSP_GAME/param.sfo");
            PSF psf = new PSF();
            byte[] data = new byte[(int)psfFile.length()];
            psfFile.read(data);
            psf.read(ByteBuffer.wrap(data));
            Emulator.log.info((Object)("UMD param.sfo :\n" + psf));
            String title = psf.getPrintableString("TITLE");
            String discId = psf.getString("DISC_ID");
            if (discId == null) {
                discId = "[unknown, umd]";
            }
            this.setTitle(MetaInformation.FULL_NAME + " - " + title + " - " + discId);
            this.addRecentUMD(file, title);
            this.emulator.setFirmwareVersion(psf.getString("PSP_SYSTEM_VER"));
            RuntimeContext.setIsHomebrew(psf.isLikelyHomebrew());
            Modules.SysMemUserForUserModule.setMemory64MB(psf.getNumeric("MEMSIZE") == 1);
            State.discId = discId;
            if (!discId.equals("[unknown, umd]") && this.loadUnpackedUMD(discId + ".BIN") || this.loadUMD(iso, "PSP_GAME/SYSDIR/EBOOT.LLD") || this.loadUMD(iso, "PSP_GAME/SYSDIR/OLD_EBOOT.BIN") || this.loadUMD(iso, "PSP_GAME/SYSDIR/EBOOT.123") || this.loadUMD(iso, "PSP_GAME/SYSDIR/EBOOT_LRC_CH.BIN") || this.loadUMD(iso, "PSP_GAME/SYSDIR/BOOT0.OLD") || this.loadUMD(iso, "PSP_GAME/SYSDIR/BOOT1.OLD") || this.loadUMD(iso, "PSP_GAME/SYSDIR/EBOOT.OLD") || !discId.equals("[unknown, umd]") && this.loadUnpackedUMD(Connector.baseDirectory + discId + File.separatorChar + "EBOOT.BIN") || this.loadUMD(iso, "PSP_GAME/SYSDIR/EBOOT.BIN") || this.loadUMD(iso, "PSP_GAME/SYSDIR/BOOT.BIN")) {
                State.title = title;
                Settings.getInstance().loadPatchSettings();
                this.logConfigurationSettings();
                Modules.IoFileMgrForUserModule.setfilepath("disc0/");
                Modules.IoFileMgrForUserModule.setIsoReader(iso);
                Modules.sceUmdUserModule.setIsoReader(iso);
                if (this.instructioncounter != null) {
                    this.instructioncounter.RefreshWindow();
                }
            } else {
                State.discId = "[unknown, nothing loaded]";
                throw new GeneralJpcspException(Resource.get("encryptedBoot"));
            }
            StepLogger.clear();
            StepLogger.setName(file.getPath());
        }
        catch (GeneralJpcspException e) {
            JpcspDialogManager.showError(this, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            JpcspDialogManager.showError(this, Resource.get("ioError") + " : " + e.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex.getMessage() != null) {
                JpcspDialogManager.showError(this, Resource.get("criticalError") + " : " + ex.getMessage());
            }
            JpcspDialogManager.showError(this, Resource.get("criticalError") + " : Check console for details.");
        }
    }

    public void loadUMDVideo(File file) {
        try {
            UmdVideoPlayer vp;
            if (this.consolewin != null) {
                this.consolewin.clearScreenMessages();
            }
            Modules.SysMemUserForUserModule.reset();
            Emulator.log.info((Object)MetaInformation.FULL_NAME);
            this.umdLoaded = true;
            this.loadedFile = file;
            UmdIsoReader iso = new UmdIsoReader(file.getPath());
            UmdIsoFile psfFile = iso.getFile("UMD_VIDEO/param.sfo");
            UmdIsoFile umdDataFile = iso.getFile("UMD_DATA.BIN");
            PSF psf = new PSF();
            byte[] data = new byte[(int)psfFile.length()];
            psfFile.read(data);
            psf.read(ByteBuffer.wrap(data));
            Emulator.log.info((Object)("UMD param.sfo :\n" + psf));
            String title = psf.getPrintableString("TITLE");
            String discId = psf.getString("DISC_ID");
            if (discId == null) {
                byte[] umdDataId = new byte[10];
                String umdDataIdString = "";
                umdDataFile.readFully(umdDataId, 0, 9);
                umdDataIdString = new String(umdDataId);
                discId = umdDataIdString.equals("") ? "[unknown, umd]" : umdDataIdString;
            }
            this.setTitle(MetaInformation.FULL_NAME + " - " + title);
            this.addRecentUMD(file, title);
            this.emulator.setFirmwareVersion(psf.getString("PSP_SYSTEM_VER"));
            RuntimeContext.setIsHomebrew(false);
            Modules.SysMemUserForUserModule.setMemory64MB(psf.getNumeric("MEMSIZE") == 1);
            State.discId = discId;
            State.title = title;
            this.logConfigurationSettings();
            this.umdvideoplayer = vp = new UmdVideoPlayer(this, iso);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex.getMessage() != null) {
                JpcspDialogManager.showError(this, Resource.get("criticalError") + " : " + ex.getMessage());
            }
            JpcspDialogManager.showError(this, Resource.get("criticalError") + " : Check console for details.");
        }
    }

    public void loadUMDAudio(File file) {
        try {
            if (this.consolewin != null) {
                this.consolewin.clearScreenMessages();
            }
            Modules.SysMemUserForUserModule.reset();
            Emulator.log.info((Object)MetaInformation.FULL_NAME);
            this.umdLoaded = true;
            this.loadedFile = file;
            UmdIsoReader iso = new UmdIsoReader(file.getPath());
            UmdIsoFile psfFile = iso.getFile("UMD_AUDIO/param.sfo");
            PSF psf = new PSF();
            byte[] data = new byte[(int)psfFile.length()];
            psfFile.read(data);
            psf.read(ByteBuffer.wrap(data));
            Emulator.log.info((Object)("UMD param.sfo :\n" + psf));
            String title = psf.getPrintableString("TITLE");
            String discId = psf.getString("DISC_ID");
            if (discId == null) {
                discId = "[unknown, umd]";
            }
            this.setTitle(MetaInformation.FULL_NAME + " - " + title);
            this.addRecentUMD(file, title);
            this.emulator.setFirmwareVersion(psf.getString("PSP_SYSTEM_VER"));
            RuntimeContext.setIsHomebrew(false);
            Modules.SysMemUserForUserModule.setMemory64MB(psf.getNumeric("MEMSIZE") == 1);
            State.discId = discId;
            State.title = title;
            this.logConfigurationSettings();
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex.getMessage() != null) {
                JpcspDialogManager.showError(this, Resource.get("criticalError") + " : " + ex.getMessage());
            }
            JpcspDialogManager.showError(this, Resource.get("criticalError") + " : Check console for details.");
        }
    }

    private void logConfigurationSetting(String resourceKey, String settingKey, String value, boolean textLeft) {
        boolean isSettingFromPatch = Settings.getInstance().isOptionFromPatch(settingKey);
        String format = isSettingFromPatch ? (textLeft ? logConfigurationSettingLeftPatch : logConfigurationSettingRightPatch) : (textLeft ? logConfigurationSettingLeft : logConfigurationSettingRight);
        String text = Resource.getEnglish(resourceKey);
        if (text == null) {
            text = resourceKey;
        }
        Emulator.log.info((Object)String.format(format, text, value, "from patch file"));
    }

    private void logConfigurationSettingBool(String resourceKey, String settingKey, boolean textLeft) {
        boolean value = Settings.getInstance().readBool(settingKey);
        this.logConfigurationSetting(resourceKey, settingKey, value ? "X" : " ", textLeft);
    }

    private void logConfigurationSettingInt(String resourceKey, String settingKey, boolean textLeft) {
        int value = Settings.getInstance().readInt(settingKey);
        this.logConfigurationSetting(resourceKey, settingKey, Integer.toString(value), textLeft);
    }

    private void logConfigurationSettingString(String resourceKey, String settingKey, boolean textLeft) {
        String value = Settings.getInstance().readString(settingKey);
        this.logConfigurationSetting(resourceKey, settingKey, value, textLeft);
    }

    private void logConfigurationSettingList(String resourceKey, String settingKey, String[] values, boolean textLeft) {
        int valueIndex = Settings.getInstance().readInt(settingKey);
        String value = Integer.toString(valueIndex);
        if (values != null && valueIndex >= 0 && valueIndex < values.length) {
            value = values[valueIndex];
        }
        this.logConfigurationSetting(resourceKey, settingKey, value, textLeft);
    }

    private void logConfigurationPanel(String resourceKey) {
        Emulator.log.info((Object)String.format("%s / %s", Resource.getEnglish("settings"), Resource.getEnglish(resourceKey)));
    }

    private void logConfigurationSettings() {
        if (!Emulator.log.isInfoEnabled()) {
            return;
        }
        Emulator.log.info((Object)"Using the following settings:");
        this.logConfigurationPanel("region");
        this.logConfigurationSettingList("language", "emu.impose.language", SettingsGUI.getImposeLanguages(), true);
        this.logConfigurationSettingList("buttonpref", "emu.impose.button", SettingsGUI.getImposeButtons(), true);
        this.logConfigurationSettingList("daylightSavings", "emu.sysparam.daylightsavings", SettingsGUI.getSysparamDaylightSavings(), true);
        this.logConfigurationSettingInt("timezone", "emu.sysparam.timezone", true);
        this.logConfigurationSettingList("timeformat", "emu.sysparam.timeformat", SettingsGUI.getSysparamTimeFormats(), true);
        this.logConfigurationSettingList("dateformat", "emu.sysparam.dateformat", SettingsGUI.getSysparamDateFormats(), true);
        this.logConfigurationSettingList("wlanpowersaving", "emu.sysparam.wlanpowersave", SettingsGUI.getSysparamWlanPowerSaves(), true);
        this.logConfigurationSettingList("adhocChannel", "emu.sysparam.adhocchannel", SettingsGUI.getSysparamAdhocChannels(), true);
        this.logConfigurationSettingString("nickname", "emu.sysparam.nickname", true);
        this.logConfigurationPanel("video");
        this.logConfigurationSettingBool("disablevbo", "emu.disablevbo", false);
        this.logConfigurationSettingBool("onlyGeGraphics", "emu.onlyGEGraphics", false);
        this.logConfigurationSettingBool("usevertex", "emu.useVertexCache", false);
        this.logConfigurationSettingBool("useshader", "emu.useshaders", false);
        this.logConfigurationSettingBool("useGeometryShader", "emu.useGeometryShader", false);
        this.logConfigurationSettingBool("disableubo", "emu.disableubo", false);
        this.logConfigurationSettingBool("enablevao", "emu.enablevao", false);
        this.logConfigurationSettingBool("enablegetexture", "emu.enablegetexture", false);
        this.logConfigurationSettingBool("enablenativeclut", "emu.enablenativeclut", false);
        this.logConfigurationSettingBool("enabledynamicshaders", "emu.enabledynamicshaders", false);
        this.logConfigurationSettingBool("enableshaderstenciltest", "emu.enableshaderstenciltest", false);
        this.logConfigurationSettingBool("enableshadercolormask", "emu.enableshadercolormask", false);
        this.logConfigurationSettingBool("disableoptimizedvertexinforeading", "emu.disableoptimizedvertexinforeading", false);
        this.logConfigurationSettingBool("useSoftwareRenderer", "emu.useSoftwareRenderer", false);
        this.logConfigurationPanel("audio");
        this.logConfigurationSettingBool("disableaudiothreads", "emu.ignoreaudiothreads", false);
        this.logConfigurationSettingBool("disableaudiotchannels", "emu.disablesceAudio", false);
        this.logConfigurationSettingBool("disableaudiotblocking", "emu.disableblockingaudio", false);
        this.logConfigurationPanel("memory");
        this.logConfigurationSettingBool("ignoreinvalidmemory", "emu.ignoreInvalidMemoryAccess", false);
        this.logConfigurationSettingBool("ignoreUnmaped", "emu.ignoreUnmappedImports", false);
        this.logConfigurationPanel("misc");
        this.logConfigurationSettingBool("useMediaEngine", "emu.useMediaEngine", false);
        this.logConfigurationSettingBool("useConnector", "emu.useConnector", false);
        this.logConfigurationSettingBool("useExternalDecoder", "emu.useExternalDecoder", false);
        this.logConfigurationSettingBool("useDebugFont", "emu.useDebugFont", false);
        this.logConfigurationPanel("compiler");
        this.logConfigurationSettingBool("useCompiler", "emu.compiler", false);
        this.logConfigurationSettingBool("outputprofiler", "emu.profiler", false);
        this.logConfigurationSettingInt("methodMaxInstructions", "emu.compiler.methodMaxInstructions", false);
        this.logConfigurationPanel("crypto");
        this.logConfigurationSettingBool("extractEboot", "emu.extractEboot", false);
        this.logConfigurationSettingBool("cryptoSavedata", "emu.cryptoSavedata", false);
        this.logConfigurationSettingBool("extractPGD", "emu.extractPGD", false);
        this.logConfigurationPanel("display");
        this.logConfigurationSettingString("antiAliasing", "emu.graphics.antialias", true);
        this.logConfigurationSettingString("resolution", "emu.graphics.resolution", true);
        this.logConfigurationSettingBool("fullscreenMode", "gui.fullscreen", false);
    }

    private void ResetButtonActionPerformed(ActionEvent evt) {
        this.resetEmu();
    }

    private void resetEmu() {
        if (this.loadedFile != null) {
            this.PauseEmu();
            RuntimeContext.reset();
            HLEModuleManager.getInstance().stopModules();
            if (this.umdLoaded) {
                this.loadUMD(this.loadedFile);
            } else {
                this.loadFile(this.loadedFile);
            }
        }
    }

    private void InstructionCounterActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        if (this.instructioncounter == null) {
            this.instructioncounter = new InstructionCounter();
            this.emulator.setInstructionCounter(this.instructioncounter);
            Point mainwindow = this.getLocation();
            this.instructioncounter.setLocation(mainwindow.x + 100, mainwindow.y + 50);
        } else {
            this.instructioncounter.RefreshWindow();
        }
        this.startWindowDialog(this.instructioncounter);
    }

    private void FileLogActionPerformed(ActionEvent evt) {
        this.PauseEmu();
        this.startWindowDialog(State.fileLogger);
    }

    private void VfpuRegistersActionPerformed(ActionEvent evt) {
        this.startWindowDialog(VfpuFrame.getInstance());
    }

    private void DumpIsoActionPerformed(ActionEvent evt) {
        UmdIsoReader iso;
        if (this.umdLoaded && (iso = Modules.IoFileMgrForUserModule.getIsoReader()) != null) {
            try {
                iso.dumpIndexFile("iso-index.txt");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void ResetProfilerActionPerformed(ActionEvent evt) {
        Profiler.reset();
        GEProfiler.reset();
    }

    private void ShotItemActionPerformed(ActionEvent evt) {
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.takeScreenshot();
        }
        Modules.sceDisplayModule.getscreen = true;
    }

    private void RotateItemActionPerformed(ActionEvent evt) {
        sceDisplay screen = Modules.sceDisplayModule;
        Object[] options = new Object[]{"90 CW", "90 CCW", "180", "Mirror", "Normal"};
        int jop = JOptionPane.showOptionDialog(null, Resource.get("chooseRotation"), "Rotate", -1, 3, null, options, options[4]);
        if (jop == -1) {
            return;
        }
        screen.rotate(jop);
    }

    private void ExportVisibleElementsActionPerformed(ActionEvent evt) {
        State.exportGeNextFrame = true;
        State.exportGeOnlyVisibleElements = true;
    }

    private void ExportAllElementsActionPerformed(ActionEvent evt) {
        State.exportGeNextFrame = true;
        State.exportGeOnlyVisibleElements = false;
    }

    private byte safeRead8(int address) {
        byte value = 0;
        if (Memory.isAddressGood(address)) {
            value = (byte)Memory.getInstance().read8(address);
        }
        return value;
    }

    private void safeWrite8(byte value, int address) {
        if (Memory.isAddressGood(address)) {
            Memory.getInstance().write8(address, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void SaveSnapActionPerformed(ActionEvent evt) {
        File f = new File("Snap_" + State.discId + ".bin");
        BufferedOutputStream bOut = null;
        ByteBuffer cpuBuf = ByteBuffer.allocate(1024);
        Emulator.getProcessor().save(cpuBuf);
        try {
            bOut = new BufferedOutputStream(new FileOutputStream(f));
            for (int i = 0x8000000; i <= 0x9FFFFFF; ++i) {
                bOut.write(this.safeRead8(i));
            }
            bOut.write(cpuBuf.array());
        }
        catch (IOException e) {
            Utilities.close(bOut);
            catch (Throwable throwable) {
                Utilities.close(bOut);
                throw throwable;
            }
        }
        Utilities.close(bOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void LoadSnapActionPerformed(ActionEvent evt) {
        File f = new File("Snap_" + State.discId + ".bin");
        BufferedInputStream bIn = null;
        ByteBuffer cpuBuf = ByteBuffer.allocate(1024);
        try {
            bIn = new BufferedInputStream(new FileInputStream(f));
            for (int i = 0x8000000; i <= 0x9FFFFFF; ++i) {
                this.safeWrite8((byte)bIn.read(), i);
            }
            bIn.read(cpuBuf.array());
        }
        catch (IOException e) {
            Utilities.close(bIn);
            catch (Throwable throwable) {
                Utilities.close(bIn);
                throw throwable;
            }
        }
        Utilities.close(bIn);
        Emulator.getProcessor().load(cpuBuf);
    }

    private void EnglishActionPerformed(ActionEvent evt) {
        this.changeLanguage("en_EN");
    }

    private void FrenchActionPerformed(ActionEvent evt) {
        this.changeLanguage("fr_FR");
    }

    private void GermanActionPerformed(ActionEvent evt) {
        this.changeLanguage("de_DE");
    }

    private void LithuanianActionPerformed(ActionEvent evt) {
        this.changeLanguage("lt_LT");
    }

    private void SpanishActionPerformed(ActionEvent evt) {
        this.changeLanguage("es_ES");
    }

    private void CatalanActionPerformed(ActionEvent evt) {
        this.changeLanguage("es_CA");
    }

    private void PortugueseActionPerformed(ActionEvent evt) {
        this.changeLanguage("pt_PT");
    }

    private void JapaneseActionPerformed(ActionEvent evt) {
        this.changeLanguage("jp_JP");
    }

    private void PortugueseBRActionPerformed(ActionEvent evt) {
        this.changeLanguage("pt_BR");
    }

    private void cwcheatActionPerformed(ActionEvent evt) {
        CheatsGUI cwCheats = new CheatsGUI();
        this.startWindowDialog(cwCheats);
    }

    private void RussianActionPerformed(ActionEvent evt) {
        this.changeLanguage("ru_RU");
    }

    private void PolishActionPerformed(ActionEvent evt) {
        this.changeLanguage("pl_PL");
    }

    private void ItalianActionPerformed(ActionEvent evt) {
        this.changeLanguage("it_IT");
    }

    private void ControlsConfActionPerformed(ActionEvent evt) {
        if (this.ctrlgui == null) {
            this.ctrlgui = new ControlsGUI();
            Point mainwindow = this.getLocation();
            this.ctrlgui.setLocation(mainwindow.x + 100, mainwindow.y + 50);
        }
        this.startWindowDialog(this.ctrlgui);
    }

    private void MuteOptActionPerformed(ActionEvent evt) {
        Audio.setMuted(this.MuteOpt.isSelected());
    }

    private void ToggleLoggerActionPerformed(ActionEvent evt) {
        if (!this.consolewin.isVisible() && this.snapConsole) {
            this.mainwindowPos = this.getLocation();
            this.consolewin.setLocation(this.mainwindowPos.x, this.mainwindowPos.y + this.getHeight());
        }
        this.consolewin.setVisible(!this.consolewin.isVisible());
        this.ToggleLogger.setSelected(this.consolewin.isVisible());
    }

    private void CustomLoggerActionPerformed(ActionEvent evt) {
        if (this.loggui == null) {
            this.loggui = new LogGUI();
            Point mainwindow = this.getLocation();
            this.loggui.setLocation(mainwindow.x + 100, mainwindow.y + 50);
            this.loggui.setMainGUI(this);
        }
        this.startWindowDialog(this.loggui);
    }

    private void ChinesePRCActionPerformed(ActionEvent evt) {
        this.changeLanguage("cn_CN");
    }

    private void ChineseTWActionPerformed(ActionEvent evt) {
        this.changeLanguage("tw_TW");
    }

    private void noneCheckActionPerformed(ActionEvent evt) {
        VideoEngine.getInstance().setUseTextureAnisotropicFilter(false);
        Settings.getInstance().writeBool("emu.graphics.filters.anisotropic", false);
    }

    private void anisotropicCheckActionPerformed(ActionEvent evt) {
        VideoEngine.getInstance().setUseTextureAnisotropicFilter(true);
        Settings.getInstance().writeBool("emu.graphics.filters.anisotropic", this.anisotropicCheck.isSelected());
    }

    private void frameSkipNoneActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(0);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS5ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(5);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS10ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(10);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS15ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(15);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS20ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(20);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS30ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(30);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void frameSkipFPS60ActionPerformed(ActionEvent evt) {
        Modules.sceDisplayModule.setDesiredFPS(60);
        Settings.getInstance().writeInt("emu.graphics.frameskip.desiredFPS", Modules.sceDisplayModule.getDesiredFPS());
    }

    private void setViewportResizeScaleFactor(int viewportResizeScaleFactor) {
        Modules.sceDisplayModule.setViewportResizeScaleFactor(viewportResizeScaleFactor);
        this.pack();
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.pauseVideo();
            this.umdvideoplayer.setVideoPlayerResizeScaleFactor(this, viewportResizeScaleFactor);
            this.umdvideoplayer.resumeVideo();
        }
    }

    private void oneTimeResizeActionPerformed(ActionEvent evt) {
        this.setViewportResizeScaleFactor(1);
    }

    private void twoTimesResizeActionPerformed(ActionEvent evt) {
        this.setViewportResizeScaleFactor(2);
    }

    private void threeTimesResizeActionPerformed(ActionEvent evt) {
        this.setViewportResizeScaleFactor(3);
    }

    private void fourTimesResizeActionPerformed(ActionEvent evt) {
        this.setViewportResizeScaleFactor(4);
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.pauseVideo();
            this.umdvideoplayer.setVideoPlayerResizeScaleFactor(this, 4);
            this.umdvideoplayer.resumeVideo();
        }
    }

    private void fiveTimesResizeActionPerformed(ActionEvent evt) {
        this.setViewportResizeScaleFactor(5);
        if (this.umdvideoplayer != null) {
            this.umdvideoplayer.pauseVideo();
            this.umdvideoplayer.setVideoPlayerResizeScaleFactor(this, 5);
            this.umdvideoplayer.resumeVideo();
        }
    }

    private void exitEmu() {
        if (Settings.getInstance().readBool("gui.saveWindowPos") && !this.isFullScreen()) {
            Settings.getInstance().writeWindowPos(windowNameForSettings, this.getLocation());
        }
        ProOnlineNetworkAdapter.exit();
        Modules.ThreadManForUserModule.exit();
        Modules.sceDisplayModule.exit();
        VideoEngine.exit();
        Screen.exit();
        Emulator.exit();
        System.exit(0);
    }

    public void snaptoMainwindow() {
        this.snapConsole = true;
        this.mainwindowPos = this.getLocation();
        this.consolewin.setLocation(this.mainwindowPos.x, this.mainwindowPos.y + this.getHeight());
    }

    private void RunEmu() {
        this.emulator.RunEmu();
        Modules.sceDisplayModule.getCanvas().requestFocusInWindow();
    }

    private void TogglePauseEmu() {
        if (Emulator.run) {
            if (!Emulator.pause) {
                Emulator.PauseEmuWithStatus(64);
            } else {
                this.RunEmu();
            }
        }
    }

    private void PauseEmu() {
        if (Emulator.run && !Emulator.pause) {
            Emulator.PauseEmuWithStatus(64);
        }
    }

    @Override
    public void RefreshButtons() {
        this.RunButton.setSelected(Emulator.run && !Emulator.pause);
        this.PauseButton.setSelected(Emulator.run && Emulator.pause);
    }

    @Override
    public void setMainTitle(String message) {
        String oldtitle = this.getTitle();
        int sub = oldtitle.indexOf("FPS:");
        if (sub != -1) {
            String newtitle = oldtitle.substring(0, sub - 1);
            this.setTitle(newtitle + " " + message);
        } else {
            this.setTitle(oldtitle + " " + message);
        }
    }

    private void printUsage() {
        System.err.println("Usage: java -Xmx512m -jar jpcsp.jar [OPTIONS]");
        System.err.println();
        System.err.println("  -d, --debugger             Open debugger at start.");
        System.err.println("  -f, --loadfile FILE        Load a file.");
        System.err.println("                             Example: ms0/PSP/GAME/pspsolitaire/EBOOT.PBP");
        System.err.println("  -u, --loadumd FILE         Load a UMD. Example: umdimages/cube.iso");
        System.err.println("  -r, --run                  Run loaded file or umd. Use with -f or -u option.");
        System.err.println("  -t, --tests                Run the automated tests.");
        System.err.println("  --netClientPortShift N     Increase Network client ports by N (when running 2 Jpcsp on the same computer)");
        System.err.println("  --netServerPortShift N     Increase Network server ports by N (when running 2 Jpcsp on the same computer)");
    }

    private void processArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t") || args[i].equals("--tests")) {
                throw new RuntimeException("Shouldn't get there");
            }
            if (args[i].equals("-d") || args[i].equals("--debugger")) {
                this.EnterDebuggerActionPerformed(null);
                continue;
            }
            if (args[i].equals("-f") || args[i].equals("--loadfile")) {
                if (++i < args.length) {
                    File file = new File(args[i]);
                    if (!file.exists()) continue;
                    Modules.sceDisplayModule.setCalledFromCommandLine();
                    this.loadFile(file);
                    continue;
                }
                this.printUsage();
                break;
            }
            if (args[i].equals("-u") || args[i].equals("--loadumd")) {
                if (++i < args.length) {
                    File file = new File(args[i]);
                    if (!file.exists()) continue;
                    Modules.sceDisplayModule.setCalledFromCommandLine();
                    this.loadUMD(file);
                    continue;
                }
                this.printUsage();
                break;
            }
            if (args[i].equals("-r") || args[i].equals("--run")) {
                this.RunEmu();
                continue;
            }
            if (args[i].equals("--netClientPortShift")) {
                if (++i < args.length) {
                    int netClientPortShift = Integer.parseInt(args[i]);
                    Modules.sceNetAdhocModule.setNetClientPortShift(netClientPortShift);
                    continue;
                }
                this.printUsage();
                break;
            }
            if (args[i].equals("--netServerPortShift")) {
                if (++i < args.length) {
                    int netServerPortShift = Integer.parseInt(args[i]);
                    Modules.sceNetAdhocModule.setNetServerPortShift(netServerPortShift);
                    continue;
                }
                this.printUsage();
                break;
            }
            if (args[i].equals("--ProOnline")) {
                ProOnlineNetworkAdapter.setEnabled(true);
                continue;
            }
            this.printUsage();
            break;
        }
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("--tests")) {
            new AutoTestsRunner().run();
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final String[] fargs = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("GUI");
                MainGUI maingui = new MainGUI();
                maingui.setVisible(true);
                if (Settings.getInstance().readBool("gui.openLogwindow")) {
                    maingui.consolewin.setVisible(true);
                    maingui.ToggleLogger.setSelected(true);
                }
                maingui.processArgs(fargs);
            }
        });
    }

    @Override
    public boolean isFullScreen() {
        return this.useFullscreen;
    }

    private boolean userChooseSomething(int returnVal) {
        return returnVal == 0;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.useFullscreen && event.isPopupTrigger()) {
            this.fullScreenMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.useFullscreen && event.isPopupTrigger()) {
            this.fullScreenMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        State.controller.keyPressed(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        State.controller.keyReleased(event);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.snapConsole && this.consolewin.isVisible()) {
            Point newPos = this.getLocation();
            Point consolePos = this.consolewin.getLocation();
            Dimension mainwindowSize = this.getSize();
            if (consolePos.x == this.mainwindowPos.x && consolePos.y == this.mainwindowPos.y + mainwindowSize.height) {
                this.consolewin.setLocation(newPos.x, newPos.y + mainwindowSize.height);
            } else {
                this.snapConsole = false;
            }
            this.mainwindowPos = newPos;
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private static class SetLocationThread
    extends Thread {
        private SetLocationThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    SetLocationThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Emulator.getMainGUI().setLocation();
            }
        }
    }

    private class RecentElementActionListener
    implements ActionListener {
        public static final int TYPE_UMD = 0;
        public static final int TYPE_FILE = 1;
        int type;
        String path;

        public RecentElementActionListener(int type, String path) {
            this.path = path;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = new File(this.path);
            if (file.exists()) {
                if (this.type == 0) {
                    MainGUI.this.loadUMD(file);
                } else {
                    MainGUI.this.loadFile(file);
                }
            }
        }
    }
}

