/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import jpcsp.Memory;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VertexState;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.Utilities;

public class VertexInfoReaderTemplate {
    public static boolean isLogTraceEnabled;
    public static boolean transform2D;
    public static int skinningWeightCount;
    public static int morphingVertexCount;
    public static int texture;
    public static int color;
    public static int normal;
    public static int position;
    public static int weight;
    public static int index;
    public static int vtype;
    public static boolean readTexture;
    public static int vertexSize;
    public static int oneVertexSize;
    public static int textureOffset;
    public static int colorOffset;
    public static int normalOffset;
    public static int positionOffset;
    public static int alignmentSize;

    public void processType(VertexInfo vinfo) {
        vinfo.transform2D = transform2D;
        vinfo.skinningWeightCount = skinningWeightCount;
        vinfo.morphingVertexCount = morphingVertexCount;
        vinfo.texture = texture;
        vinfo.color = color;
        vinfo.normal = normal;
        vinfo.position = position;
        vinfo.weight = weight;
        vinfo.index = index;
        vinfo.vtype = vtype;
        vinfo.readTexture = readTexture;
        vinfo.vertexSize = vertexSize;
        vinfo.oneVertexSize = oneVertexSize;
        vinfo.textureOffset = textureOffset;
        vinfo.colorOffset = colorOffset;
        vinfo.normalOffset = normalOffset;
        vinfo.positionOffset = positionOffset;
        vinfo.alignmentSize = alignmentSize;
    }

    public void readVertex(Memory mem, int addr, VertexState v, float[] morphWeights) {
        VertexInfoReaderTemplate.doReadVertex(mem, addr, v, morphWeights);
    }

    /*
     * Unable to fully structure code
     */
    private static void doReadVertex(Memory mem, int addr, VertexState v, float[] morphWeights) {
        block93: {
            block92: {
                startAddr = addr;
                if (VertexInfoReaderTemplate.weight != 0) {
                    if (VertexInfoReaderTemplate.weight == 2) {
                        addr = addr + 1 & -2;
                    } else if (VertexInfoReaderTemplate.weight == 3) {
                        addr = addr + 3 & -4;
                    }
                    block49: for (i = 0; i < VertexInfoReaderTemplate.skinningWeightCount; ++i) {
                        switch (VertexInfoReaderTemplate.weight) {
                            case 1: {
                                v.boneWeights[i] = mem.read8(addr++);
                                v0 = i;
                                v.boneWeights[v0] = v.boneWeights[v0] / 128.0f;
                                continue block49;
                            }
                            case 2: {
                                v.boneWeights[i] = mem.read16(addr);
                                v1 = i;
                                v.boneWeights[v1] = v.boneWeights[v1] / 32768.0f;
                                addr += 2;
                                continue block49;
                            }
                            case 3: {
                                v.boneWeights[i] = Float.intBitsToFloat(mem.read32(addr));
                                addr += 4;
                            }
                        }
                    }
                }
                if (VertexInfoReaderTemplate.morphingVertexCount <= 1 || VertexInfoReaderTemplate.transform2D) break block92;
                if (VertexInfoReaderTemplate.readTexture) {
                    v.t[1] = 0.0f;
                    v.t[0] = 0.0f;
                    switch (VertexInfoReaderTemplate.texture) {
                        case 1: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.textureOffset;
                                tu = mem.read8(addr);
                                tv = mem.read8(addr + 1);
                                v.t[0] = v.t[0] + (tu /= 128.0f) * morphWeights[morphCounter];
                                v.t[1] = v.t[1] + (tv /= 128.0f) * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 2: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.textureOffset;
                                tu = mem.read16(addr);
                                tv = mem.read16(addr + 2);
                                v.t[0] = v.t[0] + (tu /= 32768.0f) * morphWeights[morphCounter];
                                v.t[1] = v.t[1] + (tv /= 32768.0f) * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 3: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.textureOffset;
                                tu = Float.intBitsToFloat(mem.read32(addr));
                                tv = Float.intBitsToFloat(mem.read32(addr + 4));
                                v.t[0] = v.t[0] + tu * morphWeights[morphCounter];
                                v.t[1] = v.t[1] + tv * morphWeights[morphCounter];
                            }
                            break;
                        }
                    }
                }
                if (VertexInfoReaderTemplate.color != 0) {
                    v.c[3] = 0.0f;
                    v.c[2] = 0.0f;
                    v.c[1] = 0.0f;
                    v.c[0] = 0.0f;
                    switch (VertexInfoReaderTemplate.color) {
                        case 1: 
                        case 2: 
                        case 3: {
                            VideoEngine.log.error((Object)String.format("Unknown color type %d", new Object[]{VertexInfoReaderTemplate.color}));
                            break;
                        }
                        case 4: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.colorOffset;
                                packed = mem.read16(addr);
                                rBits = packed & 31;
                                gBits = packed >> 5 & 63;
                                bBits = packed >> 11 & 31;
                                r = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                                g = (float)(gBits << 2 | gBits >> 4) / 255.0f;
                                b = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                                v.c[0] = v.c[0] + r * morphWeights[morphCounter];
                                v.c[1] = v.c[1] + g * morphWeights[morphCounter];
                                v.c[2] = v.c[2] + b * morphWeights[morphCounter];
                                v.c[3] = v.c[3] + morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 5: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.colorOffset;
                                packed = mem.read16(addr);
                                rBits = packed & 31;
                                gBits = packed >> 5 & 31;
                                bBits = packed >> 10 & 31;
                                r = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                                g = (float)(gBits << 3 | gBits >> 2) / 255.0f;
                                b = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                                a = (float)(packed >> 15 & 1) / 1.0f;
                                v.c[0] = v.c[0] + r * morphWeights[morphCounter];
                                v.c[1] = v.c[1] + g * morphWeights[morphCounter];
                                v.c[2] = v.c[2] + b * morphWeights[morphCounter];
                                v.c[3] = v.c[3] + a * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 6: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.colorOffset;
                                packed = mem.read16(addr);
                                rBits = packed & 15;
                                gBits = packed >> 4 & 15;
                                bBits = packed >> 8 & 15;
                                aBits = packed >> 12 & 15;
                                r = (float)(rBits << 4 | rBits) / 255.0f;
                                g = (float)(gBits << 4 | gBits) / 255.0f;
                                b = (float)(bBits << 4 | bBits) / 255.0f;
                                a = (float)(aBits << 4 | aBits) / 255.0f;
                                v.c[0] = v.c[0] + r * morphWeights[morphCounter];
                                v.c[1] = v.c[1] + g * morphWeights[morphCounter];
                                v.c[2] = v.c[2] + b * morphWeights[morphCounter];
                                v.c[3] = v.c[3] + a * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 7: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.colorOffset;
                                packed = mem.read32(addr);
                                r = (float)(packed & 255) / 255.0f;
                                g = (float)(packed >> 8 & 255) / 255.0f;
                                b = (float)(packed >> 16 & 255) / 255.0f;
                                a = (float)(packed >> 24 & 255) / 255.0f;
                                v.c[0] = v.c[0] + r * morphWeights[morphCounter];
                                v.c[1] = v.c[1] + g * morphWeights[morphCounter];
                                v.c[2] = v.c[2] + b * morphWeights[morphCounter];
                                v.c[3] = v.c[3] + a * morphWeights[morphCounter];
                            }
                            break;
                        }
                    }
                }
                if (VertexInfoReaderTemplate.normal != 0) {
                    v.n[2] = 0.0f;
                    v.n[1] = 0.0f;
                    v.n[0] = 0.0f;
                    switch (VertexInfoReaderTemplate.normal) {
                        case 1: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.normalOffset;
                                x = (byte)mem.read8(addr);
                                y = (byte)mem.read8(addr + 1);
                                z = (byte)mem.read8(addr + 2);
                                v.n[0] = v.n[0] + (x /= 127.0f) * morphWeights[morphCounter];
                                v.n[1] = v.n[1] + (y /= 127.0f) * morphWeights[morphCounter];
                                v.n[2] = v.n[2] + (z /= 127.0f) * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 2: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.normalOffset;
                                x = (short)mem.read16(addr);
                                y = (short)mem.read16(addr + 2);
                                z = (short)mem.read16(addr + 4);
                                v.n[0] = v.n[0] + (x /= 32767.0f) * morphWeights[morphCounter];
                                v.n[1] = v.n[1] + (y /= 32767.0f) * morphWeights[morphCounter];
                                v.n[2] = v.n[2] + (z /= 32767.0f) * morphWeights[morphCounter];
                            }
                            break;
                        }
                        case 3: {
                            for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                                addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.normalOffset;
                                x = Float.intBitsToFloat(mem.read32(addr));
                                y = Float.intBitsToFloat(mem.read32(addr + 4));
                                z = Float.intBitsToFloat(mem.read32(addr + 8));
                                v.n[0] = v.n[0] + x * morphWeights[morphCounter];
                                v.n[1] = v.n[1] + y * morphWeights[morphCounter];
                                v.n[2] = v.n[2] + z * morphWeights[morphCounter];
                            }
                            break;
                        }
                    }
                }
                if (VertexInfoReaderTemplate.position == 0) break block93;
                v.p[2] = 0.0f;
                v.p[1] = 0.0f;
                v.p[0] = 0.0f;
                switch (VertexInfoReaderTemplate.position) {
                    case 1: {
                        for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                            addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.positionOffset;
                            x = (float)((byte)mem.read8(addr)) / 127.0f;
                            y = (float)((byte)mem.read8(addr + 1)) / 127.0f;
                            z = (float)((byte)mem.read8(addr + 2)) / 127.0f;
                            v.p[0] = v.p[0] + x * morphWeights[morphCounter];
                            v.p[1] = v.p[1] + y * morphWeights[morphCounter];
                            v.p[2] = v.p[2] + z * morphWeights[morphCounter];
                        }
                        break block93;
                    }
                    case 2: {
                        for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                            addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.positionOffset;
                            x = (float)((short)mem.read16(addr)) / 32767.0f;
                            y = (float)((short)mem.read16(addr + 2)) / 32767.0f;
                            z = (float)((short)mem.read16(addr + 4)) / 32767.0f;
                            v.p[0] = v.p[0] + x * morphWeights[morphCounter];
                            v.p[1] = v.p[1] + y * morphWeights[morphCounter];
                            v.p[2] = v.p[2] + z * morphWeights[morphCounter];
                        }
                        break block93;
                    }
                    case 3: {
                        for (morphCounter = 0; morphCounter < VertexInfoReaderTemplate.morphingVertexCount; ++morphCounter) {
                            addr = startAddr + morphCounter * VertexInfoReaderTemplate.oneVertexSize + VertexInfoReaderTemplate.positionOffset;
                            x = Float.intBitsToFloat(mem.read32(addr));
                            y = Float.intBitsToFloat(mem.read32(addr + 4));
                            z = Float.intBitsToFloat(mem.read32(addr + 8));
                            v.p[0] = v.p[0] + x * morphWeights[morphCounter];
                            v.p[1] = v.p[1] + y * morphWeights[morphCounter];
                            v.p[2] = v.p[2] + z * morphWeights[morphCounter];
                        }
                        ** break;
                    }
                }
lbl208:
                // 2 sources

                break block93;
            }
            if (VertexInfoReaderTemplate.readTexture) {
                switch (VertexInfoReaderTemplate.texture) {
                    case 1: {
                        tu = mem.read8(addr++);
                        tv = mem.read8(addr++);
                        if (!VertexInfoReaderTemplate.transform2D) {
                            tu /= 128.0f;
                            tv /= 128.0f;
                        }
                        v.t[0] = tu;
                        v.t[1] = tv;
                        break;
                    }
                    case 2: {
                        addr = addr + 1 & -2;
                        tu = mem.read16(addr);
                        tv = mem.read16(addr + 2);
                        addr += 4;
                        if (!VertexInfoReaderTemplate.transform2D) {
                            tu /= 32768.0f;
                            tv /= 32768.0f;
                        }
                        v.t[0] = tu;
                        v.t[1] = tv;
                        break;
                    }
                    case 3: {
                        addr = addr + 3 & -4;
                        v.t[0] = Float.intBitsToFloat(mem.read32(addr));
                        v.t[1] = Float.intBitsToFloat(mem.read32(addr + 4));
                        addr += 8;
                    }
                }
            } else if (VertexInfoReaderTemplate.texture != 0) {
                addr += VertexInfoReaderTemplate.colorOffset - VertexInfoReaderTemplate.textureOffset;
            }
            if (VertexInfoReaderTemplate.color != 0) {
                switch (VertexInfoReaderTemplate.color) {
                    case 1: 
                    case 2: 
                    case 3: {
                        VideoEngine.log.error((Object)String.format("Unknown color type %d", new Object[]{VertexInfoReaderTemplate.color}));
                        break;
                    }
                    case 4: {
                        addr = addr + 1 & -2;
                        packed = mem.read16(addr);
                        addr += 2;
                        rBits = packed & 31;
                        gBits = packed >> 5 & 63;
                        bBits = packed >> 11 & 31;
                        v.c[0] = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                        v.c[1] = (float)(gBits << 2 | gBits >> 4) / 255.0f;
                        v.c[2] = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                        v.c[3] = 1.0f;
                        break;
                    }
                    case 5: {
                        addr = addr + 1 & -2;
                        packed = mem.read16(addr);
                        addr += 2;
                        rBits = packed & 31;
                        gBits = packed >> 5 & 31;
                        bBits = packed >> 10 & 31;
                        v.c[0] = (float)(rBits << 3 | rBits >> 2) / 255.0f;
                        v.c[1] = (float)(gBits << 3 | gBits >> 2) / 255.0f;
                        v.c[2] = (float)(bBits << 3 | bBits >> 2) / 255.0f;
                        v.c[3] = (float)(packed >> 15 & 1) / 1.0f;
                        break;
                    }
                    case 6: {
                        addr = addr + 1 & -2;
                        packed = mem.read16(addr);
                        addr += 2;
                        rBits = packed & 15;
                        gBits = packed >> 4 & 15;
                        bBits = packed >> 8 & 15;
                        aBits = packed >> 12 & 15;
                        v.c[0] = (float)(rBits << 4 | rBits) / 255.0f;
                        v.c[1] = (float)(gBits << 4 | gBits) / 255.0f;
                        v.c[2] = (float)(bBits << 4 | bBits) / 255.0f;
                        v.c[3] = (float)(aBits << 4 | aBits) / 255.0f;
                        break;
                    }
                    case 7: {
                        addr = addr + 3 & -4;
                        packed = mem.read32(addr);
                        addr += 4;
                        v.c[0] = (float)(packed & 255) / 255.0f;
                        v.c[1] = (float)(packed >> 8 & 255) / 255.0f;
                        v.c[2] = (float)(packed >> 16 & 255) / 255.0f;
                        v.c[3] = (float)(packed >> 24 & 255) / 255.0f;
                        break;
                    }
                }
            }
            if (VertexInfoReaderTemplate.normal != 0) {
                switch (VertexInfoReaderTemplate.normal) {
                    case 1: {
                        x = (byte)mem.read8(addr++);
                        y = (byte)mem.read8(addr++);
                        z = (byte)mem.read8(addr++);
                        if (!VertexInfoReaderTemplate.transform2D) {
                            x /= 127.0f;
                            y /= 127.0f;
                            z /= 127.0f;
                        }
                        v.n[0] = x;
                        v.n[1] = y;
                        v.n[2] = z;
                        break;
                    }
                    case 2: {
                        addr = addr + 1 & -2;
                        x = (short)mem.read16(addr);
                        y = (short)mem.read16(addr + 2);
                        z = (short)mem.read16(addr + 4);
                        addr += 6;
                        if (!VertexInfoReaderTemplate.transform2D) {
                            x /= 32767.0f;
                            y /= 32767.0f;
                            z /= 32767.0f;
                        }
                        v.n[0] = x;
                        v.n[1] = y;
                        v.n[2] = z;
                        break;
                    }
                    case 3: {
                        addr = addr + 3 & -4;
                        v.n[0] = Float.intBitsToFloat(mem.read32(addr));
                        v.n[1] = Float.intBitsToFloat(mem.read32(addr + 4));
                        v.n[2] = Float.intBitsToFloat(mem.read32(addr + 8));
                        addr += 12;
                    }
                }
            }
            if (VertexInfoReaderTemplate.position != 0) {
                switch (VertexInfoReaderTemplate.position) {
                    case 1: {
                        if (VertexInfoReaderTemplate.transform2D) {
                            v.p[0] = (byte)mem.read8(addr++);
                            v.p[1] = (byte)mem.read8(addr++);
                            v.p[2] = mem.read8(addr++);
                            break;
                        }
                        v.p[0] = (float)((byte)mem.read8(addr++)) / 127.0f;
                        v.p[1] = (float)((byte)mem.read8(addr++)) / 127.0f;
                        v.p[2] = (float)((byte)mem.read8(addr++)) / 127.0f;
                        break;
                    }
                    case 2: {
                        addr = addr + 1 & -2;
                        if (VertexInfoReaderTemplate.transform2D) {
                            v.p[0] = (short)mem.read16(addr);
                            v.p[1] = (short)mem.read16(addr + 2);
                            v.p[2] = mem.read16(addr + 4);
                        } else {
                            v.p[0] = (float)((short)mem.read16(addr)) / 32767.0f;
                            v.p[1] = (float)((short)mem.read16(addr + 2)) / 32767.0f;
                            v.p[2] = (float)((short)mem.read16(addr + 4)) / 32767.0f;
                        }
                        addr += 6;
                        break;
                    }
                    case 3: {
                        addr = addr + 3 & -4;
                        x = Float.intBitsToFloat(mem.read32(addr));
                        y = Float.intBitsToFloat(mem.read32(addr + 4));
                        z = Float.intBitsToFloat(mem.read32(addr + 8));
                        addr += 12;
                        if (VertexInfoReaderTemplate.transform2D) {
                            z = z < 0.0f ? 0.0f : (z > 65535.0f ? 65535.0f : (float)((int)z));
                        }
                        v.p[0] = x;
                        v.p[1] = y;
                        v.p[2] = z;
                        break;
                    }
                }
            }
        }
        if (VertexInfoReaderTemplate.isLogTraceEnabled) {
            VideoEngine.log.trace((Object)String.format("Reading vertex at 0x%08X %s", new Object[]{startAddr, VertexInfo.toString(VertexInfoReaderTemplate.texture, VertexInfoReaderTemplate.color, VertexInfoReaderTemplate.normal, VertexInfoReaderTemplate.position, VertexInfoReaderTemplate.weight, VertexInfoReaderTemplate.skinningWeightCount, VertexInfoReaderTemplate.morphingVertexCount, VertexInfoReaderTemplate.index, VertexInfoReaderTemplate.transform2D, VertexInfoReaderTemplate.vertexSize)}));
            if (VertexInfoReaderTemplate.weight != 0) {
                VideoEngine.log.trace((Object)String.format("Weight(%d) %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f", new Object[]{VertexInfoReaderTemplate.skinningWeightCount, Float.valueOf(v.boneWeights[0]), Float.valueOf(v.boneWeights[1]), Float.valueOf(v.boneWeights[2]), Float.valueOf(v.boneWeights[3]), Float.valueOf(v.boneWeights[4]), Float.valueOf(v.boneWeights[5]), Float.valueOf(v.boneWeights[6]), Float.valueOf(v.boneWeights[7])}));
            }
            if (VertexInfoReaderTemplate.texture != 0) {
                if (VertexInfoReaderTemplate.transform2D) {
                    VideoEngine.log.trace((Object)String.format("texture type %d %d, %d", new Object[]{VertexInfoReaderTemplate.texture, Utilities.round(v.t[0]), Utilities.round(v.t[1])}));
                } else {
                    VideoEngine.log.trace((Object)String.format("texture type %d %f, %f", new Object[]{VertexInfoReaderTemplate.texture, Float.valueOf(v.t[0]), Float.valueOf(v.t[1])}));
                }
            }
            if (VertexInfoReaderTemplate.color != 0) {
                VideoEngine.log.trace((Object)String.format("color type %d 0x%08X", new Object[]{VertexInfoReaderTemplate.color, PixelColor.getColor(v.c)}));
            }
            if (VertexInfoReaderTemplate.normal != 0) {
                VideoEngine.log.trace((Object)String.format("normal type %d %f, %f, %f", new Object[]{VertexInfoReaderTemplate.normal, Float.valueOf(v.n[0]), Float.valueOf(v.n[1]), Float.valueOf(v.n[2])}));
            }
            if (VertexInfoReaderTemplate.position != 0) {
                VideoEngine.log.trace((Object)String.format("vertex type %d %f, %f, %f", new Object[]{VertexInfoReaderTemplate.position, Float.valueOf(v.p[0]), Float.valueOf(v.p[1]), Float.valueOf(v.p[2])}));
            }
        }
    }
}

