/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Vector;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules150.IoFileMgrForUser;
import jpcsp.Memory;
import jpcsp.connector.AtracCodec;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.media.MediaEngine;
import jpcsp.media.MpegDemux;
import jpcsp.media.OMAFormat;
import jpcsp.media.PacketChannel;
import jpcsp.media.StreamReader;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import jpcsp.util.Hash;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ExternalDecoder {
    private static Logger log = Modules.log;
    private static File extAudioDecoder;
    private static IoListener ioListener;
    private static boolean enabled;
    private static boolean dumpEncodedFile;
    private static boolean dumpPmfFile;
    private static boolean dumpAudioStreamFile;
    private static boolean keepOmaFile;
    private static boolean scanAllFileMagicOffsets;
    private static EnableExternalDecoderSettingsListerner enableExternalDecoderSettingsListerner;

    public ExternalDecoder() {
        ExternalDecoder.init();
    }

    private static void setEnabled(boolean flag) {
        enabled = flag;
    }

    private static void init() {
        if (enableExternalDecoderSettingsListerner == null) {
            enableExternalDecoderSettingsListerner = new EnableExternalDecoderSettingsListerner();
            Settings.getInstance().registerSettingsListener("ExternalDecoder", "emu.useExternalDecoder", enableExternalDecoderSettingsListerner);
        }
        if (enabled && extAudioDecoder == null) {
            String extAudioDecoderPath = System.getProperty("java.library.path");
            if (extAudioDecoderPath == null) {
                extAudioDecoderPath = "";
            } else if (!extAudioDecoderPath.endsWith("/")) {
                extAudioDecoderPath = extAudioDecoderPath + "/";
            }
            String[] extAudioDecoders = new String[]{"DecodeAudio.bat", "DecodeAudio.exe", "DecodeAudio.sh"};
            for (int i = 0; i < extAudioDecoders.length; ++i) {
                File f = new File(String.format("%s%s", extAudioDecoderPath, extAudioDecoders[i]));
                if (!f.exists()) continue;
                extAudioDecoder = f;
                break;
            }
            if (extAudioDecoder == null) {
                enabled = false;
            } else {
                log.info((Object)"Using the external audio decoder (SonicStage)");
            }
        }
        if (enabled && ioListener == null) {
            ioListener = new IoListener();
            Modules.IoFileMgrForUserModule.registerIoListener(ioListener);
        }
    }

    public static boolean isEnabled() {
        ExternalDecoder.init();
        return enabled;
    }

    private boolean executeExternalDecoder(String inputFileName, String outputFileName, boolean keepInputFile, int channels) {
        File outputFile;
        boolean decoded = false;
        if (channels != 1) {
            decoded = this.executeExternalDecoder(inputFileName, outputFileName);
        }
        if (!keepInputFile) {
            File inputFile = new File(inputFileName);
            inputFile.delete();
        }
        if ((outputFile = new File(outputFileName)).canRead() && outputFile.length() == 0L) {
            outputFile.delete();
            decoded = false;
        }
        return decoded;
    }

    private boolean executeExternalDecoder(String inputFileName, String outputFileName) {
        String[] cmd = extAudioDecoder.toString().endsWith(".bat") ? new String[]{"cmd", "/C", extAudioDecoder.toString(), inputFileName, outputFileName} : new String[]{extAudioDecoder.toString(), inputFileName, outputFileName};
        try {
            Process extAudioDecodeProcess = Runtime.getRuntime().exec(cmd);
            StreamReader stdoutReader = new StreamReader(extAudioDecodeProcess.getInputStream());
            StreamReader stderrReader = new StreamReader(extAudioDecodeProcess.getErrorStream());
            stdoutReader.start();
            stderrReader.start();
            int exitValue = extAudioDecodeProcess.waitFor();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External AudioDecode Process '%s' returned %d", extAudioDecoder.toString(), exitValue));
                log.debug((Object)("stdout: " + stdoutReader.getInput()));
                log.debug((Object)("stderr: " + stderrReader.getInput()));
            }
        }
        catch (InterruptedException e) {
            log.error((Object)e);
            return false;
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public boolean decodeExtAudio(byte[] mpegData, int mpegFileSize, int mpegOffset) {
        ByteBuffer omaBuffer;
        if (dumpPmfFile) {
            try {
                new File(MediaEngine.getExtAudioBasePath(mpegFileSize)).mkdirs();
                FileOutputStream pmfOut = new FileOutputStream(MediaEngine.getExtAudioPath(mpegFileSize, "pmf"));
                pmfOut.write(mpegData);
                pmfOut.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        MpegDemux mpegDemux = new MpegDemux(mpegData, mpegOffset);
        try {
            mpegDemux.demux(false, true);
        }
        catch (OutOfMemoryError e) {
            log.error((Object)String.format("Error '%s' while decoding external audio file (mpegFileSize=%d)", e.toString(), mpegFileSize));
            return false;
        }
        ByteBuffer audioStream = mpegDemux.getAudioStream();
        if (audioStream == null) {
            return false;
        }
        if (dumpAudioStreamFile) {
            try {
                new File(MediaEngine.getExtAudioBasePath(mpegFileSize)).mkdirs();
                FileOutputStream pmfOut = new FileOutputStream(MediaEngine.getExtAudioPath(mpegFileSize, "audio"));
                pmfOut.getChannel().write(audioStream);
                audioStream.rewind();
                pmfOut.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        if ((omaBuffer = OMAFormat.convertStreamToOMA(audioStream)) == null) {
            return false;
        }
        try {
            new File(MediaEngine.getExtAudioBasePath(mpegFileSize)).mkdirs();
            String encodedFileName = MediaEngine.getExtAudioPath(mpegFileSize, "oma");
            FileOutputStream os = new FileOutputStream(encodedFileName);
            os.getChannel().write(omaBuffer);
            os.close();
            String decodedFileName = MediaEngine.getExtAudioPath(mpegFileSize, "wav");
            int channels = OMAFormat.getOMANumberAudioChannels(omaBuffer);
            if (!this.executeExternalDecoder(encodedFileName, decodedFileName, keepOmaFile, channels)) {
                return false;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public void decodeExtAudio(int address, int mpegFileSize, int mpegOffset, byte[] bufferHeaderData) {
        if (!ExternalDecoder.isEnabled()) {
            return;
        }
        byte[] mpegData = ioListener.readFileData(address, 2048, mpegFileSize, bufferHeaderData);
        if (mpegData == null) {
            return;
        }
        this.decodeExtAudio(mpegData, mpegFileSize, mpegOffset);
    }

    private static String getAtracAudioPath(int address, int atracFileSize, String suffix) {
        return String.format("%sAtrac-%08X-%08X.%s", AtracCodec.getBaseDirectory(), atracFileSize, address, suffix);
    }

    private String decodeAtrac(byte[] atracData, int address, int atracFileSize, String decodedFileName) {
        try {
            ByteBuffer omaBuffer;
            ByteBuffer riffBuffer = ByteBuffer.wrap(atracData);
            if (dumpEncodedFile) {
                new File(AtracCodec.getBaseDirectory()).mkdirs();
                FileOutputStream encodedOut = new FileOutputStream(ExternalDecoder.getAtracAudioPath(address, atracFileSize, "encoded"));
                encodedOut.getChannel().write(riffBuffer);
                encodedOut.close();
                riffBuffer.rewind();
            }
            if ((omaBuffer = OMAFormat.convertRIFFtoOMA(riffBuffer)) == null) {
                Modules.log.info((Object)"AT3+ data could not be decoded by the external decoder (error while converting to OMA)");
                return null;
            }
            new File(AtracCodec.getBaseDirectory()).mkdirs();
            String encodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, "oma");
            FileOutputStream os = new FileOutputStream(encodedFileName);
            os.getChannel().write(omaBuffer);
            os.close();
            int channels = OMAFormat.getOMANumberAudioChannels(omaBuffer);
            if (!this.executeExternalDecoder(encodedFileName, decodedFileName, keepOmaFile, channels)) {
                if (channels == 1) {
                    Modules.log.info((Object)"Mono AT3+ data could not be decoded by the external decoder");
                } else if (channels == 2) {
                    Modules.log.info((Object)"Stereo AT3+ data could not be decoded by the external decoder");
                } else {
                    Modules.log.info((Object)("AT3+ data could not be decoded by the external decoder (channels=" + channels + ")"));
                }
                return null;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return decodedFileName;
    }

    public String decodeAtrac(PacketChannel packetChannel, int address, int atracFileSize) {
        if (!ExternalDecoder.isEnabled()) {
            return null;
        }
        byte[] atracData = new byte[atracFileSize];
        int readLength = packetChannel.read(atracData, atracData.length);
        if (readLength != atracData.length) {
            return null;
        }
        String decodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, "wav");
        return this.decodeAtrac(atracData, address, atracFileSize, decodedFileName);
    }

    public String decodeAtrac(int address, int length, int atracFileSize, AtracCodec atracCodec) {
        byte[] atracData;
        if (!ExternalDecoder.isEnabled()) {
            return null;
        }
        String decodedFileName = ExternalDecoder.getAtracAudioPath(address, atracFileSize, "wav");
        File decodedFile = new File(decodedFileName);
        if (decodedFile.canRead() && decodedFile.length() > 0L) {
            return decodedFileName;
        }
        if (length >= atracFileSize) {
            atracData = new byte[atracFileSize];
            Utilities.putBuffer(ByteBuffer.wrap(atracData), Memory.getInstance().getBuffer(address, length), ByteOrder.LITTLE_ENDIAN, atracData.length);
        } else {
            atracData = ioListener.readFileData(address, length, atracFileSize, null);
        }
        if (atracData == null) {
            Modules.log.debug((Object)"AT3+ data could not be decoded by the external decoder (complete atrac data need to be retrieved)");
            atracCodec.setRequireAllAtracData();
            return null;
        }
        return this.decodeAtrac(atracData, address, atracFileSize, decodedFileName);
    }

    static {
        enabled = true;
        dumpEncodedFile = false;
        dumpPmfFile = false;
        dumpAudioStreamFile = false;
        keepOmaFile = true;
        scanAllFileMagicOffsets = true;
    }

    private static class IoListener
    implements IoFileMgrForUser.IIoListener {
        private HashMap<Integer, ReadInfo> readInfos = new HashMap();
        private HashMap<Integer, ReadInfo> readMagics = new HashMap();
        private static final int MAGIC_HASH_LENGTH = 16;
        private static final int[] fileMagics = new int[]{1179011410, 1179472720};

        private static boolean memcmp(byte[] data, int address, int length) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, length, 1);
            for (int i = 0; i < length; ++i) {
                if (memoryReader.readNext() == (data[i] & 0xFF)) continue;
                return false;
            }
            return true;
        }

        private static boolean cmp(byte[] data, byte[] checkData, int length) {
            length = Math.min(length, checkData.length);
            for (int i = 0; i < length; ++i) {
                if (data[i] == checkData[i]) continue;
                return false;
            }
            return true;
        }

        private static int getMagicHash(int address) {
            return Hash.getHashCodeFloatingMemory(0, address, 16);
        }

        private static int getMagicHash(byte[] data) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(data, 0, 16, 4);
            return Hash.getHashCodeFloatingMemory(0, memoryReader, 16);
        }

        public byte[] readFileData(int address, int length, int fileSize, byte[] checkData) {
            byte[] fileData;
            int positionOffset = 0;
            ReadInfo readInfo = this.readInfos.get(address);
            if (readInfo == null) {
                long currentPosition;
                byte[] fileData2;
                for (ReadInfo ri : this.readInfos.values()) {
                    try {
                        if (ri.vFile != null && ri.vFile.length() == (long)fileSize) {
                            fileData2 = new byte[length];
                            currentPosition = ri.vFile.getPosition();
                            ri.vFile.ioLseek(ri.position);
                            ri.vFile.ioRead(fileData2, 0, length);
                            ri.vFile.ioLseek(currentPosition);
                            if (!IoListener.memcmp(fileData2, address, length)) continue;
                            readInfo = ri;
                            break;
                        }
                        if (ri.dataInput != null && ri.dataInput.length() == (long)fileSize) {
                            fileData2 = new byte[length];
                            currentPosition = ri.dataInput.getFilePointer();
                            ri.dataInput.seek(ri.position);
                            ri.dataInput.readFully(fileData2);
                            ri.dataInput.seek(currentPosition);
                            if (!IoListener.memcmp(fileData2, address, length)) continue;
                            readInfo = ri;
                            break;
                        }
                        if (ri.address >= address || ri.address + ri.size < address + length) continue;
                        positionOffset = address - ri.address;
                        readInfo = ri;
                        break;
                    }
                    catch (IOException e) {
                    }
                }
                if (readInfo == null) {
                    ReadInfo ri = this.readMagics.get(IoListener.getMagicHash(address));
                    if (ri == null && checkData != null && checkData.length >= 16) {
                        ri = this.readMagics.get(IoListener.getMagicHash(checkData));
                    }
                    if (ri != null) {
                        try {
                            if (ri.vFile != null && ri.vFile.length() >= (long)fileSize) {
                                int checkLength = Math.min(length, fileSize);
                                fileData2 = new byte[checkLength];
                                currentPosition = ri.vFile.getPosition();
                                ri.vFile.ioLseek(ri.position);
                                ri.vFile.ioRead(fileData2, 0, checkLength);
                                ri.vFile.ioLseek(currentPosition);
                                boolean match = checkData != null ? IoListener.cmp(fileData2, checkData, checkLength) : IoListener.memcmp(fileData2, address, checkLength);
                                if (match) {
                                    readInfo = ri;
                                }
                            } else if (ri.dataInput != null && ri.dataInput.length() >= (long)fileSize) {
                                int checkLength = Math.min(length, fileSize);
                                fileData2 = new byte[checkLength];
                                currentPosition = ri.dataInput.getFilePointer();
                                ri.dataInput.seek(ri.position);
                                ri.dataInput.readFully(fileData2);
                                ri.dataInput.seek(currentPosition);
                                boolean match = checkData != null ? IoListener.cmp(fileData2, checkData, checkLength) : IoListener.memcmp(fileData2, address, checkLength);
                                if (match) {
                                    readInfo = ri;
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (readInfo == null) {
                        return null;
                    }
                }
            }
            try {
                fileData = new byte[fileSize];
                if (readInfo.vFile != null) {
                    long currentPosition = readInfo.vFile.getPosition();
                    readInfo.vFile.ioLseek(readInfo.position + (long)positionOffset);
                    readInfo.vFile.ioRead(fileData, 0, fileSize);
                    readInfo.vFile.ioLseek(currentPosition);
                } else if (readInfo.dataInput != null) {
                    long currentPosition = readInfo.dataInput.getFilePointer();
                    readInfo.dataInput.seek(readInfo.position + (long)positionOffset);
                    readInfo.dataInput.readFully(fileData);
                    readInfo.dataInput.seek(currentPosition);
                }
            }
            catch (IOException e) {
                return null;
            }
            catch (OutOfMemoryError e) {
                log.error((Object)String.format("Error '%s' while decoding external audio file (fileSize=%d, position=%d, dataInput=%s)", e.toString(), fileSize, readInfo.position + (long)positionOffset, readInfo.dataInput.toString()));
                return null;
            }
            int checkLength = Math.min(length, 16);
            boolean match = checkData != null ? IoListener.cmp(fileData, checkData, checkLength) : IoListener.memcmp(fileData, address, checkLength);
            if (!match) {
                return null;
            }
            return fileData;
        }

        private static boolean isFileMagicValue(int magicValue) {
            for (int i = 0; i < fileMagics.length; ++i) {
                if (magicValue != fileMagics[i]) continue;
                return true;
            }
            return false;
        }

        private static int getFirstFileMagicOffset(int address, int size) {
            if (Memory.isAddressGood(address)) {
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 4);
                int stepSize = 2048;
                int skip = 511;
                for (int i = 0; i < size; i += 2048) {
                    int magicValue = memoryReader.readNext();
                    if (IoListener.isFileMagicValue(magicValue)) {
                        return i;
                    }
                    memoryReader.skip(511);
                }
            }
            return -1;
        }

        private static int[] getAllFileMagicOffsets(int address, int size) {
            if (!Memory.isAddressGood(address)) {
                return null;
            }
            Vector<Integer> magicOffsets = new Vector<Integer>();
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(address, size, 4);
            int stepSize = 16;
            int skip = 3;
            int endSize = size / 16 * 16;
            for (int i = 0; i < endSize; i += 16) {
                int magicValue = memoryReader.readNext();
                if (IoListener.isFileMagicValue(magicValue)) {
                    magicOffsets.add(i);
                }
                memoryReader.skip(3);
            }
            if (magicOffsets.size() <= 0) {
                return null;
            }
            int[] fileMagicOffsets = new int[magicOffsets.size()];
            for (int i = 0; i < fileMagicOffsets.length; ++i) {
                fileMagicOffsets[i] = (Integer)magicOffsets.get(i);
            }
            return fileMagicOffsets;
        }

        @Override
        public void sceIoRead(int result, int uid, int data_addr, int size, int bytesRead, long position, SeekableDataInput dataInput, IVirtualFile vFile) {
            if (result >= 0 && (dataInput != null || vFile != null)) {
                ReadInfo readInfo = this.readInfos.get(data_addr);
                boolean processed = false;
                if (scanAllFileMagicOffsets) {
                    int[] magicOffsets = IoListener.getAllFileMagicOffsets(data_addr, bytesRead);
                    if (magicOffsets != null && magicOffsets.length > 0) {
                        for (int i = 0; i < magicOffsets.length; ++i) {
                            int magicOffset = magicOffsets[i];
                            int nextMagicOffset = i + 1 < magicOffsets.length ? magicOffsets[i + 1] : bytesRead;
                            int magicAddress = data_addr + magicOffset;
                            readInfo = new ReadInfo(magicAddress, nextMagicOffset - magicOffset, dataInput, vFile, position + (long)magicOffset);
                            this.readInfos.put(magicAddress, readInfo);
                            this.readMagics.put(IoListener.getMagicHash(magicAddress), readInfo);
                        }
                        processed = true;
                    }
                } else {
                    int magicOffset = IoListener.getFirstFileMagicOffset(data_addr, bytesRead);
                    if (magicOffset >= 0) {
                        int magicAddress = data_addr + magicOffset;
                        readInfo = new ReadInfo(magicAddress, bytesRead - magicOffset, dataInput, vFile, position + (long)magicOffset);
                        this.readInfos.put(magicAddress, readInfo);
                        this.readMagics.put(IoListener.getMagicHash(magicAddress), readInfo);
                        processed = true;
                    }
                }
                if (!processed && readInfo == null) {
                    readInfo = new ReadInfo(data_addr, bytesRead, dataInput, vFile, position);
                    this.readInfos.put(data_addr, readInfo);
                }
            }
        }

        @Override
        public void sceIoAssign(int result, int dev1_addr, String dev1, int dev2_addr, String dev2, int dev3_addr, String dev3, int mode, int unk1, int unk2) {
        }

        @Override
        public void sceIoCancel(int result, int uid) {
        }

        @Override
        public void sceIoChdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoChstat(int result, int path_addr, String path, int stat_addr, int bits) {
        }

        @Override
        public void sceIoClose(int result, int uid) {
        }

        @Override
        public void sceIoDclose(int result, int uid) {
        }

        @Override
        public void sceIoDevctl(int result, int device_addr, String device, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoDopen(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoDread(int result, int uid, int dirent_addr) {
        }

        @Override
        public void sceIoGetStat(int result, int path_addr, String path, int stat_addr) {
        }

        @Override
        public void sceIoIoctl(int result, int uid, int cmd, int indata_addr, int inlen, int outdata_addr, int outlen) {
        }

        @Override
        public void sceIoMkdir(int result, int path_addr, String path, int permissions) {
        }

        @Override
        public void sceIoOpen(int result, int filename_addr, String filename, int flags, int permissions, String mode) {
        }

        @Override
        public void sceIoPollAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoRemove(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoRename(int result, int path_addr, String path, int new_path_addr, String newpath) {
        }

        @Override
        public void sceIoRmdir(int result, int path_addr, String path) {
        }

        @Override
        public void sceIoSeek32(int result, int uid, int offset, int whence) {
        }

        @Override
        public void sceIoSeek64(long result, int uid, long offset, int whence) {
        }

        @Override
        public void sceIoSync(int result, int device_addr, String device, int unknown) {
        }

        @Override
        public void sceIoWaitAsync(int result, int uid, int res_addr) {
        }

        @Override
        public void sceIoWrite(int result, int uid, int data_addr, int size, int bytesWritten) {
        }

        private static class ReadInfo {
            public int address;
            public int size;
            public SeekableDataInput dataInput;
            public IVirtualFile vFile;
            public long position;

            public ReadInfo(int address, int size, SeekableDataInput dataInput, IVirtualFile vFile, long position) {
                this.address = address;
                this.size = size;
                this.dataInput = dataInput;
                this.vFile = vFile;
                this.position = position;
            }

            public String toString() {
                return String.format("ReadInfo(0x%08X-0x%08X(size=0x%X), position=%d, %s)", this.address, this.address + this.size, this.size, this.position, this.dataInput.toString());
            }
        }
    }

    private static class EnableExternalDecoderSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableExternalDecoderSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            ExternalDecoder.setEnabled(value);
        }
    }
}

