/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.upnp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpcsp.State;
import jpcsp.network.upnp.IGD;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UPnP {
    public static Logger log = Logger.getLogger((String)"upnp");
    protected IGD igd;
    private static final int discoveryTimeoutMillis = 2000;
    private static final int discoveryPort = 1900;
    private static final String multicastIp = "239.255.255.250";
    private static final String[] deviceList = new String[]{"urn:schemas-upnp-org:device:InternetGatewayDevice:1", "urn:schemas-upnp-org:service:WANIPConnection:1", "urn:schemas-upnp-org:service:WANPPPConnection:1", "upnp:rootdevice"};

    public void discover() {
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(2000);
            socket.setReuseAddress(true);
            byte[] response = new byte[1536];
            DatagramPacket responsePacket = new DatagramPacket(response, response.length);
            LinkedList<Device> devices = new LinkedList<Device>();
            for (String device : deviceList) {
                if (responsePacket.getPort() == -1) {
                    String discoveryRequest = String.format("M-SEARCH * HTTP/1.1\r\nHOST: %s:%d\r\nST: %s\r\nMAN: \"ssdp:discover\"\r\nMX: %d\r\n\r\n", multicastIp, 1900, device, 2);
                    DatagramPacket packet = new DatagramPacket(discoveryRequest.getBytes(), discoveryRequest.length(), new InetSocketAddress(multicastIp, 1900));
                    socket.send(packet);
                }
                try {
                    socket.receive(responsePacket);
                    if (responsePacket.getLength() > 0) {
                        String reply = new String(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                        log.debug((Object)String.format("Discovery %s: %s", device, reply));
                        Pattern p = Pattern.compile("^location: *(\\S+)$.*^st: *(\\S+)$", 42);
                        Matcher m = p.matcher(reply);
                        if (m.find()) {
                            String location = m.group(1);
                            String st = m.group(2);
                            log.debug((Object)String.format("Location: '%s', st: '%s'", location, st));
                            Device newDevice = new Device();
                            newDevice.descURL = location;
                            newDevice.st = st;
                            devices.add(newDevice);
                        } else {
                            log.error((Object)String.format("Could not parse discovery response for %s: %s", device, reply));
                        }
                    }
                    responsePacket = new DatagramPacket(response, response.length);
                }
                catch (SocketTimeoutException e) {
                    log.info((Object)String.format("Timeout while discovering %s", device));
                }
            }
            this.igd = new IGD();
            HashSet<String> processedUrls = new HashSet<String>();
            for (Device device : devices) {
                if (processedUrls.contains(device.descURL)) continue;
                this.igd.discover(device.descURL);
                processedUrls.add(device.descURL);
                if (!this.igd.isValid() || !this.igd.isConnected(this)) continue;
                log.info((Object)String.format("IGD connected with external IP: %s", this.igd.getExternalIPAddress(this)));
                break;
            }
        }
        catch (IOException e) {
            log.error((Object)"discover", (Throwable)e);
        }
    }

    public IGD getIGD() {
        return this.igd;
    }

    protected HashMap<String, String> executeSimpleUPnPcommand(String controlUrl, String serviceType, String action, HashMap<String, String> arguments) {
        HashMap<String, String> result = null;
        StringBuilder body = new StringBuilder();
        body.append(String.format("<?xml version=\"1.0\"?>\r\n", new Object[0]));
        body.append(String.format("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n", new Object[0]));
        body.append(String.format("<s:Body>\r\n", new Object[0]));
        body.append(String.format("  <u:%s xmlns:u=\"%s\">\r\n", action, serviceType));
        if (arguments != null) {
            for (String name : arguments.keySet()) {
                String value = arguments.get(name);
                if (value == null) {
                    body.append(String.format("    <%s />\r\n", name));
                    continue;
                }
                body.append(String.format("    <%s>%s</%s>\r\n", name, value, name));
            }
        }
        body.append(String.format("  </u:%s>\r\n", action));
        body.append(String.format("</s:Body>\r\n", new Object[0]));
        body.append(String.format("</s:Envelope>\r\n", new Object[0]));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Sending UPnP command: %s", body.toString()));
        }
        try {
            String errorCode;
            int n;
            URL url = new URL(controlUrl);
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                httpURLConnection.setRequestMethod("POST");
            }
            connection.setRequestProperty("SOAPAction", String.format("%s#%s", serviceType, action));
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setDoOutput(true);
            OutputStream output = connection.getOutputStream();
            output.write(body.toString().getBytes());
            output.flush();
            output.close();
            connection.connect();
            InputStream response = connection.getInputStream();
            StringBuilder content = new StringBuilder();
            byte[] buffer = new byte[1024];
            do {
                if ((n = response.read(buffer)) <= 0) continue;
                content.append(new String(buffer, 0, n));
            } while (n >= 0);
            response.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UPnP command serviceType %s, action %s, result: %s", serviceType, action, content.toString()));
            }
            result = this.parseSimpleCommandResponse(content.toString());
            if (log.isDebugEnabled() && (errorCode = result.get("errorCode")) != null) {
                log.debug((Object)String.format("UPnP command %s: errorCode = %s", action, errorCode));
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"executeUPnPcommand", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"executeUPnPcommand", (Throwable)e);
        }
        return result;
    }

    protected HashMap<String, String> parseSimpleCommandResponse(String content) {
        HashMap<String, String> result = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document response = documentBuilder.parse(new ByteArrayInputStream(content.getBytes()));
            result = new HashMap<String, String>();
            this.parseElement(response.getDocumentElement(), result, null);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Discovery", (Throwable)e);
        }
        return result;
    }

    protected void parseElement(Element element, HashMap<String, String> result, String name) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node instanceof Element) {
                this.parseElement((Element)node, result, node.getNodeName());
                continue;
            }
            if (name == null || node.getTextContent() == null) continue;
            String value = node.getTextContent();
            if (result.containsKey(name)) {
                value = result.get(name) + value;
            }
            result.put(name, value);
        }
    }

    public String getStatusInfo(String controlUrl, String serviceType) {
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "GetStatusInfo", null);
        return result.get("NewConnectionStatus");
    }

    public String getExternalIPAddress(String controlUrl, String serviceType) {
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "GetExternalIPAddress", null);
        return result.get("NewExternalIPAddress");
    }

    public void addPortMapping(String controlUrl, String serviceType, String remoteHost, int externalPort, String protocol, int internalPort, String internalClient, String description, int leaseDuration) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("NewRemoteHost", remoteHost);
        arguments.put("NewExternalPort", Integer.toString(externalPort));
        arguments.put("NewProtocol", this.getProtocol(protocol));
        arguments.put("NewInternalPort", Integer.toString(internalPort));
        arguments.put("NewInternalClient", internalClient);
        arguments.put("NewEnabled", "1");
        arguments.put("NewPortMappingDescription", description != null ? description : String.format("Jpcsp-%s", State.discId));
        arguments.put("NewLeaseDuration", Integer.toString(leaseDuration));
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "AddPortMapping", arguments);
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("addPortMapping errorCode=%s", result.get("errorCode")));
        }
    }

    public void deletePortMapping(String controlUrl, String serviceType, String remoteHost, int externalPort, String protocol) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("NewRemoteHost", remoteHost);
        arguments.put("NewExternalPort", Integer.toString(externalPort));
        arguments.put("NewProtocol", this.getProtocol(protocol));
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "DeletePortMapping", arguments);
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("deletePortMapping errorCode=%s", result.get("errorCode")));
        }
    }

    protected String getProtocol(String protocol) {
        if (protocol != null && !(protocol = protocol.toUpperCase()).equals("TCP") && !protocol.equals("UDP")) {
            protocol = null;
        }
        return protocol;
    }

    protected static class Device {
        public String descURL;
        public String st;

        protected Device() {
        }
    }
}

