/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.sound.ISampleSource;

public class SampleSourceWithDelay
implements ISampleSource {
    private ISampleSource sampleSource;
    private int delay;
    private int sampleIndex;

    public SampleSourceWithDelay(ISampleSource sampleSource, int delay) {
        this.sampleSource = sampleSource;
        this.delay = delay;
    }

    @Override
    public short getNextSample() {
        short sample;
        if (this.sampleIndex < this.delay) {
            sample = 0;
            ++this.sampleIndex;
        } else {
            sample = this.sampleSource.getNextSample();
        }
        return sample;
    }

    @Override
    public int getNumberSamples() {
        return this.delay + this.sampleSource.getNumberSamples();
    }

    @Override
    public int getSampleIndex() {
        if (this.sampleIndex < this.delay) {
            return this.sampleIndex;
        }
        return this.delay + this.sampleSource.getSampleIndex();
    }

    @Override
    public void setSampleIndex(int index) {
        if (index < this.delay) {
            this.sampleIndex = index;
            this.sampleSource.setSampleIndex(0);
        } else {
            this.sampleIndex = this.delay;
            this.sampleSource.setSampleIndex(index - this.delay);
        }
    }
}

