/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspFontStyle;
import jpcsp.format.PGF;
import jpcsp.util.Debug;

public class SceFontInfo {
    public static final int FONT_FILETYPE_PGF = 0;
    public static final int FONT_FILETYPE_BWFON = 1;
    public static final int FONT_PGF_BMP_H_ROWS = 1;
    public static final int FONT_PGF_BMP_V_ROWS = 2;
    public static final int FONT_PGF_BMP_OVERLAY = 3;
    public static final int FONT_PGF_METRIC_FLAG1 = 4;
    public static final int FONT_PGF_METRIC_FLAG2 = 8;
    public static final int FONT_PGF_METRIC_FLAG3 = 16;
    public static final int FONT_PGF_CHARGLYPH = 32;
    public static final int FONT_PGF_SHADOWGLYPH = 64;
    protected String fileName;
    protected String fileType;
    protected int[] fontdata;
    protected long fontdataBits;
    protected int n_chars;
    protected int advancex;
    protected int advancey;
    protected int charmap_compr_len;
    protected int[] charmap_compr;
    protected int[] charmap;
    protected Glyph[] glyphs;
    protected int firstGlyph;
    protected int n_shadows;
    protected int shadowscale;
    protected Glyph[] shadowGlyphs;
    protected int[] shadowCharMap;
    protected int[] charPointerTable;
    protected int[][] advanceTable;
    protected pspFontStyle fontStyle;

    public SceFontInfo(PGF fontFile) {
        int i;
        this.fileName = fontFile.getFileNamez();
        this.fileType = fontFile.getPGFMagic();
        this.n_chars = fontFile.getCharPointerLength();
        this.n_shadows = fontFile.getShadowMapLength();
        this.charmap = new int[fontFile.getCharMapLength() * 2];
        this.charmap_compr_len = fontFile.getRevision() == 3 ? 7 : 1;
        this.charmap_compr = new int[this.charmap_compr_len * 4];
        this.advancex = fontFile.getMaxAdvance()[0] / 16;
        this.advancey = fontFile.getMaxAdvance()[1] / 16;
        this.shadowscale = fontFile.getShadowScale()[0];
        this.glyphs = new Glyph[this.n_chars];
        this.shadowGlyphs = new Glyph[this.n_chars];
        this.firstGlyph = fontFile.getFirstGlyphInCharMap();
        this.advanceTable = fontFile.getAdvanceTable();
        int[] rawShadowCharMap = fontFile.getShadowCharMap();
        this.shadowCharMap = new int[fontFile.getShadowMapLength()];
        for (int i2 = 0; i2 < this.shadowCharMap.length; ++i2) {
            this.shadowCharMap[i2] = this.getBits(fontFile.getShadowMapBpe(), rawShadowCharMap, i2 * fontFile.getShadowMapBpe());
        }
        this.shadowCharMap = fontFile.getShadowCharMap();
        int[] rawCharMap = fontFile.getCharMap();
        for (int i3 = 0; i3 < fontFile.getCharMapLength(); ++i3) {
            this.charmap[i3] = this.getBits(fontFile.getCharMapBpe(), rawCharMap, i3 * fontFile.getCharMapBpe());
            if (this.charmap[i3] < this.n_chars) continue;
            this.charmap[i3] = 65535;
        }
        int[] rawCharPointerTable = fontFile.getCharPointerTable();
        this.charPointerTable = new int[this.n_chars];
        for (i = 0; i < this.charPointerTable.length; ++i) {
            this.charPointerTable[i] = this.getBits(fontFile.getCharPointerBpe(), rawCharPointerTable, i * fontFile.getCharPointerBpe());
        }
        this.fontdata = fontFile.getFontdata();
        this.fontdataBits = (long)this.fontdata.length * 8L;
        for (i = 0; i < this.n_chars; ++i) {
            this.glyphs[i] = this.getGlyph(this.fontdata, this.charPointerTable[i] * 4 * 8, 32, this.advanceTable[0], this.advanceTable[1]);
        }
        for (i = 0; i < this.n_chars; ++i) {
            this.shadowGlyphs[i] = this.getGlyph(this.fontdata, this.charPointerTable[i] * 4 * 8, 64, null, null);
        }
    }

    private int getBits(int bpe, int[] buf, long pos) {
        int v = 0;
        for (int i = 0; i < bpe; ++i) {
            v += (buf[(int)(pos / 8L)] >> (int)(pos % 8L) & 1) << i;
            ++pos;
        }
        return v;
    }

    private Glyph getGlyph(int[] fontdata, long charPtr, int glyphType, int[] advanceHmap, int[] advanceVmap) {
        Glyph glyph = new Glyph();
        if (glyphType == 64) {
            if (charPtr + 96L > this.fontdataBits) {
                return null;
            }
            charPtr += (long)(this.getBits(14, fontdata, charPtr) * 8);
        }
        if (charPtr + 96L > this.fontdataBits) {
            return null;
        }
        glyph.w = this.getBits(7, fontdata, charPtr += 14L);
        glyph.h = this.getBits(7, fontdata, charPtr += 7L);
        glyph.left = this.getBits(7, fontdata, charPtr += 7L);
        charPtr += 7L;
        if (glyph.left >= 64) {
            glyph.left -= 128;
        }
        glyph.top = this.getBits(7, fontdata, charPtr);
        charPtr += 7L;
        if (glyph.top >= 64) {
            glyph.top -= 128;
        }
        glyph.flags = this.getBits(6, fontdata, charPtr);
        charPtr += 6L;
        if (glyph.hasFlag(32)) {
            glyph.shadowID = this.getBits(9, fontdata, charPtr += 7L);
            charPtr += 9L;
            int advanceIndex = this.getBits(8, fontdata, charPtr += (long)(24 + (glyph.hasFlag(4) ? 0 : 56) + (glyph.hasFlag(8) ? 0 : 56) + (glyph.hasFlag(16) ? 0 : 56)));
            charPtr += 8L;
            glyph.advanceH = advanceHmap != null && advanceIndex < advanceHmap.length ? advanceHmap[advanceIndex] : 0;
            glyph.advanceV = advanceVmap != null && advanceIndex < advanceVmap.length ? advanceVmap[advanceIndex] : 0;
        } else {
            glyph.shadowID = 65535;
            glyph.advanceH = 0;
        }
        glyph.ptr = charPtr / 8L;
        return glyph;
    }

    private Glyph getCharGlyph(int charCode, int glyphType) {
        Glyph glyph;
        if (charCode < this.firstGlyph) {
            return null;
        }
        if ((charCode -= this.firstGlyph) < this.charmap.length) {
            charCode = this.charmap[charCode];
        }
        if (glyphType == 32) {
            if (charCode >= this.glyphs.length) {
                return null;
            }
            glyph = this.glyphs[charCode];
        } else {
            if (charCode >= this.shadowGlyphs.length) {
                return null;
            }
            glyph = this.shadowGlyphs[charCode];
        }
        return glyph;
    }

    private void generateFontTexture(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int pixelformat, int charCode, int altCharCode, int glyphType) {
        Glyph glyph = this.getCharGlyph(charCode, glyphType);
        if (glyph == null && (glyph = this.getCharGlyph(charCode = altCharCode, glyphType)) == null) {
            return;
        }
        if (glyph.w <= 0 || glyph.h <= 0) {
            return;
        }
        if ((glyph.flags & 3) != 1 && (glyph.flags & 3) != 2) {
            return;
        }
        long bitPtr = glyph.ptr * 8L;
        int nibbleBits = 4;
        int value = 0;
        boolean bitmapHorizontalRows = (glyph.flags & 3) == 1;
        int numberPixels = glyph.w * glyph.h;
        int pixelIndex = 0;
        while (pixelIndex < numberPixels && bitPtr + 8L < this.fontdataBits) {
            int count;
            int nibble = this.getBits(4, this.fontdata, bitPtr);
            bitPtr += 4L;
            if (nibble < 8) {
                value = this.getBits(4, this.fontdata, bitPtr);
                bitPtr += 4L;
                count = nibble + 1;
            } else {
                count = 16 - nibble;
            }
            for (int i = 0; i < count && pixelIndex < numberPixels; ++pixelIndex, ++i) {
                int yy;
                int xx;
                if (nibble >= 8) {
                    value = this.getBits(4, this.fontdata, bitPtr);
                    bitPtr += 4L;
                }
                if (bitmapHorizontalRows) {
                    xx = pixelIndex % glyph.w;
                    yy = pixelIndex / glyph.w;
                } else {
                    xx = pixelIndex / glyph.h;
                    yy = pixelIndex % glyph.h;
                }
                int pixelColor = value;
                switch (pixelformat) {
                    case 2: {
                        pixelColor |= pixelColor << 4;
                        break;
                    }
                    case 3: {
                        pixelColor |= pixelColor << 4;
                        pixelColor |= pixelColor << 8;
                        pixelColor |= pixelColor << 8;
                        break;
                    }
                    case 4: {
                        pixelColor |= pixelColor << 4;
                        pixelColor |= pixelColor << 8;
                        pixelColor |= pixelColor << 16;
                    }
                }
                Debug.setFontPixel(base, bpl, bufWidth, bufHeight, x + xx, y + yy, pixelColor, pixelformat);
            }
        }
    }

    public void printFont(int base, int bpl, int bufWidth, int bufHeight, int x, int y, int pixelformat, int charCode, int altCharCode) {
        this.generateFontTexture(base, bpl, bufWidth, bufHeight, x, y, pixelformat, charCode, altCharCode, 32);
    }

    public pspCharInfo getCharInfo(int charCode) {
        pspCharInfo charInfo = new pspCharInfo();
        Glyph glyph = this.getCharGlyph(charCode, 32);
        if (glyph == null) {
            return null;
        }
        charInfo.bitmapWidth = glyph.w;
        charInfo.bitmapHeight = glyph.h;
        charInfo.bitmapLeft = glyph.left;
        charInfo.bitmapTop = glyph.top;
        charInfo.sfp26Width = glyph.w << 6;
        charInfo.sfp26Height = glyph.h << 6;
        charInfo.sfp26Ascender = glyph.top << 6;
        charInfo.sfp26Descender = glyph.h - glyph.top << 6;
        charInfo.sfp26BearingHX = glyph.left << 6;
        charInfo.sfp26BearingHY = glyph.top << 6;
        charInfo.sfp26BearingVX = glyph.left << 6;
        charInfo.sfp26BearingVY = glyph.top << 6;
        charInfo.sfp26AdvanceH = glyph.advanceH;
        charInfo.sfp26AdvanceV = glyph.advanceV;
        return charInfo;
    }

    public pspFontStyle getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(pspFontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected static class Glyph {
        protected int x;
        protected int y;
        protected int w;
        protected int h;
        protected int left;
        protected int top;
        protected int flags;
        protected int shadowID;
        protected int advanceH;
        protected int advanceV;
        protected long ptr;

        protected Glyph() {
        }

        public boolean hasFlag(int flag) {
            return (this.flags & flag) == flag;
        }

        public String toString() {
            return String.format("Glyph[x=%d, y=%d, w=%d, h=%d, left=%d, top=%d, flags=0x%X, shadowID=%d, advance=%d, ptr=%d]", this.x, this.y, this.w, this.h, this.left, this.top, this.flags, this.shadowID, this.advanceH, this.ptr);
        }
    }
}

