/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.Memory;

public class SceMpegRingbuffer
extends pspAbstractMemoryMappedStructure {
    public int packets;
    public int packetsRead;
    public int packetsWritten;
    public int packetsFree;
    public int packetSize;
    public int data;
    public int callback_addr;
    public int callback_args;
    public int dataUpperBound;
    public int semaID;
    public int mpeg;

    public SceMpegRingbuffer(int packets, int data, int size, int callback_addr, int callback_args) {
        this.packets = packets;
        this.packetsRead = 0;
        this.packetsWritten = 0;
        this.packetsFree = 0;
        this.packetSize = 2048;
        this.data = data;
        this.callback_addr = callback_addr;
        this.callback_args = callback_args;
        this.dataUpperBound = data + packets * 2048;
        this.semaID = -1;
        this.mpeg = 0;
        if (this.dataUpperBound > data + size) {
            this.dataUpperBound = data + size;
            Modules.log.warn((Object)("SceMpegRingbuffer clamping dataUpperBound to " + this.dataUpperBound));
        }
    }

    private SceMpegRingbuffer() {
    }

    public static SceMpegRingbuffer fromMem(Memory mem, int address) {
        SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer();
        ringbuffer.read(mem, address);
        return ringbuffer;
    }

    public void reset() {
        this.packetsRead = 0;
        this.packetsWritten = 0;
        this.packetsFree = this.packets;
    }

    public boolean isEmpty() {
        return this.packetsFree == this.packets;
    }

    @Override
    protected void read() {
        this.packets = this.read32();
        this.packetsRead = this.read32();
        this.packetsWritten = this.read32();
        this.packetsFree = this.read32();
        this.packetSize = this.read32();
        this.data = this.read32();
        this.callback_addr = this.read32();
        this.callback_args = this.read32();
        this.dataUpperBound = this.read32();
        this.semaID = this.read32();
        this.mpeg = this.read32();
    }

    @Override
    protected void write() {
        this.write32(this.packets);
        this.write32(this.packetsRead);
        this.write32(this.packetsWritten);
        this.write32(this.packetsFree);
        this.write32(this.packetSize);
        this.write32(this.data);
        this.write32(this.callback_addr);
        this.write32(this.callback_args);
        this.write32(this.dataUpperBound);
        this.write32(this.semaID);
        this.write32(this.mpeg);
    }

    @Override
    public int sizeof() {
        return 44;
    }

    @Override
    public String toString() {
        return String.format("SceMpegRingbuffer(packets=%d, packetsRead=%d, packetsWritten=%d, packetsFree=%d, packetSize=%d)", this.packets, this.packetsRead, this.packetsWritten, this.packetsFree, this.packetSize);
    }
}

