/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.connector.AtracCodec;
import jpcsp.settings.AbstractBoolSettingsListener;
import org.apache.log4j.Logger;

public class sceAtrac3plus
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceAtrac3plus");
    protected static final String idPurpose = "sceAtrac3plus";
    protected static final int AT3_MAGIC = 624;
    protected static final int AT3_PLUS_MAGIC = 65534;
    public static final int RIFF_MAGIC = 1179011410;
    protected static final int WAVE_MAGIC = 1163280727;
    public static final int FMT_CHUNK_MAGIC = 544501094;
    protected static final int FACT_CHUNK_MAGIC = 1952670054;
    protected static final int SMPL_CHUNK_MAGIC = 1819307379;
    public static final int DATA_CHUNK_MAGIC = 1635017060;
    public static final int PSP_ATRAC_ALLDATA_IS_ON_MEMORY = -1;
    public static final int PSP_ATRAC_NONLOOP_STREAM_DATA_IS_ON_MEMORY = -2;
    public static final int PSP_ATRAC_LOOP_STREAM_DATA_IS_ON_MEMORY = -3;
    protected static final int PSP_ATRAC_STATUS_NONLOOP_STREAM_DATA = 0;
    protected static final int PSP_ATRAC_STATUS_LOOP_STREAM_DATA = 1;
    protected static final int PSP_MODE_AT_3_PLUS = 4096;
    protected static final int PSP_MODE_AT_3 = 4097;
    protected int atrac3MaxIDsCount = 2;
    protected int atrac3plusMaxIDsCount = 2;
    protected int atrac3Num;
    protected int atrac3plusNum;
    protected static final int atracDecodeDelay = 2300;
    public static boolean useAtracCodec = false;
    protected HashMap<Integer, AtracID> atracIDs;
    protected static final int atracIDMask = 255;

    @Override
    public String getName() {
        return idPurpose;
    }

    @Override
    public void start() {
        this.atracIDs = new HashMap();
        this.setSettingsListener("emu.useConnector", new EnableConnectorSettingsListener());
        super.start();
    }

    public static boolean isEnableConnector() {
        return useAtracCodec;
    }

    private static void setEnableConnector(boolean useConnector) {
        useAtracCodec = useConnector;
    }

    protected String getStringFromInt32(int n) {
        char c1 = (char)(n & 0xFF);
        char c2 = (char)(n >> 8 & 0xFF);
        char c3 = (char)(n >> 16 & 0xFF);
        char c4 = (char)(n >> 24 & 0xFF);
        return String.format("%c%c%c%c", Character.valueOf(c1), Character.valueOf(c2), Character.valueOf(c3), Character.valueOf(c4));
    }

    public int getBytesPerFrame(int atID) {
        return this.atracIDs.get(atID).getAtracBytesPerFrame();
    }

    protected int getRemainFrames(AtracID id) {
        return this.getRemainFrames(id, id.getMaxSamples());
    }

    protected int getRemainFrames(AtracID id, int samples) {
        id.update();
        int remainFrames = id.getRemainFrames();
        if (id.getInputFileOffset() < id.getInputFileSize()) {
            if (remainFrames > 0 && samples < id.getMaxSamples()) {
                id.setInputBufferOffset(id.getInputBufferSize());
                remainFrames = 0;
            } else if (id.getAtracCodec().getChannelLength() <= 0) {
                id.setInputBufferOffset(id.getInputBufferSize());
                remainFrames = 0;
            }
        }
        return remainFrames;
    }

    protected void hleAtracReinit(int newAT3IdCount, int newAT3plusIdCount) {
        this.atrac3MaxIDsCount = newAT3IdCount;
        this.atrac3plusMaxIDsCount = newAT3plusIdCount;
    }

    protected int hleCreateAtracID(int codecType) {
        AtracCodec atracCodec;
        int atracID = SceUidManager.getNewId(idPurpose, 0, 255);
        AtracID id = new AtracID(atracID, codecType, atracCodec = new AtracCodec());
        if (id.getAtracId() >= 0) {
            this.atracIDs.put(atracID, id);
            return atracID;
        }
        return -2140995581;
    }

    protected void hleReleaseAtracID(int atracID) {
        AtracID id = this.atracIDs.remove(atracID);
        SceUidManager.releaseId(atracID, idPurpose);
        id.release();
    }

    public static int getCodecType(int address) {
        int at3magic = Memory.getInstance().read16(address + 20);
        if (at3magic == 624) {
            return 4097;
        }
        if (at3magic == 65534) {
            return 4096;
        }
        return 0;
    }

    public int checkAtracID(int atID) {
        if (!this.atracIDs.containsKey(atID &= 0xFF)) {
            log.warn((Object)String.format("Unknown atracID=0x%X", atID));
            throw new SceKernelErrorException(-2140995579);
        }
        return atID;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-772431909, version=150, checkInsideInterrupt=true)
    public int sceAtracStartEntry() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-708670272, version=150, checkInsideInterrupt=true)
    public int sceAtracEndEntry() {
        return 0;
    }

    @HLEFunction(nid=2014283985, version=150, checkInsideInterrupt=true)
    public int sceAtracGetAtracID(int codecType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetAtracID codecType=0x%X", codecType));
        }
        int atId = this.hleCreateAtracID(codecType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetAtracID: returning atracID=0x%08X", atId));
        }
        return atId;
    }

    @HLEFunction(nid=1642804213, version=150, checkInsideInterrupt=true)
    public int sceAtracReleaseAtracID(@CheckArgument(value="checkAtracID") int atID) {
        AtracCodec atracCodec;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracReleaseAtracID atracID=0x%X", atID));
        }
        if ((atracCodec = this.atracIDs.get(atID).getAtracCodec()) != null) {
            atracCodec.finish();
        }
        this.hleReleaseAtracID(atID);
        return 0;
    }

    @HLEFunction(nid=237663147, version=150, checkInsideInterrupt=true)
    public int sceAtracSetData(@CheckArgument(value="checkAtracID") int atID, TPointer buffer, int bufferSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetData atID=0x%X, buffer=%s, bufferSize=0x%08X", atID, buffer, bufferSize));
        }
        this.atracIDs.get(atID).setData(buffer.getAddress(), bufferSize, bufferSize, false);
        return 0;
    }

    @HLEFunction(nid=1064183477, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer halfBuffer, int readSize, int halfBufferSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetHalfwayBuffer atID=0x%X, buffer=%s, readSize=0x%08X, bufferSize=0x%08X", atID, halfBuffer, readSize, halfBufferSize));
        }
        this.atracIDs.get(atID).setData(halfBuffer.getAddress(), readSize, halfBufferSize, false);
        return 0;
    }

    @HLEFunction(nid=2048976815, version=150, checkInsideInterrupt=true)
    public int sceAtracSetDataAndGetID(TPointer buffer, int bufferSize) {
        int codecType;
        int atID;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetDataAndGetID buffer=%s, bufferSize=0x%08X", buffer, bufferSize));
        }
        if (this.atracIDs.containsKey(atID = this.hleCreateAtracID(codecType = sceAtrac3plus.getCodecType(buffer.getAddress())))) {
            this.atracIDs.get(atID).setData(buffer.getAddress(), bufferSize, bufferSize, false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetDataAndGetID returning atracID=0x%08X", atID));
        }
        return atID;
    }

    @HLEFunction(nid=263075598, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBufferAndGetID(TPointer halfBuffer, int readSize, int halfBufferSize) {
        int codecType;
        int atID;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetHalfwayBufferAndGetID halfBuffer=%s, readSize=0x%08X, halfBufferSize=0x%08X", halfBuffer, readSize, halfBufferSize));
        }
        if (this.atracIDs.containsKey(atID = this.hleCreateAtracID(codecType = sceAtrac3plus.getCodecType(halfBuffer.getAddress())))) {
            this.atracIDs.get(atID).setData(halfBuffer.getAddress(), readSize, halfBufferSize, false);
        }
        return atID;
    }

    @HLEFunction(nid=1787575509, version=150, checkInsideInterrupt=true)
    public int sceAtracDecodeData(@CheckArgument(value="checkAtracID") int atID, TPointer samplesAddr, @CanBeNull TPointer32 samplesNbrAddr, @CanBeNull TPointer32 outEndAddr, @CanBeNull TPointer32 remainFramesAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracDecodeData atracID=0x%X, samplesAddr=%s, samplesNbrAddr=%s, outEndAddr=%s, remainFramesAddr=%s", atID, samplesAddr, samplesNbrAddr, outEndAddr, remainFramesAddr));
        }
        if (this.atracIDs.get(atID).isSecondBufferNeeded() && !this.atracIDs.get(atID).isSecondBufferSet()) {
            log.warn((Object)String.format("sceAtracDecodeData atracID=0x%X needs second buffer!", atID));
            return -2140995566;
        }
        AtracID id = this.atracIDs.get(atID);
        int result = 0;
        AtracCodec atracCodec = id.getAtracCodec();
        int samples = 0;
        int end = 1;
        if (id.isForceReloadOfData()) {
            result = -2140995549;
            end = 0;
        } else if (atracCodec != null) {
            samples = atracCodec.atracDecodeData(atID, samplesAddr.getAddress());
            if (samples < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceAtracDecodeData faked samples");
                }
                samples = id.getMaxSamples();
                if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                    samples = 0;
                    result = -2140995548;
                    end = 1;
                } else {
                    end = 0;
                }
                samplesAddr.clear(samples * 4);
            } else if (samples == 0) {
                result = -2140995548;
                end = 1;
            } else {
                end = atracCodec.getAtracEnd();
            }
        }
        if (samples > 0) {
            int consumedInputBytes = id.getAtracBytesPerFrame();
            if (consumedInputBytes < 0) {
                consumedInputBytes = 0;
            } else if (id.getInputBufferOffset() + consumedInputBytes > id.getInputBufferSize()) {
                consumedInputBytes = id.getInputBufferSize() - id.getInputBufferOffset();
            }
            id.setInputBufferOffset(id.getInputBufferOffset() + consumedInputBytes);
        }
        if (samples > 0) {
            id.setDecodedSamples(samples);
            if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
                end = 1;
            }
        }
        int remainFrames = end == 1 ? -1 : this.getRemainFrames(id, samples);
        samplesNbrAddr.setValue(samples);
        outEndAddr.setValue(end);
        remainFramesAddr.setValue(remainFrames);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracDecodeData returning 0x%08X, samples=%d, end=%d, remainFrames=%d, currentSample=%d/%d, %s", result, samples, end, remainFrames, id.getAtracCurrentSample(), id.getAtracEndSample(), id.toString()));
        }
        if (result == 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        }
        return result;
    }

    @HLEFunction(nid=-1696052825, version=150, checkInsideInterrupt=true)
    public int sceAtracGetRemainFrame(@CheckArgument(value="checkAtracID") int atID, TPointer32 remainFramesAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetRemainFrame atracID=0x%X, remainFramesAddr=%s", atID, remainFramesAddr));
        }
        if (!this.atracIDs.containsKey(atID)) {
            log.warn((Object)("sceAtracGetRemainFrame: bad atracID= " + atID));
            return -2140995579;
        }
        AtracID id = this.atracIDs.get(atID);
        int remainFrames = this.getRemainFrames(id);
        remainFramesAddr.setValue(remainFrames);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetRemainFrame returning %d, %s", remainFrames, id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=1562806023, version=150, checkInsideInterrupt=true)
    public int sceAtracGetStreamDataInfo(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 writeAddr, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 readOffsetAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetStreamDataInfo atracID=0x%X, writeAddr=%s, writableBytesAddr=%s, readOffsetAddr=%s", atID, writeAddr, writableBytesAddr, readOffsetAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        id.update();
        writeAddr.setValue(id.getInputBufferAddr());
        writableBytesAddr.setValue(id.getInputBufferWritableBytes());
        readOffsetAddr.setValue(id.getInputFileOffset());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetStreamDataInfo write=0x%08X, writableBytes=%d, readOffset=%d, %s", writeAddr.getValue(), writableBytesAddr.getValue(), readOffsetAddr.getValue(), id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=2108887633, version=150, checkInsideInterrupt=true)
    public int sceAtracAddStreamData(@CheckArgument(value="checkAtracID") int atID, int bytesToAdd) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracAddStreamData atracID=0x%X, bytesToAdd=0x%X", atID, bytesToAdd));
        }
        AtracID id = this.atracIDs.get(atID);
        id.addStreamData(bytesToAdd);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracAddStreamData: %s", id.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-2081923424, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSecondBufferInfo(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 outPosition, @CanBeNull TPointer32 outBytes) {
        AtracID id;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetSecondBufferInfo atracID=0x%X, outPosition=%s, outBytes=%s", atID, outPosition, outBytes));
        }
        if (!(id = this.atracIDs.get(atID)).isSecondBufferNeeded()) {
            return -2140995550;
        }
        outPosition.setValue(id.getSecondInputFileOffset());
        outBytes.setValue(id.getSecondInputFileSize());
        return 0;
    }

    @HLEFunction(nid=-2084603139, version=150, checkInsideInterrupt=true)
    public int sceAtracSetSecondBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer secondBuffer, int secondBufferSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetSecondBuffer atracID=0x%X, secondBuffer=%s, secondBufferSize=0x%08X", atID, secondBuffer, secondBufferSize));
        }
        AtracID id = this.atracIDs.get(atID);
        id.setData(secondBuffer.getAddress(), secondBufferSize, secondBufferSize, true);
        return 0;
    }

    @HLEFunction(nid=-499238347, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextDecodePosition(@CheckArgument(value="checkAtracID") int atID, TPointer32 posAddr) {
        AtracID id;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextDecodePosition atracID=0x%X, posAddr=%s", atID, posAddr));
        }
        if ((id = this.atracIDs.get(atID)).getAtracCurrentSample() >= id.getAtracEndSample()) {
            return -2140995548;
        }
        posAddr.setValue(id.getAtracCurrentSample());
        return 0;
    }

    @HLEFunction(nid=-1564759874, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSoundSample(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 endSampleAddr, @CanBeNull TPointer32 loopStartSampleAddr, @CanBeNull TPointer32 loopEndSampleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetSoundSample atracID=0x%X, endSampleAddr=%s, loopStartSampleAddr=%s, loopEndSampleAddr=%s", atID, endSampleAddr, loopStartSampleAddr, loopEndSampleAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        int endSample = id.getAtracEndSample();
        int loopStartSample = id.getLoopStartSample();
        int loopEndSample = id.getLoopEndSample();
        if (endSample < 0) {
            endSample = id.getAtracCodec().getAtracEndSample();
        }
        if (endSample < 0) {
            endSample = id.getInputFileSize();
        }
        endSampleAddr.setValue(endSample);
        loopStartSampleAddr.setValue(loopStartSample);
        loopEndSampleAddr.setValue(loopEndSample);
        return 0;
    }

    @HLEFunction(nid=828804010, version=150, checkInsideInterrupt=true)
    public int sceAtracGetChannel(@CheckArgument(value="checkAtracID") int atID, TPointer32 channelAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetChannel atracID=0x%X, channelAddr%s", atID, channelAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        channelAddr.setValue(id.getAtracChannels());
        return 0;
    }

    @HLEFunction(nid=-693767433, version=150, checkInsideInterrupt=true)
    public int sceAtracGetMaxSample(@CheckArgument(value="checkAtracID") int atID, TPointer32 maxSamplesAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetMaxSample atracID=0x%X, maxSamplesAddr=%s", atID, maxSamplesAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        maxSamplesAddr.setValue(id.getMaxSamples());
        return 0;
    }

    @HLEFunction(nid=922397691, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextSample(@CheckArgument(value="checkAtracID") int atID, TPointer32 nbrSamplesAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextSample atracID=0x%X, nbrSamplesAddr=%s", atID, nbrSamplesAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        int samples = id.getMaxSamples();
        if (id.getInputBufferOffset() >= id.getInputBufferSize()) {
            samples = 0;
        }
        nbrSamplesAddr.setValue(samples);
        return 0;
    }

    @HLEFunction(nid=-1521180328, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBitrate(@CheckArgument(value="checkAtracID") int atID, TPointer32 bitrateAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetBitrate atracID=0x%X, bitrateAddr=%s", atID, bitrateAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        bitrateAddr.setValue(id.getAtracBitrate());
        return 0;
    }

    @HLEFunction(nid=-89851749, version=150, checkInsideInterrupt=true)
    public int sceAtracGetLoopStatus(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer32 loopNbr, @CanBeNull TPointer32 statusAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetLoopStatus atracID=0x%X, loopNbr=%s, statusAddr=%s", atID, loopNbr, statusAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        loopNbr.setValue(id.getLoopNum());
        statusAddr.setValue(id.getLoopStatus());
        return 0;
    }

    @HLEFunction(nid=-2038357835, version=150, checkInsideInterrupt=true)
    public int sceAtracSetLoopNum(@CheckArgument(value="checkAtracID") int atID, int loopNbr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetLoopNum atracID=0x%X, loopNbr=%d", atID, loopNbr));
        }
        AtracID id = this.atracIDs.get(atID);
        id.setLoopNum(loopNbr);
        id.getAtracCodec().setAtracLoopCount(loopNbr);
        return 0;
    }

    @HLEFunction(nid=-901995566, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBufferInfoForReseting(@CheckArgument(value="checkAtracID") int atID, int sample, TPointer32 bufferInfoAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetBufferInfoForReseting atracID=0x%X, sample=%d, bufferInfoAddr=%s", atID, sample, bufferInfoAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        id.getBufferInfoForResetting(sample, bufferInfoAddr);
        return 0;
    }

    @HLEFunction(nid=1682855431, version=150, checkInsideInterrupt=true)
    public int sceAtracResetPlayPosition(@CheckArgument(value="checkAtracID") int atID, int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracResetPlayPosition atracId=0x%X, sample=%d, bytesWrittenFirstBuf=%d, bytesWrittenSecondBuf=%d", atID, sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf));
        }
        AtracID id = this.atracIDs.get(atID);
        id.setPlayPosition(sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf);
        return 0;
    }

    @HLEFunction(nid=-393251429, version=150, checkInsideInterrupt=true)
    public int sceAtracGetInternalErrorInfo(@CheckArgument(value="checkAtracID") int atID, TPointer32 errorAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetInternalErrorInfo atracId=0x%X, errorAddr=%s", atID, errorAddr));
        }
        AtracID id = this.atracIDs.get(atID);
        errorAddr.setValue(id.getInternalErrorInfo());
        return 0;
    }

    private static class EnableConnectorSettingsListener
    extends AbstractBoolSettingsListener {
        private EnableConnectorSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceAtrac3plus.setEnableConnector(value);
        }
    }

    protected class AtracID {
        protected int id;
        protected int codecType;
        protected AtracCodec atracCodec;
        protected int atracBitrate = 64;
        protected int atracChannels = 2;
        protected int atracSampleRate = 44100;
        protected int atracBytesPerFrame = 560;
        protected int atracEndSample;
        protected int atracCurrentSample;
        protected int maxSamples;
        protected int atracSampleOffset;
        protected int inputBufferAddr;
        protected int inputBufferSize;
        protected int inputBufferOffset;
        protected int inputBufferWritableBytes;
        protected int inputBufferNeededBytes;
        protected int secondInputBufferAddr;
        protected int secondInputBufferSize;
        protected int secondInputBufferOffset;
        protected int secondInputBufferWritableBytes;
        protected int secondInputBufferNeededBytes;
        protected int inputFileSize;
        protected int inputFileOffset;
        protected int secondInputFileSize;
        protected int secondInputFileOffset;
        protected boolean isSecondBufferNeeded;
        protected boolean isSecondBufferSet;
        protected int internalErrorInfo;
        protected int loopNum;
        protected int numLoops;
        protected LoopInfo[] loops;
        protected int loopStartBytesWrittenFirstBuf;
        protected int loopStartBytesWrittenSecondBuf;
        protected int currentLoopNum = -1;
        protected boolean forceReloadOfData;
        protected boolean forceAllDataIsOnMemory;

        public AtracID(int id, int codecType, AtracCodec atracCodec) {
            this.codecType = codecType;
            this.id = id;
            this.atracCodec = atracCodec;
            if (codecType == 4097 && sceAtrac3plus.this.atrac3Num < sceAtrac3plus.this.atrac3MaxIDsCount) {
                ++sceAtrac3plus.this.atrac3Num;
                this.maxSamples = 1024;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else if (codecType == 4096 && sceAtrac3plus.this.atrac3plusNum < sceAtrac3plus.this.atrac3plusMaxIDsCount) {
                ++sceAtrac3plus.this.atrac3plusNum;
                this.maxSamples = 2048;
                atracCodec.setAtracMaxSamples(this.maxSamples);
            } else {
                this.id = -1;
                this.atracCodec = null;
                this.maxSamples = 0;
            }
        }

        public void release() {
            if (this.id >= 0) {
                if (this.codecType == 4097) {
                    --sceAtrac3plus.this.atrac3Num;
                } else if (this.codecType == 4096) {
                    --sceAtrac3plus.this.atrac3plusNum;
                }
            }
        }

        private void analyzeAtracHeader() {
            Memory mem = Memory.getInstance();
            int currentAddr = this.inputBufferAddr;
            int bufferSize = this.inputBufferSize;
            this.atracEndSample = -1;
            this.atracCurrentSample = 0;
            this.isSecondBufferNeeded = false;
            this.numLoops = 0;
            if (bufferSize < 12) {
                log.error((Object)String.format("Atrac buffer too small %d", bufferSize));
                return;
            }
            int RIFFMagic = mem.read32(currentAddr);
            int WAVEMagic = mem.read32(currentAddr + 8);
            if (RIFFMagic != 1179011410 || WAVEMagic != 1163280727) {
                log.error((Object)String.format("Not a RIFF/WAVE format! %08X %08X", RIFFMagic, WAVEMagic));
                return;
            }
            this.inputFileSize = mem.read32(currentAddr + 4) + 8;
            currentAddr += 12;
            bufferSize -= 12;
            boolean foundData = false;
            while (bufferSize >= 8 && !foundData) {
                int chunkMagic = mem.read32(currentAddr);
                int chunkSize = mem.read32(currentAddr + 4);
                currentAddr += 8;
                if (chunkSize > (bufferSize -= 8)) break;
                switch (chunkMagic) {
                    case 544501094: {
                        if (chunkSize < 16) break;
                        int compressionCode = mem.read16(currentAddr);
                        this.atracChannels = mem.read16(currentAddr + 2);
                        this.atracSampleRate = mem.read32(currentAddr + 4);
                        this.atracBitrate = mem.read32(currentAddr + 8);
                        this.atracBytesPerFrame = mem.read16(currentAddr + 12);
                        int hiBytesPerSample = mem.read16(currentAddr + 14);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("WAVE format: magic=0x%08X('%s'), chunkSize=%d, compressionCode=0x%04X, channels=%d, sampleRate=%d, bitrate=%d, chunkAlign=%d, hiBytesPerSample=%d", chunkMagic, sceAtrac3plus.this.getStringFromInt32(chunkMagic), chunkSize, compressionCode, this.atracChannels, this.atracSampleRate, this.atracBitrate, this.atracBytesPerFrame, hiBytesPerSample));
                        StringBuilder restChunk = new StringBuilder();
                        for (int i = 16; i < chunkSize; ++i) {
                            int b = mem.read8(currentAddr + i);
                            restChunk.append(String.format(" %02X", b));
                        }
                        if (restChunk.length() <= 0) break;
                        log.debug((Object)String.format("Additional chunk data:%s", restChunk));
                        break;
                    }
                    case 1952670054: {
                        if (chunkSize < 8) break;
                        this.atracEndSample = mem.read32(currentAddr);
                        this.atracSampleOffset = mem.read32(currentAddr + 4);
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("FACT Chunk: endSample=%d, sampleOffset=%d", this.atracEndSample, this.atracSampleOffset));
                        break;
                    }
                    case 1819307379: {
                        int checkNumLoops;
                        if (chunkSize < 36 || chunkSize < 36 + (checkNumLoops = mem.read32(currentAddr + 28)) * 24) break;
                        this.numLoops = checkNumLoops;
                        this.loops = new LoopInfo[this.numLoops];
                        int loopInfoAddr = currentAddr + 36;
                        for (int i = 0; i < this.numLoops; ++i) {
                            LoopInfo loop;
                            this.loops[i] = loop = new LoopInfo();
                            loop.cuePointID = mem.read32(loopInfoAddr);
                            loop.type = mem.read32(loopInfoAddr + 4);
                            loop.startSample = mem.read32(loopInfoAddr + 8) - this.atracSampleOffset;
                            loop.endSample = mem.read32(loopInfoAddr + 12) - this.atracSampleOffset;
                            loop.fraction = mem.read32(loopInfoAddr + 16);
                            loop.playCount = mem.read32(loopInfoAddr + 20);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Loop #%d: %s", i, loop.toString()));
                            }
                            loopInfoAddr += 24;
                        }
                        break;
                    }
                    case 1635017060: {
                        foundData = true;
                    }
                }
                currentAddr += chunkSize;
                bufferSize -= chunkSize;
            }
        }

        public int getAtracId() {
            return this.id;
        }

        public int getAtracCodecType() {
            return this.codecType;
        }

        public AtracCodec getAtracCodec() {
            return this.atracCodec;
        }

        public int getAtracBitrate() {
            return this.atracBitrate;
        }

        public int getAtracChannels() {
            return this.atracChannels;
        }

        public int getAtracSampleRate() {
            return this.atracSampleRate;
        }

        public int getAtracEndSample() {
            return this.atracEndSample;
        }

        public int getAtracCurrentSample() {
            return this.atracCurrentSample;
        }

        public int getAtracBytesPerFrame() {
            return this.atracBytesPerFrame;
        }

        public void setAtracCurrentSample(int sample) {
            this.atracCurrentSample = sample;
        }

        public int getLoopNum() {
            if (!this.hasLoop()) {
                return 0;
            }
            return this.loopNum;
        }

        public void setLoopNum(int num) {
            this.loopNum = num;
        }

        public int getMaxSamples() {
            return this.maxSamples;
        }

        public int getInputBufferAddr() {
            return this.inputBufferAddr;
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public int getInputBufferOffset() {
            return this.inputBufferOffset;
        }

        public void setInputBufferOffset(int offset) {
            this.inputBufferOffset = offset;
        }

        public int getInputBufferWritableBytes() {
            return this.inputBufferWritableBytes;
        }

        public void setInputBufferWritableBytes(int bytes) {
            this.inputBufferWritableBytes = bytes;
        }

        public int getInputBufferNeededBytes() {
            return this.inputBufferNeededBytes;
        }

        public int getSecondInputBufferAddr() {
            return this.secondInputBufferAddr;
        }

        public int getSecondInputBufferSize() {
            return this.secondInputBufferSize;
        }

        public int getSecondInputBufferOffset() {
            return this.secondInputBufferOffset;
        }

        public int getSecondInputBufferWritableBytes() {
            return this.secondInputBufferWritableBytes;
        }

        public int getSecondInputBufferNeededBytes() {
            return this.secondInputBufferNeededBytes;
        }

        public int getInputFileSize() {
            return this.inputFileSize;
        }

        public void setInputFileSize(int bytes) {
            this.inputFileSize = bytes;
        }

        public int getInputFileOffset() {
            return this.inputFileOffset;
        }

        public void setInputFileOffset(int offset) {
            this.inputFileOffset = offset;
        }

        public int getSecondInputFileSize() {
            return this.secondInputFileSize;
        }

        public int getSecondInputFileOffset() {
            return this.secondInputFileOffset;
        }

        public boolean isSecondBufferNeeded() {
            return this.isSecondBufferNeeded;
        }

        public boolean isSecondBufferSet() {
            return this.isSecondBufferSet;
        }

        public int getInternalErrorInfo() {
            return this.internalErrorInfo;
        }

        public void setData(int buffer, int readSize, int bufferSize, boolean isSecondBuf) {
            Emulator.getClock().pause();
            if (isSecondBuf) {
                this.secondInputBufferAddr = buffer;
                this.secondInputBufferSize = bufferSize;
                this.secondInputBufferOffset = bufferSize - readSize;
                this.secondInputBufferWritableBytes = bufferSize - readSize;
                this.isSecondBufferSet = true;
            } else {
                this.inputBufferAddr = buffer;
                this.inputBufferSize = bufferSize;
                this.inputBufferOffset = bufferSize - readSize;
                this.inputBufferWritableBytes = bufferSize - readSize;
                this.inputFileSize = readSize;
                this.inputFileOffset = readSize;
                this.secondInputFileSize = 256;
                this.secondInputFileOffset = this.inputFileSize - 256;
                this.forceAllDataIsOnMemory = false;
                this.forceReloadOfData = false;
                this.analyzeAtracHeader();
                log.info((Object)String.format("hleAtracSetData atracID=%d, buffer=0x%08X, readSize=0x%X, bufferSize=0x%X, fileSize=0x%X", this.getAtracId(), buffer, readSize, this.inputBufferSize, this.inputFileSize));
                if (this.getAtracCodec() == null) {
                    log.warn((Object)String.format("hleAtracSetData atracID=%d is invalid", this.getAtracId()));
                    return;
                }
                this.getAtracCodec().atracSetData(this.getAtracId(), this.getAtracCodecType(), buffer, readSize, this.inputFileSize);
            }
            Emulator.getClock().resume();
        }

        protected void addStreamData(int length) {
            if (length > 0) {
                this.inputFileOffset += length;
                this.inputBufferOffset -= length;
                this.forceReloadOfData = false;
                this.getAtracCodec().atracAddStreamData(this.inputBufferAddr, length);
            }
        }

        public int getRemainFrames() {
            if (this.inputFileOffset >= this.inputFileSize || this.atracCurrentSample >= this.atracEndSample) {
                return -1;
            }
            if (this.forceReloadOfData) {
                return 0;
            }
            if (this.forceAllDataIsOnMemory) {
                return -1;
            }
            if (this.getInputBufferWritableBytes() <= 0) {
                return this.inputBufferSize / this.atracBytesPerFrame;
            }
            int remainFrames = (this.inputBufferSize - this.inputBufferOffset) / this.atracBytesPerFrame;
            return remainFrames;
        }

        public void getBufferInfoForResetting(int sample, TPointer32 bufferInfoAddr) {
            bufferInfoAddr.setValue(0, this.inputBufferAddr);
            bufferInfoAddr.setValue(4, this.inputBufferWritableBytes);
            bufferInfoAddr.setValue(8, this.inputBufferNeededBytes);
            bufferInfoAddr.setValue(12, this.inputFileOffset);
            bufferInfoAddr.setValue(16, this.secondInputBufferAddr);
            bufferInfoAddr.setValue(20, this.secondInputBufferWritableBytes);
            bufferInfoAddr.setValue(24, this.secondInputBufferNeededBytes);
            bufferInfoAddr.setValue(28, this.secondInputFileOffset);
        }

        public void setDecodedSamples(int samples) {
            int currentSample = this.getAtracCurrentSample();
            int nextCurrentSample = currentSample + samples;
            for (int i = 0; i < this.numLoops; ++i) {
                LoopInfo loop = this.loops[i];
                if (currentSample <= loop.startSample && loop.startSample < nextCurrentSample) {
                    this.loopStartBytesWrittenFirstBuf = this.inputFileOffset;
                    this.loopStartBytesWrittenSecondBuf = this.secondInputFileOffset;
                    this.currentLoopNum = i;
                    break;
                }
                if (currentSample > loop.endSample || loop.endSample > nextCurrentSample || this.currentLoopNum != i) continue;
                if (this.loopNum == 0) {
                    this.currentLoopNum = -1;
                    continue;
                }
                log.info((Object)String.format("Replaying atrac loop atracID=%d, loopStart=%d, loopEnd=%d", this.id, loop.startSample, loop.endSample));
                this.setPlayPosition(loop.startSample, this.loopStartBytesWrittenFirstBuf, this.loopStartBytesWrittenSecondBuf);
                nextCurrentSample = loop.startSample;
                if (this.loopNum <= 0) break;
                --this.loopNum;
                break;
            }
            this.setAtracCurrentSample(nextCurrentSample);
        }

        public void setPlayPosition(int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
            if (sample != this.getAtracCurrentSample()) {
                this.setInputBufferOffset(this.getInputBufferSize() - bytesWrittenFirstBuf);
                this.setAtracCurrentSample(sample);
                this.getAtracCodec().atracResetPlayPosition(sample);
                int position = this.getAtracCodec().getChannelPosition();
                if (position >= 0) {
                    this.setInputFileOffset(position);
                } else {
                    this.setInputFileOffset(0);
                }
                if (this.getInputBufferSize() < this.getInputFileSize() && !this.getAtracCodec().isExternalAudio()) {
                    this.getAtracCodec().resetChannel();
                    this.forceReloadOfData = true;
                } else {
                    this.forceAllDataIsOnMemory = true;
                }
            }
        }

        private boolean hasLoop() {
            return this.numLoops > 0;
        }

        public int getLoopStatus() {
            if (!this.hasLoop()) {
                return 0;
            }
            return 1;
        }

        public int getLoopStartSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].startSample;
        }

        public int getLoopEndSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.loops[0].endSample;
        }

        public void update() {
            this.setInputBufferWritableBytes(this.getInputBufferOffset());
            if (this.getInputFileOffset() >= this.getInputFileSize()) {
                this.setInputBufferWritableBytes(0);
            } else if (this.getInputBufferWritableBytes() > this.getInputFileSize() - this.getInputFileOffset()) {
                this.setInputBufferWritableBytes(this.getInputFileSize() - this.getInputFileOffset());
            }
        }

        public boolean isForceReloadOfData() {
            return this.forceReloadOfData;
        }

        public String toString() {
            return String.format("AtracID[id=%d, inputBufferAddr=0x%08X, inputBufferSize=%d, inputBufferOffset=%d, inputBufferWritableBytes=%d, inputBufferNeededBytes=%d]", this.id, this.inputBufferAddr, this.inputBufferSize, this.inputBufferOffset, this.inputBufferWritableBytes, this.inputBufferNeededBytes);
        }
    }

    protected static class LoopInfo {
        protected int cuePointID;
        protected int type;
        protected int startSample;
        protected int endSample;
        protected int fraction;
        protected int playCount;

        protected LoopInfo() {
        }

        public String toString() {
            return String.format("LoopInfo[cuePointID %d, type %d, startSample %d, endSample %d, fraction %d, playCount %d]", this.cuePointID, this.type, this.startSample, this.endSample, this.fraction, this.playCount);
        }
    }
}

