/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Allegrex.CpuState;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import org.apache.log4j.Logger;

public class sceWlan
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceWlan");

    @Override
    public String getName() {
        return "sceWlan";
    }

    @HLEFunction(nid=207757441, version=150, checkInsideInterrupt=true)
    public void sceWlanGetEtherAddr(Processor processor) {
        CpuState cpu = processor.cpu;
        Memory mem = Processor.memory;
        int ether_addr = cpu.gpr[4];
        if (log.isDebugEnabled()) {
            log.debug((Object)("sceWlanGetEtherAddr ether_addr=0x" + Integer.toHexString(ether_addr)));
        }
        if (Memory.isAddressGood(ether_addr)) {
            byte[] wlanAddr = Wlan.getMacAddress();
            for (int i = 0; i < wlanAddr.length; ++i) {
                mem.write8(ether_addr + i, wlanAddr[i]);
            }
            cpu.gpr[2] = 0;
        } else {
            cpu.gpr[2] = -2143220461;
        }
    }

    @HLEFunction(nid=-680118631, version=150)
    public void sceWlanGetSwitchState(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceWlanGetSwitchState");
        }
        cpu.gpr[2] = Wlan.getSwitchState();
    }

    @HLEFunction(nid=-1824257263, version=150)
    public void sceWlanDevIsPowerOn(Processor processor) {
        CpuState cpu = processor.cpu;
        if (log.isDebugEnabled()) {
            log.debug((Object)"sceWlanDevIsPowerOn");
        }
        cpu.gpr[2] = Wlan.getSwitchState();
    }
}

