/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules500;

import java.util.HashMap;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules150.SysMemUserForUser;
import org.apache.log4j.Logger;

public class sceHeap
extends HLEModule {
    protected static Logger log = Modules.getLogger("sceHeap");
    protected static final int PSP_HEAP_ATTR_ADDR_HIGH = 16384;
    protected static final int PSP_HEAP_ATTR_EXT = 32768;
    private HashMap<Integer, SysMemUserForUser.SysMemInfo> heapMap = new HashMap();
    private HashMap<Integer, SysMemUserForUser.SysMemInfo> heapMemMap = new HashMap();

    @Override
    public String getName() {
        return "sceHeap";
    }

    @HLEFunction(nid=243751296, version=500, checkInsideInterrupt=true)
    public int sceHeapReallocHeapMemory(TPointer heapAddr, TPointer memAddr, int memSize) {
        log.warn((Object)String.format("Unimplemented sceHeapReallocHeapMemory heapAddr=%s, memAddr=%s, memSize=0x%X", heapAddr, memAddr, memSize));
        return 0;
    }

    @HLEFunction(nid=478459277, version=500, checkInsideInterrupt=true)
    public int sceHeapReallocHeapMemoryWithOption(TPointer heapAddr, TPointer memAddr, int memSize, TPointer paramAddr) {
        log.warn((Object)String.format("Unimplemented sceHeapReallocHeapMemoryWithOption heapAddr=%s, memAddr=%s, memSize=0x%X, paramAddr=%s", heapAddr, memAddr, memSize, paramAddr));
        return 0;
    }

    @HLEFunction(nid=716889187, version=500, checkInsideInterrupt=true)
    public int sceHeapFreeHeapMemory(TPointer heapAddr, TPointer memAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHeapFreeHeapMemory heapAddr=%s, memAddr=%s", heapAddr, memAddr));
        }
        if (this.heapMemMap.containsKey(memAddr.getAddress())) {
            Modules.SysMemUserForUserModule.free(this.heapMemMap.get(memAddr.getAddress()));
            return 0;
        }
        if (this.heapMap.containsKey(heapAddr.getAddress())) {
            return -2147483392;
        }
        return -2147483389;
    }

    @HLEFunction(nid=705437705, version=500, checkInsideInterrupt=true)
    public int sceHeapGetMallinfo(TPointer heapAddr, TPointer infoAddr) {
        log.warn((Object)String.format("Unimplemented sceHeapGetMallinfo heapAddr=%s, infoAddr=%s", heapAddr, infoAddr));
        return 0;
    }

    @HLEFunction(nid=728930776, version=500, checkInsideInterrupt=true)
    public int sceHeapAllocHeapMemoryWithOption(TPointer heapAddr, int memSize, @CanBeNull TPointer32 paramAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHeapAllocHeapMemoryWithOption heapAddr=%s, memSize=0x%X, paramAddr=%s", heapAddr, memSize, paramAddr));
        }
        if (paramAddr.isNotNull()) {
            int paramSize = paramAddr.getValue(0);
            if (paramSize == 8) {
                int memAlign = paramAddr.getValue(4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceHeapAllocHeapMemoryWithOption options: struct size=%d, alignment=0x%X", paramSize, memAlign));
                }
            } else {
                log.warn((Object)String.format("sceHeapAllocHeapMemoryWithOption option at %s(size=%d)", paramAddr, paramSize));
            }
        }
        SysMemUserForUser.SysMemInfo heapInfo = null;
        SysMemUserForUser.SysMemInfo heapMemInfo = null;
        if (this.heapMap.containsKey(heapAddr.getAddress())) {
            heapInfo = this.heapMap.get(heapAddr.getAddress());
            heapMemInfo = Modules.SysMemUserForUserModule.malloc(heapInfo.partitionid, "ThreadMan-HeapMem", heapInfo.type, memSize, 0);
        }
        if (heapMemInfo == null) {
            return 0;
        }
        this.heapMemMap.put(heapMemInfo.addr, heapMemInfo);
        return heapMemInfo.addr;
    }

    @HLEFunction(nid=1227469837, version=500, checkInsideInterrupt=true)
    public int sceHeapGetTotalFreeSize(TPointer heapAddr) {
        log.warn((Object)String.format("Unimplemented sceHeapGetTotalFreeSize heapAddr=%s", heapAddr));
        return 0;
    }

    @HLEFunction(nid=1880275933, version=500, checkInsideInterrupt=true)
    public int sceHeapIsAllocatedHeapMemory(TPointer heapAddr, TPointer memAddr) {
        log.warn((Object)String.format("Unimplemented sceHeapIsAllocatedHeapMemory heapAddr=%s, memAddr=%s", heapAddr, memAddr));
        return 0;
    }

    @HLEFunction(nid=1881213811, version=500, checkInsideInterrupt=true)
    public int sceHeapDeleteHeap(TPointer heapAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHeapDeleteHeap heapAddr=%s", heapAddr));
        }
        if (!this.heapMap.containsKey(heapAddr.getAddress())) {
            return -2147483392;
        }
        Modules.SysMemUserForUserModule.free(this.heapMap.get(heapAddr.getAddress()));
        return 0;
    }

    @HLEFunction(nid=2111996354, version=500, checkInsideInterrupt=true)
    public int sceHeapCreateHeap(PspString name, int heapSize, int attr, @CanBeNull TPointer paramAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHeapCreateHeap name=%s, heapSize=0x%X, attr=0x%X, paramAddr=%s", name, heapSize, attr, paramAddr));
        }
        if (paramAddr.isNotNull()) {
            log.warn((Object)String.format("sceHeapCreateHeap unknown option at %s", paramAddr));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        SysMemUserForUser.SysMemInfo info = null;
        int alignment = 4;
        int totalHeapSize = heapSize + (alignment - 1) & ~(alignment - 1);
        int maxFreeSize = Modules.SysMemUserForUserModule.maxFreeMemSize();
        if (totalHeapSize <= maxFreeSize) {
            info = Modules.SysMemUserForUserModule.malloc(2, name.getString(), memType, totalHeapSize, 0);
        } else {
            log.warn((Object)String.format("sceHeapCreateHeap not enough free mem (want=%d, free=%d, diff=%d", totalHeapSize, maxFreeSize, totalHeapSize - maxFreeSize));
        }
        if (info == null) {
            return 0;
        }
        this.heapMap.put(info.addr, info);
        return info.addr;
    }

    @HLEFunction(nid=-1461648736, version=500, checkInsideInterrupt=true)
    public int sceHeapAllocHeapMemory(TPointer heapAddr, int memSize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceHeapAllocHeapMemoryWithOption heapAddr=%s, memSize=0x%X", heapAddr, memSize));
        }
        SysMemUserForUser.SysMemInfo heapInfo = null;
        SysMemUserForUser.SysMemInfo heapMemInfo = null;
        if (this.heapMap.containsKey(heapAddr.getAddress())) {
            heapInfo = this.heapMap.get(heapAddr.getAddress());
            heapMemInfo = Modules.SysMemUserForUserModule.malloc(heapInfo.partitionid, "ThreadMan-HeapMem", heapInfo.type, memSize, 0);
        }
        if (heapMemInfo == null) {
            return 0;
        }
        this.heapMemMap.put(heapMemInfo.addr, heapMemInfo);
        return heapMemInfo.addr;
    }
}

