/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class Elf32EntHeader {
    private String modulenamez = "";
    private long modulename;
    private int version;
    private int attr;
    private short size;
    private short vcount;
    private int fcount;
    private long resident;

    public static int sizeof() {
        return 16;
    }

    public Elf32EntHeader(ByteBuffer f) throws IOException {
        this.modulename = Utilities.readUWord(f);
        this.version = Utilities.readUHalf(f);
        this.attr = Utilities.readUHalf(f);
        this.size = Utilities.readUByte(f);
        this.vcount = Utilities.readUByte(f);
        this.fcount = Utilities.readUHalf(f);
        this.resident = Utilities.readUWord(f);
    }

    public Elf32EntHeader(Memory mem, int address) {
        this.modulename = mem.read32(address);
        this.version = mem.read16(address + 4);
        this.attr = mem.read16(address + 6);
        this.size = (short)mem.read8(address + 8);
        this.vcount = (short)mem.read8(address + 9);
        this.fcount = mem.read16(address + 10);
        this.resident = mem.read32(address + 12);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.modulenamez != null && this.modulenamez.length() > 0) {
            str.append(this.modulenamez + "\n");
        }
        str.append("modulename\t" + Utilities.formatString("long", Long.toHexString(this.modulename & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("version\t\t" + Utilities.formatString("short", Long.toHexString(this.version & 0xFFFF).toUpperCase()) + "\n");
        str.append("attr\t\t" + Utilities.formatString("short", Long.toHexString(this.attr & 0xFFFF).toUpperCase()) + "\n");
        str.append("size\t\t" + Utilities.formatString("byte", Long.toHexString(this.size & 0xFFFF).toUpperCase()) + "\n");
        str.append("vcount\t\t" + Utilities.formatString("byte", Long.toHexString(this.vcount & 0xFFFF).toUpperCase()) + "\n");
        str.append("fcount\t\t" + Utilities.formatString("short", Long.toHexString(this.fcount & 0xFFFF).toUpperCase()) + "\n");
        str.append("resident\t\t" + Utilities.formatString("long", Long.toHexString(this.resident & 0xFFFFFFFFL).toUpperCase()) + "\n");
        return str.toString();
    }

    public String getModuleNamez() {
        return this.modulenamez;
    }

    public void setModuleNamez(String moduleName) {
        this.modulenamez = moduleName;
    }

    public long getOffsetModuleName() {
        return this.modulename;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAttr() {
        return this.attr;
    }

    public int getSize() {
        return this.size;
    }

    public int getVariableCount() {
        return this.vcount;
    }

    public int getFunctionCount() {
        return this.fcount;
    }

    public long getOffsetResident() {
        return this.resident;
    }
}

