/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.util.Utilities;

public class Elf32Relocate {
    private long r_offset;
    private long r_info;

    public static int sizeof() {
        return 8;
    }

    public void read(ByteBuffer f) throws IOException {
        this.setR_offset(Utilities.readUWord(f));
        this.setR_info(Utilities.readUWord(f));
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("r_offset \t " + Utilities.formatString("long", Long.toHexString(this.getR_offset() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("r_info \t\t " + Utilities.formatString("long", Long.toHexString(this.getR_info() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        return str.toString();
    }

    public long getR_offset() {
        return this.r_offset;
    }

    public void setR_offset(long r_offset) {
        this.r_offset = r_offset;
    }

    public long getR_info() {
        return this.r_info;
    }

    public void setR_info(long r_info) {
        this.r_info = r_info;
    }
}

