/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import java.util.Arrays;
import java.util.HashMap;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.software.BaseRenderer;
import jpcsp.graphics.RE.software.CachedTextureResampled;
import jpcsp.graphics.RE.software.FilterCompiler;
import jpcsp.graphics.RE.software.IRendererWriter;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.RE.software.PixelState;
import jpcsp.graphics.RE.software.PrimitiveState;
import jpcsp.graphics.RE.software.RendererTemplate;
import jpcsp.graphics.RE.software.RendererWriter;
import jpcsp.graphics.VertexState;
import jpcsp.util.DurationStatistics;
import jpcsp.util.LongLongKey;
import jpcsp.util.Utilities;

public abstract class BasePrimitiveRenderer
extends BaseRenderer {
    private static HashMap<Integer, DurationStatistics> pixelsStatistics = new HashMap();
    private DurationStatistics pixelStatistics = new DurationStatistics();
    public final PixelState pixel = new PixelState();
    public PrimitiveState prim = new PrimitiveState();
    protected boolean needScissoringX;
    protected boolean needScissoringY;
    protected boolean needSourceDepthRead;
    protected boolean needDestinationDepthRead;
    protected boolean needDepthWrite;
    protected boolean needTextureUV;
    protected boolean swapTextureUV;
    protected boolean simpleTextureUV;
    protected boolean needTextureWrapU;
    protected boolean needTextureWrapV;
    protected boolean sameVertexColor;
    protected boolean needSourceDepthClamp;
    public int fbAddress;
    public int depthAddress;
    public IRendererWriter rendererWriter;

    protected void copy(BasePrimitiveRenderer from) {
        super.copy(from);
        this.pixel.copy(from.pixel);
        this.prim.copy(from.prim);
        this.needScissoringX = from.needScissoringX;
        this.needScissoringY = from.needScissoringY;
        this.needSourceDepthRead = from.needSourceDepthRead;
        this.needDestinationDepthRead = from.needDestinationDepthRead;
        this.needDepthWrite = from.needDepthWrite;
        this.needTextureUV = from.needTextureUV;
        this.simpleTextureUV = from.simpleTextureUV;
        this.needTextureWrapU = from.needTextureWrapU;
        this.needTextureWrapV = from.needTextureWrapV;
        this.sameVertexColor = from.sameVertexColor;
        this.fbAddress = from.fbAddress;
        this.depthAddress = from.depthAddress;
        this.rendererWriter = from.rendererWriter;
        this.needSourceDepthClamp = from.needSourceDepthClamp;
    }

    @Override
    protected void init(GeContext context, CachedTextureResampled texture, boolean useVertexTexture, boolean isTriangle) {
        super.init(context, texture, useVertexTexture, isTriangle);
        this.prim.pxMax = Integer.MIN_VALUE;
        this.prim.pxMin = Integer.MAX_VALUE;
        this.prim.pyMax = Integer.MIN_VALUE;
        this.prim.pyMin = Integer.MAX_VALUE;
        this.prim.pzMax = Integer.MIN_VALUE;
        this.prim.pzMin = Integer.MAX_VALUE;
        if (!this.transform2D) {
            Utilities.matrixMult(this.pixel.modelViewMatrix, context.view_uploaded_matrix, context.model_uploaded_matrix);
            Utilities.matrixMult(this.pixel.modelViewProjectionMatrix, context.proj_uploaded_matrix, this.pixel.modelViewMatrix);
        }
    }

    @Override
    protected void initRendering(GeContext context) {
        if (this.renderingInitialized) {
            return;
        }
        super.initRendering(context);
        this.pixel.materialAmbient = PixelColor.getColor(context.mat_ambient);
        this.pixel.materialDiffuse = PixelColor.getColor(context.mat_diffuse);
        this.pixel.materialSpecular = PixelColor.getColor(context.mat_specular);
        if (!this.transform2D) {
            if (context.tex_map_mode == 1) {
                System.arraycopy(context.texture_uploaded_matrix, 0, this.pixel.textureMatrix, 0, this.pixel.textureMatrix.length);
            }
            boolean bl = this.pixel.hasNormal = context.vinfo.normal != 0;
            if (this.pixel.hasNormal) {
                float[] invertedModelViewMatrix = new float[16];
                if (Utilities.invertMatrix3x3(invertedModelViewMatrix, this.pixel.modelViewMatrix)) {
                    Utilities.transposeMatrix3x3(this.pixel.normalMatrix, invertedModelViewMatrix);
                } else {
                    System.arraycopy(this.pixel.modelViewMatrix, 0, this.pixel.normalMatrix, 0, this.pixel.normalMatrix.length);
                    if (this.isLogDebugEnabled) {
                        log.debug((Object)String.format("ModelView matrix cannot be inverted, taking the Model-View matrix itself!", new Object[0]));
                    }
                }
            }
        }
    }

    protected void addPosition(float[] p) {
        float[] screenCoordinates = new float[4];
        this.getScreenCoordinates(screenCoordinates, p);
        this.prim.pxMax = Utilities.maxInt(this.prim.pxMax, screenCoordinates[0]);
        this.prim.pxMin = Utilities.minInt(this.prim.pxMin, screenCoordinates[0]);
        this.prim.pyMax = Utilities.maxInt(this.prim.pyMax, screenCoordinates[1]);
        this.prim.pyMin = Utilities.minInt(this.prim.pyMin, screenCoordinates[1]);
        this.prim.pzMax = Utilities.maxInt(this.prim.pzMax, screenCoordinates[2]);
        this.prim.pzMin = Utilities.minInt(this.prim.pzMin, screenCoordinates[2]);
    }

    protected void setVertexPositions(VertexState v1, VertexState v2, VertexState v3) {
        this.setPositions(v1, v2, v3);
    }

    protected void setVertexPositions(VertexState v1, VertexState v2) {
        this.setPositions(v1, v2);
    }

    protected void setVertexTextures(GeContext context, VertexState v1, VertexState v2, VertexState v3) {
        this.setTextures(v1, v2, v3);
        this.setVertexTextures(context, v1.c, v2.c, v3.c);
    }

    protected void setVertexTextures(GeContext context, VertexState v1, VertexState v2) {
        this.setTextures(v1, v2);
        this.setVertexTextures(context, v1.c, v2.c, null);
    }

    private void setVertexTextures(GeContext context, float[] c1, float[] c2, float[] c3) {
        this.textureWidth = context.texture_width[this.mipmapLevel];
        this.textureHeight = context.texture_height[this.mipmapLevel];
        if (this.transform2D) {
            --this.prim.pxMax;
            --this.prim.pyMax;
        } else {
            if (this.needScissoringX) {
                this.prim.pxMin = Utilities.max(this.prim.pxMin, this.scissorX1);
                this.prim.pxMax = Utilities.min(this.prim.pxMax, this.scissorX2);
                this.needScissoringX = false;
            }
            if (this.needScissoringY) {
                this.prim.pyMin = Utilities.max(this.prim.pyMin, this.scissorY1);
                this.prim.pyMax = Utilities.min(this.prim.pyMax, this.scissorY2);
                this.needScissoringY = false;
            }
        }
        this.prim.destinationWidth = this.prim.pxMax - this.prim.pxMin + 1;
        this.prim.destinationHeight = this.prim.pyMax - this.prim.pyMin + 1;
        if (this.isUsingTexture(context)) {
            boolean bl = this.simpleTextureUV = !this.isTriangle;
            if (!this.simpleTextureUV && this.isTriangle && this.transform2D) {
                if (this.prim.p1x == this.prim.p2x && this.prim.t1u == this.prim.t2u) {
                    if (this.prim.p1y == this.prim.p3y && this.prim.t1v == this.prim.t3v) {
                        this.simpleTextureUV = true;
                    } else if (this.prim.p2y == this.prim.p3y && this.prim.t2v == this.prim.t3v) {
                        this.simpleTextureUV = true;
                    }
                } else if (this.prim.p1x == this.prim.p3x && this.prim.t1u == this.prim.t3u) {
                    if (this.prim.p1y == this.prim.p2y && this.prim.t1v == this.prim.t2v) {
                        this.simpleTextureUV = true;
                    } else if (this.prim.p2y == this.prim.p3y && this.prim.t2v == this.prim.t3v) {
                        this.simpleTextureUV = true;
                    }
                } else if (this.prim.p2x == this.prim.p3x && this.prim.t2u == this.prim.t3u) {
                    if (this.prim.p1y == this.prim.p2y && this.prim.t1v == this.prim.t2v) {
                        this.simpleTextureUV = true;
                    } else if (this.prim.p1y == this.prim.p1y && this.prim.t2v == this.prim.t3v) {
                        this.simpleTextureUV = true;
                    }
                }
            }
            if (this.simpleTextureUV) {
                if (this.transform2D) {
                    boolean flipX = false;
                    boolean flipY = false;
                    if (this.isTriangle) {
                        if (this.prim.t1u != this.prim.t2u) {
                            flipX = this.prim.t1u > this.prim.t2u ^ this.prim.p1x > this.prim.p2x;
                        }
                        if (this.prim.t1v != this.prim.t2v) {
                            flipY = this.prim.t1v > this.prim.t2v ^ this.prim.p1y > this.prim.p2y;
                        }
                        if (!flipX && this.prim.t2u != this.prim.t3u) {
                            flipX = this.prim.t2u > this.prim.t3u ^ this.prim.p2x > this.prim.p3x;
                        }
                        if (!flipY && this.prim.t2v != this.prim.t3v) {
                            flipY = this.prim.t2v > this.prim.t3v ^ this.prim.p2y > this.prim.p3y;
                        }
                    } else {
                        flipX = this.prim.t1u > this.prim.t2u ^ this.prim.p1x > this.prim.p2x;
                        flipY = this.prim.t1v > this.prim.t2v ^ this.prim.p1y > this.prim.p2y;
                        if (flipX && flipY) {
                            this.swapTextureUV = true;
                            flipX = false;
                            flipY = false;
                        }
                    }
                    if (this.isLogTraceEnabled) {
                        log.trace((Object)String.format("2D texture flipX=%b, flipY=%b, swapUV=%b, point (%d,%d)-(%d,%d), texture (%d,%d)-(%d,%d)", flipX, flipY, this.swapTextureUV, this.prim.pxMin, this.prim.pyMin, this.prim.pxMax, this.prim.pyMax, this.prim.tuMin, this.prim.tvMin, this.prim.tuMax, this.prim.tvMax));
                    }
                    this.prim.uStart = flipX ? (float)this.prim.tuMax : (float)this.prim.tuMin;
                    float uEnd = flipX ? (float)this.prim.tuMin : (float)this.prim.tuMax;
                    this.prim.vStart = flipY ? (float)this.prim.tvMax : (float)this.prim.tvMin;
                    float vEnd = flipY ? (float)this.prim.tvMin : (float)this.prim.tvMax;
                    this.prim.uStep = (uEnd - this.prim.uStart) / (float)(this.swapTextureUV ? this.prim.destinationHeight : this.prim.destinationWidth);
                    this.prim.vStep = (vEnd - this.prim.vStart) / (float)(this.swapTextureUV ? this.prim.destinationWidth : this.prim.destinationHeight);
                } else {
                    this.prim.uStart = this.prim.t1u;
                    float uEnd = this.prim.t2u;
                    this.prim.vStart = this.prim.t1v;
                    float vEnd = this.prim.t2v;
                    this.prim.uStep = this.prim.p1x == this.prim.p2x ? 1.0f : (uEnd - this.prim.uStart) / Math.abs(this.prim.p2x - this.prim.p1x);
                    this.prim.vStep = this.prim.p1y == this.prim.p2y ? 1.0f : (vEnd - this.prim.vStart) / Math.abs(this.prim.p2y - this.prim.p1y);
                    if (this.isLogTraceEnabled) {
                        log.trace((Object)String.format("3D sprite uStart=%f, uStep=%f, vStart=%f, vStep=%f, texTranslateX=%f, texTranslateY=%f, texScaleX=%f, texScaleY=%f, point (%d,%d)-(%d,%d), texture (%d,%d)-(%d,%d)", Float.valueOf(this.prim.uStart), Float.valueOf(this.prim.uStep), Float.valueOf(this.prim.vStart), Float.valueOf(this.prim.vStep), Float.valueOf(this.texTranslateX), Float.valueOf(this.texTranslateY), Float.valueOf(this.texScaleX), Float.valueOf(this.texScaleY), this.prim.pxMin, this.prim.pyMin, this.prim.pxMax, this.prim.pyMax, this.prim.tuMin, this.prim.tvMin, this.prim.tuMax, this.prim.tvMax));
                    }
                }
                if (this.needScissoringX) {
                    int deltaX = this.scissorX1 - this.prim.pxMin;
                    if (deltaX > 0) {
                        this.prim.uStart += this.prim.uStep * (float)deltaX;
                        this.prim.pxMin += deltaX;
                        if (this.transform2D) {
                            this.prim.tuMin += Utilities.round(this.prim.uStep * (float)deltaX);
                        }
                    }
                    if ((deltaX = this.prim.pxMax - this.scissorX2) > 0) {
                        this.prim.pxMax -= deltaX;
                        if (this.transform2D) {
                            this.prim.tuMax -= Utilities.round(this.prim.uStep * (float)deltaX);
                        }
                    }
                    this.prim.destinationWidth = this.prim.pxMax - this.prim.pxMin + 1;
                    this.needScissoringX = false;
                }
                if (this.needScissoringY) {
                    int deltaY = this.scissorY1 - this.prim.pyMin;
                    if (deltaY > 0) {
                        this.prim.vStart += this.prim.vStep * (float)deltaY;
                        this.prim.pyMin += deltaY;
                        if (this.transform2D) {
                            this.prim.tvMin += Utilities.round(this.prim.vStep * (float)deltaY);
                        }
                    }
                    if ((deltaY = this.prim.pyMax - this.scissorY2) > 0) {
                        this.prim.pyMax -= deltaY;
                        if (this.transform2D) {
                            this.prim.tvMax -= Utilities.round(this.prim.vStep * (float)deltaY);
                        }
                    }
                    this.prim.destinationHeight = this.prim.pyMax - this.prim.pyMin + 1;
                    this.needScissoringY = false;
                }
            }
        }
        if (this.setVertexPrimaryColor) {
            if (c3 != null) {
                this.pixel.c1a = PixelColor.getColor(c1[3]);
                this.pixel.c1b = PixelColor.getColor(c1[2]);
                this.pixel.c1g = PixelColor.getColor(c1[1]);
                this.pixel.c1r = PixelColor.getColor(c1[0]);
                this.pixel.c2a = PixelColor.getColor(c2[3]);
                this.pixel.c2b = PixelColor.getColor(c2[2]);
                this.pixel.c2g = PixelColor.getColor(c2[1]);
                this.pixel.c2r = PixelColor.getColor(c2[0]);
                this.pixel.c3a = PixelColor.getColor(c3[3]);
                this.pixel.c3b = PixelColor.getColor(c3[2]);
                this.pixel.c3g = PixelColor.getColor(c3[1]);
                this.pixel.c3r = PixelColor.getColor(c3[0]);
                this.pixel.c3 = PixelColor.getColor(c3);
            }
            if (this.isTriangle) {
                this.sameVertexColor = context.shadeModel == 0 ? true : Utilities.sameColor(c1, c2, c3);
            } else {
                this.primaryColor = PixelColor.getColor(c2);
                if (context.textureColorDoubled) {
                    this.primaryColor = PixelColor.doubleColor(this.primaryColor);
                }
            }
        }
        this.needDepthWrite = this.getNeedDepthWrite(context);
        this.needSourceDepthRead = this.needDepthWrite || this.getNeedSourceDepthRead(context);
        this.needDestinationDepthRead = this.getNeedDestinationDepthRead(context, this.needDepthWrite);
        if (this.zbw <= 0) {
            this.needDepthWrite = false;
            this.needSourceDepthRead = false;
            this.needDestinationDepthRead = false;
        }
        this.needTextureUV = this.getNeedTextureUV(context);
        if (this.transform2D) {
            this.needTextureWrapU = this.prim.tuMin < 0 || this.prim.tuMax >= context.texture_width[this.mipmapLevel];
            this.needTextureWrapV = this.prim.tvMin < 0 || this.prim.tvMax >= context.texture_height[this.mipmapLevel];
        } else if (context.tex_map_mode != 0) {
            this.needTextureWrapU = true;
            this.needTextureWrapV = true;
        } else {
            float tvMax;
            float tvMin;
            float tuMax;
            float tuMin;
            if (this.isTriangle) {
                tuMin = Utilities.min(this.prim.t1u, Utilities.min(this.prim.t2u, this.prim.t3u));
                tuMax = Utilities.max(this.prim.t1u, Utilities.max(this.prim.t2u, this.prim.t3u));
                tvMin = Utilities.min(this.prim.t1v, Utilities.min(this.prim.t2v, this.prim.t3v));
                tvMax = Utilities.max(this.prim.t1v, Utilities.max(this.prim.t2v, this.prim.t3v));
            } else {
                tuMin = Utilities.min(this.prim.t1u, this.prim.t2u);
                tuMax = Utilities.max(this.prim.t1u, this.prim.t2u);
                tvMin = Utilities.min(this.prim.t1v, this.prim.t2v);
                tvMax = Utilities.max(this.prim.t1v, this.prim.t2v);
            }
            tuMin = tuMin * this.texScaleX + this.texTranslateX;
            tuMax = tuMax * this.texScaleX + this.texTranslateX;
            tvMin = tvMin * this.texScaleY + this.texTranslateY;
            tvMax = tvMax * this.texScaleY + this.texTranslateY;
            this.needTextureWrapU = tuMin < 0.0f || tuMin >= 0.99999f || tuMax < 0.0f || tuMax >= 0.99999f;
            this.needTextureWrapV = tvMin < 0.0f || tvMin >= 0.99999f || tvMax < 0.0f || tvMax >= 0.99999f;
        }
        this.needSourceDepthClamp = false;
        if (this.needDepthWrite && this.needSourceDepthRead && this.isTriangle) {
            if (this.prim.p1z < 0.0f || this.prim.p2z < 0.0f || this.prim.p3z < 0.0f) {
                this.needSourceDepthClamp = true;
            } else if (this.prim.p1z > 65535.0f || this.prim.p2z > 65535.0f || this.prim.p3z > 65535.0f) {
                this.needSourceDepthClamp = true;
            }
        }
        this.prepareWriters();
        LongLongKey rendererKey = this.getRendererKey();
        if (this.compiledRenderer == null || !rendererKey.equals(this.compiledRendererKey)) {
            this.compiledRendererKey = rendererKey;
            this.compiledRenderer = FilterCompiler.getInstance().getCompiledRenderer(this, rendererKey, context);
            if (this.isLogTraceEnabled) {
                log.trace((Object)String.format("Rendering using compiled renderer %s", this.compiledRenderer.getClass().getName()));
            }
        }
        if (c3 != null) {
            this.prim.preComputeTriangleWeights();
        }
    }

    private boolean getNeedSourceDepthRead(GeContext context) {
        if (!this.clearMode && context.depthTestFlag.isEnabled() && context.depthFunc != 0 && context.depthFunc != 1) {
            return true;
        }
        return !this.clearMode && !this.transform2D && (this.nearZ != 0 || this.farZ != 65535);
    }

    private boolean getNeedDestinationDepthRead(GeContext context, boolean needDepthWrite) {
        if (!this.clearMode && context.depthTestFlag.isEnabled() && context.depthFunc != 0 && context.depthFunc != 1) {
            return true;
        }
        if (this.clearMode) {
            if (!context.clearModeDepth) {
                return true;
            }
        } else {
            if (!context.depthTestFlag.isEnabled() && needDepthWrite) {
                return true;
            }
            if (!context.depthMask && needDepthWrite) {
                return true;
            }
        }
        return false;
    }

    private boolean getNeedDepthWrite(GeContext context) {
        if (this.clearMode) {
            if (!context.clearModeDepth) {
                return false;
            }
        } else {
            if (!context.depthTestFlag.isEnabled()) {
                return false;
            }
            if (!context.depthMask) {
                return false;
            }
        }
        return true;
    }

    private boolean getNeedTextureUV(GeContext context) {
        return context.textureFlag.isEnabled() && (!this.transform2D || this.useVertexTexture) && !this.clearMode;
    }

    private static final int positionCoordinate2D(float value) {
        return (int)(value + 0.437f);
    }

    private void setPositions(VertexState v1, VertexState v2) {
        this.pixel.v1x = v1.p[0];
        this.pixel.v1y = v1.p[1];
        this.pixel.v1z = v1.p[2];
        this.pixel.n1x = v1.n[0];
        this.pixel.n1y = v1.n[1];
        this.pixel.n1z = v1.n[2];
        this.pixel.v2x = v2.p[0];
        this.pixel.v2y = v2.p[1];
        this.pixel.v2z = v2.p[2];
        this.pixel.n2x = v2.n[0];
        this.pixel.n2y = v2.n[1];
        this.pixel.n2z = v2.n[2];
        if (this.transform2D) {
            this.prim.p1x = this.pixel.v1x;
            this.prim.p1y = this.pixel.v1y;
            this.prim.p1z = this.pixel.v1z;
            this.prim.p2x = this.pixel.v2x;
            this.prim.p2y = this.pixel.v2y;
            this.prim.p2z = this.pixel.v2z;
            this.prim.pxMax = Utilities.maxInt(this.prim.p1x, this.prim.p2x);
            this.prim.pxMin = Utilities.minInt(this.prim.p1x, this.prim.p2x);
            this.prim.pyMax = Utilities.maxInt(this.prim.p1y, this.prim.p2y);
            this.prim.pyMin = Utilities.minInt(this.prim.p1y, this.prim.p2y);
            this.prim.pzMax = Utilities.maxInt(this.prim.p1z, this.prim.p2z);
            this.prim.pzMin = Utilities.minInt(this.prim.p1z, this.prim.p2z);
        } else {
            float[] screenCoordinates = new float[4];
            this.getScreenCoordinates(screenCoordinates, this.pixel.v1x, this.pixel.v1y, this.pixel.v1z);
            this.prim.p1x = screenCoordinates[0];
            this.prim.p1y = screenCoordinates[1];
            this.prim.p1z = screenCoordinates[2];
            this.prim.p1w = screenCoordinates[3];
            this.prim.p1wInverted = 1.0f / this.prim.p1w;
            this.getScreenCoordinates(screenCoordinates, this.pixel.v2x, this.pixel.v2y, this.pixel.v2z);
            this.prim.p2x = screenCoordinates[0];
            this.prim.p2y = screenCoordinates[1];
            this.prim.p2z = screenCoordinates[2];
            this.prim.p2w = screenCoordinates[3];
            this.prim.p2wInverted = 1.0f / this.prim.p2w;
            this.prim.pxMax = Utilities.maxInt(this.prim.p1x, this.prim.p2x);
            this.prim.pxMin = Utilities.minInt(this.prim.p1x, this.prim.p2x);
            this.prim.pyMax = Utilities.maxInt(this.prim.p1y, this.prim.p2y);
            this.prim.pyMin = Utilities.minInt(this.prim.p1y, this.prim.p2y);
            this.prim.pzMax = Utilities.maxInt(this.prim.p1z, this.prim.p2z);
            this.prim.pzMin = Utilities.minInt(this.prim.p1z, this.prim.p2z);
        }
    }

    private void setPositions(VertexState v1, VertexState v2, VertexState v3) {
        this.setPositions(v1, v2);
        this.pixel.v3x = v3.p[0];
        this.pixel.v3y = v3.p[1];
        this.pixel.v3z = v3.p[2];
        this.pixel.n3x = v3.n[0];
        this.pixel.n3y = v3.n[1];
        this.pixel.n3z = v3.n[2];
        if (this.transform2D) {
            this.prim.p3x = this.pixel.v3x;
            this.prim.p3y = this.pixel.v3y;
            this.prim.p3z = this.pixel.v3z;
            this.prim.pxMax = Utilities.maxInt(this.prim.pxMax, this.prim.p3x);
            this.prim.pxMin = Utilities.minInt(this.prim.pxMin, this.prim.p3x);
            this.prim.pyMax = Utilities.maxInt(this.prim.pyMax, this.prim.p3y);
            this.prim.pyMin = Utilities.minInt(this.prim.pyMin, this.prim.p3y);
            this.prim.pzMax = Utilities.maxInt(this.prim.pzMax, this.prim.p3z);
            this.prim.pzMin = Utilities.minInt(this.prim.pzMin, this.prim.p3z);
        } else {
            float[] screenCoordinates = new float[4];
            this.getScreenCoordinates(screenCoordinates, this.pixel.v3x, this.pixel.v3y, this.pixel.v3z);
            this.prim.p3x = screenCoordinates[0];
            this.prim.p3y = screenCoordinates[1];
            this.prim.p3z = screenCoordinates[2];
            this.prim.p3w = screenCoordinates[3];
            this.prim.p3wInverted = 1.0f / this.prim.p3w;
            this.prim.pxMax = Utilities.maxInt(this.prim.pxMax, this.prim.p3x);
            this.prim.pxMin = Utilities.minInt(this.prim.pxMin, this.prim.p3x);
            this.prim.pyMax = Utilities.maxInt(this.prim.pyMax, this.prim.p3y);
            this.prim.pyMin = Utilities.minInt(this.prim.pyMin, this.prim.p3y);
            this.prim.pzMax = Utilities.maxInt(this.prim.pzMax, this.prim.p3z);
            this.prim.pzMin = Utilities.minInt(this.prim.pzMin, this.prim.p3z);
        }
    }

    private void setTextures(VertexState v1, VertexState v2) {
        this.prim.t1u = v1.t[0];
        this.prim.t1v = v1.t[1];
        this.prim.t2u = v2.t[0];
        this.prim.t2v = v2.t[1];
        if (this.transform2D) {
            this.prim.tuMax = Utilities.max(Utilities.round(this.prim.t1u), Utilities.round(this.prim.t2u));
            this.prim.tuMin = Utilities.min(Utilities.round(this.prim.t1u), Utilities.round(this.prim.t2u));
            this.prim.tvMax = Utilities.max(Utilities.round(this.prim.t1v), Utilities.round(this.prim.t2v));
            this.prim.tvMin = Utilities.min(Utilities.round(this.prim.t1v), Utilities.round(this.prim.t2v));
        }
    }

    private void setTextures(VertexState v1, VertexState v2, VertexState v3) {
        this.setTextures(v1, v2);
        this.prim.t3u = v3.t[0];
        this.prim.t3v = v3.t[1];
        if (this.transform2D) {
            this.prim.tuMax = Utilities.max(this.prim.tuMax, Utilities.round(this.prim.t3u));
            this.prim.tuMin = Utilities.min(this.prim.tuMin, Utilities.round(this.prim.t3u));
            this.prim.tvMax = Utilities.max(this.prim.tvMax, Utilities.round(this.prim.t3v));
            this.prim.tvMin = Utilities.min(this.prim.tvMin, Utilities.round(this.prim.t3v));
        }
    }

    private void prepareWriters() {
        this.fbAddress = this.getTextureAddress(this.fbp, this.prim.pxMin, this.prim.pyMin, this.fbw, this.psm);
        this.depthAddress = this.getTextureAddress(this.zbp, this.prim.pxMin, this.prim.pyMin, this.zbw, 6);
        if (!RendererTemplate.isRendererWriterNative(this.memInt, this.psm)) {
            this.rendererWriter = RendererWriter.getRendererWriter(this.fbAddress, this.fbw, this.psm, this.depthAddress, this.zbw, 6, this.needDestinationDepthRead, this.needDepthWrite);
        }
        this.imageWriterSkipEOL = this.fbw - this.prim.destinationWidth;
        this.depthWriterSkipEOL = this.zbw - this.prim.destinationWidth;
    }

    protected boolean isVisible() {
        if (!this.transform2D) {
            if (this.prim.pxMin + this.screenOffsetX < 0 || this.prim.pxMax + this.screenOffsetX >= 4096 || this.prim.pyMin + this.screenOffsetY < 0 || this.prim.pyMax + this.screenOffsetY >= 4096 || this.prim.pzMax >= 65536) {
                if (this.isLogTraceEnabled) {
                    log.trace((Object)String.format("Screen coordinates outside valid range %d-%d, %d-%d, %d", this.prim.pxMin + this.screenOffsetX, this.prim.pxMax + this.screenOffsetX, this.prim.pyMin + this.screenOffsetY, this.prim.pyMax + this.screenOffsetY, this.prim.pzMax));
                }
                return false;
            }
            if (this.prim.pzMin < 0 && this.prim.pzMax > 0 && this.prim.pzMax - this.prim.pzMin > 65536) {
                if (this.isLogTraceEnabled) {
                    log.trace((Object)String.format("Z range too large: %d, %d", this.prim.pzMin, this.prim.pzMax));
                }
                return false;
            }
            if (!this.clipPlanesEnabled) {
                if (this.prim.pzMin < 0) {
                    if (this.isLogTraceEnabled) {
                        log.trace((Object)String.format("Z behind clip plane %d", this.prim.pzMin));
                    }
                    return false;
                }
            } else if (this.prim.p1w < 0.0f || this.prim.p2w < 0.0f || this.prim.p3w < 0.0f) {
                if (this.isLogTraceEnabled) {
                    log.trace((Object)String.format("W negative %f, %f, %f", Float.valueOf(this.prim.p1w), Float.valueOf(this.prim.p2w), Float.valueOf(this.prim.p3w)));
                }
                return false;
            }
        }
        if (!this.useVertexTexture) {
            this.prim.pxMin = Math.max(this.prim.pxMin, this.scissorX1);
            this.prim.pxMax = Math.min(this.prim.pxMax, Math.min(this.scissorX2 + 1, this.fbw));
            this.prim.pyMin = Math.max(this.prim.pyMin, this.scissorY1);
            this.prim.pyMax = Math.min(this.prim.pyMax, this.scissorY2 + 1);
        }
        if (this.prim.pxMin == this.prim.pxMax || this.prim.pyMin == this.prim.pyMax) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)"Empty area");
            }
            return false;
        }
        if (this.isTriangle && (this.pixel.v1x == this.pixel.v2x && this.pixel.v1y == this.pixel.v2y && this.pixel.v1z == this.pixel.v2z || this.pixel.v1x == this.pixel.v3x && this.pixel.v1y == this.pixel.v3y && this.pixel.v1z == this.pixel.v3z || this.pixel.v2x == this.pixel.v3x && this.pixel.v2y == this.pixel.v3y && this.pixel.v2z == this.pixel.v3z)) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)"2 vertices equal in triangle");
            }
            return false;
        }
        if (!this.insideScissor()) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)"Not inside scissor");
            }
            return false;
        }
        return true;
    }

    protected boolean insideScissor() {
        this.needScissoringX = false;
        this.needScissoringY = false;
        if (this.prim.pxMax < this.scissorX1 || this.prim.pxMin > this.scissorX2) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)String.format("X outside scissor area %d-%d, %d-%d", this.prim.pxMin, this.prim.pxMax, this.scissorX1, this.scissorX2));
            }
            return false;
        }
        if (this.prim.pyMax < this.scissorY1 || this.prim.pyMin > this.scissorY2) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)String.format("Y outside scissor area %d-%d, %d-%d", this.prim.pyMin, this.prim.pyMax, this.scissorY1, this.scissorY2));
            }
            return false;
        }
        if (!this.transform2D && (this.nearZ > 0 && this.prim.pzMax < this.nearZ || this.farZ < 65535 && this.prim.pzMin > this.farZ)) {
            if (this.isLogTraceEnabled) {
                log.trace((Object)String.format("Z outside view area %d-%d, %d-%d", this.prim.pzMin, this.prim.pzMax, this.nearZ, this.farZ));
            }
            return false;
        }
        if (this.prim.pxMin < this.scissorX1 || this.prim.pxMax > this.scissorX2) {
            this.needScissoringX = true;
        }
        if (this.prim.pyMin < this.scissorY1 || this.prim.pyMax > this.scissorY2) {
            this.needScissoringY = true;
        }
        return true;
    }

    private void getScreenCoordinates(float[] screenCoordinates, float[] position) {
        this.getScreenCoordinates(screenCoordinates, position[0], position[1], position[2]);
    }

    private void getScreenCoordinates(float[] screenCoordinates, float x, float y, float z) {
        float[] position4 = new float[]{x, y, z, 1.0f};
        float[] projectedCoordinates = new float[4];
        Utilities.vectorMult44(projectedCoordinates, this.pixel.modelViewProjectionMatrix, position4);
        float w = projectedCoordinates[3];
        float wInverted = 1.0f / w;
        screenCoordinates[0] = projectedCoordinates[0] * wInverted * (float)this.viewportWidth + (float)this.viewportX - (float)this.screenOffsetX;
        screenCoordinates[1] = projectedCoordinates[1] * wInverted * (float)this.viewportHeight + (float)this.viewportY - (float)this.screenOffsetY;
        screenCoordinates[2] = projectedCoordinates[2] * wInverted * this.zscale + this.zpos;
        screenCoordinates[3] = w;
        if (this.isLogTraceEnabled) {
            log.trace((Object)String.format("X,Y,Z = %f, %f, %f, projected X,Y,Z,W = %f, %f, %f, %f -> Screen %.3f, %.3f, %.3f", Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(projectedCoordinates[0] / w), Float.valueOf(projectedCoordinates[1] / w), Float.valueOf(projectedCoordinates[2] / w), Float.valueOf(w), Float.valueOf(screenCoordinates[0]), Float.valueOf(screenCoordinates[1]), Float.valueOf(screenCoordinates[2])));
        }
    }

    @Override
    public void postRender() {
        if (this.rendererWriter != null) {
            this.rendererWriter.flush();
        }
        super.postRender();
        this.statisticsFilters(this.pixel.getNumberPixels());
    }

    @Override
    public void preRender() {
        this.pixel.reset();
        super.preRender();
    }

    protected void writerSkip(int count) {
        this.rendererWriter.skip(count, count);
    }

    protected void writerSkipEOL(int count) {
        this.rendererWriter.skip(count + this.imageWriterSkipEOL, count + this.depthWriterSkipEOL);
    }

    protected void writerSkipEOL() {
        this.rendererWriter.skip(this.imageWriterSkipEOL, this.depthWriterSkipEOL);
    }

    @Override
    public void render() {
        this.compiledRenderer.render(this);
    }

    public static void exit() {
        if (!log.isInfoEnabled() || pixelsStatistics.isEmpty()) {
            return;
        }
        Object[] sortedPixelsStatistics = pixelsStatistics.values().toArray(new DurationStatistics[pixelsStatistics.size()]);
        Arrays.sort(sortedPixelsStatistics);
        for (Object durationStatistics : sortedPixelsStatistics) {
            log.info(durationStatistics);
        }
    }

    protected LongLongKey getRendererKey() {
        LongLongKey key = new LongLongKey(this.baseRendererKey);
        key.addKeyComponent(this.needSourceDepthRead);
        key.addKeyComponent(this.needDestinationDepthRead);
        key.addKeyComponent(this.needDepthWrite);
        key.addKeyComponent(this.needTextureUV);
        key.addKeyComponent(this.simpleTextureUV);
        key.addKeyComponent(this.swapTextureUV);
        key.addKeyComponent(this.needScissoringX);
        key.addKeyComponent(this.needScissoringY);
        key.addKeyComponent(this.needTextureWrapU);
        key.addKeyComponent(this.needTextureWrapV);
        key.addKeyComponent(this.sameVertexColor);
        key.addKeyComponent(this.needSourceDepthClamp);
        return key;
    }
}

