/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.hardware.Audio;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoftwareSynthesizer;
import jpcsp.sound.SoundChannel;
import jpcsp.sound.SoundVoice;

public class SoundMixer {
    private SoundVoice[] voices;
    private SoftwareSynthesizer[] synthesizers;

    public SoundMixer(SoundVoice[] voices) {
        this.voices = voices;
        this.synthesizers = new SoftwareSynthesizer[voices.length];
        for (int i = 0; i < voices.length; ++i) {
            this.synthesizers[i] = new SoftwareSynthesizer(voices[i]);
        }
    }

    private static short clampSample(int sample) {
        if (sample < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (sample > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)sample;
    }

    private void mix(int[] stereoSamples, ISampleSource sampleSource, int startIndex, int length, int leftVol, int rightVol) {
        int endIndex = startIndex + length;
        sampleSource.setSampleIndex(startIndex);
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            short monoSample = sampleSource.getNextSample();
            int n = j;
            stereoSamples[n] = stereoSamples[n] + SoundChannel.adjustSample(monoSample, leftVol);
            int n2 = j + 1;
            stereoSamples[n2] = stereoSamples[n2] + SoundChannel.adjustSample(monoSample, rightVol);
            ++i;
            j += 2;
        }
    }

    private void copySamplesToMem(int[] mixedSamples, int addr, int samples, int leftVol, int rightVol, boolean writeSamples) {
        leftVol = Audio.getVolume(leftVol);
        rightVol = Audio.getVolume(rightVol);
        if (!writeSamples && leftVol == 32768 && rightVol == 32768) {
            return;
        }
        int lengthInBytes = mixedSamples.length * 2;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(addr, lengthInBytes, 2);
        int i = 0;
        int j = 0;
        while (i < samples) {
            short sampleLeft = SoundMixer.clampSample(mixedSamples[j]);
            short sampleRight = SoundMixer.clampSample(mixedSamples[j + 1]);
            memoryWriter.writeNext(SoundChannel.adjustSample(sampleLeft, leftVol) & 0xFFFF);
            memoryWriter.writeNext(SoundChannel.adjustSample(sampleRight, rightVol) & 0xFFFF);
            ++i;
            j += 2;
        }
        memoryWriter.flush();
    }

    private void mix(int[] mixedSamples, int addr, int samples, int leftVol, int rightVol, boolean writeSamples) {
        for (int i = 0; i < this.voices.length; ++i) {
            SoundVoice voice = this.voices[i];
            if (!voice.isPlaying() || voice.isPaused()) continue;
            ISampleSource sampleSource = this.synthesizers[i].getSampleSource();
            int playSample = voice.getPlaySample();
            int restPlay = sampleSource.getNumberSamples() - playSample;
            if (restPlay <= 0) {
                voice.setPlaying(false);
                continue;
            }
            int numSamples = Math.min(samples, restPlay);
            this.mix(mixedSamples, sampleSource, playSample, numSamples, voice.getLeftVolume(), voice.getRightVolume());
            writeSamples = true;
            voice.setPlaySample(sampleSource.getSampleIndex());
        }
        this.copySamplesToMem(mixedSamples, addr, samples, leftVol, rightVol, writeSamples);
    }

    public void synthesize(int addr, int samples) {
        int[] mixedSamples = new int[samples * 2];
        for (int i = 0; i < mixedSamples.length; ++i) {
            mixedSamples[i] = 0;
        }
        this.mix(mixedSamples, addr, samples, 32768, 32768, true);
    }

    public void synthesizeWithMix(int addr, int samples, int leftVol, int rightVol) {
        int[] mixedSamples = new int[samples * 2];
        int lengthInBytes = mixedSamples.length * 2;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 2);
        for (int i = 0; i < mixedSamples.length; ++i) {
            mixedSamples[i] = (short)memoryReader.readNext();
        }
        this.mix(mixedSamples, addr, samples, leftVol, rightVol, false);
    }
}

