/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class Hash {
    private static final int[] salt = new int[]{978715090, 725469969, -365320644, 1428995263, -306512206, -647488162, 1808679868, -212099772, 332407269, 1469480069, -321877328, 107521109, 743953084, 1372339721, 490310821, -185174905, -800510096, -226403488, 1115580542, 859737837, -2089137066, 2027426590, 542916301, -1260662046, -682446256, -2027358126, 679384931, -1302940155, -1652371321, 1966478384, -1515320279, 1290696837, -1873521322, -1019478545, -742503119, -1324688994, 116564617, 757206260, -917515769, -193589150, -162934586, 762906928, 1693109325, 959909052, 1175320139, 17432005, -1992413306, 81806513, -60578599, 1403851247, 1705435697, 782733801, -1128410385, -1204122591, 768633882, -119544978, -820730821, 1441162094, -293489173, -1800026190, 1323025741, -545717462, 1673375241, 1838944982, 609635981, -354540335, 780723869, -1394203351, 575758959, 866968614, 874676464, -1310616082, -1657931036, -1210420833, -1903166981, 127485537, 1370855955, 351995648, 1547742270, 998777084, -1313025464, 478872133, 327621328, -266204938, 357685548, 1760840388, 1140021687, 1870511627, -1067148746, 1638032531, -193255559, -1244481406, -1179059103, -994453978, -149845006, -2060828308, -1614065889, -1892826051, -1843851160, 869485353, -1235610995, 842590204, 322495708, -232993232, -2100850969, 233653083, 516851362, -1580028402, 1505292093, 1709193152, -1866810317, -1221236050, 343921510, -1657871639, 1340209730, 669327835, -868840139, -999234033, -1431992820, 482125059, 1917222123, 351140680, 1629219060, -400447682, -1651293973, 718077228, -282818226, -417642611, 268217524, -499563333, -1914995590, 818969446, -1399538934, 65372542, -1364203979, -769385104, -1559892106, 706834411, -474973909, 1379705994, -75900175, -617999859, -1782125361, 757188369, -417941541, 95571556, -69960593, 595234402, -282701518, 1142692105, 976143234, -971333987, 1869064447, 1471712021, -1172468924, -1716144468, -1976561133, -1578660797, -907059836, -285430653, -1105743629, 1398141652, -1455165252, -170432088, 1882757136, 337853874, -678903454, 1269017590, -1966673093, -391754536, -308974467, -191328611, -516164009, -1877296144, 1947901818, 1139482476, 2025096015, -218709187, 275755327, 491816018, 1740618570, -129776965, 1702377600, 1765700897, 2078863133, 844225412, 404501330, -1005384299, -1475632383, -708756620, 1264751613, -614909035, -734553723, -798884080, 2028422933, -1813033544, -1714021947, 840289699, -194836789, -1138137590, -736041764, 1860998057, 1837928320, 2120340751, 2030997142, -244842639, -134215269, 252027143, -1595986582, -2073582595, 777174171, -1119109773, -441477721, -134617556, -381264017, -206981417, -1205300244, 426514458, 1332779524, 755029698, -37561636, 1471571655, 434146336, 162202635, 1332713490, -804880906, 1217752430, -1539382436, -1207901101, -1124727209, -214525223, -313066508, -1884519678, 2083021287, -928078564, 404743336, 1756800216, 1407011479, 1615869082, 724417834, 1207542227, 2059155243, 38065770, 1247377293, 635100783, 1777773157, -1603074378, -1150634488, -259239917, 1662898274, -1911944123, 2019246329, -1300409138, 568987203, 532117845, 323836205};

    public static int getHashCode(int hashCode, int addr, int lengthInBytes) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 4);
        int i = 0;
        int j = 0;
        while (i < lengthInBytes) {
            int value = memoryReader.readNext();
            hashCode ^= value + salt[j & 0xFF];
            hashCode += i + addr;
            i += 4;
            ++j;
        }
        return hashCode;
    }

    public static int getHashCode(int hashCode, int addr, int lengthInBytes, int strideInBytes) {
        if (strideInBytes <= 4) {
            return Hash.getHashCode(hashCode, addr, lengthInBytes);
        }
        int skip = strideInBytes / 4 - 1;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 4);
        int step = (skip + 1) * 4;
        lengthInBytes -= lengthInBytes % strideInBytes;
        int i = 0;
        int j = 0;
        while (i < lengthInBytes) {
            int value = memoryReader.readNext();
            memoryReader.skip(skip);
            hashCode ^= value + salt[j & 0xFF];
            hashCode += i + addr;
            i += step;
            ++j;
        }
        return hashCode;
    }

    public static int getHashCodeComplex(int hashCode, int addr, int lengthInBytes) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 4);
        int n = lengthInBytes / 4;
        for (int i = 0; i < n; ++i) {
            int value = memoryReader.readNext();
            value = Integer.rotateLeft(value, i & 0x1F);
            hashCode ^= value + i + addr;
            hashCode += i + addr;
        }
        return hashCode;
    }

    public static int getHashCodeComplex(int hashCode, int addr, int lengthInBytes, int strideInBytes) {
        if (strideInBytes <= 4) {
            return Hash.getHashCodeComplex(hashCode, addr, lengthInBytes);
        }
        int skip = strideInBytes / 4 - 1;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 4);
        int n = lengthInBytes / strideInBytes;
        for (int i = 0; i < n; ++i) {
            int value = memoryReader.readNext();
            memoryReader.skip(skip);
            value = Integer.rotateLeft(value, i & 0x1F);
            hashCode ^= value + i + addr;
            hashCode += i + addr;
        }
        return hashCode;
    }

    public static int getHashCodeFloatingMemory(int hashCode, int addr, int lengthInBytes) {
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, lengthInBytes, 4);
        return Hash.getHashCodeFloatingMemory(hashCode, memoryReader, lengthInBytes);
    }

    public static int getHashCodeFloatingMemory(int hashCode, IMemoryReader memoryReader, int lengthInBytes) {
        for (int i = 0; i < lengthInBytes; i += 4) {
            int value = memoryReader.readNext();
            hashCode ^= value + i;
            hashCode += i;
        }
        return hashCode;
    }
}

