/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.FerryJNI;
import com.xuggle.ferry.JNIReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JNIMemoryManager {
    private static final JNIMemoryManager mMgr = new JNIMemoryManager();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static MemoryModel mMemoryModel;
    private final ReferenceQueue<Object> mRefQueue = new ReferenceQueue();
    private final AtomicBoolean mSpinLock;
    private final Lock mLock = new ReentrantLock();
    private JNIReference[] mValidReferences;
    private volatile int mNextAvailableReferenceSlot;
    private volatile int mMaxValidReference;
    private int mMinimumReferencesToCache;
    private double mExpandIncrement;
    private double mShrinkScaleFactor;
    private double mMaxFreeRatio;
    private double mMinFreeRatio;
    private volatile Thread mCollectionThread = null;

    public static JNIMemoryManager getMgr() {
        return mMgr;
    }

    public static void collect() {
        JNIMemoryManager.getMgr().gc();
    }

    JNIMemoryManager() {
        this.mSpinLock = new AtomicBoolean(false);
        int minReferences = 4096;
        this.mMinimumReferencesToCache = 4096;
        this.mExpandIncrement = 0.2;
        this.mShrinkScaleFactor = 0.25;
        this.mValidReferences = new JNIReference[4096];
        this.mMaxValidReference = 4096;
        this.mNextAvailableReferenceSlot = 0;
        this.mMaxFreeRatio = 0.7;
        this.mMinFreeRatio = 0.3;
    }

    private void blockingLock() {
        this.mLock.lock();
        while (!this.mSpinLock.compareAndSet(false, true)) {
        }
    }

    private void blockingUnlock() {
        boolean result = this.mSpinLock.compareAndSet(true, false);
        assert (result) : "Should never ever be unlocked here";
        this.mLock.unlock();
    }

    public void setMinimumReferencesToCache(int minimumReferencesToCache) {
        if (minimumReferencesToCache <= 0) {
            throw new IllegalArgumentException("Must pass in a positive integer");
        }
        this.mMinimumReferencesToCache = minimumReferencesToCache;
    }

    public int getMinimumReferencesToCache() {
        return this.mMinimumReferencesToCache;
    }

    public void setExpandIncrement(double expandIncrement) {
        if (expandIncrement <= 0.0) {
            throw new IllegalArgumentException("Must pass in positive percentage");
        }
        this.mExpandIncrement = expandIncrement / 100.0;
    }

    public double getExpandIncrement() {
        return this.mExpandIncrement * 100.0;
    }

    public void setShrinkFactor(double shrinkFactor) {
        if (shrinkFactor <= 0.0 || shrinkFactor >= 100.0) {
            throw new IllegalArgumentException("only 0 < shrinkFactor < 100 allowed");
        }
        this.mShrinkScaleFactor = shrinkFactor / 100.0;
    }

    public double getShrinkFactor() {
        return this.mShrinkScaleFactor * 100.0;
    }

    public void setMaxFreeRatio(double maxFreeRatio) {
        this.mMaxFreeRatio = maxFreeRatio / 100.0;
    }

    public double getMaxFreeRatio() {
        return this.mMaxFreeRatio * 100.0;
    }

    public void setMinFreeRatio(double minFreeRatio) {
        this.mMinFreeRatio = minFreeRatio / 100.0;
    }

    public double getMinFreeRatio() {
        return this.mMinFreeRatio * 100.0;
    }

    private int sweepAndCollect() {
        JNIReference[] survivors = new JNIReference[this.mMaxValidReference];
        int numSurvivors = 0;
        int numValid = this.mMaxValidReference;
        for (int i = 0; i < numValid; ++i) {
            JNIReference victim = this.mValidReferences[i];
            if (victim == null || victim.isDeleted()) continue;
            survivors[numSurvivors] = victim;
            ++numSurvivors;
        }
        int survivorLength = survivors.length;
        int freeSpace = survivorLength - numSurvivors;
        if ((double)freeSpace > (double)survivorLength * this.mMaxFreeRatio) {
            int newSize = (int)((double)survivorLength * (1.0 - this.mExpandIncrement * this.mShrinkScaleFactor));
            if (newSize >= this.mMinimumReferencesToCache) {
                JNIReference[] shrunk = new JNIReference[newSize];
                System.arraycopy(survivors, 0, shrunk, 0, newSize);
                survivors = shrunk;
            }
        } else if ((double)freeSpace <= (double)survivorLength * this.mMinFreeRatio) {
            int newSize = (int)((double)survivorLength * (1.0 + this.mExpandIncrement));
            JNIReference[] expanded = new JNIReference[newSize];
            System.arraycopy(survivors, 0, expanded, 0, survivorLength);
            survivors = expanded;
        }
        this.mValidReferences = survivors;
        this.mMaxValidReference = survivors.length;
        this.mNextAvailableReferenceSlot = numSurvivors;
        return numSurvivors;
    }

    ReferenceQueue<Object> getQueue() {
        return this.mRefQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumPinnedObjects() {
        long numPinnedObjects = 0L;
        this.blockingLock();
        try {
            int numItems = this.mNextAvailableReferenceSlot;
            for (int i = 0; i < numItems; ++i) {
                JNIReference ref = this.mValidReferences[i];
                if (ref == null || ref.isDeleted()) continue;
                ++numPinnedObjects;
            }
        }
        finally {
            this.blockingUnlock();
        }
        return numPinnedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpMemoryLog() {
        this.blockingLock();
        try {
            int numItems = this.mNextAvailableReferenceSlot;
            this.log.debug("Memory slots in use: {}", (Object)numItems);
            for (int i = 0; i < numItems; ++i) {
                JNIReference ref = this.mValidReferences[i];
                if (ref == null) continue;
                this.log.debug("Slot: {}; Ref: {}", (Object)i, (Object)ref);
            }
        }
        finally {
            this.blockingUnlock();
        }
    }

    public boolean isMemoryDebugging() {
        return JNIReference.isMemoryDebugging();
    }

    public void setMemoryDebugging(boolean value) {
        JNIReference.setMemoryDebugging(value);
    }

    public void finalize() {
        this.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean addReference(JNIReference ref) {
        int slot;
        boolean gotNonblockingLock = false;
        gotNonblockingLock = this.mSpinLock.compareAndSet(false, true);
        if (gotNonblockingLock) {
            if ((slot = this.mNextAvailableReferenceSlot++) < this.mMaxValidReference) {
                this.mValidReferences[slot] = ref;
                boolean result = this.mSpinLock.compareAndSet(true, false);
                assert (result) : "Should never be unlocked here";
                return true;
            }
            if (!this.mLock.tryLock()) {
                gotNonblockingLock = false;
                this.mSpinLock.compareAndSet(true, false);
            }
        }
        if (!gotNonblockingLock) {
            this.mLock.lock();
            while (!this.mSpinLock.compareAndSet(false, true)) {
            }
        }
        try {
            slot = this.mNextAvailableReferenceSlot++;
            if (slot >= this.mMaxValidReference) {
                this.sweepAndCollect();
                slot = this.mNextAvailableReferenceSlot++;
            }
            this.mValidReferences[slot] = ref;
        }
        finally {
            boolean result = this.mSpinLock.compareAndSet(true, false);
            assert (result) : "Should never ever be unlocked here";
            this.mLock.unlock();
        }
        return true;
    }

    public void gc() {
        this.gc(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc(boolean doSweep) {
        this.gcInternal();
        if (doSweep) {
            this.blockingLock();
            try {
                this.sweepAndCollect();
            }
            finally {
                this.blockingUnlock();
            }
        }
    }

    void gcInternal() {
        JNIReference ref = null;
        while ((ref = (JNIReference)this.mRefQueue.poll()) != null) {
            ref.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCollectionThread() {
        JNIMemoryManager jNIMemoryManager = this;
        synchronized (jNIMemoryManager) {
            if (this.mCollectionThread != null) {
                throw new RuntimeException("Thread already running");
            }
            this.mCollectionThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    JNIReference ref = null;
                    try {
                        while (true) {
                            if ((ref = (JNIReference)JNIMemoryManager.this.mRefQueue.remove()) == null) {
                                continue;
                            }
                            ref.delete();
                        }
                    }
                    catch (InterruptedException ex) {
                        JNIMemoryManager jNIMemoryManager = JNIMemoryManager.this;
                        synchronized (jNIMemoryManager) {
                            JNIMemoryManager.this.mCollectionThread = null;
                            Thread.currentThread().interrupt();
                        }
                        return;
                    }
                }
            }, "Xuggle Ferry Collection Thread");
            this.mCollectionThread.setDaemon(true);
            this.mCollectionThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCollectionThread() {
        JNIMemoryManager jNIMemoryManager = this;
        synchronized (jNIMemoryManager) {
            if (this.mCollectionThread != null) {
                this.mCollectionThread.interrupt();
            }
        }
    }

    public static MemoryModel getMemoryModel() {
        return mMemoryModel;
    }

    public static void setMemoryModel(MemoryModel model) {
        FerryJNI.setMemoryModel(model.getNativeValue());
        mMemoryModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        this.blockingLock();
        try {
            int numSurvivors = this.sweepAndCollect();
            for (int i = 0; i < numSurvivors; ++i) {
                JNIReference ref = this.mValidReferences[i];
                if (ref == null) continue;
                ref.delete();
            }
            this.sweepAndCollect();
            this.mValidReferences = new JNIReference[this.mMinimumReferencesToCache];
            this.mNextAvailableReferenceSlot = 0;
            this.mMaxValidReference = this.mMinimumReferencesToCache;
        }
        finally {
            this.blockingUnlock();
        }
    }

    static {
        int model = 0;
        mMemoryModel = MemoryModel.JAVA_STANDARD_HEAP;
        model = FerryJNI.getMemoryModel();
        for (MemoryModel candidate : MemoryModel.values()) {
            if (candidate.getNativeValue() != model) continue;
            mMemoryModel = candidate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemoryModel {
        JAVA_STANDARD_HEAP(0),
        JAVA_DIRECT_BUFFERS(1),
        JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION(2),
        NATIVE_BUFFERS(3),
        NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION(4);

        private final int mNativeValue;

        private MemoryModel(int nativeValue) {
            this.mNativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.mNativeValue;
        }
    }
}

