/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.ISimpleMediaFile;
import com.xuggle.xuggler.ITimeValue;

public class SimpleMediaFile
implements ISimpleMediaFile {
    private String mURL = null;
    private boolean mHasAudio = true;
    private int mAudioBitRate = 64000;
    private boolean mAudioBitRateKnown = false;
    private int mAudioChannels = 1;
    private boolean mAudioChannelsKnown = false;
    private int mAudioSampleRate = 44100;
    private boolean mAudioSampleRateKnown = false;
    private IRational mAudioTimeBase = null;
    private ICodec.ID mAudioCodec = ICodec.ID.CODEC_ID_NONE;
    private IAudioSamples.Format mAudioSamplesFormat = IAudioSamples.Format.FMT_S16;
    private boolean mHasVideo = true;
    private ICodec.ID mVideoCodec = ICodec.ID.CODEC_ID_NONE;
    private int mVideoHeight = 1;
    private boolean mVideoHeightKnown = false;
    private int mVideoWidth = 1;
    private boolean mVideoWidthKnown = false;
    private int mVideoBitRate = 320000;
    private boolean mVideoBitRateKnown = false;
    private IRational mVideoTimeBase = null;
    private IRational mVideoFrameRate = null;
    private int mVideoGOPS = 15;
    private boolean mVideoGOPSKnown = false;
    private int mVideoGlobalQuality = 0;
    private boolean mVideoGlobalQualityKnown = false;
    private IPixelFormat.Type mPixelFormat = IPixelFormat.Type.YUV420P;
    private boolean mVideoPixelFormatKnown = false;
    private IContainerFormat mContainerFormat = null;
    private ITimeValue mDuration = null;

    public SimpleMediaFile() {
    }

    public SimpleMediaFile(ISimpleMediaFile src) {
        if (src == null) {
            throw new IllegalArgumentException("cannot pass null src");
        }
        this.setHasAudio(src.hasAudio());
        this.setAudioBitRate(src.getAudioBitRate());
        this.setAudioChannels(src.getAudioChannels());
        this.setAudioSampleRate(src.getAudioSampleRate());
        this.setAudioSampleFormat(src.getAudioSampleFormat());
        this.setHasVideo(src.hasVideo());
        this.setAudioCodec(src.getAudioCodec());
        this.setVideoCodec(src.getVideoCodec());
        this.setVideoHeight(src.getVideoHeight());
        this.setVideoWidth(src.getVideoWidth());
        IRational srcRational = src.getVideoTimeBase();
        this.setVideoTimeBase(srcRational);
        srcRational = src.getVideoFrameRate();
        this.setVideoFrameRate(srcRational);
        srcRational = src.getAudioTimeBase();
        this.setAudioTimeBase(srcRational);
        this.setVideoNumPicturesInGroupOfPictures(src.getVideoNumPicturesInGroupOfPictures());
        this.setVideoGlobalQuality(src.getVideoGlobalQuality());
        this.setVideoPixelFormat(src.getVideoPixelFormat());
        this.setContainerFormat(src.getContainerFormat());
        this.setDuration(src.getDuration());
        this.setURL(src.getURL());
        this.setAudioBitRateKnown(src.isAudioBitRateKnown());
        this.setAudioChannelsKnown(src.isAudioChannelsKnown());
        this.setAudioSampleRateKnown(src.isAudioSampleRateKnown());
        this.setVideoHeightKnown(src.isVideoHeightKnown());
        this.setVideoWidthKnown(src.isVideoWidthKnown());
        this.setVideoNumPicturesInGroupOfPicturesKnown(src.isVideoNumPicturesInGroupOfPicturesKnown());
        this.setVideoPixelFormatKnown(src.isVideoPixelFormatKnown());
        this.setVideoGlobalQualityKnown(src.isVideoGlobalQualityKnown());
    }

    public int getAudioBitRate() {
        return this.mAudioBitRate;
    }

    public int getAudioChannels() {
        return this.mAudioChannels;
    }

    public int getAudioSampleRate() {
        return this.mAudioSampleRate;
    }

    public void setAudioBitRate(int bitRate) {
        this.mAudioBitRate = bitRate;
        this.setAudioBitRateKnown(true);
    }

    public void setAudioChannels(int numChannels) {
        if (numChannels < 1 || numChannels > 2) {
            throw new IllegalArgumentException("only supports 1 or 2 channels");
        }
        this.mAudioChannels = numChannels;
        this.setAudioChannelsKnown(true);
    }

    public void setAudioSampleRate(int sampleRate) {
        this.mAudioSampleRate = sampleRate;
        this.setAudioSampleRateKnown(true);
    }

    public ICodec.ID getAudioCodec() {
        return this.mAudioCodec;
    }

    public void setAudioCodec(ICodec.ID audioCodec) {
        this.mAudioCodec = audioCodec;
    }

    public ICodec.ID getVideoCodec() {
        return this.mVideoCodec;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoBitRate() {
        return this.mVideoBitRate;
    }

    public void setVideoCodec(ICodec.ID videoCodec) {
        this.mVideoCodec = videoCodec;
    }

    public void setVideoHeight(int height) {
        this.mVideoHeight = height;
        this.setVideoHeightKnown(true);
    }

    public void setVideoWidth(int width) {
        this.mVideoWidth = width;
        this.setVideoWidthKnown(true);
    }

    public IRational getVideoTimeBase() {
        return this.mVideoTimeBase;
    }

    public void setVideoTimeBase(IRational timeBase) {
        this.mVideoTimeBase = timeBase;
    }

    public void setVideoBitRate(int bitRate) {
        this.mVideoBitRate = bitRate;
        this.setVideoBitRateKnown(true);
    }

    public IPixelFormat.Type getVideoPixelFormat() {
        return this.mPixelFormat;
    }

    public void setVideoPixelFormat(IPixelFormat.Type pixelFormat) {
        this.mPixelFormat = pixelFormat;
        this.setVideoPixelFormatKnown(true);
    }

    public IRational getVideoFrameRate() {
        return this.mVideoFrameRate;
    }

    public int getVideoGlobalQuality() {
        return this.mVideoGlobalQuality;
    }

    public int getVideoNumPicturesInGroupOfPictures() {
        return this.mVideoGOPS;
    }

    public void setVideoFrameRate(IRational frameRate) {
        this.mVideoFrameRate = frameRate;
    }

    public void setVideoGlobalQuality(int quality) {
        this.mVideoGlobalQuality = quality;
        this.setVideoGlobalQualityKnown(true);
    }

    public void setVideoNumPicturesInGroupOfPictures(int gops) {
        this.mVideoGOPS = gops;
        this.setVideoNumPicturesInGroupOfPicturesKnown(true);
    }

    public boolean hasAudio() {
        return this.mHasAudio;
    }

    public boolean hasVideo() {
        return this.mHasVideo;
    }

    public void setHasAudio(boolean hasAudio) {
        this.mHasAudio = hasAudio;
    }

    public void setHasVideo(boolean hasVideo) {
        this.mHasVideo = hasVideo;
    }

    public IContainerFormat getContainerFormat() {
        return this.mContainerFormat;
    }

    public void setContainerFormat(IContainerFormat aFormat) {
        this.mContainerFormat = aFormat;
    }

    public IRational getAudioTimeBase() {
        return this.mAudioTimeBase;
    }

    public void setAudioTimeBase(IRational aTimeBase) {
        this.mAudioTimeBase = aTimeBase;
    }

    public void setAudioBitRateKnown(boolean audioBitRateKnown) {
        this.mAudioBitRateKnown = audioBitRateKnown;
    }

    public boolean isAudioBitRateKnown() {
        return this.mAudioBitRateKnown;
    }

    public void setAudioChannelsKnown(boolean audioChannelsKnown) {
        this.mAudioChannelsKnown = audioChannelsKnown;
    }

    public boolean isAudioChannelsKnown() {
        return this.mAudioChannelsKnown;
    }

    public void setAudioSampleRateKnown(boolean audioSampleRateKnown) {
        this.mAudioSampleRateKnown = audioSampleRateKnown;
    }

    public boolean isAudioSampleRateKnown() {
        return this.mAudioSampleRateKnown;
    }

    public void setVideoHeightKnown(boolean videoHeightKnown) {
        this.mVideoHeightKnown = videoHeightKnown;
    }

    public boolean isVideoHeightKnown() {
        return this.mVideoHeightKnown;
    }

    public void setVideoWidthKnown(boolean videoWidthKnown) {
        this.mVideoWidthKnown = videoWidthKnown;
    }

    public boolean isVideoWidthKnown() {
        return this.mVideoWidthKnown;
    }

    public void setVideoBitRateKnown(boolean videoBitRateKnown) {
        this.mVideoBitRateKnown = videoBitRateKnown;
    }

    public boolean isVideoBitRateKnown() {
        return this.mVideoBitRateKnown;
    }

    public void setVideoNumPicturesInGroupOfPicturesKnown(boolean videoGOPSKnown) {
        this.mVideoGOPSKnown = videoGOPSKnown;
    }

    public boolean isVideoNumPicturesInGroupOfPicturesKnown() {
        return this.mVideoGOPSKnown;
    }

    public void setVideoGlobalQualityKnown(boolean videoGlobalQualityKnown) {
        this.mVideoGlobalQualityKnown = videoGlobalQualityKnown;
    }

    public boolean isVideoGlobalQualityKnown() {
        return this.mVideoGlobalQualityKnown;
    }

    public void setVideoPixelFormatKnown(boolean videoPixelFormatKnown) {
        this.mVideoPixelFormatKnown = videoPixelFormatKnown;
    }

    public boolean isVideoPixelFormatKnown() {
        return this.mVideoPixelFormatKnown;
    }

    public void setDuration(ITimeValue duration) {
        this.mDuration = duration;
    }

    public ITimeValue getDuration() {
        return this.mDuration;
    }

    public void setURL(String uRL) {
        this.mURL = uRL;
    }

    public String getURL() {
        return this.mURL;
    }

    public IAudioSamples.Format getAudioSampleFormat() {
        return this.mAudioSamplesFormat;
    }

    public void setAudioSampleFormat(IAudioSamples.Format aFormat) {
        if (aFormat == null) {
            throw new IllegalArgumentException("cannot set to null format");
        }
        this.mAudioSamplesFormat = aFormat;
    }
}

