/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProtocolHandler
implements IURLProtocolHandler {
    File file = null;
    RandomAccessFile stream = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FileProtocolHandler() {
        this.log.debug("Initializing file protocol handler without file");
        this.file = null;
    }

    public FileProtocolHandler(File file) {
        this.log.debug("Initializing file protocol handler: {}", (Object)file);
        this.file = file;
    }

    public FileProtocolHandler(String filename) {
        this.log.debug("Initializing file protocol handler: {}", (Object)filename);
        filename = this.getFilename(filename);
        this.file = filename != null ? new File(filename) : null;
    }

    public int close() {
        this.log.debug("Closing file: {}", (Object)this.file);
        try {
            this.stream.close();
        }
        catch (IOException e) {
            this.log.error("Error closing file: {}", (Object)this.file);
            e.printStackTrace();
            return -1;
        }
        this.log.debug("Succesfully closed file: {}", (Object)this.file);
        return 0;
    }

    public int open(String url, int flags) {
        String mode;
        int retval = -1;
        this.log.debug("attempting to open {} with flags {}", url == null ? this.file : url, (Object)flags);
        if (this.stream != null) {
            this.close();
        }
        if (this.file == null && (url = this.getFilename(url)) != null) {
            this.file = new File(url);
        }
        this.log.debug("Opening file: {}", (Object)this.file);
        switch (flags) {
            case 2: {
                mode = "rw";
                break;
            }
            case 1: {
                mode = "rw";
                break;
            }
            case 0: {
                mode = "r";
                break;
            }
            default: {
                this.log.error("Invalid flag passed to open: {}", (Object)this.file);
                return retval;
            }
        }
        this.log.debug("read mode \"{}\" for file: {}", (Object)mode, (Object)this.file);
        try {
            this.stream = new RandomAccessFile(this.file, mode);
            retval = 0;
        }
        catch (Exception e) {
            this.log.error("Could not find file: {}; ex: {}", (Object)this.file, (Object)e);
            return retval;
        }
        this.log.debug("Opened file: {}", (Object)this.file);
        return retval;
    }

    public int read(byte[] buf, int size) {
        try {
            int ret = -1;
            ret = this.stream.read(buf, 0, size);
            return ret;
        }
        catch (IOException e) {
            this.log.error("Got IO exception reading from file: {}", (Object)this.file);
            e.printStackTrace();
            return -1;
        }
    }

    public long seek(long offset, int whence) {
        try {
            long seek;
            if (whence == 0) {
                seek = offset;
            } else if (whence == 1) {
                seek = this.stream.getFilePointer() + offset;
            } else if (whence == 2) {
                seek = this.stream.length() + offset;
            } else {
                if (whence == 65536) {
                    return (int)this.stream.length();
                }
                this.log.error("invalid seek value \"{}\" for file: {}", (Object)whence, (Object)this.file);
                return -1L;
            }
            this.stream.seek(seek);
            this.log.debug("seeking to \"{}\" in: {}", (Object)seek, (Object)this.file);
            return seek;
        }
        catch (IOException e) {
            this.log.error("got io exception \"{}\" while seeking in: {}", (Object)e.getMessage(), (Object)this.file);
            e.printStackTrace();
            return -1L;
        }
    }

    public int write(byte[] buf, int size) {
        try {
            this.stream.write(buf, 0, size);
            return size;
        }
        catch (IOException e) {
            this.log.error("Got error writing to file: {}", (Object)this.file);
            e.printStackTrace();
            return -1;
        }
    }

    private String getFilename(String url) {
        int colonIndex;
        String retval = url;
        if (url != null && url.length() > 0 && (colonIndex = url.indexOf(":")) > 0) {
            retval = url.substring(colonIndex + 1);
        }
        this.log.debug("url->filename: {}->{}", (Object)url, (Object)retval);
        return retval;
    }

    public boolean isStreamed(String url, int flags) {
        return false;
    }
}

