/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.ferry.JNIReference;
import com.xuggle.ferry.MemoryTestHelper;
import com.xuggle.ferry.RefCounted;
import com.xuggle.ferry.RefCountedTester;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class MemoryModelExhaustiveTest
extends TestCase {
    private static final int MAX_BUFFERS_TO_CACHE = 5;
    private static final int NUM_ALLOCS_PER_TEST = 1000;
    private static final int TEST_BUFFER_SIZE = 0x100000;

    public void tearDown() {
        JNIMemoryManager.getMgr().flush();
    }

    public void testMediumTermReference_JAVA_BYTE_ARRAYS() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP, false);
    }

    public void testMediumTermReference_JAVA_DIRECT_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS, false);
    }

    public void testMediumTermReference_JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, false);
    }

    public void testMediumTermReference_NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, false);
    }

    public void testMediumTermReference_ExplicitCleanup_JAVA_BYTE_ARRAYS() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP, true);
    }

    public void testMediumTermReference_ExplicitCleanup_JAVA_DIRECT_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS, true);
    }

    public void testMediumTermReference_ExplicitCleanup_JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, true);
    }

    public void testMediumTermReference_ExplicitCleanup_NATIVE_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS, true);
    }

    public void testMediumTermReference_ExplicitCleanup_NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, true);
    }

    public void testShortTermReference_JAVA_BYTE_ARRAYS() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP, false);
    }

    public void testShortTermReference_JAVA_DIRECT_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS, false);
    }

    public void testShortTermReference_JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, false);
    }

    public void testShortTermReference_NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, false);
    }

    public void testShortTermReference_ExplicitCleanup_JAVA_BYTE_ARRAYS() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_STANDARD_HEAP, true);
    }

    public void testShortTermReference_ExplicitCleanup_JAVA_DIRECT_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS, true);
    }

    public void testShortTermReference_ExplicitCleanup_JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.JAVA_DIRECT_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, true);
    }

    public void testShortTermReference_ExplicitCleanup_NATIVE_BUFFERS() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS, true);
    }

    public void testShortTermReference_ExplicitCleanup_NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION() {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(JNIMemoryManager.MemoryModel.NATIVE_BUFFERS_WITH_STANDARD_HEAP_NOTIFICATION, true);
    }

    public static void helperMaintainShortTermReference(JNIMemoryManager.MemoryModel model, boolean cleanUpAfterOurselves) {
        MemoryModelExhaustiveTest.helperMaintainShortTermReference(model, cleanUpAfterOurselves, 1000, 0x100000, true);
    }

    public static void helperMaintainShortTermReference(JNIMemoryManager.MemoryModel model, boolean cleanUpAfterOurselves, int numAllocsPerTest, int bufferSize, boolean forceCommit) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
        System.out.println("Short Term Test; Memory model = " + JNIMemoryManager.getMemoryModel());
        int i = 0;
        RefCountedTester allocator = RefCountedTester.make();
        for (i = 0; i < numAllocsPerTest; ++i) {
            IBuffer buffer = MemoryModelExhaustiveTest.getTestBuffer((RefCounted)allocator, bufferSize, forceCommit);
            if (!cleanUpAfterOurselves) continue;
            buffer.delete();
        }
        System.out.println("Finished allocating objects: " + i);
    }

    public static void helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel model, boolean cleanUpAfterOurselves) {
        MemoryModelExhaustiveTest.helperMaintainMediumTermReference(model, cleanUpAfterOurselves, 1000, 0x100000, 5, true);
    }

    public static void helperMaintainMediumTermReference(JNIMemoryManager.MemoryModel model, final boolean cleanUpAfterOurselves, int numAllocsPerTest, int bufferSize, final int cacheSize, boolean forceCommit) {
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
        System.out.println("Medium Term Test; Memory model = " + JNIMemoryManager.getMemoryModel());
        LinkedHashMap<IBuffer, IBuffer> map = new LinkedHashMap<IBuffer, IBuffer>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<IBuffer, IBuffer> eldest) {
                if (this.size() > cacheSize) {
                    IBuffer key = eldest.getKey();
                    this.remove(key);
                    if (cleanUpAfterOurselves) {
                        key.delete();
                    }
                }
                return false;
            }
        };
        int i = 0;
        RefCountedTester allocator = RefCountedTester.make();
        for (i = 0; i < numAllocsPerTest; ++i) {
            IBuffer buffer = MemoryModelExhaustiveTest.getTestBuffer((RefCounted)allocator, bufferSize, forceCommit);
            map.put(buffer, buffer);
            MemoryModelExhaustiveTest.assertTrue((String)("unexpected map size: " + map.size()), (map.size() <= cacheSize ? 1 : 0) != 0);
        }
        System.out.println("Finished allocating objects: " + i);
    }

    public static IBuffer getTestBuffer(RefCounted allocator, int size, boolean forceCommit) throws OutOfMemoryError {
        IBuffer buffer = null;
        try {
            buffer = IBuffer.make((RefCounted)allocator, (int)size);
            if (forceCommit) {
                AtomicReference<Object> ref = new AtomicReference<Object>(null);
                ByteBuffer jbuffer = buffer.getByteBuffer(0, size, ref);
                for (int i = 0; i < size; ++i) {
                    jbuffer.put(i, (byte)-1);
                }
                ((JNIReference)ref.get()).delete();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Attempting recovery from OOME");
            MemoryTestHelper.forceJavaHeapWeakReferenceClear();
            JNIMemoryManager.collect();
            buffer = IBuffer.make(null, (int)size);
            System.out.println("Recovered from OOME");
        }
        return buffer;
    }
}

