/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class StreamCoderRegressionTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testIssue55() {
        IContainer container = IContainer.make();
        Assert.assertNotNull((Object)container);
        int retval = -1;
        retval = container.open("fixtures/testfile_mpeg1video_mp2audio.mpg", IContainer.Type.READ, null);
        Assert.assertTrue((String)"could not open file", (retval >= 0 ? 1 : 0) != 0);
        int videoId = -1;
        for (int i = 0; i < container.getNumStreams(); ++i) {
            IStream stream = container.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            this.log.debug("found video on stream: {}", (Object)i);
            videoId = i;
            retval = coder.open();
            Assert.assertTrue((String)"could not open decoder", (retval >= 0 ? 1 : 0) != 0);
            break;
        }
        Assert.assertTrue((String)"no video found", (videoId >= 0 ? 1 : 0) != 0);
        IPacket pkt = IPacket.make();
        int vidPackets = 0;
        long lastPts = Global.NO_PTS;
        while (container.readNextPacket(pkt) >= 0) {
            IVideoPicture pict;
            if (pkt.getStreamIndex() != videoId) continue;
            IStreamCoder vidCoder = container.getStream((long)videoId).getStreamCoder();
            retval = vidCoder.decodeVideo(pict = IVideoPicture.make((IPixelFormat.Type)vidCoder.getPixelType(), (int)vidCoder.getWidth(), (int)vidCoder.getHeight()), pkt, 0);
            Assert.assertTrue((String)"could not decode", (retval >= 0 ? 1 : 0) != 0);
            if (lastPts != Global.NO_PTS && lastPts + 50000L < pict.getPts()) {
                this.log.debug("last pts: {}; now: {}", (Object)lastPts, (Object)pict.getPts());
                Assert.fail((String)"issue 55: timestamps not correctly computed");
            }
            lastPts = pict.getPts();
            ++vidPackets;
        }
        Assert.assertEquals((String)"should be this number video packets", (long)470L, (long)vidPackets);
        if (videoId >= 0) {
            container.getStream((long)videoId).getStreamCoder().close();
        }
        container.close();
    }
}

