/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.Resource;
import jpcsp.State;
import jpcsp.util.Utilities;

public class CheatsGUI
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = 6791588139795694296L;
    private static final int cheatsThreadSleepMillis = 5;
    private JButton jButtonClear;
    private JRadioButton jRadioONOFF;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton jButtonImportFromCheatDB;
    private boolean cheatsOn = false;
    private CheatsThread cheatsThread = null;

    public CheatsGUI() {
        this.initComponents();
        this.setTitle("Cheats - CWCheat");
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    private void initComponents() {
        this.jButtonClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jRadioONOFF = new JRadioButton();
        this.jButtonImportFromCheatDB = new JButton();
        this.setTitle("Cheats");
        this.setResizable(true);
        this.jButtonClear.setText(Resource.get("Clear"));
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsGUI.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jTextArea1.setColumns(30);
        this.jTextArea1.setEditable(true);
        this.jTextArea1.setFont(new Font("Monospaced", 1, 14));
        this.jTextArea1.setRows(20);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTextArea1.getAccessibleContext().setAccessibleName("cheatPane");
        this.jRadioONOFF.setText(Resource.get("On") + "/" + Resource.get("Off"));
        this.jRadioONOFF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsGUI.this.jRadioONOFFActionPerformed(evt);
            }
        });
        this.jButtonImportFromCheatDB.setText(Resource.get("ImportFromcheatdb"));
        this.jButtonImportFromCheatDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheatsGUI.this.jButtonImportFromCheatDBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioONOFF).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addComponent(this.jButtonImportFromCheatDB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClear, -2, 94, -2)).addComponent(this.jScrollPane1, -1, 314, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonClear).addComponent(this.jRadioONOFF).addComponent(this.jButtonImportFromCheatDB)).addContainerGap()));
        this.pack();
    }

    public String[] getCodesList() {
        String text = this.jTextArea1.getText();
        String[] codes = text.split("\n");
        return codes;
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextArea1.setText("");
    }

    private void jRadioONOFFActionPerformed(ActionEvent evt) {
        this.cheatsOn = !this.cheatsOn;
        this.jTextArea1.setEditable(!this.cheatsOn);
        if (this.cheatsOn && this.cheatsThread == null && !this.jTextArea1.getText().equals("")) {
            this.jTextArea1.setEditable(false);
            this.cheatsThread = new CheatsThread(this);
            this.cheatsThread.setPriority(1);
            this.cheatsThread.setName("HLECheatThread");
            this.cheatsThread.setDaemon(true);
            this.cheatsThread.start();
        } else if (!this.cheatsOn && this.cheatsThread != null) {
            this.cheatsThread.exit();
        }
    }

    private void addCheatLine(String line) {
        String cheatCodes = this.jTextArea1.getText();
        cheatCodes = cheatCodes == null || cheatCodes.length() <= 0 ? line : cheatCodes + "\n" + line;
        this.jTextArea1.setText(cheatCodes);
    }

    private void jButtonImportFromCheatDBActionPerformed(ActionEvent evt) {
        File cheatDBFile = new File("cheat.db");
        if (cheatDBFile.canRead()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(cheatDBFile));
                boolean insideApplicationid = false;
                while (reader.ready() && (line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("_S ")) {
                        String applicationId = line.substring(2).trim().replace("-", "");
                        insideApplicationid = applicationId.equalsIgnoreCase(State.discId);
                    }
                    if (!insideApplicationid) continue;
                    this.addCheatLine(line);
                }
            }
            catch (IOException e) {
                Emulator.log.error((Object)"Import from cheat.db", (Throwable)e);
            }
        }
    }

    public void onCheatsThreadEnded() {
        this.cheatsThread = null;
    }

    @Override
    public void dispose() {
        if (this.cheatsThread != null) {
            this.cheatsThread.exit();
        }
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private static class CheatsThread
    extends Thread {
        private String[] codes;
        private int currentCode;
        private final CheatsGUI cheats;
        private volatile boolean exit;

        public CheatsThread(CheatsGUI cheats) {
            this.cheats = cheats;
        }

        public void exit() {
            this.exit = true;
        }

        private String getNextCode() {
            String code;
            do {
                if (this.currentCode >= this.codes.length) {
                    code = null;
                } else {
                    if (!(code = this.codes[this.currentCode++].trim()).startsWith("_L")) continue;
                    code = code.substring(2).trim();
                }
                break;
            } while (!code.startsWith("0"));
            return code;
        }

        private void skipCodes(int count) {
            for (int i = 0; i < count && this.getNextCode() != null; ++i) {
            }
        }

        private void skipAllCodes() {
            this.currentCode = this.codes.length;
        }

        private static int getAddress(int value) {
            return value + 0x8800000 & 0x3FFFFFFF;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            Memory mem = Memory.getInstance();
            block81: while (true) {
                if (this.exit) {
                    this.cheats.onCheatsThreadEnded();
                    return;
                }
                Utilities.sleep(5, 0);
                this.codes = this.cheats.getCodesList();
                this.currentCode = 0;
                block82: while (true) {
                    String code;
                    if ((code = this.getNextCode()) == null) continue block81;
                    String[] parts = code.split(" ");
                    if (parts == null || parts.length < 2) continue;
                    int comm = (int)Utilities.parseHexLong(parts[0].trim());
                    int arg = (int)Utilities.parseHexLong(parts[1].trim());
                    int addr = CheatsThread.getAddress(comm & 0xFFFFFFF);
                    block0 : switch (comm >>> 28) {
                        case 0: {
                            if (!Memory.isAddressGood(addr)) continue block82;
                            mem.write8(addr, (byte)arg);
                            break;
                        }
                        case 1: {
                            if (!Memory.isAddressGood(addr)) continue block82;
                            mem.write16(addr, (short)arg);
                            break;
                        }
                        case 2: {
                            if (!Memory.isAddressGood(addr)) continue block82;
                            mem.write32(addr, arg);
                            break;
                        }
                        case 3: {
                            addr = CheatsThread.getAddress(arg);
                            int value = 0;
                            int increment = 0;
                            switch (comm >> 20 & 0xF) {
                                case 1: 
                                case 2: {
                                    value = mem.read8(addr);
                                    increment = comm & 0xFF;
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    value = mem.read16(addr);
                                    increment = comm & 0xFFFF;
                                    break;
                                }
                                case 5: 
                                case 6: {
                                    value = mem.read32(addr);
                                    code = this.getNextCode();
                                    parts = code.split(" ");
                                    if (parts == null || parts.length < 1) break;
                                    increment = (int)Utilities.parseHexLong(parts[0].trim());
                                    break;
                                }
                            }
                            switch (comm >> 20 & 0xF) {
                                case 1: 
                                case 3: 
                                case 5: {
                                    value += increment;
                                    break;
                                }
                                case 2: 
                                case 4: 
                                case 6: {
                                    value -= increment;
                                    break;
                                }
                            }
                            switch (comm >> 20 & 0xF) {
                                case 1: 
                                case 2: {
                                    mem.write8(addr, (byte)value);
                                    break block0;
                                }
                                case 3: 
                                case 4: {
                                    mem.write16(addr, (short)value);
                                    break block0;
                                }
                                case 5: 
                                case 6: {
                                    mem.write32(addr, value);
                                    continue block82;
                                }
                            }
                            break;
                        }
                        case 4: {
                            code = this.getNextCode();
                            parts = code.split(" ");
                            if (parts == null || parts.length < 1) continue block82;
                            int data = (int)Utilities.parseHexLong(parts[0].trim());
                            int dataAdd = (int)Utilities.parseHexLong(parts[1].trim());
                            int maxAddr = arg >> 16 & 0xFFFF;
                            int stepAddr = (arg & 0xFFFF) * 4;
                            int a = 0;
                            while (true) {
                                if (a >= maxAddr) continue block82;
                                if (Memory.isAddressGood(addr)) {
                                    mem.write32(addr, data);
                                }
                                addr += stepAddr;
                                data += dataAdd;
                                ++a;
                            }
                        }
                        case 5: {
                            code = this.getNextCode();
                            parts = code.split(" ");
                            if (parts == null || parts.length < 1) continue block82;
                            int destAddr = (int)Utilities.parseHexLong(parts[0].trim());
                            if (!Memory.isAddressGood(addr) || !Memory.isAddressGood(destAddr)) continue block82;
                            mem.memcpy(destAddr, addr, arg);
                            break;
                        }
                        case 6: {
                            code = this.getNextCode();
                            parts = code.split(" ");
                            if (parts == null || parts.length < 2) continue block82;
                            int arg2 = (int)Utilities.parseHexLong(parts[0].trim());
                            int offset = (int)Utilities.parseHexLong(parts[1].trim());
                            int baseOffset = (arg2 >>> 20) * 4;
                            int base = mem.read32(addr + baseOffset);
                            int count = arg2 & 0xFFFF;
                            int type = arg2 >> 16 & 0xF;
                            block84: for (int i = 1; i < count; ++i) {
                                if (i + 1 >= count || (parts = (code = this.getNextCode()).split(" ")) == null || parts.length < 2) continue;
                                int arg3 = (int)Utilities.parseHexLong(parts[0].trim());
                                int arg4 = (int)Utilities.parseHexLong(parts[1].trim());
                                int comm3 = arg3 >>> 28;
                                switch (comm3) {
                                    case 1: {
                                        int srcAddr = mem.read32(addr) + offset;
                                        int dstAddr = mem.read32(addr + baseOffset) + (arg3 & 0xFFFFFFF);
                                        mem.memcpy(dstAddr, srcAddr, arg);
                                        type = -1;
                                        continue block84;
                                    }
                                    case 2: 
                                    case 3: {
                                        int walkOffset = arg3 & 0xFFFFFFF;
                                        if (comm3 == 3) {
                                            walkOffset = -walkOffset;
                                        }
                                        base = mem.read32(base + walkOffset);
                                        int comm4 = arg4 >>> 28;
                                        switch (comm4) {
                                            case 2: 
                                            case 3: {
                                                walkOffset = arg4 & 0xFFFFFFF;
                                                if (comm4 == 3) {
                                                    walkOffset = -walkOffset;
                                                }
                                                base = mem.read32(base + walkOffset);
                                                continue block84;
                                            }
                                        }
                                        continue block84;
                                    }
                                    case 9: {
                                        base += arg3 & 0xFFFFFFF;
                                        arg += arg4;
                                        continue block84;
                                    }
                                }
                            }
                            switch (type) {
                                case 0: {
                                    mem.write8(base + offset, (byte)arg);
                                    break block0;
                                }
                                case 1: {
                                    mem.write16(base + offset, (short)arg);
                                    break block0;
                                }
                                case 2: {
                                    mem.write32(base + offset, arg);
                                    break block0;
                                }
                                case 3: {
                                    mem.write8(base - offset, (byte)arg);
                                    break block0;
                                }
                                case 4: {
                                    mem.write16(base - offset, (short)arg);
                                    break block0;
                                }
                                case 5: {
                                    mem.write32(base - offset, arg);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (arg >> 16) {
                                case 0: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (short)(arg & 0xFF);
                                        val2 = (short)mem.read8(addr);
                                        mem.write8(addr, (byte)(val1 | val2));
                                        break;
                                    }
                                    continue block82;
                                }
                                case 2: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (byte)(arg & 0xFF);
                                        val2 = (byte)mem.read8(addr);
                                        mem.write8(addr, (byte)(val1 & val2));
                                        break;
                                    }
                                    continue block82;
                                }
                                case 4: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (byte)(arg & 0xFF);
                                        val2 = (byte)mem.read8(addr);
                                        mem.write8(addr, (byte)(val1 ^ val2));
                                        break;
                                    }
                                    continue block82;
                                }
                                case 1: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (short)(arg & 0xFFFF);
                                        val2 = (short)mem.read16(addr);
                                        mem.write16(addr, (short)(val1 | val2));
                                        break;
                                    }
                                    continue block82;
                                }
                                case 3: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (short)(arg & 0xFFFF);
                                        val2 = (short)mem.read16(addr);
                                        mem.write16(addr, (short)(val1 & val2));
                                        break;
                                    }
                                    continue block82;
                                }
                                case 5: {
                                    short val2;
                                    short val1;
                                    if (Memory.isAddressGood(addr)) {
                                        val1 = (short)(arg & 0xFFFF);
                                        val2 = (short)mem.read16(addr);
                                        mem.write16(addr, (short)(val1 ^ val2));
                                    }
                                    continue block82;
                                }
                            }
                            continue block82;
                        }
                        case 8: {
                            code = this.getNextCode();
                            parts = code.split(" ");
                            if (parts == null || parts.length < 1) continue block82;
                            int data = (int)Utilities.parseHexLong(parts[0].trim());
                            int dataAdd = (int)Utilities.parseHexLong(parts[1].trim());
                            boolean is8Bit = data >> 16 == 0;
                            int maxAddr = arg >> 16 & 0xFFFF;
                            int stepAddr = (arg & 0xFFFF) * (is8Bit ? 1 : 2);
                            int a = 0;
                            while (true) {
                                if (a >= maxAddr) continue block82;
                                if (Memory.isAddressGood(addr)) {
                                    if (is8Bit) {
                                        mem.write8(addr, (byte)(data & 0xFF));
                                    } else {
                                        mem.write16(addr, (short)(data & 0xFFFF));
                                    }
                                }
                                addr += stepAddr;
                                data += dataAdd;
                                ++a;
                            }
                        }
                        case 11: {
                            break;
                        }
                        case 12: {
                            int value;
                            if (!Memory.isAddressGood(addr) || (value = mem.read32(addr)) == arg) continue block82;
                            this.skipAllCodes();
                            break;
                        }
                        case 13: {
                            int testValue;
                            int memoryValue;
                            boolean is8Bit;
                            switch (arg >>> 28) {
                                case 0: 
                                case 2: {
                                    boolean bl = is8Bit = arg >> 28 == 2;
                                    if (!Memory.isAddressGood(addr)) break;
                                    memoryValue = is8Bit ? mem.read8(addr) : mem.read16(addr);
                                    testValue = arg & (is8Bit ? 255 : 65535);
                                    boolean executeNextLine = false;
                                    switch (arg >> 20 & 0xF) {
                                        case 0: {
                                            executeNextLine = memoryValue == testValue;
                                            break;
                                        }
                                        case 1: {
                                            executeNextLine = memoryValue != testValue;
                                            break;
                                        }
                                        case 2: {
                                            executeNextLine = memoryValue < testValue;
                                            break;
                                        }
                                        case 3: {
                                            executeNextLine = memoryValue > testValue;
                                            break;
                                        }
                                    }
                                    if (executeNextLine) continue block82;
                                    this.skipCodes(1);
                                    continue block82;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    int addr1 = addr;
                                    int addr2 = CheatsThread.getAddress(arg & 0xFFFFFFF);
                                    if (!Memory.isAddressGood(addr1) || !Memory.isAddressGood(addr2) || (parts = (code = this.getNextCode()).split(" ")) == null || parts.length < 1) break;
                                    int skip = (int)Utilities.parseHexLong(parts[0].trim());
                                    int type = (int)Utilities.parseHexLong(parts[1].trim());
                                    int value1 = 0;
                                    int value2 = 0;
                                    switch (type & 0xF) {
                                        case 0: {
                                            value1 = mem.read8(addr1);
                                            value2 = mem.read8(addr2);
                                            break;
                                        }
                                        case 1: {
                                            value1 = mem.read16(addr1);
                                            value2 = mem.read16(addr2);
                                            break;
                                        }
                                        case 2: {
                                            value1 = mem.read32(addr1);
                                            value2 = mem.read32(addr2);
                                            break;
                                        }
                                    }
                                    boolean executeNextLines = false;
                                    switch (arg >>> 28) {
                                        case 4: {
                                            executeNextLines = value1 == value2;
                                            break;
                                        }
                                        case 5: {
                                            executeNextLines = value1 != value2;
                                            break;
                                        }
                                        case 6: {
                                            executeNextLines = value1 < value2;
                                            break;
                                        }
                                        case 7: {
                                            executeNextLines = value1 > value2;
                                            break;
                                        }
                                    }
                                    if (executeNextLines) continue block82;
                                    this.skipCodes(skip);
                                    continue block82;
                                }
                                case 1: 
                                case 3: {
                                    int testButtons = arg & 0xFFFFFFF;
                                    int buttons = State.controller.getButtons();
                                    boolean executeNextLines = false;
                                    if (arg >>> 28 == 1) {
                                        executeNextLines = testButtons == buttons;
                                    } else {
                                        boolean bl = executeNextLines = testButtons != buttons;
                                    }
                                    if (executeNextLines) break;
                                    int skip = (comm & 0xFF) + 1;
                                    this.skipCodes(skip);
                                }
                            }
                            continue block82;
                        }
                        case 14: {
                            boolean is8Bit = comm >> 24 == 1;
                            addr = CheatsThread.getAddress(arg & 0xFFFFFFF);
                            if (!Memory.isAddressGood(addr)) continue block82;
                            int memoryValue = is8Bit ? mem.read8(addr) : mem.read16(addr);
                            int testValue = comm & (is8Bit ? 255 : 65535);
                            boolean executeNextLines = false;
                            switch (arg >>> 28) {
                                case 0: {
                                    executeNextLines = memoryValue == testValue;
                                    break;
                                }
                                case 1: {
                                    executeNextLines = memoryValue != testValue;
                                    break;
                                }
                                case 2: {
                                    executeNextLines = memoryValue < testValue;
                                    break;
                                }
                                case 3: {
                                    executeNextLines = memoryValue > testValue;
                                    break;
                                }
                            }
                            if (executeNextLines) continue block82;
                            int skip = comm >> 16 & (is8Bit ? 255 : 4095);
                            this.skipCodes(skip);
                            continue block82;
                        }
                    }
                }
                break;
            }
        }
    }
}

